/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.net;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.d2d.D2DSocketConnectionHandler;
import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.message.KnownNodes;
import de.dal33t.powerfolder.message.KnownNodesExt;
import de.dal33t.powerfolder.message.Message;
import de.dal33t.powerfolder.message.SingleMessageProducer;
import de.dal33t.powerfolder.net.AbstractAcceptor;
import de.dal33t.powerfolder.net.ConnectionException;
import de.dal33t.powerfolder.net.ConnectionHandler;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.Util;
import de.dal33t.powerfolder.util.net.NetworkUtil;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;

public class ConnectionListener
extends PFComponent
implements Runnable {
    public static final int DEFAULT_PORT = 1337;
    public static final int DEFAULT_D2D_PORT = 7331;
    public static final int OK = 0;
    public static final int CANNOT_RESOLVE = 1;
    public static final int VALIDATION_FAILED = 2;
    private Thread myThread;
    private ServerSocket serverSocket;
    private InetSocketAddress myDyndns;
    private int port;
    private final String interfaceAddress;
    private boolean hasIncomingConnection;
    public final boolean useD2D;

    public ConnectionListener(Controller controller, int n, String string) throws ConnectionException {
        this(controller, n, string, false);
    }

    public ConnectionListener(Controller controller, int n, String string, boolean bl) throws ConnectionException {
        super(controller);
        this.port = 0 > n ? (bl ? ConfigurationEntry.NET_PORT_D2D.getValueInt(this.getController()) : 1337) : n;
        this.hasIncomingConnection = false;
        this.interfaceAddress = string;
        this.useD2D = bl;
        String string2 = ConfigurationEntry.HOSTNAME.getValue(this.getController());
        this.setMyDynDns(string2, false);
        this.openServerSocket();
    }

    private void openServerSocket() throws ConnectionException {
        InetAddress inetAddress = null;
        try {
            this.logFiner("Opening listener on port " + this.port);
            String string = this.interfaceAddress;
            if (string != null && !StringUtils.isBlank(string)) {
                try {
                    inetAddress = InetAddress.getByName(string);
                }
                catch (UnknownHostException unknownHostException) {
                    this.logInfo("Bad BIND address: " + string);
                    string = null;
                }
            }
            boolean bl = this.useD2D;
            if (this.useD2D) {
                if (NetworkUtil.LOOPBACK_LOCALHOST_IPv4.equals(string)) {
                    bl = false;
                } else if (this.port != 7331) {
                    this.logWarning("Opening non-SSL secured iOS listener. " + inetAddress + ":" + this.port + " must not be reachable from the internet.");
                    bl = false;
                }
            }
            this.serverSocket = bl ? this.createD2DSSLServerSocket(inetAddress) : new ServerSocket(this.port, 100, inetAddress);
        }
        catch (EOFException eOFException) {
            this.logWarning("Cannot open D2D server socket: Cannot get SSL certificate");
            throw new ConnectionException("Cannot open D2D server socket: Cannot get SSL certificate", eOFException);
        }
        catch (Exception exception) {
            throw new ConnectionException(Translation.get("dialog.unable_to_open_port", "" + this.port), exception);
        }
        if (this.isFine()) {
            if (this.useD2D) {
                this.logFine("Listening for incoming D2D connections on port " + ((InetSocketAddress)this.serverSocket.getLocalSocketAddress()).getPort() + ", own address: " + inetAddress);
            } else {
                this.logFine("Listening for incoming connections on port " + this.serverSocket.getLocalPort() + (String)(this.myDyndns != null ? ", own address: " + this.myDyndns : ""));
            }
        }
        this.port = this.serverSocket.getLocalPort();
    }

    private ServerSocket createD2DSSLServerSocket(InetAddress inetAddress) throws Exception {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(new FileInputStream(this.getController().getSslTrustStoreFile().toString()), new char[0]);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, new char[0]);
        KeyManager[] keyManagerArray = keyManagerFactory.getKeyManagers();
        SSLContext sSLContext = SSLContext.getInstance("TLSv1.2");
        sSLContext.init(keyManagerArray, null, new SecureRandom());
        SSLServerSocketFactory sSLServerSocketFactory = sSLContext.getServerSocketFactory();
        return sSLServerSocketFactory.createServerSocket(this.port, 100, inetAddress);
    }

    public boolean isServerSocketOpen() {
        return this.serverSocket != null && !this.serverSocket.isClosed();
    }

    private String parseString(String string) {
        if (string.startsWith("http://")) {
            int n = string.indexOf("//");
            string = string.substring(n + 2);
        }
        return string;
    }

    private List<InetAddress> getNetworkAddresses() {
        Enumeration<NetworkInterface> enumeration;
        ArrayList<NetworkInterface> arrayList = new ArrayList<NetworkInterface>();
        ArrayList<InetAddress> arrayList2 = new ArrayList<InetAddress>();
        try {
            enumeration = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException socketException) {
            this.logWarning("Unable to get local network interfaces. " + socketException);
            return null;
        }
        catch (Error error) {
            this.logWarning("Unable to get local network interfaces. " + error);
            return null;
        }
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            NetworkInterface networkInterface = (NetworkInterface)arrayList.get(i);
            Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
            while (enumeration2.hasMoreElements()) {
                arrayList2.add(enumeration2.nextElement());
            }
        }
        return arrayList2;
    }

    public int setMyDynDns(String string, boolean bl) {
        this.logFine("Setting own dns to " + string + ". was: " + (this.myDyndns != null ? this.myDyndns.getHostName() : ""));
        if (bl) {
            this.getController().getDynDnsManager().show(string);
        } else {
            if (this.myDyndns != null && this.myDyndns.getHostName().equals(string)) {
                this.logFine("Not resetting supernode state");
                return 0;
            }
            this.logFine("Resetting supernode state");
        }
        this.myDyndns = null;
        this.getController().getMySelf().getInfo().isSupernode = false;
        if (!StringUtils.isBlank(string)) {
            this.logFiner("Resolving " + string);
            string = this.parseString(string).trim();
            try {
                this.myDyndns = new InetSocketAddress(string, this.port);
                if (this.myDyndns.isUnresolved()) {
                    if (bl) {
                        this.getController().getDynDnsManager().close();
                        this.getController().getDynDnsManager().showWarningMsg(1, this.myDyndns.getHostName());
                    }
                    this.logWarning("Unable to resolve own address '" + string + "'");
                    this.myDyndns = null;
                    return 1;
                }
            }
            catch (Exception exception) {
                this.logWarning("Unable to get hostname: " + string + ":" + this.port + ". " + exception);
                this.myDyndns = null;
            }
            if (bl) {
                int n;
                this.logFiner("Validating " + string);
                InetAddress inetAddress = this.myDyndns.getAddress();
                List<InetAddress> list = this.getNetworkAddresses();
                String string2 = inetAddress.getHostAddress();
                String string3 = this.getController().getDynDnsManager().getIPviaHTTPCheckIP();
                boolean bl2 = false;
                for (n = 0; n < list.size(); ++n) {
                    InetAddress inetAddress2 = list.get(n);
                    if (!Util.compareIpAddresses(inetAddress.getAddress(), inetAddress2.getAddress())) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2 && string3.equals(string2)) {
                    this.logFiner("DynDns matches with external IP " + string);
                    bl2 = true;
                }
                if (!bl2) {
                    this.getController().getDynDnsManager().close();
                    this.logWarning("Own address " + string + " does not match any of the local network interfaces");
                    return 2;
                }
                this.getController().getDynDnsManager().close();
                if (string3 == "") {
                    this.logWarning("cannot determine the external IP of this host");
                    return 2;
                }
                n = string3.equals(string2) ? 1 : 0;
                boolean bl3 = string3.equals(ConfigurationEntry.DYNDNS_LAST_UPDATED_IP.getValue(this.getController()));
                if (n == 0 && !bl3) {
                    this.logWarning("Own address " + string + " does not match the external IP of this host");
                    return 2;
                }
            }
        }
        if (this.myDyndns != null) {
            this.logFiner("Successfully set dyndns to " + this.myDyndns.getHostName());
        } else {
            this.logFine("Dyndns not set");
        }
        return 0;
    }

    public void start() throws ConnectionException {
        if (!this.isServerSocketOpen()) {
            this.openServerSocket();
        }
        if (this.myThread == null) {
            this.myThread = new Thread((Runnable)this, "Listener on port " + this.serverSocket.getLocalPort());
            this.myThread.setPriority(1);
            this.myThread.start();
            this.logFine("Started");
        }
    }

    public void shutdown() {
        if (this.myThread != null) {
            this.myThread.interrupt();
        }
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                this.logFiner(iOException.toString());
            }
        }
        this.logFine("Stopped");
    }

    public InetSocketAddress getMyDynDns() {
        return this.myDyndns;
    }

    public InetSocketAddress getAddress() {
        return this.myDyndns != null ? this.myDyndns : (this.serverSocket == null ? null : (InetSocketAddress)this.serverSocket.getLocalSocketAddress());
    }

    public InetSocketAddress getLocalAddress() {
        return this.serverSocket == null ? null : (InetSocketAddress)this.serverSocket.getLocalSocketAddress();
    }

    public boolean hasIncomingConnections() {
        return this.hasIncomingConnection;
    }

    public int getPort() {
        return this.serverSocket != null ? this.serverSocket.getLocalPort() : this.port;
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                if (this.isFiner()) {
                    this.logFiner("Listening for new connections on " + this.serverSocket);
                }
                Socket socket = this.serverSocket.accept();
                boolean bl = true;
                if (this.getController().isLanOnly()) {
                    bl = this.getController().getNodeManager().isOnLANorConfiguredOnLAN(socket.getInetAddress());
                }
                if (!bl) {
                    socket.close();
                    continue;
                }
                NetworkUtil.setupSocket(socket, this.getController());
                this.hasIncomingConnection = true;
                if (this.isFiner()) {
                    this.logFiner("Incoming connection from: " + socket.getInetAddress() + ":" + socket.getPort());
                }
                final MemberInfo memberInfo = this.getController().getMySelf().getInfo();
                if (this.myDyndns != null && !memberInfo.isSupernode) {
                    this.logFine("Acting as supernode on address " + this.myDyndns);
                    memberInfo.isSupernode = true;
                    memberInfo.setConnectAddress(this.getAddress());
                    this.getController().getNodeManager().broadcastMessage(107, new SingleMessageProducer(){

                        @Override
                        public Message getMessage(boolean bl) {
                            return bl ? new KnownNodesExt(memberInfo) : new KnownNodes(memberInfo);
                        }
                    }, null);
                }
                this.getController().getNodeManager().acceptConnectionAsynchron(new SocketAcceptor(socket));
            }
            catch (SocketException socketException) {
                this.logFine("Listening socket on port " + this.serverSocket.getLocalPort() + " closed");
                break;
            }
            catch (IOException iOException) {
                this.logSevere("Exception while accepting socket: " + iOException, iOException);
            }
            catch (RuntimeException runtimeException) {
                this.logSevere("Exception while accepting socket: " + runtimeException, runtimeException);
            }
        }
    }

    public class SocketAcceptor
    extends AbstractAcceptor {
        protected Socket socket;

        protected SocketAcceptor(Socket socket) {
            super(ConnectionListener.this.getController());
            Reject.ifNull(socket, "Socket is null");
            this.socket = socket;
        }

        @Override
        public String getConnectionInfo() {
            return this.socket.getRemoteSocketAddress().toString();
        }

        @Override
        protected void accept() throws ConnectionException {
            ConnectionHandler connectionHandler;
            if (this.isFiner()) {
                this.logFiner("Accepting connection from: " + this.socket.getInetAddress() + ":" + this.socket.getPort());
            }
            if ((connectionHandler = this.getController().getIOProvider().getConnectionHandlerFactory().createAndInitSocketConnectionHandler(this.socket, ConnectionListener.this.useD2D)) instanceof D2DSocketConnectionHandler) {
                ((D2DSocketConnectionHandler)connectionHandler).setSocketAcceptor(this);
            } else {
                this.acceptConnection(connectionHandler);
            }
        }

        @Override
        protected void shutdown() {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                this.logFiner("Unable to close socket from acceptor", iOException);
            }
        }
    }
}

