/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.net;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Feature;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.message.Identity;
import de.dal33t.powerfolder.message.IdentityReply;
import de.dal33t.powerfolder.message.LimitBandwidth;
import de.dal33t.powerfolder.message.Message;
import de.dal33t.powerfolder.message.Pong;
import de.dal33t.powerfolder.message.Problem;
import de.dal33t.powerfolder.net.ConnectionException;
import de.dal33t.powerfolder.net.ConnectionHandler;
import de.dal33t.powerfolder.net.ConnectionQuality;
import de.dal33t.powerfolder.transfer.LimitedInputStream;
import de.dal33t.powerfolder.transfer.LimitedOutputStream;
import de.dal33t.powerfolder.util.ByteSerializer;
import de.dal33t.powerfolder.util.Convert;
import de.dal33t.powerfolder.util.Format;
import de.dal33t.powerfolder.util.IdGenerator;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StreamUtils;
import de.dal33t.powerfolder.util.net.NetworkUtil;
import de.dal33t.powerfolder.util.net.UDTSocket;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Date;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class AbstractUDTSocketConnectionHandler
extends PFComponent
implements ConnectionHandler {
    private UDTSocket socket;
    private Member member;
    private Identity myIdentity;
    private Identity identity;
    private IdentityReply identityReply;
    private String myMagicId;
    private LimitedOutputStream out;
    private LimitedInputStream in;
    private ByteSerializer serializer;
    private Queue<Message> messagesToSendQueue;
    private boolean started;
    private boolean onLAN;
    private final Object identityWaiter = new Object();
    private final Object identityAcceptWaiter = new Object();
    private final Object sendLock = new Object();
    private Runnable sender;
    private Lock senderSpawnLock;
    private Date lastKeepaliveMessage;
    private boolean omitBandwidthLimit;

    protected AbstractUDTSocketConnectionHandler(Controller controller, UDTSocket uDTSocket) {
        super(controller);
        this.socket = uDTSocket;
        this.serializer = new ByteSerializer();
    }

    protected abstract byte[] serialize(Message var1) throws ConnectionException;

    protected abstract Object deserialize(byte[] var1, int var2) throws ConnectionException, ClassNotFoundException;

    protected boolean receivedObject(Object object) throws ConnectionException {
        return false;
    }

    protected abstract Identity createOwnIdentity();

    protected ByteSerializer getSerializer() {
        return this.serializer;
    }

    protected UDTSocket getSocket() {
        return this.socket;
    }

    @Override
    public void init() throws ConnectionException {
        if (this.socket.isClosed() || !this.socket.isConnected()) {
            throw new ConnectionException("Connection to peer is closed").with(this);
        }
        this.started = true;
        this.identity = null;
        this.identityReply = null;
        this.messagesToSendQueue = new ConcurrentLinkedQueue<Message>();
        this.senderSpawnLock = new ReentrantLock();
        long l = System.currentTimeMillis();
        try {
            this.out = new LimitedOutputStream(this.getController().getTransferManager().getOutputLimiter(this), new BufferedOutputStream(this.socket.getOutputStream(), 1024));
            this.in = new LimitedInputStream(this.getController().getTransferManager().getInputLimiter(this), new BufferedInputStream(this.socket.getInputStream(), 1024));
            if (this.isFiner()) {
                this.logFiner("Got streams");
            }
            this.myMagicId = IdGenerator.makeId() + IdGenerator.makeId() + IdGenerator.makeId() + IdGenerator.makeId() + IdGenerator.makeId() + IdGenerator.makeId() + IdGenerator.makeId() + IdGenerator.makeId();
            this.myIdentity = this.createOwnIdentity();
            if (this.isFiner()) {
                this.logFiner("Sending my identity, nick: '" + this.myIdentity.getMemberInfo().nick + "', ID: " + this.myIdentity.getMemberInfo().id);
            }
            this.getController().getIOProvider().startIO(new Receiver());
            this.sendMessagesAsynchron(this.myIdentity);
        }
        catch (IOException iOException) {
            throw new ConnectionException("Unable to open connection", iOException).with(this);
        }
        this.waitForRemoteIdentity();
        if (!this.isConnected()) {
            this.shutdown();
            throw new ConnectionException("Remote peer disconnected while waiting for his identity").with(this);
        }
        if (this.identity == null || this.identity.getMemberInfo() == null) {
            throw new ConnectionException("Did not receive a valid identity from peer after 60s").with(this);
        }
        long l2 = System.currentTimeMillis() - l;
        if (this.isFiner()) {
            this.logFiner("Connect took " + l2 + "ms, time differ: " + this.getTimeDeltaMS() / 1000L / 60L + " min, remote ident: " + this.getIdentity());
        }
        this.analyseConnection();
        this.getController().getIOProvider().startKeepAliveCheck(this);
    }

    @Override
    public void shutdownWithMember() {
        if (this.getMember() != null) {
            this.getMember().shutdown();
        }
        if (this.started) {
            this.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Queue<Message> queue;
        if (!this.started) {
            return;
        }
        if (this.isFiner()) {
            this.logFiner("Shutting down");
        }
        this.started = false;
        this.setMember(null);
        this.messagesToSendQueue.clear();
        this.getController().getIOProvider().removeKeepAliveCheck(this);
        try {
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (IOException iOException) {
            this.logSevere("Could not close out stream", iOException);
        }
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (IOException iOException) {
            this.logSevere("Could not close in stream", iOException);
        }
        UDTSocket uDTSocket = this.socket;
        if (uDTSocket != null) {
            try {
                queue = uDTSocket.getLocalAddress();
                if (queue != null) {
                    this.getController().getIOProvider().getUDTSocketConnectionManager().releaseSlot(((InetSocketAddress)((Object)queue)).getPort());
                }
                uDTSocket.close();
            }
            catch (IOException iOException) {
                this.logFiner("IOException", iOException);
            }
        }
        queue = this.identityWaiter;
        synchronized (queue) {
            this.identityWaiter.notifyAll();
        }
        queue = this.identityAcceptWaiter;
        synchronized (queue) {
            this.identityAcceptWaiter.notifyAll();
        }
        queue = this.messagesToSendQueue;
        synchronized (queue) {
            this.messagesToSendQueue.notifyAll();
        }
        this.serializer = null;
    }

    @Override
    public boolean isConnected() {
        return this.socket != null && this.in != null && this.out != null && this.socket.isConnected() && !this.socket.isClosed() && this.serializer != null;
    }

    @Override
    public boolean isEncrypted() {
        return false;
    }

    @Override
    public boolean isOnLAN() {
        return this.onLAN;
    }

    @Override
    public void setOnLAN(boolean bl) {
        this.onLAN = bl;
        this.out.setBandwidthLimiter(this.getController().getTransferManager().getOutputLimiter(this));
        this.in.setBandwidthLimiter(this.getController().getTransferManager().getInputLimiter(this));
    }

    public void setMember(Member member) {
        this.member = member;
    }

    @Override
    public Member getMember() {
        return this.member;
    }

    @Override
    public Date getLastKeepaliveMessageTime() {
        return this.lastKeepaliveMessage;
    }

    private void read(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        StreamUtils.read(inputStream, byArray, n, n2);
        this.getController().getTransferManager().getTotalDownloadTrafficCounter().bytesTransferred(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessage(Message message) throws ConnectionException {
        if (message == null) {
            throw new NullPointerException("Message is null");
        }
        if (!this.isConnected()) {
            throw new ConnectionException("Connection to remote peer closed").with(this);
        }
        if (this.identity == null && !(message instanceof Identity)) {
            throw new ConnectionException("Unable to send message, peer did not identify yet").with(this);
        }
        try {
            Object object = this.sendLock;
            synchronized (object) {
                int n;
                if (this.isFiner()) {
                    this.logFiner("-- (sending) -> " + message);
                }
                if (!this.isConnected() || !this.started) {
                    throw new ConnectionException("Connection to remote peer closed").with(this);
                }
                boolean bl = !(message instanceof LimitBandwidth) || this.omitBandwidthLimit;
                byte[] byArray = this.serialize(message);
                this.out.write(Convert.convert2Bytes(byArray.length));
                this.getController().getTransferManager().getTotalUploadTrafficCounter().bytesTransferred(byArray.length + 4);
                int n2 = 0;
                for (int i = byArray.length; i > 0; i -= n) {
                    n = i;
                    if (!this.started) {
                        throw new ConnectionException("Unable to send message to peer, connection shutdown").with(this.member).with(this);
                    }
                    this.out.write(byArray, n2, n, bl);
                    n2 += n;
                }
                this.out.flush();
            }
        }
        catch (IOException iOException) {
            this.shutdownWithMember();
            throw new ConnectionException("Unable to send message to peer, connection closed", iOException).with(this.member).with(this);
        }
        catch (ConnectionException connectionException) {
            this.shutdownWithMember();
            throw connectionException;
        }
        catch (RuntimeException runtimeException) {
            this.logSevere("Runtime exception while serializing: " + message, runtimeException);
            this.shutdownWithMember();
            throw runtimeException;
        }
    }

    @Override
    public void sendMessagesAsynchron(Message ... messageArray) {
        for (Message message : messageArray) {
            this.sendMessageAsynchron(message, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessageAsynchron(Message message, String string) {
        Reject.ifNull(message, "Message is null");
        this.senderSpawnLock.lock();
        try {
            Object object;
            this.messagesToSendQueue.offer(message);
            if (this.messagesToSendQueue.size() > 1998 && this.isWarning()) {
                object = "Many messages in send queue: " + this.messagesToSendQueue.size() + ": " + this.messagesToSendQueue;
                if (((String)object).length() > 300) {
                    object = ((String)object).substring(0, 300);
                    object = (String)object + "...";
                }
                this.logFine((String)object);
            }
            if (this.messagesToSendQueue.size() > 2000) {
                object = "Disconnecting " + this.getIdentity() + ": Too many messages in send queue: " + this.messagesToSendQueue.size();
                this.logWarning((String)object);
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        AbstractUDTSocketConnectionHandler.this.shutdownWithMember();
                    }
                };
                this.getController().getIOProvider().startIO(runnable);
                return;
            }
            if (this.sender == null) {
                this.sender = new Sender();
                this.getController().getIOProvider().startIO(this.sender);
            }
        }
        finally {
            this.senderSpawnLock.unlock();
        }
    }

    @Override
    public long getTimeDeltaMS() {
        if (this.identity.getTimeGMT() == null) {
            return 0L;
        }
        return this.myIdentity.getTimeGMT().getTimeInMillis() - this.identity.getTimeGMT().getTimeInMillis();
    }

    @Override
    public boolean canMeasureTimeDifference() {
        return this.identity.getTimeGMT() != null;
    }

    @Override
    public Identity getIdentity() {
        return this.identity;
    }

    @Override
    public Identity getMyIdentity() {
        return this.myIdentity;
    }

    @Override
    public String getMyMagicId() {
        return this.myMagicId;
    }

    @Override
    public String getRemoteMagicId() {
        return this.identity != null ? this.identity.getMagicId() : null;
    }

    @Override
    public ConnectionQuality getConnectionQuality() {
        return ConnectionQuality.MEDIUM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForRemoteIdentity() {
        Object object = this.identityWaiter;
        synchronized (object) {
            if (this.identity == null) {
                try {
                    this.identityWaiter.wait(60000L);
                }
                catch (InterruptedException interruptedException) {
                    this.logFiner("InterruptedException", interruptedException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean acceptIdentity(Member member) {
        Reject.ifNull(member, "node is null");
        this.member = member;
        if (this.isFiner()) {
            this.logFiner("Sending accept of identity to " + this);
        }
        this.sendMessagesAsynchron(IdentityReply.accept());
        long l = System.currentTimeMillis();
        Object object = this.identityAcceptWaiter;
        synchronized (object) {
            if (this.identityReply == null) {
                try {
                    this.identityAcceptWaiter.wait(20000L);
                }
                catch (InterruptedException interruptedException) {
                    this.logFiner("InterruptedException", interruptedException);
                }
            }
        }
        long l2 = (System.currentTimeMillis() - l) / 1000L;
        if (this.identityReply != null && !this.identityReply.accepted) {
            this.logWarning("Remote peer '" + member + "' rejected our connection: " + this.identityReply.message);
            this.member = null;
            return false;
        }
        if (!this.isConnected()) {
            this.logWarning("Remote member disconnected while waiting for identity reply. " + this.identity);
            this.member = null;
            return false;
        }
        if (this.identityReply == null) {
            this.logFine("Did not receive a identity reply after " + l2 + "s. Connected? " + this.isConnected() + ". remote id: " + this.identity);
            this.member = null;
            return false;
        }
        if (this.identityReply.accepted) {
            if (this.isFiner()) {
                this.logFiner("Identity accepted by remote peer. " + this);
            }
        } else {
            this.member = null;
            this.logWarning("Identity rejected by remote peer. " + this);
        }
        return this.identityReply.accepted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitForEmptySendQueue() {
        long l = 0L;
        int n = this.messagesToSendQueue.size();
        while (!this.messagesToSendQueue.isEmpty() && this.isConnected()) {
            try {
                Queue<Message> queue = this.messagesToSendQueue;
                synchronized (queue) {
                    this.messagesToSendQueue.wait(1L);
                }
                ++l;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
                break;
            }
        }
        if (l > 0L && this.isFiner()) {
            this.logFiner(this.getMember() + ": Waited " + l + "ms for empty send buffer. " + n + " messages were in queue.");
        }
        return this.messagesToSendQueue.isEmpty();
    }

    private void analyseConnection() {
        if (Feature.CORRECT_LAN_DETECTION.isDisabled()) {
            this.logWarning("ON LAN because of correct connection analyse disabled");
            this.setOnLAN(true);
            return;
        }
        if (Feature.CORRECT_INTERNET_DETECTION.isDisabled()) {
            this.logWarning("ON Internet because of correct connection analyse disabled");
            this.setOnLAN(false);
            return;
        }
        if (this.identity != null && this.identity.isTunneled()) {
            this.setOnLAN(false);
            return;
        }
        if (this.getRemoteAddress() != null && this.getRemoteAddress().getAddress() != null) {
            InetAddress inetAddress = this.getRemoteAddress().getAddress();
            this.setOnLAN(this.getController().getNodeManager().isOnLANorConfiguredOnLAN(inetAddress));
            try {
                this.omitBandwidthLimit = NetworkUtil.isFromThisComputer(this.socket.getRemoteAddress().getAddress());
            }
            catch (SocketException socketException) {
                this.logSevere("Omitting bandwidth", socketException);
            }
        }
        if (this.isFiner()) {
            this.logFiner("analyse connection: lan: " + this.onLAN);
        }
    }

    @Override
    public boolean acceptHandshake() {
        return true;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.socket.getRemoteAddress();
    }

    @Override
    public int getRemoteListenerPort() {
        if (this.identity == null || this.identity.getMemberInfo() == null || this.identity.getMemberInfo().getConnectAddress() == null) {
            return -1;
        }
        if (this.identity.isTunneled()) {
            return -1;
        }
        return this.identity.getMemberInfo().getConnectAddress().getPort();
    }

    private void logConnectionClose(Exception exception) {
        Member member = this.member;
        Identity identity = this.identity;
        if (member == null && identity != null) {
            member = identity.getMemberInfo().getNode(this.getController(), true);
        }
        String string = "Connection closed to " + (member == null ? this.toString() : member.toString());
        boolean bl = member != null && member.isServer() && !member.isMySelf() && !member.isConnected() && !this.getController().isShuttingDown() && this.getController().isStarted();
        string = string + ". Caused by ";
        if (member != null && member.getLastProblem() != null) {
            string = string + member.getLastProblem();
            string = string + ", ";
        }
        if (exception instanceof ConnectionException) {
            string = string + exception.getCause();
        } else if (exception != null) {
            string = string + exception.toString();
        }
        if (this.isWarning() && bl) {
            this.logWarning(string);
        } else if (this.isFine()) {
            this.logFine(string);
        }
        if (this.isFiner()) {
            this.logFiner("Exception", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        if (this.socket == null) {
            return "-disconnected-";
        }
        UDTSocket uDTSocket = this.socket;
        synchronized (uDTSocket) {
            return this.socket.getRemoteAddress().getAddress() + ":" + this.socket.getRemoteAddress().getPort();
        }
    }

    class Receiver
    implements Runnable {
        Receiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            byte[] byArray = new byte[4];
            while (AbstractUDTSocketConnectionHandler.this.started && AbstractUDTSocketConnectionHandler.this.isConnected()) {
                Object object;
                try {
                    Object object2;
                    AbstractUDTSocketConnectionHandler.this.read(AbstractUDTSocketConnectionHandler.this.in, byArray, 0, byArray.length);
                    int n = Convert.convert2Int(byArray);
                    if (!AbstractUDTSocketConnectionHandler.this.started) break;
                    if (n == -1393754107) {
                        throw new IOException("Client has old protocol version");
                    }
                    if (n == -1) break;
                    if (n <= 0) {
                        throw new IOException("Illegal paket size: " + n);
                    }
                    object = AbstractUDTSocketConnectionHandler.this.serializer.read(AbstractUDTSocketConnectionHandler.this.in, n);
                    Object object3 = AbstractUDTSocketConnectionHandler.this.deserialize((byte[])object, n);
                    AbstractUDTSocketConnectionHandler.this.lastKeepaliveMessage = new Date();
                    AbstractUDTSocketConnectionHandler.this.getController().getTransferManager().getTotalDownloadTrafficCounter().bytesTransferred(n);
                    if (AbstractUDTSocketConnectionHandler.this.isFiner()) {
                        AbstractUDTSocketConnectionHandler.this.logFiner("<- (received, " + Format.formatBytes(n) + ") - " + object3);
                    }
                    if (!AbstractUDTSocketConnectionHandler.this.getController().isStarted()) {
                        AbstractUDTSocketConnectionHandler.this.logFiner("Peer still active, shutting down " + AbstractUDTSocketConnectionHandler.this.getMember());
                        break;
                    }
                    if (object3 instanceof Identity) {
                        if (AbstractUDTSocketConnectionHandler.this.isFiner()) {
                            AbstractUDTSocketConnectionHandler.this.logFiner("Received remote identity: " + object3);
                        }
                        object2 = AbstractUDTSocketConnectionHandler.this.identityWaiter;
                        synchronized (object2) {
                            AbstractUDTSocketConnectionHandler.this.identity = (Identity)object3;
                            AbstractUDTSocketConnectionHandler.this.identityWaiter.notifyAll();
                        }
                        if (!AbstractUDTSocketConnectionHandler.this.isFiner()) continue;
                        AbstractUDTSocketConnectionHandler.this.logFiner("Received magicId: " + AbstractUDTSocketConnectionHandler.this.identity.getMagicId());
                        continue;
                    }
                    if (object3 instanceof IdentityReply) {
                        if (AbstractUDTSocketConnectionHandler.this.isFiner()) {
                            AbstractUDTSocketConnectionHandler.this.logFiner("Received identity reply: " + object3);
                        }
                        object2 = AbstractUDTSocketConnectionHandler.this.identityAcceptWaiter;
                        synchronized (object2) {
                            AbstractUDTSocketConnectionHandler.this.identityReply = (IdentityReply)object3;
                            AbstractUDTSocketConnectionHandler.this.identityAcceptWaiter.notifyAll();
                            continue;
                        }
                    }
                    if (object3 instanceof Pong) continue;
                    if (object3 instanceof Problem) {
                        object2 = (Problem)object3;
                        if (AbstractUDTSocketConnectionHandler.this.member != null) {
                            AbstractUDTSocketConnectionHandler.this.member.handleMessage((Message)object2, AbstractUDTSocketConnectionHandler.this);
                            continue;
                        }
                        AbstractUDTSocketConnectionHandler.this.logFine("(" + (AbstractUDTSocketConnectionHandler.this.identity != null ? ((AbstractUDTSocketConnectionHandler)AbstractUDTSocketConnectionHandler.this).identity.getMemberInfo().nick : "-") + ") Problem received: " + ((Problem)object2).message);
                        if (!((Problem)object2).fatal) continue;
                        break;
                    }
                    if (AbstractUDTSocketConnectionHandler.this.receivedObject(object3)) continue;
                    if (object3 instanceof Message) {
                        if (AbstractUDTSocketConnectionHandler.this.member != null) {
                            AbstractUDTSocketConnectionHandler.this.member.handleMessage((Message)object3, AbstractUDTSocketConnectionHandler.this);
                            continue;
                        }
                        if (!AbstractUDTSocketConnectionHandler.this.isConnected() || AbstractUDTSocketConnectionHandler.this.lastKeepaliveMessage != null) break;
                        AbstractUDTSocketConnectionHandler.this.logWarning("Connection closed, message received, before peer identified itself: " + object3);
                        break;
                    }
                    AbstractUDTSocketConnectionHandler.this.logWarning("Received unknown message from peer: " + object3);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    AbstractUDTSocketConnectionHandler.this.logFiner("Socket timeout on read, not disconnecting. " + socketTimeoutException);
                }
                catch (SocketException socketException) {
                    AbstractUDTSocketConnectionHandler.this.logConnectionClose(socketException);
                    break;
                }
                catch (EOFException eOFException) {
                    AbstractUDTSocketConnectionHandler.this.logConnectionClose(eOFException);
                    break;
                }
                catch (InvalidClassException invalidClassException) {
                    AbstractUDTSocketConnectionHandler.this.logFiner("InvalidClassException", invalidClassException);
                    object = AbstractUDTSocketConnectionHandler.this.getMember() != null ? AbstractUDTSocketConnectionHandler.this.getMember().getNick() : this.toString();
                    AbstractUDTSocketConnectionHandler.this.logWarning("Received unknown packet/class: " + invalidClassException.getMessage() + " from " + (String)object);
                }
                catch (InvalidObjectException invalidObjectException) {
                    AbstractUDTSocketConnectionHandler.this.logFiner("InvalidObjectException", invalidObjectException);
                    object = AbstractUDTSocketConnectionHandler.this.getMember() != null ? AbstractUDTSocketConnectionHandler.this.getMember().getNick() : this.toString();
                    AbstractUDTSocketConnectionHandler.this.logWarning("Received invalid object: " + invalidObjectException.getMessage() + " from " + (String)object);
                }
                catch (IOException iOException) {
                    AbstractUDTSocketConnectionHandler.this.logFiner("IOException", iOException);
                    AbstractUDTSocketConnectionHandler.this.logConnectionClose(iOException);
                    break;
                }
                catch (ConnectionException connectionException) {
                    AbstractUDTSocketConnectionHandler.this.logFiner("ConnectionException", connectionException);
                    AbstractUDTSocketConnectionHandler.this.logConnectionClose(connectionException);
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    AbstractUDTSocketConnectionHandler.this.logFiner("ClassNotFoundException", classNotFoundException);
                    AbstractUDTSocketConnectionHandler.this.logWarning("Received unknown packet/class: " + classNotFoundException.getMessage() + " from " + AbstractUDTSocketConnectionHandler.this);
                }
                catch (RuntimeException runtimeException) {
                    AbstractUDTSocketConnectionHandler.this.logSevere("RuntimeException", runtimeException);
                    AbstractUDTSocketConnectionHandler.this.shutdownWithMember();
                    throw runtimeException;
                }
            }
            AbstractUDTSocketConnectionHandler.this.shutdownWithMember();
        }
    }

    class Sender
    implements Runnable {
        Sender() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (AbstractUDTSocketConnectionHandler.this.isFiner()) {
                AbstractUDTSocketConnectionHandler.this.logFiner("Asynchron message send triggered, sending " + AbstractUDTSocketConnectionHandler.this.messagesToSendQueue.size() + " message(s)");
            }
            if (!AbstractUDTSocketConnectionHandler.this.isConnected()) {
                AbstractUDTSocketConnectionHandler.this.logFine("Peer disconnected while sender got active. Msgs in queue: " + AbstractUDTSocketConnectionHandler.this.messagesToSendQueue.size() + ": " + AbstractUDTSocketConnectionHandler.this.messagesToSendQueue);
                return;
            }
            while (true) {
                AbstractUDTSocketConnectionHandler.this.senderSpawnLock.lock();
                Message message = (Message)AbstractUDTSocketConnectionHandler.this.messagesToSendQueue.poll();
                Queue queue = AbstractUDTSocketConnectionHandler.this.messagesToSendQueue;
                synchronized (queue) {
                    AbstractUDTSocketConnectionHandler.this.messagesToSendQueue.notifyAll();
                }
                if (message == null) {
                    AbstractUDTSocketConnectionHandler.this.sender = null;
                    AbstractUDTSocketConnectionHandler.this.senderSpawnLock.unlock();
                    break;
                }
                AbstractUDTSocketConnectionHandler.this.senderSpawnLock.unlock();
                if (!AbstractUDTSocketConnectionHandler.this.started) {
                    AbstractUDTSocketConnectionHandler.this.logFine("Peer shutdown while sending: " + message);
                    AbstractUDTSocketConnectionHandler.this.senderSpawnLock.lock();
                    AbstractUDTSocketConnectionHandler.this.sender = null;
                    AbstractUDTSocketConnectionHandler.this.senderSpawnLock.unlock();
                    AbstractUDTSocketConnectionHandler.this.shutdownWithMember();
                    break;
                }
                try {
                    AbstractUDTSocketConnectionHandler.this.sendMessage(message);
                }
                catch (ConnectionException connectionException) {
                    AbstractUDTSocketConnectionHandler.this.logFine("Unable to send message asynchronly. " + connectionException);
                    AbstractUDTSocketConnectionHandler.this.logFiner("ConnectionException", connectionException);
                    AbstractUDTSocketConnectionHandler.this.senderSpawnLock.lock();
                    AbstractUDTSocketConnectionHandler.this.sender = null;
                    AbstractUDTSocketConnectionHandler.this.senderSpawnLock.unlock();
                    AbstractUDTSocketConnectionHandler.this.shutdownWithMember();
                    break;
                }
                catch (Throwable throwable) {
                    AbstractUDTSocketConnectionHandler.this.logSevere("Unable to send message asynchronly. " + throwable, throwable);
                    AbstractUDTSocketConnectionHandler.this.senderSpawnLock.lock();
                    AbstractUDTSocketConnectionHandler.this.sender = null;
                    AbstractUDTSocketConnectionHandler.this.senderSpawnLock.unlock();
                    AbstractUDTSocketConnectionHandler.this.shutdownWithMember();
                    break;
                }
            }
        }
    }
}

