/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.net;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Feature;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.message.Identity;
import de.dal33t.powerfolder.message.IdentityReply;
import de.dal33t.powerfolder.message.LimitBandwidth;
import de.dal33t.powerfolder.message.Message;
import de.dal33t.powerfolder.message.Pong;
import de.dal33t.powerfolder.message.Problem;
import de.dal33t.powerfolder.net.ConnectionException;
import de.dal33t.powerfolder.net.ConnectionHandler;
import de.dal33t.powerfolder.net.ConnectionQuality;
import de.dal33t.powerfolder.transfer.LimitedInputStream;
import de.dal33t.powerfolder.transfer.LimitedOutputStream;
import de.dal33t.powerfolder.util.ByteSerializer;
import de.dal33t.powerfolder.util.Convert;
import de.dal33t.powerfolder.util.Format;
import de.dal33t.powerfolder.util.IdGenerator;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StreamUtils;
import de.dal33t.powerfolder.util.net.NetworkUtil;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Date;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class AbstractSocketConnectionHandler
extends PFComponent
implements ConnectionHandler {
    protected final Socket socket;
    protected Member member;
    protected Identity myIdentity;
    protected Identity identity;
    protected IdentityReply identityReply;
    private String myMagicId;
    protected LimitedOutputStream out;
    protected LimitedInputStream in;
    protected ByteSerializer serializer;
    protected Queue<Message> messagesToSendQueue;
    protected boolean started;
    private boolean onLAN;
    protected final Object identityWaiter = new Object();
    protected final Object identityAcceptWaiter = new Object();
    private final Object sendLock = new Object();
    private Runnable sender;
    protected Lock senderSpawnLock;
    protected Date lastKeepaliveMessage;
    private boolean omitBandwidthLimit;

    protected AbstractSocketConnectionHandler(Controller controller, Socket socket) {
        super(controller);
        this.socket = socket;
        this.serializer = new ByteSerializer();
    }

    protected abstract byte[] serialize(Message var1) throws ConnectionException;

    protected abstract Object deserialize(byte[] var1, int var2) throws ConnectionException, ClassNotFoundException;

    protected boolean receivedObject(Object object) throws ConnectionException {
        return false;
    }

    protected abstract Identity createOwnIdentity();

    protected ByteSerializer getSerializer() {
        return this.serializer;
    }

    protected Socket getSocket() {
        return this.socket;
    }

    @Override
    public void init() throws ConnectionException {
        if (this.socket == null) {
            throw new NullPointerException("Socket is null");
        }
        if (this.socket.isClosed() || !this.socket.isConnected()) {
            throw new ConnectionException("Connection to peer is closed").with(this);
        }
        this.started = true;
        this.identity = null;
        this.identityReply = null;
        this.messagesToSendQueue = new ConcurrentLinkedQueue<Message>();
        this.senderSpawnLock = new ReentrantLock();
        long l = System.currentTimeMillis();
        try {
            this.out = new LimitedOutputStream(this.getController().getTransferManager().getOutputLimiter(this), this.socket.getOutputStream());
            this.in = new LimitedInputStream(this.getController().getTransferManager().getInputLimiter(this), this.socket.getInputStream());
            if (this.isFiner()) {
                this.logFiner("Got streams");
            }
            this.analyseConnection();
            this.myMagicId = IdGenerator.makeId() + IdGenerator.makeId() + IdGenerator.makeId() + IdGenerator.makeId() + IdGenerator.makeId() + IdGenerator.makeId() + IdGenerator.makeId() + IdGenerator.makeId();
            this.myIdentity = this.createOwnIdentity();
            if (this.isFiner()) {
                this.logFiner("Sending my identity, nick: '" + this.myIdentity.getMemberInfo().nick + "', ID: " + this.myIdentity.getMemberInfo().id);
            }
            this.getController().getIOProvider().startIO(new Receiver());
            this.sendMessagesAsynchron(this.myIdentity);
        }
        catch (IOException iOException) {
            throw new ConnectionException("Unable to open connection: " + iOException.getMessage(), iOException).with(this);
        }
        this.waitForRemoteIdentity();
        if (!this.isConnected()) {
            this.shutdown();
            throw new ConnectionException("Remote peer " + this.socket.getRemoteSocketAddress() + " disconnected while waiting for his identity").with(this);
        }
        if (this.identity == null || this.identity.getMemberInfo() == null) {
            throw new ConnectionException("Did not receive a valid identity from peer after 60s").with(this);
        }
        long l2 = System.currentTimeMillis() - l;
        if (this.isFiner()) {
            this.logFiner("Connect took " + l2 + "ms, time differ: " + this.getTimeDeltaMS() / 1000L / 60L + " min, remote ident: " + this.getIdentity());
        }
        this.analyseConnection();
        this.getController().getIOProvider().startKeepAliveCheck(this);
    }

    @Override
    public void shutdownWithMember() {
        Member member = this.getMember();
        if (member != null) {
            member.shutdown();
        }
        if (this.started) {
            this.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Object object;
        block42: {
            if (!this.started) {
                return;
            }
            if (this.isFiner()) {
                this.logFiner("Shutting down");
            }
            this.started = false;
            this.setMember(null);
            this.messagesToSendQueue.clear();
            this.getController().getIOProvider().removeKeepAliveCheck(this);
            try {
                if (this.out != null) {
                    this.out.flush();
                }
                try {
                    this.socket.shutdownOutput();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.socket.setSoTimeout(200);
                if (this.in == null) break block42;
                object = new byte[1024];
                try {
                    while (this.in.read((byte[])object) != -1) {
                    }
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    // empty catch block
                }
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    if (this.out != null) {
                        this.out.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (this.in != null) {
                        this.in.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (this.socket != null) {
                        this.socket.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        Object object2 = this.identityWaiter;
        object = object2;
        synchronized (object2) {
            this.identityWaiter.notifyAll();
            // ** MonitorExit[var1_2 /* !! */ ] (shouldn't be in output)
            Object object3 = this.identityAcceptWaiter;
            object = object3;
            synchronized (object3) {
                this.identityAcceptWaiter.notifyAll();
                // ** MonitorExit[var1_2 /* !! */ ] (shouldn't be in output)
                Queue<Message> queue = this.messagesToSendQueue;
                object = queue;
                synchronized (queue) {
                    this.messagesToSendQueue.notifyAll();
                    // ** MonitorExit[var1_2 /* !! */ ] (shouldn't be in output)
                    this.serializer = null;
                    return;
                }
            }
        }
    }

    @Override
    public boolean isConnected() {
        return this.socket != null && this.in != null && this.out != null && this.socket.isConnected() && !this.socket.isClosed() && this.serializer != null;
    }

    @Override
    public boolean isEncrypted() {
        return false;
    }

    @Override
    public boolean isOnLAN() {
        return this.onLAN;
    }

    @Override
    public void setOnLAN(boolean bl) {
        this.onLAN = bl;
        this.out.setBandwidthLimiter(this.getController().getTransferManager().getOutputLimiter(this));
        this.in.setBandwidthLimiter(this.getController().getTransferManager().getInputLimiter(this));
    }

    public void setMember(Member member) {
        this.member = member;
    }

    @Override
    public Member getMember() {
        return this.member;
    }

    @Override
    public Date getLastKeepaliveMessageTime() {
        return this.lastKeepaliveMessage;
    }

    protected void read(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        StreamUtils.read(inputStream, byArray, n, n2);
        this.getController().getTransferManager().getTotalDownloadTrafficCounter().bytesTransferred(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessage(Message message) throws ConnectionException {
        if (message == null) {
            throw new NullPointerException("Message is null");
        }
        if (!this.isConnected()) {
            throw new ConnectionException("Connection to remote peer closed").with(this);
        }
        if (this.identity == null && !(message instanceof Identity)) {
            throw new ConnectionException("Unable to send message, peer did not identify yet").with(this);
        }
        try {
            Object object = this.sendLock;
            synchronized (object) {
                int n;
                if (this.isFiner()) {
                    this.logFiner("-- (sending) -> " + message);
                }
                if (!this.isConnected() || !this.started) {
                    throw new ConnectionException("Connection to remote peer closed").with(this);
                }
                long l = System.currentTimeMillis();
                boolean bl = !(message instanceof LimitBandwidth) || this.omitBandwidthLimit;
                byte[] byArray = this.serialize(message);
                if (null == byArray) {
                    throw new IllegalStateException("Got null while serializing message: " + message);
                }
                this.out.write(Convert.convert2Bytes(byArray.length));
                this.getController().getTransferManager().getTotalUploadTrafficCounter().bytesTransferred(byArray.length + 4);
                int n2 = 0;
                for (int i = byArray.length; i > 0; i -= n) {
                    n = i;
                    if (!this.started) {
                        throw new ConnectionException("Unable to send message to peer, connection shutdown").with(this.member).with(this);
                    }
                    this.out.write(byArray, n2, n, bl);
                    n2 += n;
                }
                long l2 = System.currentTimeMillis() - l;
                if (l2 > 40000L && this.isFine()) {
                    this.logFine("Sending (" + byArray.length + " bytes) took " + l2 + "ms: " + message + " to " + this.getMember());
                }
            }
        }
        catch (IOException iOException) {
            this.shutdownWithMember();
            throw new ConnectionException("Unable to send message to peer, connection closed: " + iOException.toString(), iOException).with(this.member).with(this);
        }
        catch (ConnectionException connectionException) {
            this.shutdownWithMember();
            throw connectionException;
        }
        catch (RuntimeException runtimeException) {
            this.logSevere("Runtime exception while serializing: " + message, runtimeException);
            this.shutdownWithMember();
            throw runtimeException;
        }
    }

    @Override
    public void sendMessagesAsynchron(Message ... messageArray) {
        for (Message message : messageArray) {
            this.sendMessageAsynchron(message, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessageAsynchron(Message message, String string) {
        Reject.ifNull(message, "Message is null");
        this.senderSpawnLock.lock();
        try {
            Object object;
            this.messagesToSendQueue.offer(message);
            if (this.messagesToSendQueue.size() > 1998 && this.isWarning()) {
                object = "Many messages in send queue: " + this.messagesToSendQueue.size() + ": " + this.messagesToSendQueue;
                if (((String)object).length() > 300) {
                    object = ((String)object).substring(0, 300);
                    object = (String)object + "...";
                }
                this.logFine((String)object);
            }
            if (this.messagesToSendQueue.size() > 2000) {
                object = "Disconnecting " + this.getIdentity() + ": Too many messages in send queue: " + this.messagesToSendQueue.size();
                this.logWarning((String)object);
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        AbstractSocketConnectionHandler.this.shutdownWithMember();
                    }
                };
                this.getController().getIOProvider().startIO(runnable);
                return;
            }
            if (this.sender == null) {
                this.sender = new Sender();
                this.getController().getIOProvider().startIO(this.sender);
            }
        }
        finally {
            this.senderSpawnLock.unlock();
        }
    }

    @Override
    public long getTimeDeltaMS() {
        if (this.identity.getTimeGMT() == null) {
            return 0L;
        }
        return this.myIdentity.getTimeGMT().getTimeInMillis() - this.identity.getTimeGMT().getTimeInMillis();
    }

    @Override
    public boolean canMeasureTimeDifference() {
        return this.identity.getTimeGMT() != null;
    }

    @Override
    public Identity getIdentity() {
        return this.identity;
    }

    @Override
    public Identity getMyIdentity() {
        return this.myIdentity;
    }

    @Override
    public String getMyMagicId() {
        return this.myMagicId;
    }

    @Override
    public String getRemoteMagicId() {
        return this.identity != null ? this.identity.getMagicId() : null;
    }

    @Override
    public ConnectionQuality getConnectionQuality() {
        if (this.identity != null && this.identity.isTunneled()) {
            return ConnectionQuality.POOR;
        }
        return ConnectionQuality.GOOD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForRemoteIdentity() {
        Object object = this.identityWaiter;
        synchronized (object) {
            if (this.identity == null) {
                try {
                    this.identityWaiter.wait(60000L);
                }
                catch (InterruptedException interruptedException) {
                    this.logFiner("InterruptedException", interruptedException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean acceptIdentity(Member member) {
        Reject.ifNull(member, "node is null");
        this.member = member;
        if (this.isFiner()) {
            this.logFiner("Sending accept of identity to " + this);
        }
        this.sendMessagesAsynchron(IdentityReply.accept());
        long l = System.currentTimeMillis();
        Object object = this.identityAcceptWaiter;
        synchronized (object) {
            if (this.identityReply == null) {
                try {
                    this.identityAcceptWaiter.wait(60000L);
                }
                catch (InterruptedException interruptedException) {
                    this.logFiner("InterruptedException", interruptedException);
                }
            }
        }
        long l2 = (System.currentTimeMillis() - l) / 1000L;
        if (this.identityReply != null && !this.identityReply.accepted) {
            this.logWarning("Remote peer '" + member + "' rejected our connection: " + this.identityReply.message);
            this.member = null;
            return false;
        }
        if (!this.isConnected()) {
            if (this.isFiner()) {
                this.logFiner("Remote member disconnected while waiting for identity reply. " + this.identity);
            }
            this.member = null;
            return false;
        }
        if (this.identityReply == null) {
            this.logFine("Did not receive a identity reply after " + l2 + "s. Connected? " + this.isConnected() + ". remote id: " + this.identity);
            this.member = null;
            return false;
        }
        if (this.identityReply.accepted) {
            if (this.isFiner()) {
                this.logFiner("Identity accepted by remote peer. " + this);
            }
        } else {
            this.member = null;
            this.logWarning("Identity rejected by remote peer. " + this);
        }
        return this.identityReply.accepted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitForEmptySendQueue() {
        long l = 0L;
        int n = this.messagesToSendQueue.size();
        while (!this.messagesToSendQueue.isEmpty() && this.isConnected()) {
            try {
                Queue<Message> queue = this.messagesToSendQueue;
                synchronized (queue) {
                    this.messagesToSendQueue.wait(1L);
                }
                ++l;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
                break;
            }
        }
        if (l > 0L && this.isFiner()) {
            this.logFiner(this.getMember() + ": Waited " + l + "ms for empty send buffer. " + n + " messages were in queue.");
        }
        return this.messagesToSendQueue.isEmpty();
    }

    private void analyseConnection() {
        if (Feature.CORRECT_LAN_DETECTION.isDisabled()) {
            this.logFine("ON LAN because of correct connection analyse disabled");
            this.setOnLAN(true);
            return;
        }
        if (Feature.CORRECT_INTERNET_DETECTION.isDisabled()) {
            this.logFine("ON Internet because of correct connection analyse disabled");
            this.setOnLAN(false);
            return;
        }
        if (this.identity != null && this.identity.isTunneled()) {
            this.setOnLAN(false);
            return;
        }
        if (this.getRemoteAddress() != null && this.getRemoteAddress().getAddress() != null) {
            InetAddress inetAddress = this.getRemoteAddress().getAddress();
            this.setOnLAN(this.getController().getNodeManager().isOnLANorConfiguredOnLAN(inetAddress));
            try {
                this.omitBandwidthLimit = NetworkUtil.isFromThisComputer(this.socket.getInetAddress());
            }
            catch (SocketException socketException) {
                this.logSevere("Omitting bandwidth", socketException);
            }
        }
        if (this.isFiner()) {
            this.logFiner("analyse connection: lan: " + this.onLAN);
        }
    }

    @Override
    public boolean acceptHandshake() {
        return true;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.socket.getRemoteSocketAddress();
    }

    @Override
    public int getRemoteListenerPort() {
        if (this.identity == null || this.identity.getMemberInfo() == null || this.identity.getMemberInfo().getConnectAddress() == null) {
            return -1;
        }
        if (this.identity.isTunneled()) {
            return -1;
        }
        return this.identity.getMemberInfo().getConnectAddress().getPort();
    }

    protected void logConnectionClose(Exception exception) {
        Member member = this.member;
        Identity identity = this.identity;
        if (member == null && identity != null) {
            member = identity.getMemberInfo().getNode(this.getController(), true);
        }
        String string = "Connection closed to " + (member == null ? this.toString() : member.toString());
        boolean bl = member != null && member.isServer() && !member.isMySelf() && !member.isConnected() && !this.getController().isShuttingDown() && this.getController().isStarted() && !(exception instanceof EOFException);
        string = string + ". Caused by ";
        if (member != null && member.getLastProblem() != null) {
            string = string + member.getLastProblem();
            string = string + ", ";
        }
        if (exception instanceof ConnectionException) {
            string = string + exception.getCause();
        } else if (exception != null) {
            string = string + exception.toString();
        }
        if (this.isWarning() && bl) {
            this.logWarning(string);
        } else if (this.isFine()) {
            this.logFine(string);
        }
        if (this.isFiner() && exception != null) {
            this.logFiner("Exception", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        if (this.socket == null) {
            return "-disconnected-";
        }
        Socket socket = this.socket;
        synchronized (socket) {
            return this.socket.getInetAddress() + ":" + this.socket.getPort();
        }
    }

    class Receiver
    implements Runnable {
        Receiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            byte[] byArray = new byte[4];
            while (AbstractSocketConnectionHandler.this.started && AbstractSocketConnectionHandler.this.isConnected()) {
                Object object;
                try {
                    Object object2;
                    AbstractSocketConnectionHandler.this.read(AbstractSocketConnectionHandler.this.in, byArray, 0, byArray.length);
                    int n = Convert.convert2Int(byArray);
                    if (!AbstractSocketConnectionHandler.this.started) break;
                    if (n == -1393754107) {
                        throw new IOException("Client has old protocol version");
                    }
                    if (n == -1) break;
                    if (n <= 0) {
                        throw new IOException("Illegal paket size: " + n);
                    }
                    object = AbstractSocketConnectionHandler.this.serializer;
                    if (object == null) {
                        throw new EOFException();
                    }
                    byte[] byArray2 = ((ByteSerializer)object).read(AbstractSocketConnectionHandler.this.in, n);
                    Object object3 = AbstractSocketConnectionHandler.this.deserialize(byArray2, n);
                    AbstractSocketConnectionHandler.this.lastKeepaliveMessage = new Date();
                    AbstractSocketConnectionHandler.this.getController().getTransferManager().getTotalDownloadTrafficCounter().bytesTransferred(n);
                    if (AbstractSocketConnectionHandler.this.isFiner()) {
                        AbstractSocketConnectionHandler.this.logFiner("<- (received, " + Format.formatBytes(n) + ") - " + object3);
                    }
                    if (!AbstractSocketConnectionHandler.this.getController().isStarted()) {
                        AbstractSocketConnectionHandler.this.logFiner("Peer still active, shutting down " + AbstractSocketConnectionHandler.this.getMember());
                        break;
                    }
                    if (object3 instanceof Identity) {
                        if (AbstractSocketConnectionHandler.this.isFiner()) {
                            AbstractSocketConnectionHandler.this.logFiner("Received remote identity: " + object3);
                        }
                        object2 = AbstractSocketConnectionHandler.this.identityWaiter;
                        synchronized (object2) {
                            AbstractSocketConnectionHandler.this.identity = (Identity)object3;
                            AbstractSocketConnectionHandler.this.identityWaiter.notifyAll();
                        }
                        if (!AbstractSocketConnectionHandler.this.isFiner()) continue;
                        AbstractSocketConnectionHandler.this.logFiner("Received magicId: " + AbstractSocketConnectionHandler.this.identity.getMagicId());
                        continue;
                    }
                    if (object3 instanceof IdentityReply) {
                        if (AbstractSocketConnectionHandler.this.isFiner()) {
                            AbstractSocketConnectionHandler.this.logFiner("Received identity reply: " + object3);
                        }
                        object2 = AbstractSocketConnectionHandler.this.identityAcceptWaiter;
                        synchronized (object2) {
                            AbstractSocketConnectionHandler.this.identityReply = (IdentityReply)object3;
                            AbstractSocketConnectionHandler.this.identityAcceptWaiter.notifyAll();
                            continue;
                        }
                    }
                    if (object3 instanceof Pong) continue;
                    if (object3 instanceof Problem) {
                        object2 = (Problem)object3;
                        if (AbstractSocketConnectionHandler.this.member != null) {
                            AbstractSocketConnectionHandler.this.member.handleMessage((Message)object2, AbstractSocketConnectionHandler.this);
                            continue;
                        }
                        AbstractSocketConnectionHandler.this.logFine("(" + (AbstractSocketConnectionHandler.this.identity != null ? AbstractSocketConnectionHandler.this.identity.getMemberInfo().nick : "-") + ") Problem received: " + ((Problem)object2).message);
                        if (!((Problem)object2).fatal) continue;
                        break;
                    }
                    if (AbstractSocketConnectionHandler.this.receivedObject(object3)) continue;
                    if (object3 instanceof Message) {
                        object2 = AbstractSocketConnectionHandler.this.member;
                        if (object2 != null) {
                            ((Member)object2).handleMessage((Message)object3, AbstractSocketConnectionHandler.this);
                            continue;
                        }
                        if (!AbstractSocketConnectionHandler.this.isConnected() || AbstractSocketConnectionHandler.this.lastKeepaliveMessage != null) break;
                        AbstractSocketConnectionHandler.this.logWarning("Connection closed, message received, before peer identified itself: " + object3);
                        break;
                    }
                    AbstractSocketConnectionHandler.this.logWarning("Received unknown message from peer: " + object3);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    AbstractSocketConnectionHandler.this.logFiner("Socket timeout on read, not disconnecting. " + socketTimeoutException);
                }
                catch (SocketException socketException) {
                    AbstractSocketConnectionHandler.this.logConnectionClose(socketException);
                    break;
                }
                catch (EOFException eOFException) {
                    AbstractSocketConnectionHandler.this.logConnectionClose(eOFException);
                    break;
                }
                catch (InvalidClassException invalidClassException) {
                    AbstractSocketConnectionHandler.this.logFiner("InvalidClassException", invalidClassException);
                    object = AbstractSocketConnectionHandler.this.getMember() != null ? AbstractSocketConnectionHandler.this.getMember().getNick() : this.toString();
                    AbstractSocketConnectionHandler.this.logWarning("Received unknown packet/class: " + invalidClassException.getMessage() + " from " + (String)object);
                }
                catch (InvalidObjectException invalidObjectException) {
                    AbstractSocketConnectionHandler.this.logFiner("InvalidObjectException", invalidObjectException);
                    object = AbstractSocketConnectionHandler.this.getMember() != null ? AbstractSocketConnectionHandler.this.getMember().getNick() : this.toString();
                    AbstractSocketConnectionHandler.this.logWarning("Received invalid object: " + invalidObjectException.getMessage() + " from " + (String)object);
                }
                catch (IOException iOException) {
                    AbstractSocketConnectionHandler.this.logFiner("IOException", iOException);
                    AbstractSocketConnectionHandler.this.logConnectionClose(iOException);
                    break;
                }
                catch (ConnectionException connectionException) {
                    AbstractSocketConnectionHandler.this.logFiner("ConnectionException", connectionException);
                    AbstractSocketConnectionHandler.this.logConnectionClose(connectionException);
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    AbstractSocketConnectionHandler.this.logFiner("ClassNotFoundException", classNotFoundException);
                    AbstractSocketConnectionHandler.this.logWarning("Received unknown packet/class: " + classNotFoundException.getMessage() + " from " + AbstractSocketConnectionHandler.this);
                }
                catch (RuntimeException runtimeException) {
                    AbstractSocketConnectionHandler.this.logSevere("RuntimeException. " + runtimeException, runtimeException);
                    AbstractSocketConnectionHandler.this.shutdownWithMember();
                    throw runtimeException;
                }
            }
            AbstractSocketConnectionHandler.this.shutdownWithMember();
        }
    }

    class Sender
    implements Runnable {
        Sender() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (AbstractSocketConnectionHandler.this.isFiner()) {
                AbstractSocketConnectionHandler.this.logFiner("Asynchron message send triggered, sending " + AbstractSocketConnectionHandler.this.messagesToSendQueue.size() + " message(s)");
            }
            if (!AbstractSocketConnectionHandler.this.isConnected()) {
                if (AbstractSocketConnectionHandler.this.isFiner()) {
                    AbstractSocketConnectionHandler.this.logFiner("Peer disconnected while sender got active. Msgs in queue: " + AbstractSocketConnectionHandler.this.messagesToSendQueue.size() + ": " + AbstractSocketConnectionHandler.this.messagesToSendQueue);
                }
                return;
            }
            while (true) {
                AbstractSocketConnectionHandler.this.senderSpawnLock.lock();
                Message message = AbstractSocketConnectionHandler.this.messagesToSendQueue.poll();
                Queue<Message> queue = AbstractSocketConnectionHandler.this.messagesToSendQueue;
                synchronized (queue) {
                    AbstractSocketConnectionHandler.this.messagesToSendQueue.notifyAll();
                }
                if (message == null) {
                    AbstractSocketConnectionHandler.this.sender = null;
                    AbstractSocketConnectionHandler.this.senderSpawnLock.unlock();
                    break;
                }
                AbstractSocketConnectionHandler.this.senderSpawnLock.unlock();
                if (!AbstractSocketConnectionHandler.this.started) {
                    AbstractSocketConnectionHandler.this.logFine("Peer shutdown while sending: " + message);
                    AbstractSocketConnectionHandler.this.senderSpawnLock.lock();
                    AbstractSocketConnectionHandler.this.sender = null;
                    AbstractSocketConnectionHandler.this.senderSpawnLock.unlock();
                    AbstractSocketConnectionHandler.this.shutdownWithMember();
                    break;
                }
                try {
                    AbstractSocketConnectionHandler.this.sendMessage(message);
                }
                catch (ConnectionException connectionException) {
                    AbstractSocketConnectionHandler.this.logFine("Unable to send message asynchronly. " + connectionException);
                    AbstractSocketConnectionHandler.this.logFiner("ConnectionException", connectionException);
                    AbstractSocketConnectionHandler.this.senderSpawnLock.lock();
                    AbstractSocketConnectionHandler.this.sender = null;
                    AbstractSocketConnectionHandler.this.senderSpawnLock.unlock();
                    AbstractSocketConnectionHandler.this.shutdownWithMember();
                    break;
                }
                catch (Throwable throwable) {
                    AbstractSocketConnectionHandler.this.logSevere("Unable to send message asynchronly. " + throwable, throwable);
                    AbstractSocketConnectionHandler.this.senderSpawnLock.lock();
                    AbstractSocketConnectionHandler.this.sender = null;
                    AbstractSocketConnectionHandler.this.senderSpawnLock.unlock();
                    AbstractSocketConnectionHandler.this.shutdownWithMember();
                    break;
                }
            }
        }
    }
}

