/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.net;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.message.Identity;
import de.dal33t.powerfolder.message.IdentityReply;
import de.dal33t.powerfolder.message.Message;
import de.dal33t.powerfolder.message.Pong;
import de.dal33t.powerfolder.message.Problem;
import de.dal33t.powerfolder.message.RelayedMessage;
import de.dal33t.powerfolder.message.RelayedMessageExt;
import de.dal33t.powerfolder.net.ConnectionException;
import de.dal33t.powerfolder.net.ConnectionHandler;
import de.dal33t.powerfolder.net.ConnectionQuality;
import de.dal33t.powerfolder.util.ByteSerializer;
import de.dal33t.powerfolder.util.Format;
import de.dal33t.powerfolder.util.IdGenerator;
import de.dal33t.powerfolder.util.Reject;
import java.net.InetSocketAddress;
import java.util.Date;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class AbstractRelayedConnectionHandler
extends PFComponent
implements ConnectionHandler {
    private Member relay;
    private long connectionId;
    private MemberInfo remote;
    private Member member;
    private Identity myIdentity;
    private Identity identity;
    private IdentityReply identityReply;
    private String myMagicId;
    private ByteSerializer serializer;
    private Queue<Message> messagesToSendQueue;
    private boolean started;
    private final Object identityWaiter = new Object();
    private final Object identityAcceptWaiter = new Object();
    private final Object sendLock = new Object();
    private Runnable sender;
    private Lock senderSpawnLock;
    private Date lastKeepaliveMessage;
    private boolean ackReceived;
    private boolean nackReceived;
    private ConcurrentLinkedQueue<RelayedMessage> receiveQueue = new ConcurrentLinkedQueue();
    private AtomicBoolean receiving = new AtomicBoolean(false);

    protected AbstractRelayedConnectionHandler(Controller controller, MemberInfo memberInfo, long l, Member member) {
        super(controller);
        Reject.ifNull(memberInfo, "Remote is null");
        Reject.ifNull(member, "Relay is null");
        this.remote = memberInfo;
        this.relay = member;
        this.serializer = new ByteSerializer();
        this.connectionId = l;
    }

    protected abstract byte[] serialize(Message var1) throws ConnectionException;

    protected abstract Object deserialize(byte[] var1, int var2) throws ConnectionException, ClassNotFoundException;

    protected boolean receivedObject(Object object) throws ConnectionException {
        return false;
    }

    protected abstract Identity createOwnIdentity();

    protected ByteSerializer getSerializer() {
        return this.serializer;
    }

    protected Member getRelay() {
        return this.relay;
    }

    @Override
    public void init() throws ConnectionException {
        if (!this.relay.isCompletelyConnected()) {
            throw new ConnectionException("Connection to peer is closed").with(this);
        }
        this.started = true;
        this.messagesToSendQueue = new ConcurrentLinkedQueue<Message>();
        this.senderSpawnLock = new ReentrantLock();
        long l = System.currentTimeMillis();
        this.myMagicId = IdGenerator.makeId() + IdGenerator.makeId() + IdGenerator.makeId() + IdGenerator.makeId() + IdGenerator.makeId() + IdGenerator.makeId() + IdGenerator.makeId() + IdGenerator.makeId();
        this.myIdentity = this.createOwnIdentity();
        if (this.isFiner()) {
            this.logFiner("Sending my identity, nick: '" + this.myIdentity.getMemberInfo().nick + "', ID: " + this.myIdentity.getMemberInfo().id);
        }
        this.sendMessagesAsynchron(this.myIdentity);
        this.waitForRemoteIdentity();
        if (!this.isConnected()) {
            this.shutdown();
            throw new ConnectionException("Remote peer disconnected while waiting for his identity").with(this);
        }
        if (this.identity == null || this.identity.getMemberInfo() == null) {
            throw new ConnectionException("Did not receive a valid identity from peer after 60s: " + this.getRemote()).with(this);
        }
        long l2 = System.currentTimeMillis() - l;
        if (this.isFiner()) {
            this.logFiner("Connect took " + l2 + "ms, time differ: " + this.getTimeDeltaMS() / 1000L / 60L + " min, remote ident: " + this.getIdentity());
        }
        this.getController().getIOProvider().startKeepAliveCheck(this);
    }

    @Override
    public void shutdownWithMember() {
        if (this.getMember() != null) {
            this.getMember().shutdown();
        }
        if (this.started) {
            this.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        if (!this.started) {
            return;
        }
        if (this.isFiner()) {
            this.logFiner("Shutting down");
        }
        this.started = false;
        this.setMember(null);
        this.messagesToSendQueue.clear();
        this.getController().getIOProvider().getRelayedConnectionManager().removePedingRelayedConnectionHandler(this);
        this.getController().getIOProvider().removeKeepAliveCheck(this);
        Queue<Message> queue = this.identityWaiter;
        synchronized (queue) {
            this.identityWaiter.notifyAll();
        }
        queue = this.identityAcceptWaiter;
        synchronized (queue) {
            this.identityAcceptWaiter.notifyAll();
        }
        queue = this.messagesToSendQueue;
        synchronized (queue) {
            this.messagesToSendQueue.notifyAll();
        }
        this.serializer = null;
    }

    @Override
    public boolean isConnected() {
        return this.started && this.relay.isConnected();
    }

    @Override
    public boolean isEncrypted() {
        return false;
    }

    @Override
    public boolean isOnLAN() {
        return false;
    }

    @Override
    public void setOnLAN(boolean bl) {
    }

    public void setMember(Member member) {
        this.member = member;
    }

    @Override
    public Member getMember() {
        return this.member;
    }

    @Override
    public Date getLastKeepaliveMessageTime() {
        return this.lastKeepaliveMessage;
    }

    public MemberInfo getRemote() {
        return this.remote;
    }

    public long getConnectionId() {
        return this.connectionId;
    }

    public boolean isAckReceived() {
        return this.ackReceived;
    }

    public void setAckReceived(boolean bl) {
        this.ackReceived = bl;
    }

    public boolean isNackReceived() {
        return this.nackReceived;
    }

    public void setNackReceived(boolean bl) {
        this.nackReceived = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessage(Message message) throws ConnectionException {
        if (message == null) {
            throw new NullPointerException("Message is null");
        }
        if (!this.isConnected()) {
            throw new ConnectionException("Connection to remote peer closed").with(this);
        }
        if (this.identity == null && !(message instanceof Identity)) {
            throw new ConnectionException("Unable to send message, peer did not identify yet").with(this);
        }
        try {
            Object object = this.sendLock;
            synchronized (object) {
                if (this.isFiner()) {
                    this.logFiner("-- (sending) -> " + message);
                }
                if (!this.isConnected() || !this.started) {
                    throw new ConnectionException("Connection to remote peer closed").with(this);
                }
                byte[] byArray = this.serialize(message);
                RelayedMessage relayedMessage = this.identity != null && this.identity.getProtocolVersion() >= 108 && this.relay.getProtocolVersion() >= 108 ? new RelayedMessageExt(RelayedMessage.Type.DATA_ZIPPED, this.getController().getMySelf().getInfo(), this.remote, this.connectionId, byArray) : new RelayedMessage(RelayedMessage.Type.DATA_ZIPPED, this.getController().getMySelf().getInfo(), this.remote, this.connectionId, byArray);
                this.relay.sendMessage(relayedMessage);
                this.getController().getTransferManager().getTotalUploadTrafficCounter().bytesTransferred(byArray.length + 4);
            }
        }
        catch (RuntimeException runtimeException) {
            this.logSevere("Runtime exception while serializing: " + message, runtimeException);
            this.shutdownWithMember();
            throw runtimeException;
        }
        catch (ConnectionException connectionException) {
            this.shutdownWithMember();
            throw connectionException;
        }
    }

    @Override
    public void sendMessagesAsynchron(Message ... messageArray) {
        for (Message message : messageArray) {
            this.sendMessageAsynchron(message, null);
        }
    }

    private void sendMessageAsynchron(Message message, String string) {
        Object object;
        Reject.ifNull(message, "Message is null");
        this.senderSpawnLock.lock();
        this.messagesToSendQueue.offer(message);
        if (this.messagesToSendQueue.size() > 1998 && this.isWarning()) {
            object = "Many messages in send queue: " + this.messagesToSendQueue.size() + ": " + this.messagesToSendQueue;
            if (((String)object).length() > 300) {
                object = ((String)object).substring(0, 300);
                object = (String)object + "...";
            }
            this.logFine((String)object);
        }
        if (this.messagesToSendQueue.size() > 2000) {
            object = "Disconnecting " + this.getIdentity() + ": Too many messages in send queue: " + this.messagesToSendQueue.size();
            this.logWarning((String)object);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    AbstractRelayedConnectionHandler.this.shutdownWithMember();
                }
            };
            this.getController().getIOProvider().startIO(runnable);
            return;
        }
        if (this.sender == null) {
            this.sender = new Sender();
            this.getController().getIOProvider().startIO(this.sender);
        }
        this.senderSpawnLock.unlock();
    }

    @Override
    public long getTimeDeltaMS() {
        if (this.identity.getTimeGMT() == null) {
            return 0L;
        }
        return this.myIdentity.getTimeGMT().getTimeInMillis() - this.identity.getTimeGMT().getTimeInMillis();
    }

    @Override
    public boolean canMeasureTimeDifference() {
        return this.identity.getTimeGMT() != null;
    }

    @Override
    public Identity getIdentity() {
        return this.identity;
    }

    @Override
    public Identity getMyIdentity() {
        return this.myIdentity;
    }

    @Override
    public String getMyMagicId() {
        return this.myMagicId;
    }

    @Override
    public String getRemoteMagicId() {
        return this.identity != null ? this.identity.getMagicId() : null;
    }

    @Override
    public ConnectionQuality getConnectionQuality() {
        return ConnectionQuality.POOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForRemoteIdentity() {
        Object object = this.identityWaiter;
        synchronized (object) {
            if (this.identity == null) {
                try {
                    this.identityWaiter.wait(60000L);
                }
                catch (InterruptedException interruptedException) {
                    this.logFiner("InterruptedException", interruptedException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean acceptIdentity(Member member) {
        Reject.ifNull(member, "node is null");
        this.member = member;
        if (this.isFiner()) {
            this.logFiner("Sending accept of identity to " + this);
        }
        this.sendMessagesAsynchron(IdentityReply.accept());
        long l = System.currentTimeMillis();
        Object object = this.identityAcceptWaiter;
        synchronized (object) {
            if (this.identityReply == null) {
                try {
                    this.identityAcceptWaiter.wait(20000L);
                }
                catch (InterruptedException interruptedException) {
                    this.logFiner("InterruptedException", interruptedException);
                }
            }
        }
        long l2 = (System.currentTimeMillis() - l) / 1000L;
        if (this.identityReply != null && !this.identityReply.accepted) {
            this.logWarning("Remote peer '" + member + "' rejected our connection: " + this.identityReply.message);
            this.member = null;
            return false;
        }
        if (!this.isConnected()) {
            this.logFine("Remote member disconnected while waiting for identity reply. " + this.identity);
            this.member = null;
            return false;
        }
        if (this.identityReply == null) {
            this.logFine("Did not receive a identity reply after " + l2 + "s. Connected? " + this.isConnected() + ". remote id: " + this.identity);
            this.member = null;
            return false;
        }
        if (this.identityReply.accepted) {
            if (this.isFiner()) {
                this.logFiner("Identity accepted by remote peer. " + this);
            }
        } else {
            this.member = null;
            this.logWarning("Identity rejected by remote peer. " + this);
        }
        return this.identityReply.accepted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitForEmptySendQueue() {
        long l = 0L;
        int n = this.messagesToSendQueue.size();
        while (!this.messagesToSendQueue.isEmpty() && this.isConnected()) {
            try {
                Queue<Message> queue = this.messagesToSendQueue;
                synchronized (queue) {
                    this.messagesToSendQueue.wait(1L);
                }
                ++l;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
                break;
            }
        }
        if (l > 0L && this.isFiner()) {
            this.logFiner(this.getMember() + ": Waited " + l + "ms for empty send buffer. " + n + " messages were in queue.");
        }
        return this.messagesToSendQueue.isEmpty();
    }

    @Override
    public boolean acceptHandshake() {
        this.getController().getIOProvider().getRelayedConnectionManager().removePedingRelayedConnectionHandler(this);
        return true;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.getMember() != null ? this.getMember().getReconnectAddress() : null;
    }

    @Override
    public int getRemoteListenerPort() {
        if (this.identity == null || this.identity.getMemberInfo() == null || this.identity.getMemberInfo().getConnectAddress() == null) {
            return -1;
        }
        if (this.identity.isTunneled()) {
            return -1;
        }
        return this.identity.getMemberInfo().getConnectAddress().getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveRelayedMessage(RelayedMessage relayedMessage) {
        boolean bl = false;
        ConcurrentLinkedQueue<RelayedMessage> concurrentLinkedQueue = this.receiveQueue;
        synchronized (concurrentLinkedQueue) {
            this.receiveQueue.offer(relayedMessage);
            bl = this.receiving.compareAndSet(false, true);
        }
        if (bl) {
            this.getController().getIOProvider().startIO(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (true) {
                        RelayedMessage relayedMessage;
                        ConcurrentLinkedQueue concurrentLinkedQueue = AbstractRelayedConnectionHandler.this.receiveQueue;
                        synchronized (concurrentLinkedQueue) {
                            relayedMessage = (RelayedMessage)AbstractRelayedConnectionHandler.this.receiveQueue.poll();
                            if (relayedMessage == null) {
                                AbstractRelayedConnectionHandler.this.receiving.set(false);
                                break;
                            }
                        }
                        AbstractRelayedConnectionHandler.this.receiveRelayedMessage0(relayedMessage);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveRelayedMessage0(RelayedMessage relayedMessage) {
        block33: {
            try {
                byte[] byArray = relayedMessage.getPayload();
                Object object = this.deserialize(byArray, byArray.length);
                this.lastKeepaliveMessage = new Date();
                this.getController().getTransferManager().getTotalDownloadTrafficCounter().bytesTransferred(byArray.length);
                if (this.isFiner()) {
                    this.logFiner("<- (received, " + Format.formatBytes(byArray.length) + ") - " + object);
                }
                if (!this.getController().isStarted()) {
                    this.logFiner("Peer still active, shutting down " + this.getMember());
                    this.shutdownWithMember();
                    return;
                }
                if (object instanceof Identity) {
                    if (this.isFiner()) {
                        this.logFiner("Received remote identity: " + object);
                    }
                    Object object2 = this.identityWaiter;
                    synchronized (object2) {
                        this.identity = (Identity)object;
                        this.identityWaiter.notifyAll();
                    }
                    if (this.isFiner()) {
                        this.logFiner("Received magicId: " + this.identity.getMagicId());
                    }
                    break block33;
                }
                if (object instanceof IdentityReply) {
                    if (this.isFiner()) {
                        this.logFiner("Received identity reply: " + object);
                    }
                    Object object3 = this.identityAcceptWaiter;
                    synchronized (object3) {
                        this.identityReply = (IdentityReply)object;
                        this.identityAcceptWaiter.notifyAll();
                        break block33;
                    }
                }
                if (!(object instanceof Pong)) {
                    if (object instanceof Problem) {
                        Problem problem = (Problem)object;
                        if (this.member != null) {
                            this.member.handleMessage(problem, this);
                        } else {
                            this.logFine("(" + (this.identity != null ? this.identity.getMemberInfo().nick : "-") + ") Problem received: " + problem.message);
                            if (problem.fatal) {
                                this.shutdown();
                            }
                        }
                    } else if (!this.receivedObject(object)) {
                        if (object instanceof Message) {
                            if (this.member != null) {
                                this.member.handleMessage((Message)object, this);
                            } else if (!this.isConnected()) {
                                this.shutdownWithMember();
                            } else {
                                if (this.lastKeepaliveMessage == null) {
                                    this.logWarning("Connection closed, message received, before peer identified itself: " + object);
                                }
                                this.shutdownWithMember();
                            }
                        } else {
                            this.logWarning("Received unknown message from peer: " + object);
                        }
                    }
                }
            }
            catch (ConnectionException connectionException) {
                this.logFiner("ConnectionException", connectionException);
                this.logConnectionClose(connectionException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.logFiner("ClassNotFoundException", classNotFoundException);
                this.logWarning("Received unknown packet/class: " + classNotFoundException.getMessage() + " from " + this);
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < relayedMessage.getPayload().length; ++i) {
                    stringBuffer.append(Integer.toHexString(0xFF & relayedMessage.getPayload()[i]));
                }
                this.logWarning("On message: " + relayedMessage + ": " + stringBuffer);
            }
            catch (RuntimeException runtimeException) {
                this.logSevere("RuntimeException", runtimeException);
                this.shutdownWithMember();
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < relayedMessage.getPayload().length; ++i) {
                    stringBuffer.append(Integer.toHexString(0xFF & relayedMessage.getPayload()[i]));
                }
                this.logWarning("On message: " + relayedMessage + ": " + stringBuffer);
                throw runtimeException;
            }
        }
    }

    private void logConnectionClose(Exception exception) {
        Member member = this.member;
        Identity identity = this.identity;
        if (member == null && identity != null) {
            member = identity.getMemberInfo().getNode(this.getController(), true);
        }
        String string = "Connection closed to " + (member == null ? this.toString() : member.toString());
        boolean bl = member != null && member.isServer() && !member.isMySelf() && !member.isConnected() && !this.getController().isShuttingDown() && this.getController().isStarted();
        string = string + ". Caused by ";
        if (member != null && member.getLastProblem() != null) {
            string = string + member.getLastProblem();
            string = string + ", ";
        }
        if (exception instanceof ConnectionException) {
            string = string + exception.getCause();
        } else if (exception != null) {
            string = string + exception.toString();
        }
        if (this.isWarning() && bl) {
            this.logWarning(string);
        } else if (this.isFine()) {
            this.logFine(string);
        }
        if (this.isFiner()) {
            this.logFiner("Exception", exception);
        }
    }

    public String toString() {
        return "RelayedConHan '" + this.remote.nick + "-" + this.connectionId + "'";
    }

    class Sender
    implements Runnable {
        Sender() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (AbstractRelayedConnectionHandler.this.isFiner()) {
                AbstractRelayedConnectionHandler.this.logFiner("Asynchron message send triggered, sending " + AbstractRelayedConnectionHandler.this.messagesToSendQueue.size() + " message(s)");
            }
            if (!AbstractRelayedConnectionHandler.this.isConnected()) {
                AbstractRelayedConnectionHandler.this.logFine("Peer disconnected while sender got active. Msgs in queue: " + AbstractRelayedConnectionHandler.this.messagesToSendQueue.size() + ": " + AbstractRelayedConnectionHandler.this.messagesToSendQueue);
                return;
            }
            int n = 0;
            while (true) {
                AbstractRelayedConnectionHandler.this.senderSpawnLock.lock();
                Message message = (Message)AbstractRelayedConnectionHandler.this.messagesToSendQueue.poll();
                Queue queue = AbstractRelayedConnectionHandler.this.messagesToSendQueue;
                synchronized (queue) {
                    AbstractRelayedConnectionHandler.this.messagesToSendQueue.notifyAll();
                }
                if (message == null) {
                    AbstractRelayedConnectionHandler.this.sender = null;
                    AbstractRelayedConnectionHandler.this.senderSpawnLock.unlock();
                    break;
                }
                AbstractRelayedConnectionHandler.this.senderSpawnLock.unlock();
                ++n;
                if (!AbstractRelayedConnectionHandler.this.started) {
                    AbstractRelayedConnectionHandler.this.logFine("Peer shutdown while sending: " + message);
                    AbstractRelayedConnectionHandler.this.senderSpawnLock.lock();
                    AbstractRelayedConnectionHandler.this.sender = null;
                    AbstractRelayedConnectionHandler.this.senderSpawnLock.unlock();
                    AbstractRelayedConnectionHandler.this.shutdownWithMember();
                    break;
                }
                try {
                    AbstractRelayedConnectionHandler.this.sendMessage(message);
                }
                catch (ConnectionException connectionException) {
                    AbstractRelayedConnectionHandler.this.logFine("Unable to send message asynchronly. " + connectionException);
                    AbstractRelayedConnectionHandler.this.logFiner("ConnectionException", connectionException);
                    AbstractRelayedConnectionHandler.this.senderSpawnLock.lock();
                    AbstractRelayedConnectionHandler.this.sender = null;
                    AbstractRelayedConnectionHandler.this.senderSpawnLock.unlock();
                    AbstractRelayedConnectionHandler.this.shutdownWithMember();
                    break;
                }
                catch (Throwable throwable) {
                    AbstractRelayedConnectionHandler.this.logSevere("Unable to send message asynchronly. " + throwable, throwable);
                    AbstractRelayedConnectionHandler.this.senderSpawnLock.lock();
                    AbstractRelayedConnectionHandler.this.sender = null;
                    AbstractRelayedConnectionHandler.this.senderSpawnLock.unlock();
                    AbstractRelayedConnectionHandler.this.shutdownWithMember();
                    break;
                }
            }
        }
    }
}

