/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.message.clientserver;

import com.google.protobuf.AbstractMessage;
import de.dal33t.powerfolder.d2d.D2DRequestMessage;
import de.dal33t.powerfolder.d2d.D2DRequestToServer;
import de.dal33t.powerfolder.d2d.NodeEvent;
import de.dal33t.powerfolder.protocol.ShareLinkInfoRequestProto;
import de.dal33t.powerfolder.util.StringUtils;

public class ShareLinkInfoRequest
extends D2DRequestMessage
implements D2DRequestToServer {
    private String fileRelativePath;
    private String folderId;

    public ShareLinkInfoRequest() {
    }

    public ShareLinkInfoRequest(AbstractMessage abstractMessage) {
        this.initFromD2D(abstractMessage);
    }

    public String getFileRelativePath() {
        return this.fileRelativePath;
    }

    public void setFileRelativePath(String string) {
        this.fileRelativePath = string;
    }

    public String getFolderId() {
        return this.folderId;
    }

    public void setFolderId(String string) {
        this.folderId = string;
    }

    @Override
    public void initFromD2D(AbstractMessage abstractMessage) {
        if (abstractMessage instanceof ShareLinkInfoRequestProto.ShareLinkInfoRequest) {
            ShareLinkInfoRequestProto.ShareLinkInfoRequest shareLinkInfoRequest = (ShareLinkInfoRequestProto.ShareLinkInfoRequest)abstractMessage;
            this.requestCode = shareLinkInfoRequest.getRequestCode();
            this.fileRelativePath = shareLinkInfoRequest.getFileRelativePath();
            this.folderId = shareLinkInfoRequest.getFolderId();
        }
    }

    @Override
    public AbstractMessage toD2D() {
        ShareLinkInfoRequestProto.ShareLinkInfoRequest.Builder builder = ShareLinkInfoRequestProto.ShareLinkInfoRequest.newBuilder();
        builder.setClazzName(this.getClass().getSimpleName());
        if (this.requestCode != null) {
            builder.setRequestCode(this.getRequestCode());
        }
        if (this.fileRelativePath != null) {
            builder.setFileRelativePath(this.fileRelativePath);
        }
        if (this.folderId != null) {
            builder.setFolderId(this.folderId);
        }
        return builder.build();
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.fileRelativePath != null && StringUtils.isNotBlank(this.folderId);
    }

    @Override
    public NodeEvent getNodeEvent() {
        return NodeEvent.SHARE_LINK_INFO_REQUEST;
    }
}

