/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.message.clientserver;

import de.dal33t.powerfolder.message.clientserver.Request;
import de.dal33t.powerfolder.util.ByteSerializer;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.lang.reflect.Method;

public class RemoteMethodCallRequest
extends Request {
    private static final long serialVersionUID = 100L;
    private String serviceId;
    private String methodName;
    private Class<?>[] methodParamTypes;
    private Object[] args;
    private byte[][] argsSerialized;

    public RemoteMethodCallRequest(String string, Method method, Object ... objectArray) {
        this.serviceId = string;
        this.methodName = method.getName();
        this.methodParamTypes = method.getParameterTypes();
        this.args = objectArray;
    }

    public RemoteMethodCallRequest toSerzializedForm() throws IOException {
        if (this.args == null) {
            this.argsSerialized = null;
            return this;
        }
        if (this.args.length == 0) {
            this.argsSerialized = new byte[0][0];
            return this;
        }
        this.argsSerialized = new byte[this.args.length][0];
        for (int i = 0; i < this.args.length; ++i) {
            Object object = this.args[i];
            if (object == null) {
                this.argsSerialized[i] = null;
                continue;
            }
            if (object instanceof Serializable) {
                this.argsSerialized[i] = ByteSerializer.serializeStatic((Serializable)object, false);
                continue;
            }
            throw new NotSerializableException("Argument not serializable: " + object);
        }
        this.args = null;
        return this;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public Method getMethod(Object object) throws NoSuchMethodException {
        return object.getClass().getMethod(this.methodName, this.methodParamTypes);
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Class<?>[] getArgsTypes() {
        return this.methodParamTypes;
    }

    public Object[] getArgs() throws IOException, ClassNotFoundException {
        if (this.args == null && this.argsSerialized != null) {
            this.args = new Object[this.argsSerialized.length];
            for (int i = 0; i < this.argsSerialized.length; ++i) {
                byte[] byArray = this.argsSerialized[i];
                this.args[i] = byArray == null ? null : ByteSerializer.deserializeStatic(byArray, false);
            }
        }
        return this.args;
    }

    public String toString() {
        return "RemoteCall(" + this.getRequestId() + ") on '" + this.serviceId + "', Method " + this.methodName + ", args " + (Serializable)(this.methodParamTypes != null ? Integer.valueOf(this.methodParamTypes.length) : "n/a");
    }
}

