/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.message.clientserver;

import com.google.protobuf.AbstractMessage;
import de.dal33t.powerfolder.StatusCode;
import de.dal33t.powerfolder.message.clientserver.InvitationCreateReply;
import de.dal33t.powerfolder.protocol.PermissionInfoProto;
import de.dal33t.powerfolder.protocol.PermissionInfoReplyProto;
import de.dal33t.powerfolder.security.AdminPermission;
import de.dal33t.powerfolder.security.ChangePreferencesPermission;
import de.dal33t.powerfolder.security.ChangeTransferModePermission;
import de.dal33t.powerfolder.security.ComputersAppPermission;
import de.dal33t.powerfolder.security.ConfigAppPermission;
import de.dal33t.powerfolder.security.FolderAdminPermission;
import de.dal33t.powerfolder.security.FolderCreatePermission;
import de.dal33t.powerfolder.security.FolderOwnerPermission;
import de.dal33t.powerfolder.security.FolderPermission;
import de.dal33t.powerfolder.security.FolderReadPermission;
import de.dal33t.powerfolder.security.FolderReadWritePermission;
import de.dal33t.powerfolder.security.FolderRemovePermission;
import de.dal33t.powerfolder.security.GroupAdminPermission;
import de.dal33t.powerfolder.security.OrganizationAdminPermission;
import de.dal33t.powerfolder.security.OrganizationCreatePermission;
import de.dal33t.powerfolder.security.Permission;
import de.dal33t.powerfolder.security.SingletonPermission;
import de.dal33t.powerfolder.security.SystemSettingsPermission;

public class PermissionInfoReply
extends InvitationCreateReply {
    private Permission permission;

    public PermissionInfoReply(String string, StatusCode statusCode) {
        this.replyCode = string;
        this.replyStatusCode = statusCode;
    }

    public PermissionInfoReply(String string, StatusCode statusCode, Permission permission) {
        this.replyCode = string;
        this.replyStatusCode = statusCode;
        this.permission = permission;
    }

    public Permission getPermission() {
        return this.permission;
    }

    @Override
    public void initFromD2D(AbstractMessage abstractMessage) {
        if (abstractMessage instanceof PermissionInfoReplyProto.PermissionInfoReply) {
            PermissionInfoReplyProto.PermissionInfoReply permissionInfoReply = (PermissionInfoReplyProto.PermissionInfoReply)abstractMessage;
            this.replyCode = permissionInfoReply.getReplyCode();
            this.replyStatusCode = StatusCode.getEnum(permissionInfoReply.getReplyStatusCode());
            PermissionInfoProto.PermissionInfo permissionInfo = permissionInfoReply.getPermissionInfo();
            switch (permissionInfo.getPermissionType()) {
                case ADMIN: {
                    this.permission = new AdminPermission(permissionInfo);
                    break;
                }
                case CHANGE_PREFERENCES: {
                    this.permission = new ChangePreferencesPermission(permissionInfo);
                    break;
                }
                case CHANGE_TRANSFER_MODE: {
                    this.permission = new ChangeTransferModePermission(permissionInfo);
                    break;
                }
                case COMPUTERS_APP: {
                    this.permission = new ComputersAppPermission(permissionInfo);
                    break;
                }
                case CONFIG_APP: {
                    this.permission = new ConfigAppPermission(permissionInfo);
                    break;
                }
                case FOLDER_ADMIN: {
                    this.permission = new FolderAdminPermission(permissionInfo);
                    break;
                }
                case FOLDER_CREATE: {
                    this.permission = new FolderCreatePermission(permissionInfo);
                    break;
                }
                case FOLDER_OWNER: {
                    this.permission = new FolderOwnerPermission(permissionInfo);
                    break;
                }
                case FOLDER_READ: {
                    this.permission = new FolderReadPermission(permissionInfo);
                    break;
                }
                case FOLDER_READ_WRITE: {
                    this.permission = new FolderReadWritePermission(permissionInfo);
                    break;
                }
                case FOLDER_REMOVE: {
                    this.permission = new FolderRemovePermission(permissionInfo);
                    break;
                }
                case GROUP_ADMIN: {
                    this.permission = new GroupAdminPermission(permissionInfo);
                    break;
                }
                case ORGANIZATION_ADMIN: {
                    this.permission = new OrganizationAdminPermission(permissionInfo);
                    break;
                }
                case ORGANIZATION_CREATE: {
                    this.permission = new OrganizationCreatePermission(permissionInfo);
                    break;
                }
                case SYSTEM_SETTINGS: {
                    this.permission = new SystemSettingsPermission(permissionInfo);
                    break;
                }
                case UNRECOGNIZED: {
                    break;
                }
            }
        }
    }

    @Override
    public AbstractMessage toD2D() {
        PermissionInfoReplyProto.PermissionInfoReply.Builder builder = PermissionInfoReplyProto.PermissionInfoReply.newBuilder();
        builder.setClazzName(this.getClass().getSimpleName());
        builder.setReplyCode(this.replyCode);
        builder.setReplyStatusCode(this.replyStatusCode.getCode());
        if (this.permission != null) {
            Permission permission = this.permission;
            if (permission instanceof FolderPermission) {
                builder.setPermissionInfo((PermissionInfoProto.PermissionInfo)((FolderPermission)permission).toD2D());
            } else if (permission instanceof GroupAdminPermission) {
                builder.setPermissionInfo((PermissionInfoProto.PermissionInfo)((GroupAdminPermission)permission).toD2D());
            } else if (permission instanceof OrganizationAdminPermission) {
                builder.setPermissionInfo((PermissionInfoProto.PermissionInfo)((OrganizationAdminPermission)permission).toD2D());
            } else if (permission instanceof SingletonPermission) {
                builder.setPermissionInfo((PermissionInfoProto.PermissionInfo)((SingletonPermission)permission).toD2D());
            }
        }
        return builder.build();
    }
}

