/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.message.clientserver;

import de.dal33t.powerfolder.message.Message;
import de.dal33t.powerfolder.security.Account;
import de.dal33t.powerfolder.util.Format;
import java.io.Serializable;

public class AccountDetails
extends Message
implements Serializable {
    private static final long serialVersionUID = 100L;
    private Account user;
    private long spaceUsed;
    private Boolean needsToAgreeToS;
    private long recycleBinSize;

    public AccountDetails(Account account, long l, long l2, Boolean bl) {
        this.user = account;
        this.spaceUsed = l;
        this.recycleBinSize = l2;
        this.needsToAgreeToS = bl;
    }

    public Account getAccount() {
        return this.user;
    }

    public long getSpaceUsed() {
        return this.spaceUsed;
    }

    public long getArchiveSize() {
        return this.recycleBinSize;
    }

    public boolean isSpaceExceededOrDisabled() {
        if (!this.getAccount().hasOwnStorage()) {
            return false;
        }
        return this.spaceUsed > this.getAccount().getOSSubscription().getStorageSize() || this.getAccount().getOSSubscription().isDisabled();
    }

    public boolean isUnknown() {
        return this.spaceUsed < 0L;
    }

    public boolean needsToAgreeToS() {
        if (this.needsToAgreeToS == null) {
            return false;
        }
        return this.needsToAgreeToS;
    }

    public String toString() {
        return "AccountDetails, " + this.user + ". " + Format.formatBytesShort(this.spaceUsed + this.recycleBinSize);
    }
}

