/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.message;

import com.google.protobuf.AbstractMessage;
import de.dal33t.powerfolder.d2d.D2DEvent;
import de.dal33t.powerfolder.d2d.D2DObject;
import de.dal33t.powerfolder.d2d.NodeEvent;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.message.Message;
import de.dal33t.powerfolder.protocol.DataRangeProto;
import de.dal33t.powerfolder.protocol.FileInfoProto;
import de.dal33t.powerfolder.protocol.FilePartRequestProto;
import de.dal33t.powerfolder.util.Range;
import de.dal33t.powerfolder.util.Reject;
import java.io.IOException;
import java.io.ObjectInputStream;

public class RequestPart
extends Message
implements D2DObject,
D2DEvent {
    private static final long serialVersionUID = 100L;
    protected FileInfo file;
    protected Range range;
    protected double progress;

    public RequestPart() {
    }

    public RequestPart(FileInfo fileInfo, double d) {
        this(fileInfo, Range.getRangeByLength(0L, fileInfo.getSize()), d);
    }

    public RequestPart(FileInfo fileInfo, Range range, double d) {
        this.file = fileInfo;
        this.range = range;
        this.progress = d;
        this.validate();
    }

    public String toString() {
        return "Request to download part of : " + this.file + ", range " + this.range;
    }

    public FileInfo getFile() {
        return this.file;
    }

    public Range getRange() {
        return this.range;
    }

    public boolean equals(Object object) {
        if (object instanceof RequestPart) {
            RequestPart requestPart = (RequestPart)object;
            return requestPart.file.equals(this.file) && requestPart.range.equals(this.range);
        }
        return false;
    }

    public int hashCode() {
        return this.file.hashCode() ^ this.range.hashCode();
    }

    public double getProgress() {
        return this.progress;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.validate();
    }

    private void validate() {
        this.validateFile(this.file);
        this.validateRange(this.range);
        this.validateProgress(this.progress);
    }

    private void validateFile(FileInfo fileInfo) {
        Reject.ifNull(fileInfo, "File is null");
    }

    private void validateRange(Range range) {
        Reject.ifNull(range, "Range is null");
        if (range.getStart() < 0L || range.getEnd() > this.file.getSize()) {
            Reject.ifTrue(range.getStart() < 0L || range.getEnd() > this.file.getSize(), "Invalid range: " + range);
        }
    }

    private void validateProgress(double d) {
        if (d < 0.0 || d > 1.0) {
            Reject.ifTrue(d < 0.0 || d > 1.0, "Invalid progress: " + d);
        }
    }

    @Override
    public void initFromD2D(AbstractMessage abstractMessage) {
        if (abstractMessage instanceof FilePartRequestProto.FilePartRequest) {
            FilePartRequestProto.FilePartRequest filePartRequest = (FilePartRequestProto.FilePartRequest)abstractMessage;
            this.file = new FileInfo(filePartRequest.getFileInfo());
            this.range = new Range(filePartRequest.getDataRange());
        }
    }

    @Override
    public AbstractMessage toD2D() {
        FilePartRequestProto.FilePartRequest.Builder builder = FilePartRequestProto.FilePartRequest.newBuilder();
        builder.setClazzName("FilePartRequest");
        builder.setFileInfo((FileInfoProto.FileInfo)this.file.toD2D());
        builder.setDataRange((DataRangeProto.DataRange)this.range.toD2D());
        return builder.build();
    }

    @Override
    public NodeEvent getNodeEvent() {
        return NodeEvent.FILE_SEARCH_REQUEST;
    }
}

