/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.event.api;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.SyncStatus;
import de.dal33t.powerfolder.disk.Lock;
import de.dal33t.powerfolder.event.api.WebHook;
import de.dal33t.powerfolder.light.AccountInfo;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.util.Format;
import java.nio.file.Path;

public abstract class FileEvent
extends WebHook {
    protected FileEvent(Controller controller, ConfigurationEntry configurationEntry) {
        super(controller, configurationEntry);
    }

    public FileEvent of(FileInfo fileInfo) {
        try {
            AccountInfo accountInfo;
            MemberInfo memberInfo;
            this.addParameter("folderID", fileInfo.getFolderInfo().getId());
            this.addParameter("folderName", fileInfo.getFolderInfo().getLocalizedName());
            if (fileInfo.isDiretory()) {
                this.addParameter("type", "dir");
            } else {
                this.addParameter("type", "file");
            }
            if (!fileInfo.isLookupInstance()) {
                this.addParameter("size", fileInfo.getSize());
            }
            this.addParameter("relativeName", fileInfo.getRelativeName());
            this.addParameter("fileName", fileInfo.getFilenameOnly());
            this.addParameter("version", fileInfo.getVersion());
            this.addParameter("deleted", fileInfo.isDeleted());
            Path path = fileInfo.getDiskFile(this.getController().getFolderRepository());
            if (path != null) {
                this.addParameter("path", path.toString());
            }
            if (fileInfo.getModifiedDate() != null) {
                this.addParameter("modifiedDateMS", fileInfo.getModifiedDate().getTime());
                this.addParameter("modifiedDate", Format.formatDateCanonical(fileInfo.getModifiedDate()));
                this.addParameter("modifiedTime", Format.formatTimeShort(fileInfo.getModifiedDate()));
            }
            if ((memberInfo = fileInfo.getModifiedBy()) != null) {
                this.addParameter("modifiedByDeviceID", memberInfo.getId());
                this.addParameter("modifiedByDeviceName", memberInfo.getNick());
                this.addParameter("modifiedByDeviceConnectAddress", memberInfo.getConnectAddress());
            }
            if ((accountInfo = fileInfo.getModifiedByAccount()) != null) {
                this.addParameter("modifiedByAccountID", accountInfo.getOID());
                this.addParameter("modifiedByAccountUsername", accountInfo.getUsername());
                this.addParameter("modifiedByAccountDisplayName", accountInfo.getDisplayName());
            }
            if (fileInfo.isLocked(this.getController())) {
                Lock lock = fileInfo.getLock(this.getController());
                if (lock != null) {
                    String string = "locked";
                    if (lock.getMemberInfo().equals(this.getMySelf().getInfo())) {
                        string = "edit";
                    }
                    for (Member member : this.getController().getNodeManager().getNodesAsCollection()) {
                        if (!member.isServer() || !member.getInfo().equals(lock.getMemberInfo())) continue;
                        string = "edit";
                    }
                    this.addParameter("syncStatus", string);
                }
            } else if (SyncStatus.of(this.getController(), fileInfo) == SyncStatus.SYNCING) {
                this.addParameter("syncStatus", "syncing");
            }
        }
        catch (RuntimeException runtimeException) {
            this.logWarning("Failed to send all parameters: " + runtimeException, runtimeException);
        }
        return this;
    }
}

