/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.domain;

import de.dal33t.powerfolder.light.AccountInfo;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.collection.CompositeCollection;
import de.dal33t.powerfolder.util.compare.FileInfoComparator;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class NewsItem
implements Comparable<NewsItem>,
Serializable {
    private static final long serialVersionUID = 100L;
    private Date date;
    private AccountInfo account;
    private FolderInfo folder;
    private Set<MemberInfo> computers;
    private SortedSet<FileInfo> newFiles;
    private SortedSet<FileInfo> updatedFiles;
    private SortedSet<FileInfo> deletedFiles;

    NewsItem(Date date, AccountInfo accountInfo, FolderInfo folderInfo) {
        Reject.ifNull(date, "Date");
        Reject.ifNull(folderInfo, "Folder");
        this.date = date;
        this.account = accountInfo;
        this.folder = folderInfo;
        this.newFiles = new TreeSet<FileInfo>(FileInfoComparator.getComparator(2));
        this.updatedFiles = new TreeSet<FileInfo>(FileInfoComparator.getComparator(2));
        this.deletedFiles = new TreeSet<FileInfo>(FileInfoComparator.getComparator(2));
        this.computers = new HashSet<MemberInfo>();
    }

    public AccountInfo getAccount() {
        return this.account;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        Reject.ifNull(date, "Date");
        this.date = date;
    }

    public FolderInfo getFolder() {
        return this.folder;
    }

    public Collection<MemberInfo> getComputers() {
        return Collections.unmodifiableCollection(this.computers);
    }

    public SortedSet<FileInfo> getNewFiles() {
        return Collections.unmodifiableSortedSet(this.newFiles);
    }

    public SortedSet<FileInfo> getUpdatedFiles() {
        return Collections.unmodifiableSortedSet(this.updatedFiles);
    }

    public SortedSet<FileInfo> getDeletedFiles() {
        return Collections.unmodifiableSortedSet(this.deletedFiles);
    }

    public Collection<FileInfo> getFiles() {
        return new CompositeCollection<FileInfo>(this.newFiles, this.updatedFiles, this.deletedFiles);
    }

    public void addFile(FileInfo fileInfo) {
        Reject.ifNull(fileInfo, "FileInfo");
        if (fileInfo.getVersion() == 0) {
            this.newFiles.add(fileInfo);
        } else if (this.newFiles.contains(fileInfo)) {
            this.newFiles.remove(fileInfo);
            this.newFiles.add(fileInfo);
        } else if (fileInfo.isDeleted()) {
            this.deletedFiles.add(fileInfo);
        } else {
            this.updatedFiles.add(fileInfo);
        }
        this.computers.add(fileInfo.getModifiedBy());
    }

    public String toString() {
        return "LogPost [account=" + this.account + ", date=" + this.date + ", folder=" + this.folder + ", newFiles=" + this.newFiles + ", updatedFiles=" + this.updatedFiles + ", deletedFiles=" + this.deletedFiles + "]";
    }

    @Override
    public int compareTo(NewsItem newsItem) {
        return -this.date.compareTo(newsItem.date);
    }
}

