/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.distribution;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.distribution.Standard;
import de.dal33t.powerfolder.util.ConfigurationLoader;
import de.dal33t.powerfolder.util.PathUtils;
import java.io.IOException;
import java.nio.file.Path;

public class bwSyncAndShare
extends Standard {
    private static final String BW_LSDF_TEST_URL = "bwlsdf.scc.kit.edu";
    private static final String BW_CLOUD_TEST_URL = "bwcloud.lsdf.kit.edu";
    private static final String BW_SYNC_AND_SHARE_TEST_URL = "bwsyncandshare-test.scc.kit.edu";
    private static final String BW_LSDF_TESTCLIENT_BINARY_NAME = "bwLSDF_Testclient";

    @Override
    public void init(Controller controller) {
        String string = ConfigurationEntry.SERVER_WEB_URL.getValue(controller);
        String string2 = ConfigurationEntry.DIST_BINARY_NAME.getValue(controller);
        boolean bl = false;
        if (string.contains(BW_LSDF_TEST_URL) || string.contains(BW_SYNC_AND_SHARE_TEST_URL) || string.contains(BW_CLOUD_TEST_URL) || string2.contains(BW_LSDF_TESTCLIENT_BINARY_NAME)) {
            Path path = Controller.getMiscFilesLocation();
            this.logInfo("Deleting configuration of testing environment");
            controller.getConfig().clear();
            try {
                controller.getPreferences().clear();
            }
            catch (Exception exception) {
                this.logInfo("Could not clear preferences. " + exception, exception);
            }
            bl = true;
            ConfigurationLoader.loadAndMergeCLI(controller);
            this.logInfo("Testing configuration removed");
            try {
                PathUtils.recursiveDelete(path);
            }
            catch (IOException iOException) {
                this.logWarning("Could not remove testing configuration. " + iOException, iOException);
            }
        }
        super.init(controller);
        if (bl) {
            this.saveConfig();
        }
    }

    private void saveConfig() {
        if (this.getController().isStarted()) {
            this.getController().saveConfig();
        } else {
            this.getController().schedule(new Runnable(){

                @Override
                public void run() {
                    bwSyncAndShare.this.getController().saveConfig();
                }
            }, 5000L);
        }
    }
}

