/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.RemoteCommandManager;
import de.dal33t.powerfolder.util.JavaVersion;
import de.dal33t.powerfolder.util.MemoryMonitor;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.logging.LoggingManager;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class PowerFolder {
    public static String NAME = "PowerFolder";
    private static final Logger log = Logger.getLogger(PowerFolder.class.getName());
    public static final Options COMMAND_LINE_OPTIONS;

    public static void main(String[] stringArray) {
        PowerFolder.startPowerFolder(stringArray);
    }

    public static void startPowerFolder(String[] stringArray) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        LoggingManager.isLogToFile();
        Thread.setDefaultUncaughtExceptionHandler((thread, throwable) -> {
            throwable.printStackTrace();
            log.log(Level.SEVERE, "Exception in " + thread + ": " + throwable.toString(), throwable);
        });
        CommandLine commandLine = PowerFolder.parseCommandLine(stringArray);
        if (commandLine == null) {
            return;
        }
        if (commandLine.hasOption("l") && (object4 = LoggingManager.levelForName((String)(object3 = commandLine.getOptionValue("l")))) != null) {
            LoggingManager.setConsoleLogging((Level)object4);
        }
        if (commandLine.hasOption("s")) {
            // empty if block
        }
        if (commandLine.hasOption("h")) {
            object3 = new HelpFormatter();
            ((HelpFormatter)object3).printHelp("PowerFolder", COMMAND_LINE_OPTIONS);
            return;
        }
        int n = Integer.valueOf(ConfigurationEntry.NET_PORT_RCON.getDefaultValue());
        object4 = commandLine.getOptionValue("k");
        if (StringUtils.isNotBlank((String)object4)) {
            try {
                n = Integer.valueOf(((String)object4).trim());
            }
            catch (Exception exception) {
                log.warning("Unable to parse rcon port: " + (String)object4 + ". " + exception);
            }
        }
        boolean bl = RemoteCommandManager.hasRunningInstance(n);
        if (commandLine.hasOption("k")) {
            if (bl) {
                System.out.println("Stopping " + NAME);
                RemoteCommandManager.sendCommand(n, "QUIT");
            } else {
                System.err.println("Process not running");
            }
            return;
        }
        if (commandLine.hasOption("o")) {
            if (bl) {
                System.out.println("Reloading config " + NAME);
                RemoteCommandManager.sendCommand(n, "RELOADCONFIG;");
            } else {
                System.err.println("Process not running");
            }
            return;
        }
        if (commandLine.hasOption("g")) {
            Preferences.userNodeForPackage(Translation.class).put("locale", commandLine.getOptionValue("g"));
        }
        JavaVersion javaVersion = JavaVersion.systemVersion();
        log.info("Using Java: " + javaVersion);
        Controller controller = Controller.createController();
        String[] stringArray2 = commandLine.getArgs();
        boolean bl2 = stringArray2 != null && stringArray2.length >= 1 || commandLine.hasOption("e") || commandLine.hasOption("r") || commandLine.hasOption("a");
        boolean bl3 = !bl2;
        try {
            log.info("PowerFolder v26.0.100");
            if (bl3) {
                controller.startConfig(commandLine);
            }
            if (stringArray2 != null && stringArray2.length > 0) {
                object2 = new StringBuilder("OPEN;");
                for (String string : stringArray2) {
                    ((StringBuilder)object2).append(string);
                }
                RemoteCommandManager.sendCommand(((StringBuilder)object2).toString());
            }
            if (commandLine.hasOption("e")) {
                RemoteCommandManager.sendCommand("MAKEFOLDER;" + commandLine.getOptionValue("e"));
            }
            if (commandLine.hasOption("r")) {
                RemoteCommandManager.sendCommand("REMOVEFOLDER;" + commandLine.getOptionValue("r"));
            }
            if (commandLine.hasOption("a")) {
                RemoteCommandManager.sendCommand("COPYLINK;" + commandLine.getOptionValue("a"));
            }
        }
        catch (Throwable throwable2) {
            throwable2.printStackTrace();
            log.log(Level.SEVERE, "Throwable", throwable2);
            return;
        }
        if (controller.isStarted() && controller.isUIEnabled()) {
            object2 = controller.getThreadPool();
            object = new MemoryMonitor(controller);
            if (PreferencesEntry.MEMORY_LIMIT_INCREASE.getValueBoolean(controller).booleanValue()) {
                ((MemoryMonitor)object).increaseAvailableMemory();
                PreferencesEntry.MEMORY_LIMIT_INCREASE.setValue(controller, false);
            }
            object2.scheduleWithFixedDelay((Runnable)object, 1L, 1L, TimeUnit.MINUTES);
        }
        if (!bl3) {
            RemoteCommandManager.sendCommand("SHOWUI;");
            return;
        }
        System.out.println("------------ " + NAME + " 26.0.100 started ------------");
        boolean bl4 = false;
        while (true) {
            if (controller.isStarted() || controller.isShuttingDown()) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    log.log(Level.WARNING, "InterruptedException", interruptedException);
                    return;
                }
            }
            bl4 = controller.isRestartRequested();
            if (bl4) {
                object = Thread.getAllStackTraces();
                for (Thread thread2 : object.keySet()) {
                    if (!thread2.getName().startsWith("PoolThread") && !thread2.getName().startsWith("Reconnector") && !thread2.getName().startsWith("ConHandler")) continue;
                    thread2.interrupt();
                }
                log.info("Restarting controller");
                System.out.println("------------ " + NAME + " 26.0.100 restarting ------------");
                controller = null;
                System.gc();
                controller = Controller.createController();
                controller.startConfig(commandLine);
            }
            if (!bl4) break;
        }
    }

    static CommandLine parseCommandLine(String[] stringArray) {
        PosixParser posixParser = new PosixParser();
        try {
            return posixParser.parse(COMMAND_LINE_OPTIONS, stringArray);
        }
        catch (ParseException parseException) {
            System.err.println("Start failed. Reason: " + parseException.getMessage());
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("PowerFolder", COMMAND_LINE_OPTIONS);
            return null;
        }
    }

    static {
        Options options = new Options();
        OptionBuilder.withArgName("config");
        OptionBuilder.withLongOpt("config");
        OptionBuilder.hasOptionalArgs(2);
        OptionBuilder.withDescription("<config file>. Sets the configuration file to start. Default: PowerFolder.config");
        Option option = OptionBuilder.create("c");
        options.addOption(option);
        options.addOption("u", "username", true, "<username>. The username to use when connecting.");
        options.addOption("p", "password", true, "<password>. The password to use when connecting.");
        options.addOption("m", "minimized", false, "Start PowerFolder minimized");
        options.addOption("s", "server", false, "Starts in console mode. Graphical user interface will be disabled");
        options.addOption("d", "dns", true, "<ip/dns>. Sets the hostname to listen to. May also be a dynamic DNS hostname");
        options.addOption("h", "help", false, "Displays this help");
        options.addOption("n", "name", true, "<Name> Sets the name of this machine");
        options.addOption("b", "data", true, "Set the base data directory for PowerFolder");
        OptionBuilder.withArgName("kill");
        OptionBuilder.withLongOpt("kill");
        OptionBuilder.hasOptionalArgs(1);
        OptionBuilder.withDescription("Shuts down a running PowerFolder instance");
        Option option2 = OptionBuilder.create("k");
        options.addOption(option2);
        options.addOption("l", "log", true, "<level> Sets console logging to severe, warning, info, fine or finer level (e.g. \"--log info\", sets info level and above");
        options.addOption("f", "langfile", true, "<path\\file> Sets the language file to use (e.g. \"--langfile c:\\powerfolder\\translation\\translation_XX.properties\", forces PowerFolder to load this file as language file)");
        options.addOption("g", "language", true, "<language> Sets the language to use (e.g. \"--language de\", sets language to german)");
        options.addOption("e", "createfolder", true, "<createfolder> Creates a new folder");
        options.addOption("r", "removefolder", true, "<removefolder> Removes an existing folder");
        options.addOption("a", "copylink", true, "<copylink> Copies the PowerFolder link of that file");
        options.addOption("y", "notifyleft", false, "Show notification at left of screen");
        options.addOption("z", "nowarn", false, "Do not warn if already running");
        options.addOption("o", "nowarn", false, "Reloads the configuration file (some config entries may require a restart)");
        COMMAND_LINE_OPTIONS = options;
    }
}

