/*
 * Decompiled with CFR 0.152.
 */
package dagger.producers.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import dagger.internal.DaggerCollections;
import dagger.producers.Produced;
import dagger.producers.Producer;
import dagger.producers.internal.AbstractProducer;
import dagger.producers.internal.Producers;
import dagger.producers.internal.SetProducer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;

public final class SetOfProducedProducer<T>
extends AbstractProducer<Set<Produced<T>>> {
    private final List<Producer<T>> individualProducers;
    private final List<Producer<Collection<T>>> collectionProducers;

    public static <T> Producer<Set<T>> empty() {
        return SetProducer.empty();
    }

    public static <T> Builder<T> builder(int n, int n2) {
        return new Builder(n, n2);
    }

    private SetOfProducedProducer(List<Producer<T>> list, List<Producer<Collection<T>>> list2) {
        this.individualProducers = list;
        this.collectionProducers = list2;
    }

    @Override
    public ListenableFuture<Set<Produced<T>>> compute() {
        ArrayList<ListenableFuture<Produced<Object>>> arrayList = new ArrayList<ListenableFuture<Produced<Object>>>(this.individualProducers.size() + this.collectionProducers.size());
        for (Producer<T> producer : this.individualProducers) {
            arrayList.add(Producers.createFutureProduced(Producers.createFutureSingletonSet(Preconditions.checkNotNull(producer.get()))));
        }
        for (Producer<Object> producer : this.collectionProducers) {
            arrayList.add(Producers.createFutureProduced(Preconditions.checkNotNull(producer.get())));
        }
        return Futures.transform(Futures.allAsList(arrayList), new Function<List<Produced<? extends Collection<T>>>, Set<Produced<T>>>(){

            @Override
            public Set<Produced<T>> apply(List<Produced<? extends Collection<T>>> list) {
                ImmutableSet.Builder builder = ImmutableSet.builder();
                for (Produced produced : list) {
                    try {
                        Collection collection = produced.get();
                        if (collection == null) {
                            builder.add(Produced.failed(new NullPointerException("Cannot contribute a null collection into a producer set binding when it's injected as Set<Produced<T>>.")));
                            continue;
                        }
                        for (Object t : collection) {
                            if (t == null) {
                                builder.add(Produced.failed(new NullPointerException("Cannot contribute a null element into a producer set binding when it's injected as Set<Produced<T>>.")));
                                continue;
                            }
                            builder.add(Produced.successful(t));
                        }
                    }
                    catch (ExecutionException executionException) {
                        builder.add(Produced.failed(executionException.getCause()));
                    }
                }
                return builder.build();
            }
        }, MoreExecutors.directExecutor());
    }

    public static final class Builder<T> {
        private final List<Producer<T>> individualProducers;
        private final List<Producer<Collection<T>>> collectionProducers;

        private Builder(int n, int n2) {
            this.individualProducers = DaggerCollections.presizedList(n);
            this.collectionProducers = DaggerCollections.presizedList(n2);
        }

        public Builder<T> addProducer(Producer<? extends T> producer) {
            assert (producer != null) : "Codegen error? Null producer";
            this.individualProducers.add(producer);
            return this;
        }

        public Builder<T> addCollectionProducer(Producer<? extends Collection<? extends T>> producer) {
            assert (producer != null) : "Codegen error? Null producer";
            this.collectionProducers.add(producer);
            return this;
        }

        public SetOfProducedProducer<T> build() {
            assert (!DaggerCollections.hasDuplicates(this.individualProducers)) : "Codegen error?  Duplicates in the producer list";
            assert (!DaggerCollections.hasDuplicates(this.collectionProducers)) : "Codegen error?  Duplicates in the producer list";
            return new SetOfProducedProducer(this.individualProducers, this.collectionProducers);
        }
    }
}

