/*
 * Decompiled with CFR 0.152.
 */
package dagger.producers.internal;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import dagger.producers.Producer;
import dagger.producers.monitoring.ProducerMonitor;
import dagger.producers.monitoring.ProducerToken;
import dagger.producers.monitoring.ProductionComponentMonitor;
import dagger.producers.monitoring.internal.Monitors;
import javax.annotation.Nullable;
import javax.inject.Provider;

public abstract class AbstractProducer<T>
implements Producer<T> {
    private final Provider<ProductionComponentMonitor> monitorProvider;
    @Nullable
    private final ProducerToken token;
    private volatile ListenableFuture<T> instance = null;
    protected volatile ProducerMonitor monitor = null;

    protected AbstractProducer() {
        this(Monitors.noOpProductionComponentMonitorProvider(), null);
    }

    protected AbstractProducer(Provider<ProductionComponentMonitor> provider, @Nullable ProducerToken producerToken) {
        this.monitorProvider = Preconditions.checkNotNull(provider);
        this.token = producerToken;
    }

    protected abstract ListenableFuture<T> compute();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ListenableFuture<T> get() {
        ListenableFuture<T> listenableFuture = this.instance;
        if (listenableFuture == null) {
            AbstractProducer abstractProducer = this;
            synchronized (abstractProducer) {
                listenableFuture = this.instance;
                if (listenableFuture == null) {
                    this.monitor = this.monitorProvider.get().producerMonitorFor(this.token);
                    this.monitor.requested();
                    this.instance = listenableFuture = this.compute();
                    if (listenableFuture == null) {
                        throw new NullPointerException("compute returned null");
                    }
                    this.monitor.addCallbackTo(listenableFuture);
                }
            }
        }
        return listenableFuture;
    }
}

