/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.nativity.modules.fileicon.win;

import com.liferay.nativity.control.NativityControl;
import com.liferay.nativity.control.win.WindowsNativityUtil;
import com.liferay.nativity.modules.fileicon.FileIconControlBase;
import com.liferay.nativity.modules.fileicon.FileIconControlCallback;
import com.liferay.nativity.util.win.RegistryUtil;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsFileIconControlImpl
extends FileIconControlBase {
    private static Logger _logger = LoggerFactory.getLogger(WindowsFileIconControlImpl.class.getName());

    public WindowsFileIconControlImpl(FileIconControlCallback fileIconControlCallback, NativityControl nativityControl) {
        super(fileIconControlCallback, nativityControl);
    }

    @Override
    public void disableFileIcons() {
        RegistryUtil.writeRegistry("SOFTWARE\\Liferay Inc\\Liferay Nativity", "EnableOverlay", 0);
    }

    @Override
    public void enableFileIcons() {
        RegistryUtil.writeRegistry("SOFTWARE\\Liferay Inc\\Liferay Nativity", "EnableOverlay", 1);
    }

    @Override
    public void refreshIcons() {
    }

    @Override
    public void refreshIcons(String[] stringArray) {
        if (!WindowsNativityUtil.loaded()) {
            return;
        }
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        try {
            for (String string : stringArray) {
                WindowsNativityUtil.updateExplorer(string);
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            _logger.error(unsatisfiedLinkError.getMessage(), unsatisfiedLinkError);
        }
    }

    @Override
    public void refreshWindow(String string) {
        if (!WindowsNativityUtil.loaded()) {
            return;
        }
        WindowsNativityUtil.refreshExplorer(string);
    }

    @Override
    public int registerIcon(String string) {
        return 0;
    }

    @Override
    public void registerIconWithId(String string, String string2, String string3) {
    }

    @Override
    public void removeAllFileIcons() {
    }

    @Override
    public void removeFileIcon(String string) {
    }

    @Override
    public void removeFileIcons(String[] stringArray) {
    }

    @Override
    public void setFileIcon(String string, int n) {
    }

    @Override
    public void setFileIcons(Map<String, Integer> map) {
    }

    @Override
    public void unregisterIcon(int n) {
    }
}

