/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.nativity.control.unix;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.nativity.control.NativityControl;
import com.liferay.nativity.control.NativityMessage;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.SocketException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UnixNativityControlBaseImpl
extends NativityControl {
    private static final String _RETURN_NEW_LINE = "\r\n";
    private static Logger _logger = LoggerFactory.getLogger(UnixNativityControlBaseImpl.class.getName());
    private static int _callbackSocketPort = 33002;
    private static int _commandSocketPort = 33001;
    private static ObjectMapper _objectMapper = new ObjectMapper().configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
    private BufferedReader _callbackBufferedReader;
    private DataOutputStream _callbackOutputStream;
    private Socket _callbackSocket;
    private ReadThread _callbackThread;
    private BufferedReader _commandBufferedReader;
    private DataOutputStream _commandOutputStream;
    private Socket _commandSocket;
    private boolean _connected = false;

    @Override
    public void addFavoritesPath(String string) {
    }

    @Override
    public boolean connect() {
        try {
            this._commandSocket = new Socket("127.0.0.1", _commandSocketPort);
            this._commandBufferedReader = new BufferedReader(new InputStreamReader(this._commandSocket.getInputStream(), "UTF-8"));
            this._commandOutputStream = new DataOutputStream(this._commandSocket.getOutputStream());
            this._callbackSocket = new Socket("127.0.0.1", _callbackSocketPort);
            this._callbackBufferedReader = new BufferedReader(new InputStreamReader(this._callbackSocket.getInputStream(), "UTF-8"));
            this._callbackOutputStream = new DataOutputStream(this._callbackSocket.getOutputStream());
            this._callbackThread = new ReadThread(this);
            this._callbackThread.start();
            this._connected = true;
            if (_logger.isDebugEnabled()) {
                _logger.debug("Successfully connected to command socket: {}", (Object)_commandSocketPort);
                _logger.debug("Successfully connected to service socket: {}", (Object)_callbackSocketPort);
            }
            return true;
        }
        catch (IOException iOException) {
            _logger.error(iOException.getMessage());
            this._connected = false;
            return false;
        }
    }

    @Override
    public boolean disconnect() {
        try {
            this._commandSocket.close();
            this._callbackSocket.close();
            this._connected = false;
            if (_logger.isDebugEnabled()) {
                _logger.debug("Successfully disconnected");
            }
            return true;
        }
        catch (IOException iOException) {
            _logger.error(iOException.getMessage(), iOException);
            this._connected = true;
            return false;
        }
    }

    @Override
    public Set<String> getAllObservedFolders() {
        return null;
    }

    @Override
    public void refreshFiles(String[] stringArray) {
    }

    @Override
    public void removeFavoritesPath(String string) {
    }

    @Override
    public String sendMessage(NativityMessage nativityMessage) {
        if (!this._connected) {
            _logger.debug("LiferayNativity is not connected");
            return "";
        }
        try {
            String string = _objectMapper.writeValueAsString(nativityMessage);
            this._commandOutputStream.write(string.getBytes("UTF-8"));
            this._commandOutputStream.write(_RETURN_NEW_LINE.getBytes("UTF-8"));
            if (_logger.isTraceEnabled()) {
                _logger.trace("Sent on socket {}: {}", (Object)_commandSocketPort, (Object)string);
            }
            String string2 = this._commandBufferedReader.readLine();
            if (_logger.isTraceEnabled()) {
                _logger.trace("Received on socket {}: {}", (Object)_commandSocketPort, (Object)string2);
            }
            if (string2 == null) {
                this._commandSocket.close();
                this.fireSocketCloseListeners();
            }
            return string2;
        }
        catch (IOException iOException) {
            _logger.error(iOException.getMessage(), iOException);
            this.fireSocketCloseListeners();
            return "";
        }
    }

    @Override
    public void setPortFilePath(String string) {
    }

    @Override
    public void setSystemFolder(String string) {
    }

    private void _doCallbackLoop() {
        if (!this._connected) {
            _logger.debug("LiferayNativity is not connected");
            return;
        }
        while (this._connected) {
            try {
                NativityMessage nativityMessage;
                NativityMessage nativityMessage2;
                String string = this._callbackBufferedReader.readLine();
                if (_logger.isTraceEnabled()) {
                    _logger.trace("Received on socket {}: {}", (Object)_callbackSocketPort, (Object)string);
                }
                if (string == null) {
                    this.disconnect();
                    this.fireSocketCloseListeners();
                    break;
                }
                if (string.isEmpty() || (nativityMessage2 = this.fireMessage(nativityMessage = _objectMapper.readValue(string, NativityMessage.class))) == null) continue;
                String string2 = _objectMapper.writeValueAsString(nativityMessage2);
                this._callbackOutputStream.write(string2.getBytes("UTF-8"));
                this._callbackOutputStream.write(_RETURN_NEW_LINE.getBytes("UTF-8"));
                if (!_logger.isTraceEnabled()) continue;
                _logger.trace("Sent on socket {}: {}", (Object)_callbackSocketPort, (Object)string2);
            }
            catch (IOException iOException) {
                if (!(iOException instanceof SocketException)) {
                    _logger.error(iOException.getMessage(), iOException);
                }
                this.disconnect();
                this.fireSocketCloseListeners();
            }
        }
    }

    protected class ReadThread
    extends Thread {
        private UnixNativityControlBaseImpl _pluginControl;

        public ReadThread(UnixNativityControlBaseImpl unixNativityControlBaseImpl2) {
            this._pluginControl = unixNativityControlBaseImpl2;
        }

        @Override
        public void run() {
            this._pluginControl._doCallbackLoop();
        }
    }
}

