/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.layout;

import com.jgoodies.forms.layout.ConstantSize;
import com.jgoodies.forms.layout.FormSpec;
import com.jgoodies.forms.layout.FormSpecParser;
import com.jgoodies.forms.layout.LayoutMap;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.util.FormUtils;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class RowSpec
extends FormSpec {
    public static final FormSpec.DefaultAlignment TOP = FormSpec.TOP_ALIGN;
    public static final FormSpec.DefaultAlignment CENTER = FormSpec.CENTER_ALIGN;
    public static final FormSpec.DefaultAlignment BOTTOM = FormSpec.BOTTOM_ALIGN;
    public static final FormSpec.DefaultAlignment FILL = FormSpec.FILL_ALIGN;
    public static final FormSpec.DefaultAlignment DEFAULT = CENTER;
    private static final Map CACHE = new HashMap();

    public RowSpec(FormSpec.DefaultAlignment defaultAlignment, Size size, double d) {
        super(defaultAlignment, size, d);
    }

    public RowSpec(Size size) {
        super(DEFAULT, size, 0.0);
    }

    public RowSpec(String string) {
        super(DEFAULT, string);
    }

    public static RowSpec createGap(ConstantSize constantSize) {
        return new RowSpec(DEFAULT, constantSize, 0.0);
    }

    public static RowSpec decode(String string) {
        return RowSpec.decode(string, LayoutMap.getRoot());
    }

    public static RowSpec decode(String string, LayoutMap layoutMap) {
        FormUtils.assertNotBlank(string, "encoded row specification");
        FormUtils.assertNotNull(layoutMap, "LayoutMap");
        String string2 = string.trim();
        String string3 = string2.toLowerCase(Locale.ENGLISH);
        return RowSpec.decodeExpanded(layoutMap.expand(string3, false));
    }

    static RowSpec decodeExpanded(String string) {
        RowSpec rowSpec = (RowSpec)CACHE.get(string);
        if (rowSpec == null) {
            rowSpec = new RowSpec(string);
            CACHE.put(string, rowSpec);
        }
        return rowSpec;
    }

    public static RowSpec[] decodeSpecs(String string) {
        return RowSpec.decodeSpecs(string, LayoutMap.getRoot());
    }

    public static RowSpec[] decodeSpecs(String string, LayoutMap layoutMap) {
        return FormSpecParser.parseRowSpecs(string, layoutMap);
    }

    protected boolean isHorizontal() {
        return false;
    }
}

