/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.layout;

import com.jgoodies.forms.layout.ConstantSize;
import com.jgoodies.forms.layout.FormSpec;
import com.jgoodies.forms.layout.FormSpecParser;
import com.jgoodies.forms.layout.LayoutMap;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.util.FormUtils;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class ColumnSpec
extends FormSpec {
    public static final FormSpec.DefaultAlignment LEFT = FormSpec.LEFT_ALIGN;
    public static final FormSpec.DefaultAlignment CENTER;
    public static final FormSpec.DefaultAlignment MIDDLE;
    public static final FormSpec.DefaultAlignment RIGHT;
    public static final FormSpec.DefaultAlignment FILL;
    public static final FormSpec.DefaultAlignment DEFAULT;
    private static final Map CACHE;

    public ColumnSpec(FormSpec.DefaultAlignment defaultAlignment, Size size, double d) {
        super(defaultAlignment, size, d);
    }

    public ColumnSpec(Size size) {
        super(DEFAULT, size, 0.0);
    }

    public ColumnSpec(String string) {
        super(DEFAULT, string);
    }

    public static ColumnSpec createGap(ConstantSize constantSize) {
        return new ColumnSpec(DEFAULT, constantSize, 0.0);
    }

    public static ColumnSpec decode(String string) {
        return ColumnSpec.decode(string, LayoutMap.getRoot());
    }

    public static ColumnSpec decode(String string, LayoutMap layoutMap) {
        FormUtils.assertNotBlank(string, "encoded column specification");
        FormUtils.assertNotNull(layoutMap, "LayoutMap");
        String string2 = string.trim();
        String string3 = string2.toLowerCase(Locale.ENGLISH);
        return ColumnSpec.decodeExpanded(layoutMap.expand(string3, true));
    }

    static ColumnSpec decodeExpanded(String string) {
        ColumnSpec columnSpec = (ColumnSpec)CACHE.get(string);
        if (columnSpec == null) {
            columnSpec = new ColumnSpec(string);
            CACHE.put(string, columnSpec);
        }
        return columnSpec;
    }

    public static ColumnSpec[] decodeSpecs(String string) {
        return ColumnSpec.decodeSpecs(string, LayoutMap.getRoot());
    }

    public static ColumnSpec[] decodeSpecs(String string, LayoutMap layoutMap) {
        return FormSpecParser.parseColumnSpecs(string, layoutMap);
    }

    protected boolean isHorizontal() {
        return true;
    }

    static {
        MIDDLE = CENTER = FormSpec.CENTER_ALIGN;
        RIGHT = FormSpec.RIGHT_ALIGN;
        DEFAULT = FILL = FormSpec.FILL_ALIGN;
        CACHE = new HashMap();
    }
}

