/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.layout;

import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.Size;
import java.awt.Container;
import java.io.Serializable;
import java.util.List;

public final class BoundedSize
implements Size,
Serializable {
    private final Size basis;
    private final Size lowerBound;
    private final Size upperBound;

    public BoundedSize(Size size, Size size2, Size size3) {
        if (size == null) {
            throw new NullPointerException("The basis of a bounded size must not be null.");
        }
        if (size2 == null && size3 == null) {
            throw new IllegalArgumentException("A bounded size must have a non-null lower or upper bound.");
        }
        this.basis = size;
        this.lowerBound = size2;
        this.upperBound = size3;
    }

    public Size getBasis() {
        return this.basis;
    }

    public Size getLowerBound() {
        return this.lowerBound;
    }

    public Size getUpperBound() {
        return this.upperBound;
    }

    public int maximumSize(Container container, List list, FormLayout.Measure measure, FormLayout.Measure measure2, FormLayout.Measure measure3) {
        int n = this.basis.maximumSize(container, list, measure, measure2, measure3);
        if (this.lowerBound != null) {
            n = Math.max(n, this.lowerBound.maximumSize(container, list, measure, measure2, measure3));
        }
        if (this.upperBound != null) {
            n = Math.min(n, this.upperBound.maximumSize(container, list, measure, measure2, measure3));
        }
        return n;
    }

    public boolean compressible() {
        return this.getBasis().compressible();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BoundedSize)) {
            return false;
        }
        BoundedSize boundedSize = (BoundedSize)object;
        return this.basis.equals(boundedSize.basis) && (this.lowerBound == null && boundedSize.lowerBound == null || this.lowerBound != null && this.lowerBound.equals(boundedSize.lowerBound)) && (this.upperBound == null && boundedSize.upperBound == null || this.upperBound != null && this.upperBound.equals(boundedSize.upperBound));
    }

    public int hashCode() {
        int n = this.basis.hashCode();
        if (this.lowerBound != null) {
            n = n * 37 + this.lowerBound.hashCode();
        }
        if (this.upperBound != null) {
            n = n * 37 + this.upperBound.hashCode();
        }
        return n;
    }

    public String toString() {
        return this.encode();
    }

    public String encode() {
        StringBuffer stringBuffer = new StringBuffer("[");
        if (this.lowerBound != null) {
            stringBuffer.append(this.lowerBound.encode());
            stringBuffer.append(',');
        }
        stringBuffer.append(this.basis.encode());
        if (this.upperBound != null) {
            stringBuffer.append(',');
            stringBuffer.append(this.upperBound.encode());
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

