/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.value;

import com.jgoodies.binding.value.AbstractValueModel;
import com.jgoodies.binding.value.ValueModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Timer;

public final class DelayedReadValueModel
extends AbstractValueModel {
    private final ValueModel subject;
    private final Timer timer;
    private boolean coalesce;
    private Object oldValue;
    private PropertyChangeEvent pendingEvt;

    public DelayedReadValueModel(ValueModel valueModel, int n) {
        this(valueModel, n, false);
    }

    public DelayedReadValueModel(ValueModel valueModel, int n, boolean bl) {
        this.subject = valueModel;
        this.coalesce = bl;
        this.timer = new Timer(n, new ValueUpdateListener());
        this.timer.setRepeats(false);
        valueModel.addValueChangeListener(new SubjectValueChangeHandler());
        this.oldValue = valueModel.getValue();
    }

    public Object getValue() {
        return this.isPending() ? this.oldValue : this.subject.getValue();
    }

    public void setValue(Object object) {
        this.subject.setValue(object);
    }

    public int getDelay() {
        return this.timer.getDelay();
    }

    public void setDelay(int n) {
        this.timer.setInitialDelay(n);
        this.timer.setDelay(n);
    }

    public boolean isCoalesce() {
        return this.coalesce;
    }

    public void setCoalesce(boolean bl) {
        this.coalesce = bl;
    }

    public void stop() {
        this.timer.stop();
    }

    public boolean isPending() {
        return this.timer.isRunning();
    }

    private void fireDelayedValueChange(PropertyChangeEvent propertyChangeEvent) {
        this.pendingEvt = propertyChangeEvent;
        if (this.coalesce) {
            this.timer.restart();
        } else {
            this.timer.start();
        }
    }

    private final class SubjectValueChangeHandler
    implements PropertyChangeListener {
        private SubjectValueChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            DelayedReadValueModel.this.fireDelayedValueChange(propertyChangeEvent);
        }
    }

    private final class ValueUpdateListener
    implements ActionListener {
        private ValueUpdateListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DelayedReadValueModel.this.fireValueChange(DelayedReadValueModel.this.pendingEvt.getOldValue(), DelayedReadValueModel.this.pendingEvt.getNewValue(), true);
            DelayedReadValueModel.this.stop();
            DelayedReadValueModel.this.oldValue = DelayedReadValueModel.this.pendingEvt.getNewValue() != null ? DelayedReadValueModel.this.pendingEvt.getNewValue() : DelayedReadValueModel.this.subject.getValue();
        }
    }
}

