/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.list;

import com.jgoodies.binding.list.ArrayListModel;
import com.jgoodies.binding.list.IndirectListModel;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SelectionInList<E>
extends IndirectListModel<E>
implements ValueModel {
    public static final String PROPERTYNAME_SELECTION = "selection";
    public static final String PROPERTYNAME_SELECTION_EMPTY = "selectionEmpty";
    public static final String PROPERTYNAME_SELECTION_HOLDER = "selectionHolder";
    public static final String PROPERTYNAME_SELECTION_INDEX = "selectionIndex";
    public static final String PROPERTYNAME_SELECTION_INDEX_HOLDER = "selectionIndexHolder";
    public static final String PROPERTYNAME_VALUE = "value";
    private static final int NO_SELECTION_INDEX = -1;
    private ValueModel selectionHolder;
    private ValueModel selectionIndexHolder;
    private final PropertyChangeListener selectionChangeHandler;
    private final PropertyChangeListener selectionIndexChangeHandler;
    private E oldSelection;
    private int oldSelectionIndex;

    public SelectionInList() {
        this(new ArrayListModel());
    }

    public SelectionInList(E[] EArray) {
        this(Arrays.asList(EArray));
    }

    public SelectionInList(E[] EArray, ValueModel valueModel) {
        this(Arrays.asList(EArray), valueModel);
    }

    public SelectionInList(E[] EArray, ValueModel valueModel, ValueModel valueModel2) {
        this(Arrays.asList(EArray), valueModel, valueModel2);
    }

    public SelectionInList(List<E> list) {
        this(new ValueHolder(list, true));
    }

    public SelectionInList(List<E> list, ValueModel valueModel) {
        this(new ValueHolder(list, true), valueModel);
    }

    public SelectionInList(List<E> list, ValueModel valueModel, ValueModel valueModel2) {
        this(new ValueHolder(list, true), valueModel, valueModel2);
    }

    public SelectionInList(ListModel listModel) {
        this(new ValueHolder(listModel, true));
    }

    public SelectionInList(ListModel listModel, ValueModel valueModel) {
        this(new ValueHolder(listModel, true), valueModel);
    }

    public SelectionInList(ListModel listModel, ValueModel valueModel, ValueModel valueModel2) {
        this(new ValueHolder(listModel, true), valueModel, valueModel2);
    }

    public SelectionInList(ValueModel valueModel) {
        this(valueModel, (ValueModel)new ValueHolder(null, true));
    }

    public SelectionInList(ValueModel valueModel, ValueModel valueModel2) {
        this(valueModel, valueModel2, (ValueModel)new ValueHolder((Object)-1));
    }

    public SelectionInList(ValueModel valueModel, ValueModel valueModel2, ValueModel valueModel3) {
        super(valueModel);
        if (valueModel2 == null) {
            throw new NullPointerException("The selection holder must not be null.");
        }
        if (valueModel3 == null) {
            throw new NullPointerException("The selection index holder must not be null.");
        }
        this.selectionChangeHandler = new SelectionChangeHandler();
        this.selectionIndexChangeHandler = new SelectionIndexChangeHandler();
        this.selectionHolder = valueModel2;
        this.selectionIndexHolder = valueModel3;
        this.initializeSelectionIndex();
        this.selectionHolder.addValueChangeListener(this.selectionChangeHandler);
        this.selectionIndexHolder.addValueChangeListener(this.selectionIndexChangeHandler);
    }

    public void fireSelectedContentsChanged() {
        if (this.hasSelection()) {
            int n = this.getSelectionIndex();
            this.fireContentsChanged(n, n);
        }
    }

    public E getSelection() {
        return this.getSafeElementAt(this.getSelectionIndex());
    }

    public void setSelection(E e) {
        if (!this.isEmpty()) {
            this.setSelectionIndex(this.indexOf(e));
        }
    }

    public boolean hasSelection() {
        return this.getSelectionIndex() != -1;
    }

    public boolean isSelectionEmpty() {
        return !this.hasSelection();
    }

    public void clearSelection() {
        this.setSelectionIndex(-1);
    }

    public int getSelectionIndex() {
        return (Integer)this.getSelectionIndexHolder().getValue();
    }

    public void setSelectionIndex(int n) {
        int n2 = this.getSize() - 1;
        if (n < -1 || n > n2) {
            throw new IndexOutOfBoundsException("The selection index " + n + " must be in [-1, " + n2 + "]");
        }
        this.oldSelectionIndex = this.getSelectionIndex();
        if (this.oldSelectionIndex == n) {
            return;
        }
        this.getSelectionIndexHolder().setValue(n);
    }

    public ValueModel getSelectionHolder() {
        return this.selectionHolder;
    }

    public void setSelectionHolder(ValueModel valueModel) {
        if (valueModel == null) {
            throw new NullPointerException("The new selection holder must not be null.");
        }
        ValueModel valueModel2 = this.getSelectionHolder();
        valueModel2.removeValueChangeListener(this.selectionChangeHandler);
        this.selectionHolder = valueModel;
        this.oldSelection = valueModel.getValue();
        valueModel.addValueChangeListener(this.selectionChangeHandler);
        this.firePropertyChange(PROPERTYNAME_SELECTION_HOLDER, valueModel2, valueModel);
    }

    public ValueModel getSelectionIndexHolder() {
        return this.selectionIndexHolder;
    }

    public void setSelectionIndexHolder(ValueModel valueModel) {
        if (valueModel == null) {
            throw new NullPointerException("The new selection index holder must not be null.");
        }
        if (valueModel.getValue() == null) {
            throw new IllegalArgumentException("The value of the new selection index holder must not be null.");
        }
        ValueModel valueModel2 = this.getSelectionIndexHolder();
        if (this.equals(valueModel2, valueModel)) {
            return;
        }
        valueModel2.removeValueChangeListener(this.selectionIndexChangeHandler);
        this.selectionIndexHolder = valueModel;
        valueModel.addValueChangeListener(this.selectionIndexChangeHandler);
        this.oldSelectionIndex = this.getSelectionIndex();
        this.oldSelection = this.getSafeElementAt(this.oldSelectionIndex);
        this.firePropertyChange(PROPERTYNAME_SELECTION_INDEX_HOLDER, valueModel2, valueModel);
    }

    public E getValue() {
        return this.getSelection();
    }

    @Override
    public void setValue(Object object) {
        this.setSelection(object);
    }

    @Override
    public void addValueChangeListener(PropertyChangeListener propertyChangeListener) {
        this.addPropertyChangeListener(PROPERTYNAME_VALUE, propertyChangeListener);
    }

    @Override
    public void removeValueChangeListener(PropertyChangeListener propertyChangeListener) {
        this.removePropertyChangeListener(PROPERTYNAME_VALUE, propertyChangeListener);
    }

    void fireValueChange(Object object, Object object2) {
        this.firePropertyChange(PROPERTYNAME_VALUE, object, object2);
    }

    @Override
    public void release() {
        super.release();
        this.selectionHolder.removeValueChangeListener(this.selectionChangeHandler);
        this.selectionIndexHolder.removeValueChangeListener(this.selectionIndexChangeHandler);
        this.selectionHolder = null;
        this.selectionIndexHolder = null;
        this.oldSelection = null;
    }

    private E getSafeElementAt(int n) {
        return n < 0 || n >= this.getSize() ? null : (E)this.getElementAt(n);
    }

    private int indexOf(Object object) {
        return this.indexOf(this.getListHolder().getValue(), object);
    }

    private int indexOf(Object object, Object object2) {
        if (object2 == null) {
            return -1;
        }
        if (this.getSize(object) == 0) {
            return -1;
        }
        if (object instanceof List) {
            return ((List)object).indexOf(object2);
        }
        ListModel listModel = (ListModel)object;
        int n = listModel.getSize();
        for (int i = 0; i < n; ++i) {
            if (!object2.equals(listModel.getElementAt(i))) continue;
            return i;
        }
        return -1;
    }

    private void initializeSelectionIndex() {
        Object object = this.selectionHolder.getValue();
        if (object != null) {
            this.setSelectionIndex(this.indexOf(object));
        }
        this.oldSelection = object;
        this.oldSelectionIndex = this.getSelectionIndex();
    }

    @Override
    protected ListDataListener createListDataChangeHandler() {
        return new ListDataChangeHandler();
    }

    @Override
    protected void updateList(Object object, int n, Object object2) {
        boolean bl = this.hasSelection();
        Object object3 = bl ? this.getSelectionHolder().getValue() : null;
        super.updateList(object, n, object2);
        if (bl) {
            this.setSelectionIndex(this.indexOf(object2, object3));
        }
    }

    private final class SelectionIndexChangeHandler
    implements PropertyChangeListener {
        private SelectionIndexChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object;
            int n = SelectionInList.this.getSelectionIndex();
            Object object2 = SelectionInList.this.oldSelection;
            if (!SelectionInList.this.equals(object2, object = SelectionInList.this.getSafeElementAt(n))) {
                SelectionInList.this.selectionHolder.removeValueChangeListener(SelectionInList.this.selectionChangeHandler);
                SelectionInList.this.selectionHolder.setValue(object);
                SelectionInList.this.selectionHolder.addValueChangeListener(SelectionInList.this.selectionChangeHandler);
            }
            int n2 = SelectionInList.this.oldSelectionIndex;
            SelectionInList.this.oldSelectionIndex = n;
            SelectionInList.this.oldSelection = object;
            SelectionInList.this.firePropertyChange(SelectionInList.PROPERTYNAME_SELECTION_INDEX, n2, n);
            SelectionInList.this.firePropertyChange(SelectionInList.PROPERTYNAME_SELECTION_EMPTY, n2 == -1, n == -1);
            SelectionInList.this.firePropertyChange(SelectionInList.PROPERTYNAME_SELECTION, object2, object);
            SelectionInList.this.fireValueChange(object2, object);
        }
    }

    private final class SelectionChangeHandler
    implements PropertyChangeListener {
        private SelectionChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getOldValue();
            Object object2 = propertyChangeEvent.getNewValue();
            int n = SelectionInList.this.indexOf(object2);
            if (n != SelectionInList.this.oldSelectionIndex) {
                SelectionInList.this.selectionIndexHolder.removeValueChangeListener(SelectionInList.this.selectionIndexChangeHandler);
                SelectionInList.this.selectionIndexHolder.setValue(n);
                SelectionInList.this.selectionIndexHolder.addValueChangeListener(SelectionInList.this.selectionIndexChangeHandler);
            }
            int n2 = SelectionInList.this.oldSelectionIndex;
            SelectionInList.this.oldSelectionIndex = n;
            SelectionInList.this.oldSelection = object2;
            SelectionInList.this.firePropertyChange(SelectionInList.PROPERTYNAME_SELECTION_INDEX, n2, n);
            SelectionInList.this.firePropertyChange(SelectionInList.PROPERTYNAME_SELECTION_EMPTY, n2 == -1, n == -1);
            SelectionInList.this.firePropertyChange(SelectionInList.PROPERTYNAME_SELECTION, object, object2);
            SelectionInList.this.fireValueChange(object, object2);
        }
    }

    private final class ListDataChangeHandler
    implements ListDataListener {
        private ListDataChangeHandler() {
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            int n = listDataEvent.getIndex0();
            int n2 = listDataEvent.getIndex1();
            int n3 = SelectionInList.this.getSelectionIndex();
            SelectionInList.this.fireIntervalAdded(n, n2);
            if (n3 >= n) {
                SelectionInList.this.setSelectionIndex(n3 + (n2 - n + 1));
            }
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            int n = listDataEvent.getIndex0();
            int n2 = listDataEvent.getIndex1();
            int n3 = SelectionInList.this.getSelectionIndex();
            SelectionInList.this.fireIntervalRemoved(n, n2);
            if (n3 >= n) {
                if (n3 <= n2) {
                    SelectionInList.this.setSelectionIndex(-1);
                } else {
                    SelectionInList.this.setSelectionIndex(n3 - (n2 - n + 1));
                }
            }
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            SelectionInList.this.fireContentsChanged(listDataEvent.getIndex0(), listDataEvent.getIndex1());
            this.updateSelectionContentsChanged(listDataEvent.getIndex0(), listDataEvent.getIndex1());
        }

        private void updateSelectionContentsChanged(int n, int n2) {
            if (n < 0) {
                return;
            }
            int n3 = SelectionInList.this.getSelectionIndex();
            if (n <= n3 && n3 <= n2) {
                SelectionInList.this.getSelectionHolder().setValue(SelectionInList.this.getElementAt(n3));
            }
        }
    }
}

