/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.list;

import com.jgoodies.binding.beans.Model;
import com.jgoodies.binding.list.ArrayListModel;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.ListModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndirectListModel<E>
extends Model
implements ListModel {
    public static final String PROPERTYNAME_LIST = "list";
    public static final String PROPERTYNAME_LIST_HOLDER = "listHolder";
    private static final ListModel EMPTY_LIST_MODEL = new EmptyListModel();
    private ValueModel listHolder;
    private Object list;
    private int listSize;
    private final PropertyChangeListener listChangeHandler;
    private final ListDataListener listDataChangeHandler;
    private final EventListenerList listenerList = new EventListenerList();

    public IndirectListModel() {
        this(new ArrayListModel());
    }

    public IndirectListModel(E[] EArray) {
        this(Arrays.asList(EArray));
    }

    public IndirectListModel(List<E> list) {
        this(new ValueHolder(list, true));
    }

    public IndirectListModel(ListModel listModel) {
        this(new ValueHolder(listModel, true));
    }

    public IndirectListModel(ValueModel valueModel) {
        if (valueModel == null) {
            throw new NullPointerException("The list holder must not be null.");
        }
        this.checkListHolderIdentityCheck(valueModel);
        this.listChangeHandler = new ListChangeHandler();
        this.listDataChangeHandler = this.createListDataChangeHandler();
        this.listHolder = valueModel;
        this.listHolder.addValueChangeListener(this.listChangeHandler);
        this.list = valueModel.getValue();
        this.listSize = this.getSize(this.list);
        if (this.list != null) {
            if (this.list instanceof ListModel) {
                ((ListModel)this.list).addListDataListener(this.listDataChangeHandler);
            } else if (!(this.list instanceof List)) {
                throw new ClassCastException("The listHolder's value must be a List or ListModel.");
            }
        }
    }

    public final List<E> getList() {
        Object object = this.getListHolder().getValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object instanceof List) {
            return (List)object;
        }
        throw new ClassCastException("#getList assumes that the list holder holds a List");
    }

    public final void setList(List<E> list) {
        this.getListHolder().setValue(list);
    }

    public final ListModel getListModel() {
        Object object = this.getListHolder().getValue();
        if (object == null) {
            return EMPTY_LIST_MODEL;
        }
        if (object instanceof ListModel) {
            return (ListModel)object;
        }
        throw new ClassCastException("#getListModel assumes that the list holder holds a ListModel");
    }

    public final void setListModel(ListModel listModel) {
        this.getListHolder().setValue(listModel);
    }

    public final ValueModel getListHolder() {
        return this.listHolder;
    }

    public final void setListHolder(ValueModel valueModel) {
        if (valueModel == null) {
            throw new NullPointerException("The new list holder must not be null.");
        }
        this.checkListHolderIdentityCheck(valueModel);
        ValueModel valueModel2 = this.getListHolder();
        if (valueModel2 == valueModel) {
            return;
        }
        Object object = this.list;
        int n = this.listSize;
        Object object2 = valueModel.getValue();
        valueModel2.removeValueChangeListener(this.listChangeHandler);
        this.listHolder = valueModel;
        valueModel.addValueChangeListener(this.listChangeHandler);
        this.updateList(object, n, object2);
        this.firePropertyChange(PROPERTYNAME_LIST_HOLDER, valueModel2, valueModel);
    }

    public final boolean isEmpty() {
        return this.getSize() == 0;
    }

    @Override
    public final int getSize() {
        return this.getSize(this.getListHolder().getValue());
    }

    @Override
    public final E getElementAt(int n) {
        return this.getElementAt(this.getListHolder().getValue(), n);
    }

    @Override
    public final void addListDataListener(ListDataListener listDataListener) {
        this.listenerList.add(ListDataListener.class, listDataListener);
    }

    @Override
    public final void removeListDataListener(ListDataListener listDataListener) {
        this.listenerList.remove(ListDataListener.class, listDataListener);
    }

    public final ListDataListener[] getListDataListeners() {
        return (ListDataListener[])this.listenerList.getListeners(ListDataListener.class);
    }

    public final void fireContentsChanged(int n, int n2) {
        Object[] objectArray = this.listenerList.getListenerList();
        ListDataEvent listDataEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ListDataListener.class) continue;
            if (listDataEvent == null) {
                listDataEvent = new ListDataEvent(this, 0, n, n2);
            }
            ((ListDataListener)objectArray[i + 1]).contentsChanged(listDataEvent);
        }
    }

    public final void fireIntervalAdded(int n, int n2) {
        Object[] objectArray = this.listenerList.getListenerList();
        ListDataEvent listDataEvent = null;
        this.listSize = this.getSize();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ListDataListener.class) continue;
            if (listDataEvent == null) {
                listDataEvent = new ListDataEvent(this, 1, n, n2);
            }
            ((ListDataListener)objectArray[i + 1]).intervalAdded(listDataEvent);
        }
    }

    public final void fireIntervalRemoved(int n, int n2) {
        Object[] objectArray = this.listenerList.getListenerList();
        ListDataEvent listDataEvent = null;
        this.listSize = this.getSize();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ListDataListener.class) continue;
            if (listDataEvent == null) {
                listDataEvent = new ListDataEvent(this, 2, n, n2);
            }
            ((ListDataListener)objectArray[i + 1]).intervalRemoved(listDataEvent);
        }
    }

    public void release() {
        this.listHolder.removeValueChangeListener(this.listChangeHandler);
        if (this.list != null && this.list instanceof ListModel) {
            ((ListModel)this.list).removeListDataListener(this.listDataChangeHandler);
        }
        this.listHolder = null;
        this.list = null;
    }

    protected ListDataListener createListDataChangeHandler() {
        return new ListDataChangeHandler();
    }

    protected void updateList(Object object, int n, Object object2) {
        if (object != null && object instanceof ListModel) {
            ((ListModel)object).removeListDataListener(this.listDataChangeHandler);
        }
        if (object2 != null && object2 instanceof ListModel) {
            ((ListModel)object2).addListDataListener(this.listDataChangeHandler);
        }
        int n2 = this.getSize(object2);
        this.list = object2;
        this.listSize = this.getSize(object2);
        this.firePropertyChange(PROPERTYNAME_LIST, object, object2);
        this.fireListChanged(n - 1, n2 - 1);
    }

    protected final void fireListChanged(int n, int n2) {
        if (n2 < n) {
            this.fireIntervalRemoved(n2 + 1, n);
        } else if (n < n2) {
            this.fireIntervalAdded(n + 1, n2);
        }
        int n3 = Math.min(n, n2);
        if (n3 >= 0) {
            this.fireContentsChanged(0, n3);
        }
    }

    protected final int getSize(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof ListModel) {
            return ((ListModel)object).getSize();
        }
        return ((List)object).size();
    }

    private E getElementAt(Object object, int n) {
        if (object == null) {
            throw new NullPointerException("The list contents is null.");
        }
        if (object instanceof ListModel) {
            return ((ListModel)object).getElementAt(n);
        }
        return ((List)object).get(n);
    }

    private void checkListHolderIdentityCheck(ValueModel valueModel) {
        if (!(valueModel instanceof ValueHolder)) {
            return;
        }
        ValueHolder valueHolder = (ValueHolder)valueModel;
        if (!valueHolder.isIdentityCheckEnabled()) {
            throw new IllegalArgumentException("The list holder must have the identity check enabled.");
        }
    }

    private final class ListDataChangeHandler
    implements ListDataListener {
        private ListDataChangeHandler() {
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            int n = listDataEvent.getIndex0();
            int n2 = listDataEvent.getIndex1();
            IndirectListModel.this.fireIntervalAdded(n, n2);
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            int n = listDataEvent.getIndex0();
            int n2 = listDataEvent.getIndex1();
            IndirectListModel.this.fireIntervalRemoved(n, n2);
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            IndirectListModel.this.fireContentsChanged(listDataEvent.getIndex0(), listDataEvent.getIndex1());
        }
    }

    private final class ListChangeHandler
    implements PropertyChangeListener {
        private ListChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = IndirectListModel.this.list;
            int n = IndirectListModel.this.listSize;
            Object object2 = propertyChangeEvent.getNewValue();
            IndirectListModel.this.updateList(object, n, object2);
        }
    }

    private static final class EmptyListModel
    implements ListModel,
    Serializable {
        private EmptyListModel() {
        }

        public int getSize() {
            return 0;
        }

        public Object getElementAt(int n) {
            return null;
        }

        public void addListDataListener(ListDataListener listDataListener) {
        }

        public void removeListDataListener(ListDataListener listDataListener) {
        }
    }
}

