/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.beans;

import com.jgoodies.binding.beans.BeanUtils;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class IndirectPropertyChangeSupport {
    private final ValueModel beanChannel;
    private final List<PropertyChangeListener> listenerList;
    private final Map<String, List<PropertyChangeListener>> namedListeners;

    public IndirectPropertyChangeSupport() {
        this(new ValueHolder(null, true));
    }

    public IndirectPropertyChangeSupport(Object object) {
        this(new ValueHolder(object, true));
    }

    public IndirectPropertyChangeSupport(ValueModel valueModel) {
        if (valueModel == null) {
            throw new NullPointerException("The bean channel must not be null.");
        }
        this.beanChannel = valueModel;
        this.listenerList = new ArrayList<PropertyChangeListener>();
        this.namedListeners = new HashMap<String, List<PropertyChangeListener>>();
        valueModel.addValueChangeListener(new BeanChangeHandler());
    }

    public Object getBean() {
        return this.beanChannel.getValue();
    }

    public void setBean(Object object) {
        this.beanChannel.setValue(object);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        this.listenerList.add(propertyChangeListener);
        Object object = this.getBean();
        if (object != null) {
            BeanUtils.addPropertyChangeListener(object, propertyChangeListener);
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        this.listenerList.remove(propertyChangeListener);
        Object object = this.getBean();
        if (object != null) {
            BeanUtils.removePropertyChangeListener(object, propertyChangeListener);
        }
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        List<PropertyChangeListener> list = this.namedListeners.get(string);
        if (list == null) {
            list = new ArrayList<PropertyChangeListener>();
            this.namedListeners.put(string, list);
        }
        list.add(propertyChangeListener);
        Object object = this.getBean();
        if (object != null) {
            BeanUtils.addPropertyChangeListener(object, string, propertyChangeListener);
        }
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        List<PropertyChangeListener> list = this.namedListeners.get(string);
        if (list == null) {
            return;
        }
        list.remove(propertyChangeListener);
        Object object = this.getBean();
        if (object != null) {
            BeanUtils.removePropertyChangeListener(object, string, propertyChangeListener);
        }
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.listenerList.isEmpty()) {
            return new PropertyChangeListener[0];
        }
        return this.listenerList.toArray(new PropertyChangeListener[this.listenerList.size()]);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners(String string) {
        List<PropertyChangeListener> list = this.namedListeners.get(string);
        if (list == null || list.isEmpty()) {
            return new PropertyChangeListener[0];
        }
        return list.toArray(new PropertyChangeListener[list.size()]);
    }

    public void removeAll() {
        this.removeAllListenersFrom(this.getBean());
    }

    private void setBean0(Object object, Object object2) {
        this.removeAllListenersFrom(object);
        this.addAllListenersTo(object2);
    }

    private void addAllListenersTo(Object object) {
        if (object == null) {
            return;
        }
        for (PropertyChangeListener object2 : this.listenerList) {
            BeanUtils.addPropertyChangeListener(object, object2);
        }
        for (Map.Entry entry : this.namedListeners.entrySet()) {
            String string = (String)entry.getKey();
            for (PropertyChangeListener propertyChangeListener : (List)entry.getValue()) {
                BeanUtils.addPropertyChangeListener(object, string, propertyChangeListener);
            }
        }
    }

    private void removeAllListenersFrom(Object object) {
        if (object == null) {
            return;
        }
        for (PropertyChangeListener object2 : this.listenerList) {
            BeanUtils.removePropertyChangeListener(object, object2);
        }
        for (Map.Entry entry : this.namedListeners.entrySet()) {
            String string = (String)entry.getKey();
            for (PropertyChangeListener propertyChangeListener : (List)entry.getValue()) {
                BeanUtils.removePropertyChangeListener(object, string, propertyChangeListener);
            }
        }
    }

    private final class BeanChangeHandler
    implements PropertyChangeListener {
        private BeanChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            IndirectPropertyChangeSupport.this.setBean0(propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
    }
}

