/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.adapter;

import com.jgoodies.binding.BindingUtils;
import com.jgoodies.binding.value.ValueModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.JToggleButton;

public final class RadioButtonAdapter
extends JToggleButton.ToggleButtonModel {
    private final ValueModel subject;
    private final Object choice;

    public RadioButtonAdapter(ValueModel valueModel, Object object) {
        if (valueModel == null) {
            throw new NullPointerException("The subject must not be null.");
        }
        this.subject = valueModel;
        this.choice = object;
        valueModel.addValueChangeListener(new SubjectValueChangeHandler());
        this.updateSelectedState();
    }

    public void setSelected(boolean bl) {
        if (!bl || this.isSelected()) {
            return;
        }
        this.subject.setValue(this.choice);
        this.updateSelectedState();
    }

    public void setGroup(ButtonGroup buttonGroup) {
        if (buttonGroup != null) {
            throw new UnsupportedOperationException("You need not and must not use a ButtonGroup with a set of RadioButtonAdapters. These form a group by sharing the same subject ValueModel.");
        }
    }

    private void updateSelectedState() {
        boolean bl = BindingUtils.equals(this.choice, this.subject.getValue());
        super.setSelected(bl);
    }

    private final class SubjectValueChangeHandler
    implements PropertyChangeListener {
        private SubjectValueChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            RadioButtonAdapter.this.updateSelectedState();
        }
    }
}

