/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.adapter;

import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.ValueModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ComboBoxAdapter<E>
extends AbstractListModel
implements ComboBoxModel {
    private final ListModel listModel;
    private ValueModel selectionHolder;
    private final PropertyChangeListener selectionChangeHandler;

    public ComboBoxAdapter(List<E> list, ValueModel valueModel) {
        this(new ListModelAdapter<E>(list), valueModel);
        if (list == null) {
            throw new NullPointerException("The list must not be null.");
        }
    }

    public ComboBoxAdapter(ListModel listModel, ValueModel valueModel) {
        if (listModel == null) {
            throw new NullPointerException("The ListModel must not be null.");
        }
        if (valueModel == null) {
            throw new NullPointerException("The selection holder must not be null.");
        }
        this.listModel = listModel;
        this.selectionHolder = valueModel;
        listModel.addListDataListener(new ListDataChangeHandler());
        this.selectionChangeHandler = new SelectionChangeHandler();
        this.setSelectionHolder(valueModel);
    }

    public ComboBoxAdapter(E[] EArray, ValueModel valueModel) {
        this(new ListModelAdapter<E>(EArray), valueModel);
    }

    public ComboBoxAdapter(SelectionInList<E> selectionInList) {
        this(selectionInList, selectionInList);
        selectionInList.addPropertyChangeListener("selectionHolder", new SelectionHolderChangeHandler());
    }

    public E getSelectedItem() {
        return (E)this.selectionHolder.getValue();
    }

    @Override
    public void setSelectedItem(Object object) {
        this.selectionHolder.setValue(object);
    }

    @Override
    public int getSize() {
        return this.listModel.getSize();
    }

    @Override
    public E getElementAt(int n) {
        return this.listModel.getElementAt(n);
    }

    private void setSelectionHolder(ValueModel valueModel) {
        ValueModel valueModel2 = this.selectionHolder;
        if (valueModel2 != null) {
            valueModel2.removeValueChangeListener(this.selectionChangeHandler);
        }
        this.selectionHolder = valueModel;
        if (valueModel == null) {
            throw new NullPointerException("The selection holder must not be null.");
        }
        valueModel.addValueChangeListener(this.selectionChangeHandler);
    }

    private void fireContentsChanged() {
        this.fireContentsChanged(this, -1, -1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ListModelAdapter<E>
    extends AbstractListModel {
        private final List<E> aList;

        ListModelAdapter(List<E> list) {
            this.aList = list;
        }

        ListModelAdapter(E[] EArray) {
            this(Arrays.asList(EArray));
        }

        @Override
        public int getSize() {
            return this.aList.size();
        }

        @Override
        public E getElementAt(int n) {
            return this.aList.get(n);
        }
    }

    private final class SelectionHolderChangeHandler
    implements PropertyChangeListener {
        private SelectionHolderChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ComboBoxAdapter.this.setSelectionHolder((ValueModel)propertyChangeEvent.getNewValue());
            ComboBoxAdapter.this.fireContentsChanged();
        }
    }

    private final class ListDataChangeHandler
    implements ListDataListener {
        private ListDataChangeHandler() {
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            ComboBoxAdapter.this.fireIntervalAdded(ComboBoxAdapter.this, listDataEvent.getIndex0(), listDataEvent.getIndex1());
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            ComboBoxAdapter.this.fireIntervalRemoved(ComboBoxAdapter.this, listDataEvent.getIndex0(), listDataEvent.getIndex1());
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            ComboBoxAdapter.this.fireContentsChanged(ComboBoxAdapter.this, listDataEvent.getIndex0(), listDataEvent.getIndex1());
        }
    }

    private final class SelectionChangeHandler
    implements PropertyChangeListener {
        private SelectionChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ComboBoxAdapter.this.fireContentsChanged();
        }
    }
}

