/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.graph.BaseGraph;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.EndpointPairIterator;
import com.google.common.math.IntMath;
import com.google.common.primitives.Ints;
import java.util.AbstractSet;
import java.util.Set;
import javax.annotation.Nullable;

abstract class AbstractBaseGraph<N>
implements BaseGraph<N> {
    AbstractBaseGraph() {
    }

    protected long edgeCount() {
        long l = 0L;
        for (Object n : this.nodes()) {
            l += (long)this.degree(n);
        }
        Preconditions.checkState((l & 1L) == 0L);
        return l >>> 1;
    }

    @Override
    public Set<EndpointPair<N>> edges() {
        return new AbstractSet<EndpointPair<N>>(){

            @Override
            public UnmodifiableIterator<EndpointPair<N>> iterator() {
                return EndpointPairIterator.of(AbstractBaseGraph.this);
            }

            @Override
            public int size() {
                return Ints.saturatedCast(AbstractBaseGraph.this.edgeCount());
            }

            @Override
            public boolean contains(@Nullable Object object) {
                if (!(object instanceof EndpointPair)) {
                    return false;
                }
                EndpointPair endpointPair = (EndpointPair)object;
                return AbstractBaseGraph.this.isDirected() == endpointPair.isOrdered() && AbstractBaseGraph.this.nodes().contains(endpointPair.nodeU()) && AbstractBaseGraph.this.successors(endpointPair.nodeU()).contains(endpointPair.nodeV());
            }
        };
    }

    @Override
    public int degree(N n) {
        if (this.isDirected()) {
            return IntMath.saturatedAdd(this.predecessors((Object)n).size(), this.successors((Object)n).size());
        }
        Set<N> set = this.adjacentNodes(n);
        int n2 = this.allowsSelfLoops() && set.contains(n) ? 1 : 0;
        return IntMath.saturatedAdd(set.size(), n2);
    }

    @Override
    public int inDegree(N n) {
        return this.isDirected() ? this.predecessors((Object)n).size() : this.degree(n);
    }

    @Override
    public int outDegree(N n) {
        return this.isDirected() ? this.successors((Object)n).size() : this.degree(n);
    }

    @Override
    public boolean hasEdgeConnecting(N n, N n2) {
        Preconditions.checkNotNull(n);
        Preconditions.checkNotNull(n2);
        return this.nodes().contains(n) && this.successors((Object)n).contains(n2);
    }
}

