/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.fasterxml.jackson.databind.introspect.POJOPropertiesCollector;
import com.fasterxml.jackson.databind.type.TypeBindings;
import com.fasterxml.jackson.databind.util.Annotations;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.Converter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BasicBeanDescription
extends BeanDescription {
    protected final POJOPropertiesCollector _propCollector;
    protected final MapperConfig<?> _config;
    protected final AnnotationIntrospector _annotationIntrospector;
    protected final AnnotatedClass _classInfo;
    protected List<BeanPropertyDefinition> _properties;
    protected ObjectIdInfo _objectIdInfo;

    protected BasicBeanDescription(POJOPropertiesCollector pOJOPropertiesCollector, JavaType javaType, AnnotatedClass annotatedClass) {
        super(javaType);
        this._propCollector = pOJOPropertiesCollector;
        this._config = pOJOPropertiesCollector.getConfig();
        this._annotationIntrospector = this._config == null ? null : this._config.getAnnotationIntrospector();
        this._classInfo = annotatedClass;
    }

    protected BasicBeanDescription(MapperConfig<?> mapperConfig, JavaType javaType, AnnotatedClass annotatedClass, List<BeanPropertyDefinition> list) {
        super(javaType);
        this._propCollector = null;
        this._config = mapperConfig;
        this._annotationIntrospector = this._config == null ? null : this._config.getAnnotationIntrospector();
        this._classInfo = annotatedClass;
        this._properties = list;
    }

    protected BasicBeanDescription(POJOPropertiesCollector pOJOPropertiesCollector) {
        this(pOJOPropertiesCollector, pOJOPropertiesCollector.getType(), pOJOPropertiesCollector.getClassDef());
        this._objectIdInfo = pOJOPropertiesCollector.getObjectIdInfo();
    }

    public static BasicBeanDescription forDeserialization(POJOPropertiesCollector pOJOPropertiesCollector) {
        return new BasicBeanDescription(pOJOPropertiesCollector);
    }

    public static BasicBeanDescription forSerialization(POJOPropertiesCollector pOJOPropertiesCollector) {
        return new BasicBeanDescription(pOJOPropertiesCollector);
    }

    public static BasicBeanDescription forOtherUse(MapperConfig<?> mapperConfig, JavaType javaType, AnnotatedClass annotatedClass) {
        return new BasicBeanDescription(mapperConfig, javaType, annotatedClass, Collections.emptyList());
    }

    protected List<BeanPropertyDefinition> _properties() {
        if (this._properties == null) {
            this._properties = this._propCollector.getProperties();
        }
        return this._properties;
    }

    public boolean removeProperty(String string) {
        Iterator<BeanPropertyDefinition> iterator = this._properties().iterator();
        while (iterator.hasNext()) {
            BeanPropertyDefinition beanPropertyDefinition = iterator.next();
            if (!beanPropertyDefinition.getName().equals(string)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public boolean addProperty(BeanPropertyDefinition beanPropertyDefinition) {
        if (this.hasProperty(beanPropertyDefinition.getFullName())) {
            return false;
        }
        this._properties().add(beanPropertyDefinition);
        return true;
    }

    public boolean hasProperty(PropertyName propertyName) {
        return this.findProperty(propertyName) != null;
    }

    public BeanPropertyDefinition findProperty(PropertyName propertyName) {
        for (BeanPropertyDefinition beanPropertyDefinition : this._properties()) {
            if (!beanPropertyDefinition.hasName(propertyName)) continue;
            return beanPropertyDefinition;
        }
        return null;
    }

    @Override
    public AnnotatedClass getClassInfo() {
        return this._classInfo;
    }

    @Override
    public ObjectIdInfo getObjectIdInfo() {
        return this._objectIdInfo;
    }

    @Override
    public List<BeanPropertyDefinition> findProperties() {
        return this._properties();
    }

    @Override
    public AnnotatedMethod findJsonValueMethod() {
        return this._propCollector == null ? null : this._propCollector.getJsonValueMethod();
    }

    @Override
    public Set<String> getIgnoredPropertyNames() {
        Set<String> set;
        Set<String> set2 = set = this._propCollector == null ? null : this._propCollector.getIgnoredPropertyNames();
        if (set == null) {
            return Collections.emptySet();
        }
        return set;
    }

    @Override
    public boolean hasKnownClassAnnotations() {
        return this._classInfo.hasAnnotations();
    }

    @Override
    public Annotations getClassAnnotations() {
        return this._classInfo.getAnnotations();
    }

    @Override
    @Deprecated
    public TypeBindings bindingsForBeanType() {
        return this._type.getBindings();
    }

    @Override
    @Deprecated
    public JavaType resolveType(Type type) {
        if (type == null) {
            return null;
        }
        return this._config.getTypeFactory().constructType(type, this._type.getBindings());
    }

    @Override
    public AnnotatedConstructor findDefaultConstructor() {
        return this._classInfo.getDefaultConstructor();
    }

    @Override
    public AnnotatedMethod findAnySetter() throws IllegalArgumentException {
        Class<?> clazz;
        AnnotatedMethod annotatedMethod;
        AnnotatedMethod annotatedMethod2 = annotatedMethod = this._propCollector == null ? null : this._propCollector.getAnySetterMethod();
        if (annotatedMethod != null && (clazz = annotatedMethod.getRawParameterType(0)) != String.class && clazz != Object.class) {
            throw new IllegalArgumentException("Invalid 'any-setter' annotation on method " + annotatedMethod.getName() + "(): first argument not of type String or Object, but " + clazz.getName());
        }
        return annotatedMethod;
    }

    @Override
    public Map<Object, AnnotatedMember> findInjectables() {
        if (this._propCollector != null) {
            return this._propCollector.getInjectables();
        }
        return Collections.emptyMap();
    }

    @Override
    public List<AnnotatedConstructor> getConstructors() {
        return this._classInfo.getConstructors();
    }

    @Override
    public Object instantiateBean(boolean bl) {
        AnnotatedConstructor annotatedConstructor = this._classInfo.getDefaultConstructor();
        if (annotatedConstructor == null) {
            return null;
        }
        if (bl) {
            annotatedConstructor.fixAccess(this._config.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
        }
        try {
            return ((Constructor)annotatedConstructor.getAnnotated()).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            Throwable throwable = exception;
            while (throwable.getCause() != null) {
                throwable = throwable.getCause();
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new IllegalArgumentException("Failed to instantiate bean of type " + ((Class)this._classInfo.getAnnotated()).getName() + ": (" + throwable.getClass().getName() + ") " + throwable.getMessage(), throwable);
        }
    }

    @Override
    public AnnotatedMethod findMethod(String string, Class<?>[] classArray) {
        return this._classInfo.findMethod(string, classArray);
    }

    @Override
    public JsonFormat.Value findExpectedFormat(JsonFormat.Value value) {
        JsonFormat.Value value2;
        if (this._annotationIntrospector != null && (value2 = this._annotationIntrospector.findFormat(this._classInfo)) != null) {
            value = value == null ? value2 : value.withOverrides(value2);
        }
        if ((value2 = this._config.getDefaultPropertyFormat(this._classInfo.getRawType())) != null) {
            value = value == null ? value2 : value.withOverrides(value2);
        }
        return value;
    }

    @Override
    public Converter<Object, Object> findSerializationConverter() {
        if (this._annotationIntrospector == null) {
            return null;
        }
        return this._createConverter(this._annotationIntrospector.findSerializationConverter(this._classInfo));
    }

    @Override
    public JsonInclude.Value findPropertyInclusion(JsonInclude.Value value) {
        JsonInclude.Value value2;
        if (this._annotationIntrospector != null && (value2 = this._annotationIntrospector.findPropertyInclusion(this._classInfo)) != null) {
            return value.withOverrides(value2);
        }
        return value;
    }

    @Override
    public AnnotatedMember findAnyGetter() throws IllegalArgumentException {
        Class<?> clazz;
        AnnotatedMember annotatedMember;
        AnnotatedMember annotatedMember2 = annotatedMember = this._propCollector == null ? null : this._propCollector.getAnyGetter();
        if (annotatedMember != null && !Map.class.isAssignableFrom(clazz = annotatedMember.getRawType())) {
            throw new IllegalArgumentException("Invalid 'any-getter' annotation on method " + annotatedMember.getName() + "(): return type is not instance of java.util.Map");
        }
        return annotatedMember;
    }

    @Override
    public AnnotatedMember findAnySetterField() throws IllegalArgumentException {
        Class<?> clazz;
        AnnotatedMember annotatedMember;
        AnnotatedMember annotatedMember2 = annotatedMember = this._propCollector == null ? null : this._propCollector.getAnySetterField();
        if (annotatedMember != null && !Map.class.isAssignableFrom(clazz = annotatedMember.getRawType())) {
            throw new IllegalArgumentException("Invalid 'any-setter' annotation on field " + annotatedMember.getName() + "(): type is not instance of java.util.Map");
        }
        return annotatedMember;
    }

    @Override
    public Map<String, AnnotatedMember> findBackReferenceProperties() {
        HashMap<String, AnnotatedMember> hashMap = null;
        for (BeanPropertyDefinition beanPropertyDefinition : this._properties()) {
            String string;
            AnnotationIntrospector.ReferenceProperty referenceProperty;
            AnnotatedMember annotatedMember = beanPropertyDefinition.getMutator();
            if (annotatedMember == null || (referenceProperty = this._annotationIntrospector.findReferenceType(annotatedMember)) == null || !referenceProperty.isBackReference()) continue;
            if (hashMap == null) {
                hashMap = new HashMap<String, AnnotatedMember>();
            }
            if (hashMap.put(string = referenceProperty.getName(), annotatedMember) == null) continue;
            throw new IllegalArgumentException("Multiple back-reference properties with name '" + string + "'");
        }
        return hashMap;
    }

    @Override
    public List<AnnotatedMethod> getFactoryMethods() {
        List<AnnotatedMethod> list = this._classInfo.getStaticMethods();
        if (list.isEmpty()) {
            return list;
        }
        ArrayList<AnnotatedMethod> arrayList = new ArrayList<AnnotatedMethod>();
        for (AnnotatedMethod annotatedMethod : list) {
            if (!this.isFactoryMethod(annotatedMethod)) continue;
            arrayList.add(annotatedMethod);
        }
        return arrayList;
    }

    @Override
    public Constructor<?> findSingleArgConstructor(Class<?> ... classArray) {
        for (AnnotatedConstructor annotatedConstructor : this._classInfo.getConstructors()) {
            if (annotatedConstructor.getParameterCount() != 1) continue;
            Class<?> clazz = annotatedConstructor.getRawParameterType(0);
            for (Class<?> clazz2 : classArray) {
                if (clazz2 != clazz) continue;
                return annotatedConstructor.getAnnotated();
            }
        }
        return null;
    }

    @Override
    public Method findFactoryMethod(Class<?> ... classArray) {
        for (AnnotatedMethod annotatedMethod : this._classInfo.getStaticMethods()) {
            if (!this.isFactoryMethod(annotatedMethod)) continue;
            Class<?> clazz = annotatedMethod.getRawParameterType(0);
            for (Class<?> clazz2 : classArray) {
                if (!clazz.isAssignableFrom(clazz2)) continue;
                return annotatedMethod.getAnnotated();
            }
        }
        return null;
    }

    protected boolean isFactoryMethod(AnnotatedMethod annotatedMethod) {
        Class<?> clazz;
        Class<?> clazz2 = annotatedMethod.getRawReturnType();
        if (!this.getBeanClass().isAssignableFrom(clazz2)) {
            return false;
        }
        if (this._annotationIntrospector.hasCreatorAnnotation(annotatedMethod)) {
            return true;
        }
        String string = annotatedMethod.getName();
        if ("valueOf".equals(string)) {
            return true;
        }
        return "fromString".equals(string) && 1 == annotatedMethod.getParameterCount() && ((clazz = annotatedMethod.getRawParameterType(0)) == String.class || CharSequence.class.isAssignableFrom(clazz));
    }

    @Deprecated
    protected PropertyName _findCreatorPropertyName(AnnotatedParameter annotatedParameter) {
        String string;
        PropertyName propertyName = this._annotationIntrospector.findNameForDeserialization(annotatedParameter);
        if ((propertyName == null || propertyName.isEmpty()) && (string = this._annotationIntrospector.findImplicitPropertyName(annotatedParameter)) != null && !string.isEmpty()) {
            propertyName = PropertyName.construct(string);
        }
        return propertyName;
    }

    @Override
    public Class<?> findPOJOBuilder() {
        return this._annotationIntrospector == null ? null : this._annotationIntrospector.findPOJOBuilder(this._classInfo);
    }

    @Override
    public JsonPOJOBuilder.Value findPOJOBuilderConfig() {
        return this._annotationIntrospector == null ? null : this._annotationIntrospector.findPOJOBuilderConfig(this._classInfo);
    }

    @Override
    public Converter<Object, Object> findDeserializationConverter() {
        if (this._annotationIntrospector == null) {
            return null;
        }
        return this._createConverter(this._annotationIntrospector.findDeserializationConverter(this._classInfo));
    }

    @Override
    public String findClassDescription() {
        return this._annotationIntrospector == null ? null : this._annotationIntrospector.findClassDescription(this._classInfo);
    }

    @Deprecated
    public LinkedHashMap<String, AnnotatedField> _findPropertyFields(Collection<String> collection, boolean bl) {
        LinkedHashMap<String, AnnotatedField> linkedHashMap = new LinkedHashMap<String, AnnotatedField>();
        for (BeanPropertyDefinition beanPropertyDefinition : this._properties()) {
            AnnotatedField annotatedField = beanPropertyDefinition.getField();
            if (annotatedField == null) continue;
            String string = beanPropertyDefinition.getName();
            if (collection != null && collection.contains(string)) continue;
            linkedHashMap.put(string, annotatedField);
        }
        return linkedHashMap;
    }

    public Converter<Object, Object> _createConverter(Object object) {
        Converter converter;
        if (object == null) {
            return null;
        }
        if (object instanceof Converter) {
            return (Converter)object;
        }
        if (!(object instanceof Class)) {
            throw new IllegalStateException("AnnotationIntrospector returned Converter definition of type " + object.getClass().getName() + "; expected type Converter or Class<Converter> instead");
        }
        Class clazz = (Class)object;
        if (clazz == Converter.None.class || ClassUtil.isBogusClass(clazz)) {
            return null;
        }
        if (!Converter.class.isAssignableFrom(clazz)) {
            throw new IllegalStateException("AnnotationIntrospector returned Class " + clazz.getName() + "; expected Class<Converter>");
        }
        HandlerInstantiator handlerInstantiator = this._config.getHandlerInstantiator();
        Converter converter2 = converter = handlerInstantiator == null ? null : handlerInstantiator.converterInstance(this._config, this._classInfo, clazz);
        if (converter == null) {
            converter = (Converter)ClassUtil.createInstance(clazz, this._config.canOverrideAccessModifiers());
        }
        return converter;
    }
}

