/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Currency;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Pattern;

public abstract class FromStringDeserializer<T>
extends StdScalarDeserializer<T> {
    public static Class<?>[] types() {
        return new Class[]{File.class, URL.class, URI.class, Class.class, JavaType.class, Currency.class, Pattern.class, Locale.class, Charset.class, TimeZone.class, InetAddress.class, InetSocketAddress.class};
    }

    protected FromStringDeserializer(Class<?> clazz) {
        super(clazz);
    }

    public static Std findDeserializer(Class<?> clazz) {
        int n = 0;
        if (clazz == File.class) {
            n = 1;
        } else if (clazz == URL.class) {
            n = 2;
        } else if (clazz == URI.class) {
            n = 3;
        } else if (clazz == Class.class) {
            n = 4;
        } else if (clazz == JavaType.class) {
            n = 5;
        } else if (clazz == Currency.class) {
            n = 6;
        } else if (clazz == Pattern.class) {
            n = 7;
        } else if (clazz == Locale.class) {
            n = 8;
        } else if (clazz == Charset.class) {
            n = 9;
        } else if (clazz == TimeZone.class) {
            n = 10;
        } else if (clazz == InetAddress.class) {
            n = 11;
        } else if (clazz == InetSocketAddress.class) {
            n = 12;
        } else {
            return null;
        }
        return new Std(clazz, n);
    }

    @Override
    public T deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        String string = jsonParser.getValueAsString();
        if (string != null) {
            Object object;
            Object object2;
            if (string.length() == 0 || (string = string.trim()).length() == 0) {
                return this._deserializeFromEmptyString();
            }
            IllegalArgumentException illegalArgumentException = null;
            try {
                object2 = this._deserialize(string, deserializationContext);
                if (object2 != null) {
                    return object2;
                }
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                illegalArgumentException = illegalArgumentException2;
            }
            object2 = "not a valid textual representation";
            if (illegalArgumentException != null && (object = illegalArgumentException.getMessage()) != null) {
                object2 = object2 + ", problem: " + (String)object;
            }
            object = deserializationContext.weirdStringException(string, this._valueClass, (String)object2);
            if (illegalArgumentException != null) {
                ((Throwable)object).initCause(illegalArgumentException);
            }
            throw object;
        }
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.START_ARRAY && deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            jsonParser.nextToken();
            T t = this.deserialize(jsonParser, deserializationContext);
            if (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                this.handleMissingEndArrayForSingle(jsonParser, deserializationContext);
            }
            return t;
        }
        if (jsonToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
            Object object = jsonParser.getEmbeddedObject();
            if (object == null) {
                return null;
            }
            if (this._valueClass.isAssignableFrom(object.getClass())) {
                return (T)object;
            }
            return this._deserializeEmbedded(object, deserializationContext);
        }
        return (T)deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser);
    }

    protected abstract T _deserialize(String var1, DeserializationContext var2) throws IOException;

    protected T _deserializeEmbedded(Object object, DeserializationContext deserializationContext) throws IOException {
        deserializationContext.reportMappingException("Don't know how to convert embedded Object of type %s into %s", object.getClass().getName(), this._valueClass.getName());
        return null;
    }

    protected T _deserializeFromEmptyString() throws IOException {
        return null;
    }

    public static class Std
    extends FromStringDeserializer<Object> {
        private static final long serialVersionUID = 1L;
        public static final int STD_FILE = 1;
        public static final int STD_URL = 2;
        public static final int STD_URI = 3;
        public static final int STD_CLASS = 4;
        public static final int STD_JAVA_TYPE = 5;
        public static final int STD_CURRENCY = 6;
        public static final int STD_PATTERN = 7;
        public static final int STD_LOCALE = 8;
        public static final int STD_CHARSET = 9;
        public static final int STD_TIME_ZONE = 10;
        public static final int STD_INET_ADDRESS = 11;
        public static final int STD_INET_SOCKET_ADDRESS = 12;
        protected final int _kind;

        protected Std(Class<?> clazz, int n) {
            super(clazz);
            this._kind = n;
        }

        @Override
        protected Object _deserialize(String string, DeserializationContext deserializationContext) throws IOException {
            switch (this._kind) {
                case 1: {
                    return new File(string);
                }
                case 2: {
                    return new URL(string);
                }
                case 3: {
                    return URI.create(string);
                }
                case 4: {
                    try {
                        return deserializationContext.findClass(string);
                    }
                    catch (Exception exception) {
                        return deserializationContext.handleInstantiationProblem(this._valueClass, string, ClassUtil.getRootCause(exception));
                    }
                }
                case 5: {
                    return deserializationContext.getTypeFactory().constructFromCanonical(string);
                }
                case 6: {
                    return Currency.getInstance(string);
                }
                case 7: {
                    return Pattern.compile(string);
                }
                case 8: {
                    int n = string.indexOf(95);
                    if (n < 0) {
                        return new Locale(string);
                    }
                    String string2 = string.substring(0, n);
                    if ((n = (string = string.substring(n + 1)).indexOf(95)) < 0) {
                        return new Locale(string2, string);
                    }
                    String string3 = string.substring(0, n);
                    return new Locale(string2, string3, string.substring(n + 1));
                }
                case 9: {
                    return Charset.forName(string);
                }
                case 10: {
                    return TimeZone.getTimeZone(string);
                }
                case 11: {
                    return InetAddress.getByName(string);
                }
                case 12: {
                    if (string.startsWith("[")) {
                        int n = string.lastIndexOf(93);
                        if (n == -1) {
                            throw new InvalidFormatException(deserializationContext.getParser(), "Bracketed IPv6 address must contain closing bracket", (Object)string, InetSocketAddress.class);
                        }
                        int n2 = string.indexOf(58, n);
                        int n3 = n2 > -1 ? Integer.parseInt(string.substring(n2 + 1)) : 0;
                        return new InetSocketAddress(string.substring(0, n + 1), n3);
                    }
                    int n = string.indexOf(58);
                    if (n >= 0 && string.indexOf(58, n + 1) < 0) {
                        int n4 = Integer.parseInt(string.substring(n + 1));
                        return new InetSocketAddress(string.substring(0, n), n4);
                    }
                    return new InetSocketAddress(string, 0);
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        protected Object _deserializeFromEmptyString() throws IOException {
            if (this._kind == 3) {
                return URI.create("");
            }
            if (this._kind == 8) {
                return Locale.ROOT;
            }
            return super._deserializeFromEmptyString();
        }
    }
}

