/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.UnresolvedForwardReference;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.impl.ReadableObjectId;
import com.fasterxml.jackson.databind.deser.std.ContainerDeserializerBase;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

@JacksonStdImpl
public class CollectionDeserializer
extends ContainerDeserializerBase<Collection<Object>>
implements ContextualDeserializer {
    private static final long serialVersionUID = -1L;
    protected final JavaType _collectionType;
    protected final JsonDeserializer<Object> _valueDeserializer;
    protected final TypeDeserializer _valueTypeDeserializer;
    protected final ValueInstantiator _valueInstantiator;
    protected final JsonDeserializer<Object> _delegateDeserializer;
    protected final Boolean _unwrapSingle;

    public CollectionDeserializer(JavaType javaType, JsonDeserializer<Object> jsonDeserializer, TypeDeserializer typeDeserializer, ValueInstantiator valueInstantiator) {
        this(javaType, jsonDeserializer, typeDeserializer, valueInstantiator, null, null);
    }

    protected CollectionDeserializer(JavaType javaType, JsonDeserializer<Object> jsonDeserializer, TypeDeserializer typeDeserializer, ValueInstantiator valueInstantiator, JsonDeserializer<Object> jsonDeserializer2, Boolean bl) {
        super(javaType);
        this._collectionType = javaType;
        this._valueDeserializer = jsonDeserializer;
        this._valueTypeDeserializer = typeDeserializer;
        this._valueInstantiator = valueInstantiator;
        this._delegateDeserializer = jsonDeserializer2;
        this._unwrapSingle = bl;
    }

    protected CollectionDeserializer(CollectionDeserializer collectionDeserializer) {
        super(collectionDeserializer._collectionType);
        this._collectionType = collectionDeserializer._collectionType;
        this._valueDeserializer = collectionDeserializer._valueDeserializer;
        this._valueTypeDeserializer = collectionDeserializer._valueTypeDeserializer;
        this._valueInstantiator = collectionDeserializer._valueInstantiator;
        this._delegateDeserializer = collectionDeserializer._delegateDeserializer;
        this._unwrapSingle = collectionDeserializer._unwrapSingle;
    }

    protected CollectionDeserializer withResolved(JsonDeserializer<?> jsonDeserializer, JsonDeserializer<?> jsonDeserializer2, TypeDeserializer typeDeserializer, Boolean bl) {
        if (jsonDeserializer == this._delegateDeserializer && jsonDeserializer2 == this._valueDeserializer && typeDeserializer == this._valueTypeDeserializer && this._unwrapSingle == bl) {
            return this;
        }
        return new CollectionDeserializer(this._collectionType, jsonDeserializer2, typeDeserializer, this._valueInstantiator, jsonDeserializer, bl);
    }

    @Deprecated
    protected CollectionDeserializer withResolved(JsonDeserializer<?> jsonDeserializer, JsonDeserializer<?> jsonDeserializer2, TypeDeserializer typeDeserializer) {
        return this.withResolved(jsonDeserializer, jsonDeserializer2, typeDeserializer, this._unwrapSingle);
    }

    @Override
    public boolean isCachable() {
        return this._valueDeserializer == null && this._valueTypeDeserializer == null && this._delegateDeserializer == null;
    }

    public CollectionDeserializer createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
        Serializable serializable;
        JsonDeserializer<Object> jsonDeserializer = null;
        if (this._valueInstantiator != null && this._valueInstantiator.canCreateUsingDelegate()) {
            serializable = this._valueInstantiator.getDelegateType(deserializationContext.getConfig());
            if (serializable == null) {
                throw new IllegalArgumentException("Invalid delegate-creator definition for " + this._collectionType + ": value instantiator (" + this._valueInstantiator.getClass().getName() + ") returned true for 'canCreateUsingDelegate()', but null for 'getDelegateType()'");
            }
            jsonDeserializer = this.findDeserializer(deserializationContext, (JavaType)serializable, beanProperty);
        }
        serializable = this.findFormatFeature(deserializationContext, beanProperty, Collection.class, JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        JsonDeserializer<Object> jsonDeserializer2 = this._valueDeserializer;
        jsonDeserializer2 = this.findConvertingContentDeserializer(deserializationContext, beanProperty, jsonDeserializer2);
        JavaType javaType = this._collectionType.getContentType();
        jsonDeserializer2 = jsonDeserializer2 == null ? deserializationContext.findContextualValueDeserializer(javaType, beanProperty) : deserializationContext.handleSecondaryContextualization(jsonDeserializer2, beanProperty, javaType);
        TypeDeserializer typeDeserializer = this._valueTypeDeserializer;
        if (typeDeserializer != null) {
            typeDeserializer = typeDeserializer.forProperty(beanProperty);
        }
        return this.withResolved(jsonDeserializer, jsonDeserializer2, typeDeserializer, (Boolean)serializable);
    }

    @Override
    public JavaType getContentType() {
        return this._collectionType.getContentType();
    }

    @Override
    public JsonDeserializer<Object> getContentDeserializer() {
        return this._valueDeserializer;
    }

    @Override
    public Collection<Object> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        String string;
        if (this._delegateDeserializer != null) {
            return (Collection)this._valueInstantiator.createUsingDelegate(deserializationContext, this._delegateDeserializer.deserialize(jsonParser, deserializationContext));
        }
        if (jsonParser.hasToken(JsonToken.VALUE_STRING) && (string = jsonParser.getText()).length() == 0) {
            return (Collection)this._valueInstantiator.createFromString(deserializationContext, string);
        }
        return this.deserialize(jsonParser, deserializationContext, (Collection)this._valueInstantiator.createUsingDefault(deserializationContext));
    }

    @Override
    public Collection<Object> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Collection<Object> collection) throws IOException {
        JsonToken jsonToken;
        CollectionReferringAccumulator collectionReferringAccumulator;
        if (!jsonParser.isExpectedStartArrayToken()) {
            return this.handleNonArray(jsonParser, deserializationContext, collection);
        }
        jsonParser.setCurrentValue(collection);
        JsonDeserializer<Object> jsonDeserializer = this._valueDeserializer;
        TypeDeserializer typeDeserializer = this._valueTypeDeserializer;
        CollectionReferringAccumulator collectionReferringAccumulator2 = collectionReferringAccumulator = jsonDeserializer.getObjectIdReader() == null ? null : new CollectionReferringAccumulator(this._collectionType.getContentType().getRawClass(), collection);
        while ((jsonToken = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
            try {
                Object object = jsonToken == JsonToken.VALUE_NULL ? jsonDeserializer.getNullValue(deserializationContext) : (typeDeserializer == null ? jsonDeserializer.deserialize(jsonParser, deserializationContext) : jsonDeserializer.deserializeWithType(jsonParser, deserializationContext, typeDeserializer));
                if (collectionReferringAccumulator != null) {
                    collectionReferringAccumulator.add(object);
                    continue;
                }
                collection.add(object);
            }
            catch (UnresolvedForwardReference unresolvedForwardReference) {
                if (collectionReferringAccumulator == null) {
                    throw JsonMappingException.from(jsonParser, "Unresolved forward reference but no identity info", (Throwable)unresolvedForwardReference);
                }
                ReadableObjectId.Referring referring = collectionReferringAccumulator.handleUnresolvedReference(unresolvedForwardReference);
                unresolvedForwardReference.getRoid().appendReferring(referring);
            }
            catch (Exception exception) {
                boolean bl;
                boolean bl2 = bl = deserializationContext == null || deserializationContext.isEnabled(DeserializationFeature.WRAP_EXCEPTIONS);
                if (!bl && exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw JsonMappingException.wrapWithPath((Throwable)exception, collection, collection.size());
            }
        }
        return collection;
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromArray(jsonParser, deserializationContext);
    }

    protected final Collection<Object> handleNonArray(JsonParser jsonParser, DeserializationContext deserializationContext, Collection<Object> collection) throws IOException {
        Object object;
        boolean bl;
        boolean bl2 = bl = this._unwrapSingle == Boolean.TRUE || this._unwrapSingle == null && deserializationContext.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        if (!bl) {
            return (Collection)deserializationContext.handleUnexpectedToken(this._collectionType.getRawClass(), jsonParser);
        }
        JsonDeserializer<Object> jsonDeserializer = this._valueDeserializer;
        TypeDeserializer typeDeserializer = this._valueTypeDeserializer;
        JsonToken jsonToken = jsonParser.getCurrentToken();
        try {
            object = jsonToken == JsonToken.VALUE_NULL ? jsonDeserializer.getNullValue(deserializationContext) : (typeDeserializer == null ? jsonDeserializer.deserialize(jsonParser, deserializationContext) : jsonDeserializer.deserializeWithType(jsonParser, deserializationContext, typeDeserializer));
        }
        catch (Exception exception) {
            throw JsonMappingException.wrapWithPath((Throwable)exception, Object.class, collection.size());
        }
        collection.add(object);
        return collection;
    }

    private static final class CollectionReferring
    extends ReadableObjectId.Referring {
        private final CollectionReferringAccumulator _parent;
        public final List<Object> next = new ArrayList<Object>();

        CollectionReferring(CollectionReferringAccumulator collectionReferringAccumulator, UnresolvedForwardReference unresolvedForwardReference, Class<?> clazz) {
            super(unresolvedForwardReference, clazz);
            this._parent = collectionReferringAccumulator;
        }

        @Override
        public void handleResolvedForwardReference(Object object, Object object2) throws IOException {
            this._parent.resolveForwardReference(object, object2);
        }
    }

    public static final class CollectionReferringAccumulator {
        private final Class<?> _elementType;
        private final Collection<Object> _result;
        private List<CollectionReferring> _accumulator = new ArrayList<CollectionReferring>();

        public CollectionReferringAccumulator(Class<?> clazz, Collection<Object> collection) {
            this._elementType = clazz;
            this._result = collection;
        }

        public void add(Object object) {
            if (this._accumulator.isEmpty()) {
                this._result.add(object);
            } else {
                CollectionReferring collectionReferring = this._accumulator.get(this._accumulator.size() - 1);
                collectionReferring.next.add(object);
            }
        }

        public ReadableObjectId.Referring handleUnresolvedReference(UnresolvedForwardReference unresolvedForwardReference) {
            CollectionReferring collectionReferring = new CollectionReferring(this, unresolvedForwardReference, this._elementType);
            this._accumulator.add(collectionReferring);
            return collectionReferring;
        }

        public void resolveForwardReference(Object object, Object object2) throws IOException {
            Iterator<CollectionReferring> iterator = this._accumulator.iterator();
            Collection<Object> collection = this._result;
            while (iterator.hasNext()) {
                CollectionReferring collectionReferring = iterator.next();
                if (collectionReferring.hasId(object)) {
                    iterator.remove();
                    collection.add(object2);
                    collection.addAll(collectionReferring.next);
                    return;
                }
                collection = collectionReferring.next;
            }
            throw new IllegalArgumentException("Trying to resolve a forward reference with id [" + object + "] that wasn't previously seen as unresolved.");
        }
    }
}

