/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.BinaryPropertyListWriter;
import com.dd.plist.NSArray;
import com.dd.plist.NSData;
import com.dd.plist.NSDate;
import com.dd.plist.NSNumber;
import com.dd.plist.NSObject;
import com.dd.plist.NSString;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class NSDictionary
extends NSObject
implements Map<String, NSObject> {
    private final HashMap<String, NSObject> dict = new LinkedHashMap<String, NSObject>();

    public HashMap<String, NSObject> getHashMap() {
        return this.dict;
    }

    public NSObject objectForKey(String string) {
        return this.dict.get(string);
    }

    @Override
    public int size() {
        return this.dict.size();
    }

    @Override
    public boolean isEmpty() {
        return this.dict.isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.dict.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        if (object == null) {
            return false;
        }
        NSObject nSObject = NSObject.fromJavaObject(object);
        return this.dict.containsValue(nSObject);
    }

    @Override
    public NSObject get(Object object) {
        return this.dict.get(object);
    }

    @Override
    public void putAll(Map<? extends String, ? extends NSObject> map) {
        Iterator<Map.Entry<? extends String, ? extends NSObject>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<? extends String, ? extends NSObject> entry;
            Map.Entry<? extends String, ? extends NSObject> entry2 = entry = iterator.next();
            this.put(entry2.getKey(), entry2.getValue());
        }
    }

    @Override
    public NSObject put(String string, NSObject nSObject) {
        if (string == null) {
            return null;
        }
        if (nSObject == null) {
            return this.dict.get(string);
        }
        return this.dict.put(string, nSObject);
    }

    @Override
    public NSObject put(String string, Object object) {
        return this.put(string, NSObject.fromJavaObject(object));
    }

    public NSObject remove(String string) {
        return this.dict.remove(string);
    }

    @Override
    public NSObject remove(Object object) {
        return this.dict.remove(object);
    }

    @Override
    public void clear() {
        this.dict.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.dict.keySet();
    }

    @Override
    public Collection<NSObject> values() {
        return this.dict.values();
    }

    @Override
    public Set<Map.Entry<String, NSObject>> entrySet() {
        return this.dict.entrySet();
    }

    public boolean containsKey(String string) {
        return this.dict.containsKey(string);
    }

    public boolean containsValue(NSObject nSObject) {
        return nSObject != null && this.dict.containsValue(nSObject);
    }

    public boolean containsValue(String string) {
        for (NSObject nSObject : this.dict.values()) {
            NSString nSString;
            if (!nSObject.getClass().equals(NSString.class) || !(nSString = (NSString)nSObject).getContent().equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean containsValue(long l) {
        for (NSObject nSObject : this.dict.values()) {
            NSNumber nSNumber;
            if (!nSObject.getClass().equals(NSNumber.class) || !(nSNumber = (NSNumber)nSObject).isInteger() || (long)nSNumber.intValue() != l) continue;
            return true;
        }
        return false;
    }

    public boolean containsValue(double d) {
        for (NSObject nSObject : this.dict.values()) {
            NSNumber nSNumber;
            if (!nSObject.getClass().equals(NSNumber.class) || !(nSNumber = (NSNumber)nSObject).isReal() || nSNumber.doubleValue() != d) continue;
            return true;
        }
        return false;
    }

    public boolean containsValue(boolean bl) {
        for (NSObject nSObject : this.dict.values()) {
            NSNumber nSNumber;
            if (!nSObject.getClass().equals(NSNumber.class) || !(nSNumber = (NSNumber)nSObject).isBoolean() || nSNumber.boolValue() != bl) continue;
            return true;
        }
        return false;
    }

    public boolean containsValue(Date date) {
        for (NSObject nSObject : this.dict.values()) {
            NSDate nSDate;
            if (!nSObject.getClass().equals(NSDate.class) || !(nSDate = (NSDate)nSObject).getDate().equals(date)) continue;
            return true;
        }
        return false;
    }

    public boolean containsValue(byte[] byArray) {
        for (NSObject nSObject : this.dict.values()) {
            NSData nSData;
            if (!nSObject.getClass().equals(NSData.class) || !Arrays.equals((nSData = (NSData)nSObject).bytes(), byArray)) continue;
            return true;
        }
        return false;
    }

    public int count() {
        return this.dict.size();
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        return object.getClass().equals(this.getClass()) && ((NSDictionary)object).dict.equals(this.dict);
    }

    public String[] allKeys() {
        return this.dict.keySet().toArray(new String[this.count()]);
    }

    @Override
    public int hashCode() {
        int n = 7;
        n = 83 * n + this.dict.hashCode();
        return n;
    }

    @Override
    public NSDictionary clone() {
        NSDictionary nSDictionary = new NSDictionary();
        for (Map.Entry<String, NSObject> entry : this.dict.entrySet()) {
            nSDictionary.dict.put(entry.getKey(), entry.getValue() != null ? entry.getValue().clone() : null);
        }
        return nSDictionary;
    }

    @Override
    public Object toJavaObject() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(this.dict.size());
        for (String string : this.dict.keySet()) {
            hashMap.put(string, this.dict.get(string).toJavaObject());
        }
        return hashMap;
    }

    @Override
    public int compareTo(NSObject nSObject) {
        Objects.requireNonNull(nSObject);
        if (nSObject == this) {
            return 0;
        }
        if (nSObject instanceof NSDictionary) {
            long l;
            NSDictionary nSDictionary = (NSDictionary)nSObject;
            long l2 = this.dict.keySet().stream().filter(string -> !nSDictionary.dict.containsKey(string)).count();
            int n = Long.compare(l2, l = nSDictionary.dict.keySet().stream().filter(string -> !this.dict.containsKey(string)).count());
            if (n != 0) {
                return n;
            }
            for (String string2 : this.dict.keySet().stream().sorted(String::compareTo).collect(Collectors.toCollection(LinkedList::new))) {
                int n2 = this.objectForKey(string2).compareTo(nSDictionary.objectForKey(string2));
                if (n2 == 0) continue;
                return n2;
            }
            return 0;
        }
        return this.getClass().getName().compareTo(nSObject.getClass().getName());
    }

    @Override
    void toXML(StringBuilder stringBuilder, int n) {
        this.indent(stringBuilder, n);
        stringBuilder.append("<dict>");
        stringBuilder.append(NSObject.NEWLINE);
        for (String string : this.dict.keySet()) {
            NSObject nSObject = this.objectForKey(string);
            this.indent(stringBuilder, n + 1);
            stringBuilder.append("<key>");
            if (string.contains("&") || string.contains("<") || string.contains(">")) {
                stringBuilder.append("<![CDATA[");
                stringBuilder.append(string.replaceAll("]]>", "]]]]><![CDATA[>"));
                stringBuilder.append("]]>");
            } else {
                stringBuilder.append(string);
            }
            stringBuilder.append("</key>");
            stringBuilder.append(NSObject.NEWLINE);
            nSObject.toXML(stringBuilder, n + 1);
            stringBuilder.append(NSObject.NEWLINE);
        }
        this.indent(stringBuilder, n);
        stringBuilder.append("</dict>");
    }

    @Override
    void assignIDs(BinaryPropertyListWriter binaryPropertyListWriter) {
        super.assignIDs(binaryPropertyListWriter);
        for (Map.Entry<String, NSObject> entry : this.dict.entrySet()) {
            new NSString(entry.getKey()).assignIDs(binaryPropertyListWriter);
        }
        for (Map.Entry<String, NSObject> entry : this.dict.entrySet()) {
            entry.getValue().assignIDs(binaryPropertyListWriter);
        }
    }

    @Override
    void toBinary(BinaryPropertyListWriter binaryPropertyListWriter) throws IOException {
        binaryPropertyListWriter.writeIntHeader(13, this.dict.size());
        Set<Map.Entry<String, NSObject>> set = this.dict.entrySet();
        for (Map.Entry<String, NSObject> entry : set) {
            binaryPropertyListWriter.writeID(binaryPropertyListWriter.getID(new NSString(entry.getKey())));
        }
        for (Map.Entry<String, NSObject> entry : set) {
            binaryPropertyListWriter.writeID(binaryPropertyListWriter.getID(entry.getValue()));
        }
    }

    public String toASCIIPropertyList() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toASCII(stringBuilder, 0);
        stringBuilder.append(NEWLINE);
        return stringBuilder.toString();
    }

    public String toGnuStepASCIIPropertyList() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toASCIIGnuStep(stringBuilder, 0);
        stringBuilder.append(NEWLINE);
        return stringBuilder.toString();
    }

    @Override
    protected void toASCII(StringBuilder stringBuilder, int n) {
        String[] stringArray;
        this.indent(stringBuilder, n);
        stringBuilder.append('{');
        stringBuilder.append(NEWLINE);
        for (String string : stringArray = this.allKeys()) {
            NSObject nSObject = this.objectForKey(string);
            this.indent(stringBuilder, n + 1);
            stringBuilder.append('\"');
            stringBuilder.append(NSString.escapeStringForASCII(string));
            stringBuilder.append("\" =");
            Class<?> clazz = nSObject.getClass();
            if (clazz.equals(NSDictionary.class) || clazz.equals(NSArray.class) || clazz.equals(NSData.class)) {
                stringBuilder.append(NEWLINE);
                nSObject.toASCII(stringBuilder, n + 2);
            } else {
                stringBuilder.append(' ');
                nSObject.toASCII(stringBuilder, 0);
            }
            stringBuilder.append(';');
            stringBuilder.append(NEWLINE);
        }
        this.indent(stringBuilder, n);
        stringBuilder.append('}');
    }

    @Override
    protected void toASCIIGnuStep(StringBuilder stringBuilder, int n) {
        String[] stringArray;
        this.indent(stringBuilder, n);
        stringBuilder.append('{');
        stringBuilder.append(NEWLINE);
        for (String string : stringArray = this.dict.keySet().toArray(new String[0])) {
            NSObject nSObject = this.objectForKey(string);
            this.indent(stringBuilder, n + 1);
            stringBuilder.append('\"');
            stringBuilder.append(NSString.escapeStringForASCII(string));
            stringBuilder.append("\" =");
            Class<?> clazz = nSObject.getClass();
            if (clazz.equals(NSDictionary.class) || clazz.equals(NSArray.class) || clazz.equals(NSData.class)) {
                stringBuilder.append(NEWLINE);
                nSObject.toASCIIGnuStep(stringBuilder, n + 2);
            } else {
                stringBuilder.append(' ');
                nSObject.toASCIIGnuStep(stringBuilder, 0);
            }
            stringBuilder.append(';');
            stringBuilder.append(NEWLINE);
        }
        this.indent(stringBuilder, n);
        stringBuilder.append('}');
    }
}

