/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

class ByteOrderMarkReader {
    private static final int[][] BOMs = new int[][]{{239, 187, 191}, {254, 255}, {255, 254}, {0, 0, 254, 255}, {255, 254, 0, 0}};
    private static final String[] Charsets = new String[]{"UTF-8", "UTF-16BE", "UTF-16LE", "UTF-32BE", "UTF-32LE"};
    private final boolean[] charsetPossible = new boolean[]{true, true, true, true, true};
    private int offset;
    private String charset;

    ByteOrderMarkReader() {
    }

    public String getDetectedCharset() {
        return this.charset;
    }

    public boolean readByte(int n) {
        boolean bl = false;
        for (int i = 0; i < Charsets.length; ++i) {
            boolean bl2;
            if (!this.charsetPossible[i]) continue;
            int[] nArray = BOMs[i];
            boolean bl3 = bl2 = this.offset < nArray.length && nArray[this.offset] == n;
            if (bl2) {
                bl = true;
                if (this.offset + 1 != nArray.length) continue;
                this.charset = Charsets[i];
                continue;
            }
            this.charsetPossible[i] = false;
        }
        ++this.offset;
        return bl;
    }

    public static String detect(byte[] byArray) {
        if (byArray.length > 2) {
            if (byArray[0] == -2 && byArray[1] == -1) {
                return "UTF-16";
            }
            if (byArray[0] == -1 && byArray[1] == -2) {
                if (byArray.length > 4 && byArray[2] == 0 && byArray[3] == 0) {
                    return "UTF-32";
                }
                return "UTF-16";
            }
            if (byArray.length > 3) {
                if (byArray[0] == -17 && byArray[1] == -69 && byArray[2] == -65) {
                    return "UTF-8";
                }
                if (byArray.length > 4 && byArray[0] == 0 && byArray[1] == 0 && byArray[2] == -2 && byArray[3] == -1) {
                    return "UTF-32";
                }
            }
        }
        return null;
    }
}

