/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.quartz.wrappers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.quartz.JobKey;
import org.quartz.TriggerKey;
import org.terracotta.quartz.collections.ToolkitDSHolder;
import org.terracotta.quartz.wrappers.FiredTrigger;
import org.terracotta.quartz.wrappers.TriggerWrapper;
import org.terracotta.toolkit.store.ToolkitStore;

public class TriggerFacade {
    private final ToolkitStore<TriggerKey, TriggerWrapper> triggersByFQN;
    private final Set<String> allTriggersGroupNames;
    private final Set<String> pausedTriggerGroupNames;
    private final ToolkitStore<String, FiredTrigger> firedTriggers;

    public TriggerFacade(ToolkitDSHolder toolkitDSHolder) {
        this.triggersByFQN = toolkitDSHolder.getOrCreateTriggersMap();
        this.allTriggersGroupNames = toolkitDSHolder.getOrCreateAllTriggersGroupsSet();
        this.pausedTriggerGroupNames = toolkitDSHolder.getOrCreatePausedTriggerGroupsSet();
        this.firedTriggers = toolkitDSHolder.getOrCreateFiredTriggersMap();
    }

    public TriggerWrapper get(TriggerKey triggerKey) {
        return (TriggerWrapper)this.triggersByFQN.get((Object)triggerKey);
    }

    public boolean containsKey(TriggerKey triggerKey) {
        return this.triggersByFQN.containsKey((Object)triggerKey);
    }

    public void put(TriggerKey triggerKey, TriggerWrapper triggerWrapper) {
        this.triggersByFQN.putNoReturn((Object)triggerKey, (Object)triggerWrapper);
    }

    public TriggerWrapper remove(TriggerKey triggerKey) {
        return (TriggerWrapper)this.triggersByFQN.remove((Object)triggerKey);
    }

    public FiredTrigger getFiredTrigger(String string) {
        return (FiredTrigger)this.firedTriggers.get((Object)string);
    }

    public boolean containsFiredTrigger(String string) {
        return this.firedTriggers.containsKey((Object)string);
    }

    public void putFiredTrigger(String string, FiredTrigger firedTrigger) {
        this.firedTriggers.putNoReturn((Object)string, (Object)firedTrigger);
    }

    public FiredTrigger removeFiredTrigger(String string) {
        return (FiredTrigger)this.firedTriggers.remove((Object)string);
    }

    public boolean addGroup(String string) {
        return this.allTriggersGroupNames.add(string);
    }

    public boolean hasGroup(String string) {
        return this.allTriggersGroupNames.contains(string);
    }

    public boolean removeGroup(String string) {
        return this.allTriggersGroupNames.remove(string);
    }

    public boolean addPausedGroup(String string) {
        return this.pausedTriggerGroupNames.add(string);
    }

    public boolean pausedGroupsContain(String string) {
        return this.pausedTriggerGroupNames.contains(string);
    }

    public boolean removePausedGroup(String string) {
        return this.pausedTriggerGroupNames.remove(string);
    }

    public Set<String> allTriggersGroupNames() {
        return this.allTriggersGroupNames;
    }

    public Set<String> allPausedTriggersGroupNames() {
        return this.pausedTriggerGroupNames;
    }

    public Set<TriggerKey> allTriggerKeys() {
        return this.triggersByFQN.keySet();
    }

    public Collection<FiredTrigger> allFiredTriggers() {
        return this.firedTriggers.values();
    }

    public int numberOfTriggers() {
        return this.triggersByFQN.size();
    }

    public List<TriggerWrapper> getTriggerWrappersForJob(JobKey jobKey) {
        ArrayList<TriggerWrapper> arrayList = new ArrayList<TriggerWrapper>();
        for (TriggerKey triggerKey : this.triggersByFQN.keySet()) {
            TriggerWrapper triggerWrapper = (TriggerWrapper)this.triggersByFQN.get((Object)triggerKey);
            if (!triggerWrapper.getJobKey().equals(jobKey)) continue;
            arrayList.add(triggerWrapper);
        }
        return arrayList;
    }

    public List<TriggerWrapper> getTriggerWrappersForCalendar(String string) {
        ArrayList<TriggerWrapper> arrayList = new ArrayList<TriggerWrapper>();
        for (TriggerKey triggerKey : this.triggersByFQN.keySet()) {
            TriggerWrapper triggerWrapper = (TriggerWrapper)this.triggersByFQN.get((Object)triggerKey);
            String string2 = triggerWrapper.getCalendarName();
            if (string2 == null || !string2.equals(string)) continue;
            arrayList.add(triggerWrapper);
        }
        return arrayList;
    }

    public void removeAllPausedGroups(Collection<String> collection) {
        this.pausedTriggerGroupNames.removeAll(collection);
    }
}

