/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.quartz.collections;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.quartz.Calendar;
import org.quartz.JobKey;
import org.quartz.TriggerKey;
import org.terracotta.quartz.collections.SerializedToolkitStore;
import org.terracotta.quartz.collections.TimeTrigger;
import org.terracotta.quartz.collections.TimeTriggerSet;
import org.terracotta.quartz.wrappers.FiredTrigger;
import org.terracotta.quartz.wrappers.JobWrapper;
import org.terracotta.quartz.wrappers.TriggerWrapper;
import org.terracotta.toolkit.Toolkit;
import org.terracotta.toolkit.builder.ToolkitStoreConfigBuilder;
import org.terracotta.toolkit.collections.ToolkitSet;
import org.terracotta.toolkit.collections.ToolkitSortedSet;
import org.terracotta.toolkit.concurrent.locks.ToolkitLock;
import org.terracotta.toolkit.internal.ToolkitInternal;
import org.terracotta.toolkit.internal.concurrent.locks.ToolkitLockTypeInternal;
import org.terracotta.toolkit.store.ToolkitConfigFields;
import org.terracotta.toolkit.store.ToolkitStore;

public class ToolkitDSHolder {
    private static final String JOBS_MAP_PREFIX = "_tc_quartz_jobs";
    private static final String ALL_JOBS_GROUP_NAMES_SET_PREFIX = "_tc_quartz_grp_names";
    private static final String PAUSED_GROUPS_SET_PREFIX = "_tc_quartz_grp_paused_names";
    private static final String BLOCKED_JOBS_SET_PREFIX = "_tc_quartz_blocked_jobs";
    private static final String JOBS_GROUP_MAP_PREFIX = "_tc_quartz_grp_jobs_";
    private static final String TRIGGERS_MAP_PREFIX = "_tc_quartz_triggers";
    private static final String TRIGGERS_GROUP_MAP_PREFIX = "_tc_quartz_grp_triggers_";
    private static final String ALL_TRIGGERS_GROUP_NAMES_SET_PREFIX = "_tc_quartz_grp_names_triggers";
    private static final String PAUSED_TRIGGER_GROUPS_SET_PREFIX = "_tc_quartz_grp_paused_trogger_names";
    private static final String TIME_TRIGGER_SORTED_SET_PREFIX = "_tc_time_trigger_sorted_set";
    private static final String FIRED_TRIGGER_MAP_PREFIX = "_tc_quartz_fired_trigger";
    private static final String CALENDAR_WRAPPER_MAP_PREFIX = "_tc_quartz_calendar_wrapper";
    private static final String SINGLE_LOCK_NAME_PREFIX = "_tc_quartz_single_lock";
    private static final String DELIMETER = "|";
    private final String jobStoreName;
    protected final Toolkit toolkit;
    private final AtomicReference<SerializedToolkitStore<JobKey, JobWrapper>> jobsMapReference = new AtomicReference();
    private final AtomicReference<SerializedToolkitStore<TriggerKey, TriggerWrapper>> triggersMapReference = new AtomicReference();
    private final AtomicReference<ToolkitSet<String>> allGroupsReference = new AtomicReference();
    private final AtomicReference<ToolkitSet<String>> allTriggersGroupsReference = new AtomicReference();
    private final AtomicReference<ToolkitSet<String>> pausedGroupsReference = new AtomicReference();
    private final AtomicReference<ToolkitSet<JobKey>> blockedJobsReference = new AtomicReference();
    private final Map<String, ToolkitSet<String>> jobsGroupSet = new HashMap<String, ToolkitSet<String>>();
    private final Map<String, ToolkitSet<String>> triggersGroupSet = new HashMap<String, ToolkitSet<String>>();
    private final AtomicReference<ToolkitSet<String>> pausedTriggerGroupsReference = new AtomicReference();
    private final AtomicReference<ToolkitStore<String, FiredTrigger>> firedTriggersMapReference = new AtomicReference();
    private final AtomicReference<ToolkitStore<String, Calendar>> calendarWrapperMapReference = new AtomicReference();
    private final AtomicReference<TimeTriggerSet> timeTriggerSetReference = new AtomicReference();
    private final Map<String, ToolkitStore<?, ?>> toolkitMaps = new HashMap();

    public ToolkitDSHolder(String string, Toolkit toolkit) {
        this.jobStoreName = string;
        this.toolkit = toolkit;
    }

    protected final String generateName(String string) {
        return string + DELIMETER + this.jobStoreName;
    }

    public SerializedToolkitStore<JobKey, JobWrapper> getOrCreateJobsMap() {
        String string = this.generateName(JOBS_MAP_PREFIX);
        SerializedToolkitStore serializedToolkitStore = new SerializedToolkitStore(this.createStore(string));
        this.jobsMapReference.compareAndSet(null, serializedToolkitStore);
        return this.jobsMapReference.get();
    }

    protected ToolkitStore<?, ?> toolkitMap(String string) {
        ToolkitStore toolkitStore = this.toolkitMaps.get(string);
        if (toolkitStore != null && !toolkitStore.isDestroyed()) {
            return toolkitStore;
        }
        toolkitStore = this.createStore(string);
        this.toolkitMaps.put(string, toolkitStore);
        return toolkitStore;
    }

    private ToolkitStore createStore(String string) {
        ToolkitStoreConfigBuilder toolkitStoreConfigBuilder = new ToolkitStoreConfigBuilder();
        return this.toolkit.getStore(string, toolkitStoreConfigBuilder.consistency(ToolkitConfigFields.Consistency.STRONG).concurrency(1).build(), null);
    }

    public SerializedToolkitStore<TriggerKey, TriggerWrapper> getOrCreateTriggersMap() {
        String string = this.generateName(TRIGGERS_MAP_PREFIX);
        SerializedToolkitStore serializedToolkitStore = new SerializedToolkitStore(this.createStore(string));
        this.triggersMapReference.compareAndSet(null, serializedToolkitStore);
        return this.triggersMapReference.get();
    }

    public ToolkitStore<String, FiredTrigger> getOrCreateFiredTriggersMap() {
        String string = this.generateName(FIRED_TRIGGER_MAP_PREFIX);
        ToolkitStore toolkitStore = this.createStore(string);
        this.firedTriggersMapReference.compareAndSet(null, (ToolkitStore<String, FiredTrigger>)toolkitStore);
        return this.firedTriggersMapReference.get();
    }

    public ToolkitStore<String, Calendar> getOrCreateCalendarWrapperMap() {
        String string = this.generateName(CALENDAR_WRAPPER_MAP_PREFIX);
        ToolkitStore toolkitStore = this.createStore(string);
        this.calendarWrapperMapReference.compareAndSet(null, (ToolkitStore<String, Calendar>)toolkitStore);
        return this.calendarWrapperMapReference.get();
    }

    public Set<String> getOrCreateAllGroupsSet() {
        String string = this.generateName(ALL_JOBS_GROUP_NAMES_SET_PREFIX);
        ToolkitSet toolkitSet = this.toolkit.getSet(string, String.class);
        this.allGroupsReference.compareAndSet(null, (ToolkitSet<String>)toolkitSet);
        return (Set)this.allGroupsReference.get();
    }

    public Set<JobKey> getOrCreateBlockedJobsSet() {
        String string = this.generateName(BLOCKED_JOBS_SET_PREFIX);
        ToolkitSet toolkitSet = this.toolkit.getSet(string, JobKey.class);
        this.blockedJobsReference.compareAndSet(null, (ToolkitSet<JobKey>)toolkitSet);
        return (Set)this.blockedJobsReference.get();
    }

    public Set<String> getOrCreatePausedGroupsSet() {
        String string = this.generateName(PAUSED_GROUPS_SET_PREFIX);
        ToolkitSet toolkitSet = this.toolkit.getSet(string, String.class);
        this.pausedGroupsReference.compareAndSet(null, (ToolkitSet<String>)toolkitSet);
        return (Set)this.pausedGroupsReference.get();
    }

    public Set<String> getOrCreatePausedTriggerGroupsSet() {
        String string = this.generateName(PAUSED_TRIGGER_GROUPS_SET_PREFIX);
        ToolkitSet toolkitSet = this.toolkit.getSet(string, String.class);
        this.pausedTriggerGroupsReference.compareAndSet(null, (ToolkitSet<String>)toolkitSet);
        return (Set)this.pausedTriggerGroupsReference.get();
    }

    public Set<String> getOrCreateJobsGroupMap(String string) {
        ToolkitSet toolkitSet = this.jobsGroupSet.get(string);
        if (toolkitSet != null && !toolkitSet.isDestroyed()) {
            return toolkitSet;
        }
        String string2 = this.generateName(JOBS_GROUP_MAP_PREFIX + string);
        toolkitSet = this.toolkit.getSet(string2, String.class);
        this.jobsGroupSet.put(string, (ToolkitSet<String>)toolkitSet);
        return toolkitSet;
    }

    public void removeJobsGroupMap(String string) {
        ToolkitSet<String> toolkitSet = this.jobsGroupSet.remove(string);
        if (toolkitSet != null) {
            toolkitSet.destroy();
        }
    }

    public Set<String> getOrCreateTriggersGroupMap(String string) {
        ToolkitSet toolkitSet = this.triggersGroupSet.get(string);
        if (toolkitSet != null && !toolkitSet.isDestroyed()) {
            return toolkitSet;
        }
        String string2 = this.generateName(TRIGGERS_GROUP_MAP_PREFIX + string);
        toolkitSet = this.toolkit.getSet(string2, String.class);
        this.triggersGroupSet.put(string, (ToolkitSet<String>)toolkitSet);
        return toolkitSet;
    }

    public void removeTriggersGroupMap(String string) {
        ToolkitSet<String> toolkitSet = this.triggersGroupSet.remove(string);
        if (toolkitSet != null) {
            toolkitSet.destroy();
        }
    }

    public Set<String> getOrCreateAllTriggersGroupsSet() {
        String string = this.generateName(ALL_TRIGGERS_GROUP_NAMES_SET_PREFIX);
        ToolkitSet toolkitSet = this.toolkit.getSet(string, String.class);
        this.allTriggersGroupsReference.compareAndSet(null, (ToolkitSet<String>)toolkitSet);
        return (Set)this.allTriggersGroupsReference.get();
    }

    public TimeTriggerSet getOrCreateTimeTriggerSet() {
        String string = this.generateName(TIME_TRIGGER_SORTED_SET_PREFIX);
        TimeTriggerSet timeTriggerSet = new TimeTriggerSet((ToolkitSortedSet<TimeTrigger>)this.toolkit.getSortedSet(string, TimeTrigger.class));
        this.timeTriggerSetReference.compareAndSet(null, timeTriggerSet);
        return this.timeTriggerSetReference.get();
    }

    public ToolkitLock getLock(ToolkitLockTypeInternal toolkitLockTypeInternal) {
        String string = this.generateName(SINGLE_LOCK_NAME_PREFIX);
        return ((ToolkitInternal)this.toolkit).getLock(string, toolkitLockTypeInternal);
    }
}

