/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper.security;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.StringTokenizer;
import org.tanukisoftware.wrapper.security.WSCollection;

public class WrapperServicePermission
extends Permission {
    public static String ACTION_START = "start";
    public static String ACTION_STOP = "stop";
    public static String ACTION_PAUSE = "pause";
    public static String ACTION_CONTINUE = "continue";
    public static String ACTION_INTERROGATE = "interrogate";
    public static String ACTION_USER_CODE = "userCode";
    private static int MASK_START = 1;
    private static int MASK_STOP = 2;
    private static int MASK_PAUSE = 4;
    private static int MASK_CONTINUE = 8;
    private static int MASK_INTERROGATE = 16;
    private static int MASK_USER_CODE = 32;
    private static int MASK_ALL = MASK_START | MASK_STOP | MASK_PAUSE | MASK_CONTINUE | MASK_INTERROGATE | MASK_USER_CODE;
    private int m_actionMask;

    public WrapperServicePermission(String string, String string2) {
        super(string);
        this.m_actionMask = this.buildActionMask(string2);
    }

    public WrapperServicePermission(String string) {
        this(string, "*");
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof WrapperServicePermission)) {
            return false;
        }
        WrapperServicePermission wrapperServicePermission = (WrapperServicePermission)object;
        return this.m_actionMask == wrapperServicePermission.m_actionMask && this.getName().equals(wrapperServicePermission.getName());
    }

    public String getActions() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        if ((this.m_actionMask & MASK_START) != 0) {
            if (bl) {
                stringBuffer.append(',');
            } else {
                bl = false;
            }
            stringBuffer.append(ACTION_START);
        }
        if ((this.m_actionMask & MASK_STOP) != 0) {
            if (bl) {
                stringBuffer.append(',');
            } else {
                bl = false;
            }
            stringBuffer.append(ACTION_STOP);
        }
        if ((this.m_actionMask & MASK_PAUSE) != 0) {
            if (bl) {
                stringBuffer.append(',');
            } else {
                bl = false;
            }
            stringBuffer.append(ACTION_CONTINUE);
        }
        if ((this.m_actionMask & MASK_CONTINUE) != 0) {
            if (bl) {
                stringBuffer.append(',');
            } else {
                bl = false;
            }
            stringBuffer.append(ACTION_CONTINUE);
        }
        if ((this.m_actionMask & MASK_INTERROGATE) != 0) {
            if (bl) {
                stringBuffer.append(',');
            } else {
                bl = false;
            }
            stringBuffer.append(ACTION_INTERROGATE);
        }
        if ((this.m_actionMask & MASK_USER_CODE) != 0) {
            if (bl) {
                stringBuffer.append(',');
            } else {
                bl = false;
            }
            stringBuffer.append(ACTION_USER_CODE);
        }
        return stringBuffer.toString();
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof WrapperServicePermission)) {
            return false;
        }
        WrapperServicePermission wrapperServicePermission = (WrapperServicePermission)permission;
        return (this.m_actionMask & wrapperServicePermission.m_actionMask) == wrapperServicePermission.m_actionMask && this.impliesIgnoreActionMask(wrapperServicePermission);
    }

    public PermissionCollection newPermissionCollection() {
        return new WSCollection();
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    int getActionMask() {
        return this.m_actionMask;
    }

    boolean impliesIgnoreActionMask(WrapperServicePermission wrapperServicePermission) {
        if (this.getName().equals(wrapperServicePermission.getName())) {
            return true;
        }
        return wrapperServicePermission.getName().endsWith("*") && this.getName().startsWith(wrapperServicePermission.getName().substring(0, wrapperServicePermission.getName().length() - 1));
    }

    private int buildActionMask(String string) {
        if (string == ACTION_START) {
            return MASK_START;
        }
        if (string == ACTION_STOP) {
            return MASK_STOP;
        }
        if (string == ACTION_PAUSE) {
            return MASK_PAUSE;
        }
        if (string == ACTION_CONTINUE) {
            return MASK_CONTINUE;
        }
        if (string == ACTION_INTERROGATE) {
            return MASK_INTERROGATE;
        }
        if (string == ACTION_USER_CODE) {
            return MASK_USER_CODE;
        }
        if (string.equals("*")) {
            return MASK_ALL;
        }
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals(ACTION_START)) {
                n |= MASK_START;
                continue;
            }
            if (string2.equals(ACTION_STOP)) {
                n |= MASK_STOP;
                continue;
            }
            if (string2.equals(ACTION_PAUSE)) {
                n |= MASK_PAUSE;
                continue;
            }
            if (string2.equals(ACTION_CONTINUE)) {
                n |= MASK_CONTINUE;
                continue;
            }
            if (string2.equals(ACTION_INTERROGATE)) {
                n |= MASK_INTERROGATE;
                continue;
            }
            if (string2.equals(ACTION_USER_CODE)) {
                n |= MASK_USER_CODE;
                continue;
            }
            throw new IllegalArgumentException("Invalid permission action: \"" + string2 + "\"");
        }
        return n;
    }
}

