/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Hashtable;
import org.tanukisoftware.wrapper.WrapperManager;

public class WrapperActionServer
implements Runnable {
    public static final byte COMMAND_SHUTDOWN = 83;
    public static final byte COMMAND_HALT_EXPECTED = 72;
    public static final byte COMMAND_RESTART = 82;
    public static final byte COMMAND_DUMP = 68;
    public static final byte COMMAND_HALT_UNEXPECTED = 85;
    public static final byte COMMAND_ACCESS_VIOLATION = 86;
    public static final byte COMMAND_APPEAR_HUNG = 71;
    private InetAddress m_bindAddr;
    private int m_port;
    private Thread m_runner;
    private boolean m_runnerStop = false;
    private ServerSocket m_serverSocket;
    private Hashtable m_actions = new Hashtable();

    public WrapperActionServer(int n, InetAddress inetAddress) {
        this.m_port = n;
        this.m_bindAddr = inetAddress;
    }

    public WrapperActionServer(int n) {
        this(n, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        WrapperActionServer wrapperActionServer;
        if (Thread.currentThread() != this.m_runner) {
            throw new IllegalStateException("Private method.");
        }
        try {
            while (true) {
                if (this.m_runnerStop) {
                    Object var7_9 = null;
                    wrapperActionServer = this;
                    break;
                }
                try {
                    Runnable runnable;
                    Hashtable hashtable;
                    int n;
                    Socket socket = this.m_serverSocket.accept();
                    try {
                        socket.setSoTimeout(15000);
                        n = socket.getInputStream().read();
                        hashtable = null;
                    }
                    catch (Throwable throwable) {
                        hashtable = null;
                        socket.close();
                        throw throwable;
                    }
                    socket.close();
                    if (n < 0) continue;
                    hashtable = this.m_actions;
                    synchronized (hashtable) {
                        runnable = (Runnable)this.m_actions.get(new Integer(n));
                        if (runnable == null) continue;
                    }
                    try {
                        runnable.run();
                    }
                    catch (Throwable throwable) {
                        System.out.println("WrapperActionServer: Error processing action.");
                        throwable.printStackTrace();
                    }
                }
                catch (Throwable throwable) {
                    if (this.m_runnerStop && (throwable instanceof InterruptedException || throwable instanceof SocketException || throwable instanceof InterruptedIOException)) continue;
                    System.out.println("WrapperActionServer: Unexpeced error.");
                    throwable.printStackTrace();
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            WrapperActionServer wrapperActionServer2 = this;
            synchronized (wrapperActionServer2) {
                this.m_runner = null;
                this.notify();
                throw throwable;
            }
        }
        synchronized (wrapperActionServer) {
            this.m_runner = null;
            this.notify();
            return;
        }
    }

    public void start() throws IOException {
        this.m_serverSocket = new ServerSocket(this.m_port, 5, this.m_bindAddr);
        this.m_runner = new Thread((Runnable)this, "WrapperActionServer_runner");
        this.m_runner.setDaemon(true);
        this.m_runner.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() throws Exception {
        Thread thread = this.m_runner;
        this.m_runnerStop = true;
        thread.interrupt();
        ServerSocket serverSocket = this.m_serverSocket;
        if (serverSocket != null) {
            try {
                serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        WrapperActionServer wrapperActionServer = this;
        synchronized (wrapperActionServer) {
            while (this.m_runner != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return;
        }
    }

    public void registerAction(byte by, Runnable runnable) {
        Hashtable hashtable = this.m_actions;
        synchronized (hashtable) {
            this.m_actions.put(new Integer(by), runnable);
        }
    }

    public void unregisterAction(byte by) {
        Hashtable hashtable = this.m_actions;
        synchronized (hashtable) {
            this.m_actions.remove(new Integer(by));
        }
    }

    public void enableShutdownAction(boolean bl) {
        if (bl) {
            this.registerAction((byte)83, new Runnable(){

                public void run() {
                    WrapperManager.stop(0);
                }
            });
        } else {
            this.unregisterAction((byte)83);
        }
    }

    public void enableHaltExpectedAction(boolean bl) {
        if (bl) {
            this.registerAction((byte)72, new Runnable(){

                public void run() {
                    WrapperManager.stopImmediate(0);
                }
            });
        } else {
            this.unregisterAction((byte)72);
        }
    }

    public void enableRestartAction(boolean bl) {
        if (bl) {
            this.registerAction((byte)82, new Runnable(){

                public void run() {
                    WrapperManager.restart();
                }
            });
        } else {
            this.unregisterAction((byte)82);
        }
    }

    public void enableThreadDumpAction(boolean bl) {
        if (bl) {
            this.registerAction((byte)68, new Runnable(){

                public void run() {
                    WrapperManager.requestThreadDump();
                }
            });
        } else {
            this.unregisterAction((byte)68);
        }
    }

    public void enableHaltUnexpectedAction(boolean bl) {
        if (bl) {
            this.registerAction((byte)85, new Runnable(){
                static /* synthetic */ Class class$java$lang$Runtime;

                public void run() {
                    Method method;
                    try {
                        method = (class$java$lang$Runtime == null ? (class$java$lang$Runtime = 5.class$("java.lang.Runtime")) : class$java$lang$Runtime).getMethod("halt", Integer.TYPE);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        System.out.println("halt not supported by current JVM.");
                        method = null;
                    }
                    if (method != null) {
                        Runtime runtime = Runtime.getRuntime();
                        try {
                            method.invoke((Object)runtime, new Integer(0));
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            System.out.println("Unable to call runitme.halt: " + illegalAccessException.getMessage());
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            System.out.println("Unable to call runitme.halt: " + invocationTargetException.getMessage());
                        }
                    }
                }

                static /* synthetic */ Class class$(String string) {
                    try {
                        return Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            });
        } else {
            this.unregisterAction((byte)85);
        }
    }

    public void enableAccessViolationAction(boolean bl) {
        if (bl) {
            this.registerAction((byte)86, new Runnable(){

                public void run() {
                    WrapperManager.accessViolationNative();
                }
            });
        } else {
            this.unregisterAction((byte)86);
        }
    }

    public void enableAppearHungAction(boolean bl) {
        if (bl) {
            this.registerAction((byte)71, new Runnable(){

                public void run() {
                    WrapperManager.appearHung();
                }
            });
        } else {
            this.unregisterAction((byte)71);
        }
    }
}

