/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.util;

import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicateChecker {
    private static final Logger logger = LoggerFactory.getLogger(DuplicateChecker.class);

    private DuplicateChecker() {
    }

    public static void checkDuplicate(Class<?> clazz) {
        DuplicateChecker.checkDuplicate(clazz.getName().replace('.', '/') + ".class");
    }

    public static void checkDuplicate(String string) {
        try {
            Enumeration<URL> enumeration = Thread.currentThread().getContextClassLoader().getResources(string);
            HashSet<String> hashSet = new HashSet<String>();
            while (enumeration.hasMoreElements()) {
                String string2;
                URL uRL = enumeration.nextElement();
                if (uRL == null || (string2 = uRL.getFile()) == null || string2.length() <= 0) continue;
                hashSet.add(string2);
            }
            if (hashSet.size() > 1) {
                logger.error("Duplicate class " + string + " in " + hashSet.size() + " jar " + hashSet);
            }
        }
        catch (Throwable throwable) {
            logger.error(throwable.getMessage(), throwable);
        }
    }
}

