/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm.impl;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squirrelframework.foundation.fsm.Action;
import org.squirrelframework.foundation.fsm.Actions;
import org.squirrelframework.foundation.fsm.Conditions;
import org.squirrelframework.foundation.fsm.HistoryType;
import org.squirrelframework.foundation.fsm.ImmutableState;
import org.squirrelframework.foundation.fsm.ImmutableTransition;
import org.squirrelframework.foundation.fsm.MutableState;
import org.squirrelframework.foundation.fsm.MutableTransition;
import org.squirrelframework.foundation.fsm.StateCompositeType;
import org.squirrelframework.foundation.fsm.StateContext;
import org.squirrelframework.foundation.fsm.StateMachine;
import org.squirrelframework.foundation.fsm.StateMachineData;
import org.squirrelframework.foundation.fsm.TransitionResult;
import org.squirrelframework.foundation.fsm.Visitable;
import org.squirrelframework.foundation.fsm.Visitor;
import org.squirrelframework.foundation.fsm.impl.AbstractStateMachine;
import org.squirrelframework.foundation.fsm.impl.FSM;

class StateImpl<T extends StateMachine<T, S, E, C>, S, E, C>
implements MutableState<T, S, E, C> {
    private static final Logger logger = LoggerFactory.getLogger(StateImpl.class);
    protected final S stateId;
    protected final Actions<T, S, E, C> entryActions = FSM.newActions();
    protected final Actions<T, S, E, C> exitActions = FSM.newActions();
    private LinkedListMultimap<E, ImmutableTransition<T, S, E, C>> transitions;
    private Set<E> acceptableEvents;
    private MutableState<T, S, E, C> parentState;
    private List<MutableState<T, S, E, C>> childStates;
    private MutableState<T, S, E, C> childInitialState;
    private HistoryType historyType = HistoryType.NONE;
    private int level = 0;
    private boolean isFinalState = false;
    private StateCompositeType compositeType = StateCompositeType.SEQUENTIAL;

    StateImpl(S s) {
        this.stateId = s;
    }

    @Override
    public S getStateId() {
        return this.stateId;
    }

    @Override
    public List<Action<T, S, E, C>> getEntryActions() {
        return this.entryActions.getAll();
    }

    @Override
    public List<Action<T, S, E, C>> getExitActions() {
        return this.exitActions.getAll();
    }

    @Override
    public List<ImmutableTransition<T, S, E, C>> getAllTransitions() {
        if (this.transitions == null) {
            return Collections.emptyList();
        }
        return Lists.newArrayList(this.getTransitions().values());
    }

    @Override
    public List<ImmutableTransition<T, S, E, C>> getTransitions(E e) {
        if (this.transitions == null) {
            return Collections.emptyList();
        }
        return Lists.newArrayList(this.getTransitions().get((Object)e));
    }

    @Override
    public Set<E> getAcceptableEvents() {
        if (this.acceptableEvents == null) {
            HashSet hashSet = Sets.newHashSet();
            hashSet.addAll(this.getTransitions().keySet());
            this.acceptableEvents = Collections.unmodifiableSet(hashSet);
        }
        return this.acceptableEvents;
    }

    @Override
    public void prioritizeTransitions() {
        for (Object e : this.getTransitions().keySet()) {
            Collection collection = this.transitions.get(e);
            Collections.sort(collection, new Comparator<ImmutableTransition<T, S, E, C>>(){

                @Override
                public int compare(ImmutableTransition<T, S, E, C> immutableTransition, ImmutableTransition<T, S, E, C> immutableTransition2) {
                    return immutableTransition2.getPriority() - immutableTransition.getPriority();
                }
            });
        }
    }

    @Override
    public void entry(StateContext<T, S, E, C> stateContext) {
        stateContext.getExecutor().begin("STATE_ENTRY__" + this.getStateId());
        for (Action<T, S, E, C> squirrelComponent : this.getEntryActions()) {
            stateContext.getExecutor().defer(squirrelComponent, null, this.getStateId(), stateContext.getEvent(), stateContext.getContext(), stateContext.getStateMachine().getThis());
        }
        if (this.isParallelState()) {
            for (ImmutableState immutableState : this.getChildStates()) {
                immutableState.entry(stateContext);
                ImmutableState<T, S, E, C> immutableState2 = immutableState.enterByHistory(stateContext);
                stateContext.getStateMachineData().write().subStateFor(this.getStateId(), immutableState2.getStateId());
            }
        }
        logger.debug("State \"" + this.getStateId() + "\" entry.");
    }

    @Override
    public void exit(StateContext<T, S, E, C> stateContext) {
        ImmutableState<T, S, E, C> immutableState;
        ImmutableState<T, S, E, C> immutableState2;
        if (this.isParallelState()) {
            immutableState2 = this.getSubStatesOn(this, stateContext.getStateMachineData().read());
            Iterator<ImmutableState<T, S, E, C>> object = immutableState2.iterator();
            while (object.hasNext()) {
                immutableState = object.next();
                if (!immutableState.isFinalState()) {
                    immutableState.exit(stateContext);
                }
                if (immutableState.getParentState() == this) continue;
                immutableState.getParentState().exit(stateContext);
            }
            stateContext.getStateMachineData().write().removeSubStatesOn(this.getStateId());
        }
        if (this.isFinalState()) {
            return;
        }
        stateContext.getExecutor().begin("STATE_EXIT__" + this.getStateId());
        for (Action action : this.getExitActions()) {
            stateContext.getExecutor().defer(action, this.getStateId(), null, stateContext.getEvent(), stateContext.getContext(), stateContext.getStateMachine().getThis());
        }
        if (this.getParentState() != null) {
            boolean bl;
            boolean bl2;
            immutableState2 = this.getParentState();
            boolean bl3 = bl2 = immutableState2.getHistoryType() != HistoryType.NONE;
            if (!bl2) {
                for (immutableState = immutableState2.getParentState(); immutableState != null; immutableState = immutableState.getParentState()) {
                    if (immutableState.getHistoryType() != HistoryType.DEEP) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                stateContext.getStateMachineData().write().lastActiveChildStateFor(this.getParentState().getStateId(), this.getStateId());
            }
            if (this.getParentState().isRegion()) {
                immutableState = this.getParentState().getParentState().getStateId();
                stateContext.getStateMachineData().write().removeSubState(immutableState, (ImmutableState<T, S, E, C>)this.getStateId());
            }
        }
        logger.debug("State \"" + this.getStateId() + "\" exit.");
    }

    @Override
    public ImmutableState<T, S, E, C> getParentState() {
        return this.parentState;
    }

    @Override
    public List<ImmutableState<T, S, E, C>> getChildStates() {
        return Lists.newArrayList(this.childStates);
    }

    @Override
    public boolean hasChildStates() {
        return this.childStates != null && this.childStates.size() > 0;
    }

    @Override
    public void setParentState(MutableState<T, S, E, C> mutableState) {
        if (this == mutableState) {
            throw new IllegalArgumentException("parent state cannot be state itself.");
        }
        if (this.parentState != null) {
            throw new UnsupportedOperationException("Cannot change state parent.");
        }
        this.parentState = mutableState;
        this.setLevel(this.parentState != null ? this.parentState.getLevel() + 1 : 1);
    }

    @Override
    public ImmutableState<T, S, E, C> getInitialState() {
        return this.childInitialState;
    }

    @Override
    public void setInitialState(MutableState<T, S, E, C> mutableState) {
        if (this.isParallelState()) {
            logger.warn("Ignoring attempt to set initial state of parallel state group.");
            return;
        }
        if (this.childInitialState != null) {
            throw new UnsupportedOperationException("Cannot change child initial state.");
        }
        this.childInitialState = mutableState;
    }

    @Override
    public ImmutableState<T, S, E, C> enterByHistory(StateContext<T, S, E, C> stateContext) {
        if (this.isFinalState() || this.isParallelState()) {
            return this;
        }
        ImmutableState<T, S, E, C> immutableState = null;
        switch (this.historyType) {
            case NONE: {
                immutableState = this.enterHistoryNone(stateContext);
                break;
            }
            case SHALLOW: {
                immutableState = this.enterHistoryShallow(stateContext);
                break;
            }
            case DEEP: {
                immutableState = this.enterHistoryDeep(stateContext);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown HistoryType : " + (Object)((Object)this.historyType));
            }
        }
        return immutableState;
    }

    @Override
    public ImmutableState<T, S, E, C> enterDeep(StateContext<T, S, E, C> stateContext) {
        this.entry(stateContext);
        ImmutableState<T, S, E, C> immutableState = this.getLastActiveChildStateOf(this, stateContext.getStateMachineData().read());
        return immutableState == null ? this : immutableState.enterDeep(stateContext);
    }

    @Override
    public ImmutableState<T, S, E, C> enterShallow(StateContext<T, S, E, C> stateContext) {
        this.entry(stateContext);
        return this.childInitialState != null ? this.childInitialState.enterShallow(stateContext) : this;
    }

    private ImmutableState<T, S, E, C> enterHistoryShallow(StateContext<T, S, E, C> stateContext) {
        ImmutableState<T, S, E, C> immutableState = this.getLastActiveChildStateOf(this, stateContext.getStateMachineData().read());
        return immutableState != null ? immutableState.enterShallow(stateContext) : this;
    }

    private ImmutableState<T, S, E, C> enterHistoryNone(StateContext<T, S, E, C> stateContext) {
        return this.childInitialState != null ? this.childInitialState.enterShallow(stateContext) : this;
    }

    private ImmutableState<T, S, E, C> enterHistoryDeep(StateContext<T, S, E, C> stateContext) {
        ImmutableState<T, S, E, C> immutableState = this.getLastActiveChildStateOf(this, stateContext.getStateMachineData().read());
        return immutableState != null ? immutableState.enterDeep(stateContext) : this;
    }

    private LinkedListMultimap<E, ImmutableTransition<T, S, E, C>> getTransitions() {
        if (this.transitions == null) {
            this.transitions = LinkedListMultimap.create();
        }
        return this.transitions;
    }

    @Override
    public MutableTransition<T, S, E, C> addTransitionOn(E e) {
        MutableTransition mutableTransition = FSM.newTransition();
        mutableTransition.setSourceState(this);
        mutableTransition.setEvent(e);
        this.getTransitions().put(e, mutableTransition);
        return mutableTransition;
    }

    @Override
    public void addEntryAction(Action<T, S, E, C> action) {
        this.entryActions.add(action);
    }

    @Override
    public void addEntryActions(List<? extends Action<T, S, E, C>> list) {
        this.entryActions.addAll(list);
    }

    @Override
    public void addExitAction(Action<T, S, E, C> action) {
        this.exitActions.add(action);
    }

    @Override
    public void addExitActions(List<? extends Action<T, S, E, C>> list) {
        this.exitActions.addAll(list);
    }

    private boolean isParentOf(ImmutableState<T, S, E, C> immutableState) {
        for (ImmutableState<T, S, E, C> immutableState2 = immutableState.getParentState(); immutableState2 != null; immutableState2 = immutableState2.getParentState()) {
            if (immutableState2 != this) continue;
            return true;
        }
        return false;
    }

    @Override
    public void internalFire(StateContext<T, S, E, C> stateContext) {
        Visitable visitable;
        Object object;
        Object object2;
        ImmutableState<T, S, E, C> immutableState;
        List<Visitable> list;
        TransitionResult transitionResult = stateContext.getResult();
        if (this.isParallelState()) {
            list = this.getSubStatesOn(this, stateContext.getStateMachineData().read());
            for (Visitable visitable2 : list) {
                if (visitable2.isFinalState()) continue;
                immutableState = FSM.newResult(false, visitable2, transitionResult);
                object2 = FSM.newStateContext(stateContext.getStateMachine(), stateContext.getStateMachineData(), visitable2, stateContext.getEvent(), stateContext.getContext(), immutableState, stateContext.getExecutor());
                visitable2.internalFire(object2);
                if (immutableState.isDeclined()) continue;
                if (!this.isParentOf(immutableState.getTargetState())) {
                    transitionResult.setTargetState(immutableState.getTargetState());
                    return;
                }
                stateContext.getStateMachineData().write().subStateFor(this.getStateId(), immutableState.getTargetState().getStateId());
                if (!immutableState.getTargetState().isFinalState() || (object = (visitable = immutableState.getTargetState().getParentState()).getParentState()) == null || !object.isParallelState()) continue;
                boolean bl = true;
                for (ImmutableState<T, S, E, C> visitable32 : this.getSubStatesOn((ImmutableState<T, S, E, C>)object, stateContext.getStateMachineData().read())) {
                    if (visitable32.isFinalState()) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                StateMachine<T, S, E, C> stateMachine = stateContext.getStateMachine();
                AbstractStateMachine abstractStateMachine = (AbstractStateMachine)stateMachine;
                stateMachine.fireImmediate(abstractStateMachine.getFinishEvent(), stateContext.getContext());
                return;
            }
        }
        list = this.getTransitions(stateContext.getEvent());
        for (Visitable visitable2 : list) {
            visitable2.internalFire(stateContext);
            if (!transitionResult.isAccepted()) continue;
            immutableState = transitionResult.getTargetState();
            if (immutableState.isFinalState() && !immutableState.isRootState()) {
                object2 = immutableState.getParentState();
                visitable = (AbstractStateMachine)stateContext.getStateMachine();
                object = FSM.newStateContext(stateContext.getStateMachine(), stateContext.getStateMachineData(), object2, ((AbstractStateMachine)visitable).getFinishEvent(), stateContext.getContext(), transitionResult, stateContext.getExecutor());
                object2.internalFire(object);
            }
            return;
        }
        if (transitionResult.isDeclined() && this.getParentState() != null && !this.getParentState().isRegion() && !this.getParentState().isParallelState()) {
            logger.debug("Internal notify the same event to parent state");
            this.getParentState().internalFire(stateContext);
        }
    }

    @Override
    public boolean isRootState() {
        return this.parentState == null;
    }

    @Override
    public boolean isFinalState() {
        return this.isFinalState;
    }

    @Override
    public void setFinal(boolean bl) {
        this.isFinalState = bl;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitOnEntry(this);
        for (ImmutableTransition<T, S, E, C> visitable : this.getAllTransitions()) {
            visitable.accept(visitor);
        }
        if (this.childStates != null) {
            for (ImmutableState immutableState : this.childStates) {
                immutableState.accept(visitor);
            }
        }
        visitor.visitOnExit(this);
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(int n) {
        this.level = n;
        if (this.childStates != null) {
            for (MutableState<T, S, E, C> mutableState : this.childStates) {
                mutableState.setLevel(this.level + 1);
            }
        }
    }

    @Override
    public void addChildState(MutableState<T, S, E, C> mutableState) {
        if (mutableState != null) {
            if (this.childStates == null) {
                this.childStates = Lists.newArrayList();
            }
            if (!this.childStates.contains(mutableState)) {
                this.childStates.add(mutableState);
            }
        }
    }

    @Override
    public HistoryType getHistoryType() {
        return this.historyType;
    }

    @Override
    public void setHistoryType(HistoryType historyType) {
        this.historyType = historyType;
    }

    @Override
    public StateCompositeType getCompositeType() {
        return this.compositeType;
    }

    @Override
    public void setCompositeType(StateCompositeType stateCompositeType) {
        this.compositeType = stateCompositeType;
    }

    @Override
    public boolean isParallelState() {
        return this.compositeType == StateCompositeType.PARALLEL;
    }

    public String toString() {
        return this.getStateId().toString();
    }

    @Override
    public boolean isRegion() {
        return this.parentState != null && this.parentState.isParallelState();
    }

    @Override
    public void verify() {
        if (this.isFinalState()) {
            if (this.isParallelState()) {
                throw new IllegalStateException("Final state cannot be parallel state.");
            }
            if (this.hasChildStates()) {
                throw new IllegalStateException("Final state cannot have child states.");
            }
        }
        if (this.transitions != null) {
            Collection collection = this.transitions.values();
            for (ImmutableTransition immutableTransition : collection) {
                immutableTransition.verify();
                ImmutableTransition<T, S, E, C> immutableTransition2 = this.checkConflictTransitions(immutableTransition, (List<ImmutableTransition<T, S, E, C>>)collection);
                if (immutableTransition2 == null) continue;
                throw new RuntimeException(String.format("Transition '%s' is conflicted with '%s'.", immutableTransition, immutableTransition2));
            }
        }
    }

    public ImmutableTransition<T, S, E, C> checkConflictTransitions(ImmutableTransition<T, S, E, C> immutableTransition, List<ImmutableTransition<T, S, E, C>> list) {
        for (ImmutableTransition<T, S, E, C> immutableTransition2 : list) {
            if (immutableTransition == immutableTransition2 || immutableTransition2.getCondition().getClass() == Conditions.Never.class || !immutableTransition2.isMatch(immutableTransition.getSourceState().getStateId(), immutableTransition.getTargetState().getStateId(), immutableTransition.getEvent(), immutableTransition.getPriority())) continue;
            if (immutableTransition2.getCondition().getClass() == Conditions.Always.class) {
                return immutableTransition;
            }
            if (immutableTransition.getCondition().getClass() == Conditions.Always.class) {
                return immutableTransition;
            }
            if (!immutableTransition2.getCondition().name().equals(immutableTransition.getCondition().name())) continue;
            return immutableTransition;
        }
        return null;
    }

    private List<ImmutableState<T, S, E, C>> getSubStatesOn(ImmutableState<T, S, E, C> immutableState, StateMachineData.Reader<T, S, E, C> reader) {
        ArrayList<ImmutableState<T, S, ImmutableState<T, S, E, C>, C>> arrayList = Lists.newArrayList();
        for (S s : reader.subStatesOn(immutableState.getStateId())) {
            arrayList.add(reader.rawStateFrom(s));
        }
        return arrayList;
    }

    private ImmutableState<T, S, E, C> getLastActiveChildStateOf(ImmutableState<T, S, E, C> immutableState, StateMachineData.Reader<T, S, E, C> reader) {
        S s = reader.lastActiveChildStateOf(immutableState.getStateId());
        if (s != null) {
            return reader.rawStateFrom(s);
        }
        return immutableState.getInitialState();
    }

    @Override
    public ImmutableState<T, S, E, C> getThis() {
        return this;
    }

    protected String getKey(T t) {
        return t.getIdentifier() + '@' + this.getPath();
    }

    @Override
    public String getPath() {
        String string = this.stateId.toString();
        if (this.parentState == null) {
            return string;
        }
        return this.parentState.getPath() + "/" + string;
    }

    @Override
    public boolean isChildStateOf(ImmutableState<T, S, E, C> immutableState) {
        ImmutableState<T, S, E, C> immutableState2 = this;
        while (immutableState2.getLevel() > immutableState.getLevel()) {
            immutableState2 = immutableState2.getParentState();
        }
        return immutableState2 == immutableState;
    }
}

