/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm.impl;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squirrelframework.foundation.fsm.Condition;
import org.squirrelframework.foundation.fsm.MvelScriptManager;

class MvelConditionImpl<C>
implements Condition<C> {
    private static final Logger logger = LoggerFactory.getLogger(MvelConditionImpl.class);
    private final String mvelExpression;
    private final String name;
    private final MvelScriptManager scriptManager;
    private final String script;

    MvelConditionImpl(String string, MvelScriptManager mvelScriptManager) {
        String[] stringArray = StringUtils.split(string, ":::");
        if (stringArray.length == 2) {
            this.name = stringArray[0].trim();
            this.mvelExpression = stringArray[1].trim();
        } else {
            this.name = "_NoName_";
            this.mvelExpression = stringArray[0].trim();
        }
        this.script = string;
        this.scriptManager = mvelScriptManager;
        mvelScriptManager.compile(this.mvelExpression);
    }

    @Override
    public boolean isSatisfied(C c) {
        try {
            HashMap<String, C> hashMap = new HashMap<String, C>();
            hashMap.put("context", c);
            return this.scriptManager.evalBoolean(this.mvelExpression, hashMap);
        }
        catch (Exception exception) {
            logger.error("Evaluate \"" + this.mvelExpression + "\" failed, which caused by " + exception.getCause().getMessage());
            return false;
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    public final String toString() {
        return "mvel#" + this.script;
    }
}

