/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.squirrelframework.foundation.fsm.Converter;

public class GeneralConverter<T>
implements Converter<T> {
    private Class<T> type;

    public GeneralConverter(Class<T> clazz) {
        this.type = clazz;
    }

    @Override
    public String convertToString(T t) {
        if (Enum.class.isAssignableFrom(this.type)) {
            return ((Enum)t).name();
        }
        if (Date.class.isAssignableFrom(this.type)) {
            return Long.toString(((Date)t).getTime());
        }
        return t != null ? t.toString() : "";
    }

    @Override
    public T convertFromString(String string) {
        if (string == null) {
            return null;
        }
        if (this.type.equals(Boolean.TYPE) || this.type.equals(Boolean.class)) {
            if (string == null || string.isEmpty()) {
                return null;
            }
            if (string.equalsIgnoreCase("true")) {
                return this.type.cast(Boolean.TRUE);
            }
            return this.type.cast(Boolean.FALSE);
        }
        if (Number.class.isAssignableFrom(this.type) || Integer.TYPE.isAssignableFrom(this.type) || Long.TYPE.isAssignableFrom(this.type) || Double.TYPE.isAssignableFrom(this.type) || Float.TYPE.isAssignableFrom(this.type) || Byte.TYPE.isAssignableFrom(this.type) || Short.TYPE.isAssignableFrom(this.type)) {
            BigDecimal bigDecimal = new BigDecimal(string);
            if (Integer.class.equals(this.type) || Integer.TYPE.equals(this.type)) {
                return this.type.cast(bigDecimal.intValue());
            }
            if (Long.class.equals(this.type) || Long.TYPE.equals(this.type)) {
                return this.type.cast(bigDecimal.longValue());
            }
            if (Double.class.equals(this.type) || Double.TYPE.equals(this.type)) {
                return this.type.cast(bigDecimal.doubleValue());
            }
            if (Float.class.equals(this.type) || Float.TYPE.equals(this.type)) {
                return this.type.cast(Float.valueOf(bigDecimal.floatValue()));
            }
            if (BigInteger.class.equals(this.type)) {
                return this.type.cast(bigDecimal.toBigInteger());
            }
            if (BigDecimal.class.equals(this.type)) {
                return this.type.cast(bigDecimal);
            }
            if (Short.class.equals(this.type) || Short.TYPE.equals(this.type)) {
                return this.type.cast(bigDecimal.shortValue());
            }
            if (Byte.class.equals(this.type) || Byte.TYPE.equals(this.type)) {
                return this.type.cast(bigDecimal.byteValue());
            }
        } else {
            if (Enum.class.isAssignableFrom(this.type)) {
                return this.type.cast(Enum.valueOf(this.type, string));
            }
            if (String.class.equals(this.type)) {
                return this.type.cast(string);
            }
            if (Date.class.isAssignableFrom(this.type)) {
                return this.type.cast(new Date(Long.parseLong(string)));
            }
            if (Character.class.equals(this.type) || Character.TYPE.equals(this.type)) {
                return this.type.cast(Character.valueOf(string.charAt(0)));
            }
        }
        throw new IllegalStateException("Unable to convert type: '" + this.type.getName() + "' with value '" + string.toString() + "'.");
    }
}

