/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.utils;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.beans.PropertyVetoException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.quartz.SchedulerException;
import org.quartz.utils.ConnectionProvider;
import org.quartz.utils.PropertiesParser;

public class PoolingConnectionProvider
implements ConnectionProvider {
    public static final String DB_DRIVER = "driver";
    public static final String DB_URL = "URL";
    public static final String DB_USER = "user";
    public static final String DB_PASSWORD = "password";
    public static final String DB_MAX_CONNECTIONS = "maxConnections";
    public static final String DB_MAX_CACHED_STATEMENTS_PER_CONNECTION = "maxCachedStatementsPerConnection";
    public static final String DB_VALIDATION_QUERY = "validationQuery";
    public static final String DB_IDLE_VALIDATION_SECONDS = "idleConnectionValidationSeconds";
    public static final String DB_VALIDATE_ON_CHECKOUT = "validateOnCheckout";
    private static final String DB_DISCARD_IDLE_CONNECTIONS_SECONDS = "discardIdleConnectionsSeconds";
    public static final int DEFAULT_DB_MAX_CONNECTIONS = 10;
    public static final int DEFAULT_DB_MAX_CACHED_STATEMENTS_PER_CONNECTION = 120;
    private ComboPooledDataSource datasource;

    public PoolingConnectionProvider(String string, String string2, String string3, String string4, int n, String string5) throws SQLException, SchedulerException {
        this.initialize(string, string2, string3, string4, n, 120, string5, false, 50, 0);
    }

    public PoolingConnectionProvider(Properties properties) throws SchedulerException, SQLException {
        PropertiesParser propertiesParser = new PropertiesParser(properties);
        this.initialize(propertiesParser.getStringProperty(DB_DRIVER), propertiesParser.getStringProperty(DB_URL), propertiesParser.getStringProperty(DB_USER, ""), propertiesParser.getStringProperty(DB_PASSWORD, ""), propertiesParser.getIntProperty(DB_MAX_CONNECTIONS, 10), propertiesParser.getIntProperty(DB_MAX_CACHED_STATEMENTS_PER_CONNECTION, 120), propertiesParser.getStringProperty(DB_VALIDATION_QUERY), propertiesParser.getBooleanProperty(DB_VALIDATE_ON_CHECKOUT, false), propertiesParser.getIntProperty(DB_IDLE_VALIDATION_SECONDS, 50), propertiesParser.getIntProperty(DB_DISCARD_IDLE_CONNECTIONS_SECONDS, 0));
    }

    private void initialize(String string, String string2, String string3, String string4, int n, int n2, String string5, boolean bl, int n3, int n4) throws SQLException, SchedulerException {
        if (string2 == null) {
            throw new SQLException("DBPool could not be created: DB URL cannot be null");
        }
        if (string == null) {
            throw new SQLException("DBPool '" + string2 + "' could not be created: " + "DB driver class name cannot be null!");
        }
        if (n < 0) {
            throw new SQLException("DBPool '" + string2 + "' could not be created: " + "Max connections must be greater than zero!");
        }
        this.datasource = new ComboPooledDataSource();
        try {
            this.datasource.setDriverClass(string);
        }
        catch (PropertyVetoException propertyVetoException) {
            throw new SchedulerException("Problem setting driver class name on datasource: " + propertyVetoException.getMessage(), propertyVetoException);
        }
        this.datasource.setJdbcUrl(string2);
        this.datasource.setUser(string3);
        this.datasource.setPassword(string4);
        this.datasource.setMaxPoolSize(n);
        this.datasource.setMinPoolSize(1);
        this.datasource.setMaxIdleTime(n4);
        this.datasource.setMaxStatementsPerConnection(n2);
        if (string5 != null) {
            this.datasource.setPreferredTestQuery(string5);
            if (!bl) {
                this.datasource.setTestConnectionOnCheckin(true);
            } else {
                this.datasource.setTestConnectionOnCheckout(true);
            }
            this.datasource.setIdleConnectionTestPeriod(n3);
        }
    }

    public ComboPooledDataSource getDataSource() {
        return this.datasource;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.datasource.getConnection();
    }

    @Override
    public void shutdown() throws SQLException {
        this.datasource.close();
    }

    @Override
    public void initialize() throws SQLException {
    }
}

