/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.simpl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import org.quartz.Calendar;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobPersistenceException;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.impl.matchers.StringMatcher;
import org.quartz.simpl.JobWrapper;
import org.quartz.simpl.TriggerWrapper;
import org.quartz.simpl.TriggerWrapperComparator;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.JobStore;
import org.quartz.spi.OperableTrigger;
import org.quartz.spi.SchedulerSignaler;
import org.quartz.spi.TriggerFiredBundle;
import org.quartz.spi.TriggerFiredResult;
import org.quartz.utils.DirtyFlagMap;
import org.quartz.utils.Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RAMJobStore
implements JobStore {
    protected HashMap<JobKey, JobWrapper> jobsByKey = new HashMap(1000);
    protected HashMap<TriggerKey, TriggerWrapper> triggersByKey = new HashMap(1000);
    protected HashMap<String, HashMap<JobKey, JobWrapper>> jobsByGroup = new HashMap(25);
    protected HashMap<String, HashMap<TriggerKey, TriggerWrapper>> triggersByGroup = new HashMap(25);
    protected TreeSet<TriggerWrapper> timeTriggers = new TreeSet<TriggerWrapper>(new TriggerWrapperComparator());
    protected HashMap<String, Calendar> calendarsByName = new HashMap(25);
    protected ArrayList<TriggerWrapper> triggers = new ArrayList(1000);
    protected final Object lock = new Object();
    protected HashSet<String> pausedTriggerGroups = new HashSet();
    protected HashSet<String> pausedJobGroups = new HashSet();
    protected HashSet<JobKey> blockedJobs = new HashSet();
    protected long misfireThreshold = 5000L;
    protected SchedulerSignaler signaler;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final AtomicLong ftrCtr = new AtomicLong(System.currentTimeMillis());

    protected Logger getLog() {
        return this.log;
    }

    @Override
    public void initialize(ClassLoadHelper classLoadHelper, SchedulerSignaler schedulerSignaler) {
        this.signaler = schedulerSignaler;
        this.getLog().info("RAMJobStore initialized.");
    }

    @Override
    public void schedulerStarted() {
    }

    @Override
    public void schedulerPaused() {
    }

    @Override
    public void schedulerResumed() {
    }

    public long getMisfireThreshold() {
        return this.misfireThreshold;
    }

    public void setMisfireThreshold(long l) {
        if (l < 1L) {
            throw new IllegalArgumentException("Misfire threshold must be larger than 0");
        }
        this.misfireThreshold = l;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public boolean supportsPersistence() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAllSchedulingData() throws JobPersistenceException {
        Object object = this.lock;
        synchronized (object) {
            Set<Key> set;
            List<String> list = this.getTriggerGroupNames();
            for (String string : list) {
                set = this.getTriggerKeys(GroupMatcher.triggerGroupEquals(string));
                for (TriggerKey key : set) {
                    this.removeTrigger(key);
                }
            }
            list = this.getJobGroupNames();
            for (String string : list) {
                set = this.getJobKeys(GroupMatcher.jobGroupEquals(string));
                for (JobKey jobKey : set) {
                    this.removeJob(jobKey);
                }
            }
            list = this.getCalendarNames();
            for (String string : list) {
                this.removeCalendar(string);
            }
        }
    }

    @Override
    public void storeJobAndTrigger(JobDetail jobDetail, OperableTrigger operableTrigger) throws JobPersistenceException {
        this.storeJob(jobDetail, false);
        this.storeTrigger(operableTrigger, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeJob(JobDetail jobDetail, boolean bl) throws ObjectAlreadyExistsException {
        JobWrapper jobWrapper = new JobWrapper((JobDetail)jobDetail.clone());
        boolean bl2 = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.jobsByKey.get(jobWrapper.key) != null) {
                if (!bl) {
                    throw new ObjectAlreadyExistsException(jobDetail);
                }
                bl2 = true;
            }
            if (!bl2) {
                HashMap<JobKey, JobWrapper> hashMap = this.jobsByGroup.get(jobDetail.getKey().getGroup());
                if (hashMap == null) {
                    hashMap = new HashMap(100);
                    this.jobsByGroup.put(jobDetail.getKey().getGroup(), hashMap);
                }
                hashMap.put(jobDetail.getKey(), jobWrapper);
                this.jobsByKey.put(jobWrapper.key, jobWrapper);
            } else {
                JobWrapper jobWrapper2 = this.jobsByKey.get(jobWrapper.key);
                jobWrapper2.jobDetail = jobWrapper.jobDetail;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeJob(JobKey jobKey) {
        boolean bl = false;
        Object object = this.lock;
        synchronized (object) {
            List<OperableTrigger> list = this.getTriggersForJob(jobKey);
            Object object2 = list.iterator();
            while (object2.hasNext()) {
                OperableTrigger operableTrigger = object2.next();
                this.removeTrigger(operableTrigger.getKey());
                bl = true;
            }
            bl = this.jobsByKey.remove(jobKey) != null | bl;
            if (bl && (object2 = this.jobsByGroup.get(jobKey.getGroup())) != null) {
                ((HashMap)object2).remove(jobKey);
                if (((HashMap)object2).size() == 0) {
                    this.jobsByGroup.remove(jobKey.getGroup());
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeJobs(List<JobKey> list) throws JobPersistenceException {
        boolean bl = true;
        Object object = this.lock;
        synchronized (object) {
            for (JobKey jobKey : list) {
                bl = this.removeJob(jobKey) && bl;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeTriggers(List<TriggerKey> list) throws JobPersistenceException {
        boolean bl = true;
        Object object = this.lock;
        synchronized (object) {
            for (TriggerKey triggerKey : list) {
                bl = this.removeTrigger(triggerKey) && bl;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeJobsAndTriggers(Map<JobDetail, Set<? extends Trigger>> map, boolean bl) throws JobPersistenceException {
        Object object = this.lock;
        synchronized (object) {
            if (!bl) {
                for (Map.Entry<JobDetail, Set<? extends Trigger>> entry : map.entrySet()) {
                    if (this.checkExists(entry.getKey().getKey())) {
                        throw new ObjectAlreadyExistsException(entry.getKey());
                    }
                    for (Trigger trigger : entry.getValue()) {
                        if (!this.checkExists(trigger.getKey())) continue;
                        throw new ObjectAlreadyExistsException(trigger);
                    }
                }
            }
            for (Map.Entry<JobDetail, Set<? extends Trigger>> entry : map.entrySet()) {
                this.storeJob(entry.getKey(), true);
                for (Trigger trigger : entry.getValue()) {
                    this.storeTrigger((OperableTrigger)trigger, true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeTrigger(OperableTrigger operableTrigger, boolean bl) throws JobPersistenceException {
        TriggerWrapper triggerWrapper = new TriggerWrapper((OperableTrigger)operableTrigger.clone());
        Object object = this.lock;
        synchronized (object) {
            if (this.triggersByKey.get(triggerWrapper.key) != null) {
                if (!bl) {
                    throw new ObjectAlreadyExistsException(operableTrigger);
                }
                this.removeTrigger(operableTrigger.getKey(), false);
            }
            if (this.retrieveJob(operableTrigger.getJobKey()) == null) {
                throw new JobPersistenceException("The job (" + operableTrigger.getJobKey() + ") referenced by the trigger does not exist.");
            }
            this.triggers.add(triggerWrapper);
            HashMap<TriggerKey, TriggerWrapper> hashMap = this.triggersByGroup.get(operableTrigger.getKey().getGroup());
            if (hashMap == null) {
                hashMap = new HashMap(100);
                this.triggersByGroup.put(operableTrigger.getKey().getGroup(), hashMap);
            }
            hashMap.put(operableTrigger.getKey(), triggerWrapper);
            this.triggersByKey.put(triggerWrapper.key, triggerWrapper);
            if (this.pausedTriggerGroups.contains(operableTrigger.getKey().getGroup()) || this.pausedJobGroups.contains(operableTrigger.getJobKey().getGroup())) {
                triggerWrapper.state = 4;
                if (this.blockedJobs.contains(triggerWrapper.jobKey)) {
                    triggerWrapper.state = 6;
                }
            } else if (this.blockedJobs.contains(triggerWrapper.jobKey)) {
                triggerWrapper.state = 5;
            } else {
                this.timeTriggers.add(triggerWrapper);
            }
        }
    }

    @Override
    public boolean removeTrigger(TriggerKey triggerKey) {
        return this.removeTrigger(triggerKey, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeTrigger(TriggerKey triggerKey, boolean bl) {
        boolean bl2;
        Object object = this.lock;
        synchronized (object) {
            boolean bl3 = bl2 = this.triggersByKey.remove(triggerKey) != null;
            if (bl2) {
                TriggerWrapper triggerWrapper = null;
                HashMap<TriggerKey, TriggerWrapper> hashMap = this.triggersByGroup.get(triggerKey.getGroup());
                if (hashMap != null) {
                    hashMap.remove(triggerKey);
                    if (hashMap.size() == 0) {
                        this.triggersByGroup.remove(triggerKey.getGroup());
                    }
                }
                Iterator<TriggerWrapper> iterator = this.triggers.iterator();
                while (iterator.hasNext()) {
                    triggerWrapper = iterator.next();
                    if (!triggerKey.equals(triggerWrapper.key)) continue;
                    iterator.remove();
                    break;
                }
                this.timeTriggers.remove(triggerWrapper);
                if (bl) {
                    JobWrapper jobWrapper = this.jobsByKey.get(triggerWrapper.jobKey);
                    List<OperableTrigger> list = this.getTriggersForJob(triggerWrapper.jobKey);
                    if ((list == null || list.size() == 0) && !jobWrapper.jobDetail.isDurable() && this.removeJob(jobWrapper.key)) {
                        this.signaler.notifySchedulerListenersJobDeleted(jobWrapper.key);
                    }
                }
            }
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replaceTrigger(TriggerKey triggerKey, OperableTrigger operableTrigger) throws JobPersistenceException {
        boolean bl;
        Object object = this.lock;
        synchronized (object) {
            TriggerWrapper triggerWrapper = this.triggersByKey.remove(triggerKey);
            boolean bl2 = bl = triggerWrapper != null;
            if (bl) {
                if (!triggerWrapper.getTrigger().getJobKey().equals(operableTrigger.getJobKey())) {
                    throw new JobPersistenceException("New trigger is not related to the same job as the old trigger.");
                }
                triggerWrapper = null;
                HashMap<TriggerKey, TriggerWrapper> hashMap = this.triggersByGroup.get(triggerKey.getGroup());
                if (hashMap != null) {
                    hashMap.remove(triggerKey);
                    if (hashMap.size() == 0) {
                        this.triggersByGroup.remove(triggerKey.getGroup());
                    }
                }
                Iterator<TriggerWrapper> iterator = this.triggers.iterator();
                while (iterator.hasNext()) {
                    triggerWrapper = iterator.next();
                    if (!triggerKey.equals(triggerWrapper.key)) continue;
                    iterator.remove();
                    break;
                }
                this.timeTriggers.remove(triggerWrapper);
                try {
                    this.storeTrigger(operableTrigger, false);
                }
                catch (JobPersistenceException jobPersistenceException) {
                    this.storeTrigger(triggerWrapper.getTrigger(), false);
                    throw jobPersistenceException;
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobDetail retrieveJob(JobKey jobKey) {
        Object object = this.lock;
        synchronized (object) {
            JobWrapper jobWrapper = this.jobsByKey.get(jobKey);
            return jobWrapper != null ? (JobDetail)jobWrapper.jobDetail.clone() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperableTrigger retrieveTrigger(TriggerKey triggerKey) {
        Object object = this.lock;
        synchronized (object) {
            TriggerWrapper triggerWrapper = this.triggersByKey.get(triggerKey);
            return triggerWrapper != null ? (OperableTrigger)triggerWrapper.getTrigger().clone() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkExists(JobKey jobKey) throws JobPersistenceException {
        Object object = this.lock;
        synchronized (object) {
            JobWrapper jobWrapper = this.jobsByKey.get(jobKey);
            return jobWrapper != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkExists(TriggerKey triggerKey) throws JobPersistenceException {
        Object object = this.lock;
        synchronized (object) {
            TriggerWrapper triggerWrapper = this.triggersByKey.get(triggerKey);
            return triggerWrapper != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Trigger.TriggerState getTriggerState(TriggerKey triggerKey) throws JobPersistenceException {
        Object object = this.lock;
        synchronized (object) {
            TriggerWrapper triggerWrapper = this.triggersByKey.get(triggerKey);
            if (triggerWrapper == null) {
                return Trigger.TriggerState.NONE;
            }
            if (triggerWrapper.state == 3) {
                return Trigger.TriggerState.COMPLETE;
            }
            if (triggerWrapper.state == 4) {
                return Trigger.TriggerState.PAUSED;
            }
            if (triggerWrapper.state == 6) {
                return Trigger.TriggerState.PAUSED;
            }
            if (triggerWrapper.state == 5) {
                return Trigger.TriggerState.BLOCKED;
            }
            if (triggerWrapper.state == 7) {
                return Trigger.TriggerState.ERROR;
            }
            return Trigger.TriggerState.NORMAL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeCalendar(String string, Calendar calendar, boolean bl, boolean bl2) throws ObjectAlreadyExistsException {
        calendar = (Calendar)calendar.clone();
        Object object = this.lock;
        synchronized (object) {
            Calendar calendar2 = this.calendarsByName.get(string);
            if (calendar2 != null && !bl) {
                throw new ObjectAlreadyExistsException("Calendar with name '" + string + "' already exists.");
            }
            if (calendar2 != null) {
                this.calendarsByName.remove(string);
            }
            this.calendarsByName.put(string, calendar);
            if (calendar2 != null && bl2) {
                for (TriggerWrapper triggerWrapper : this.getTriggerWrappersForCalendar(string)) {
                    OperableTrigger operableTrigger = triggerWrapper.getTrigger();
                    boolean bl3 = this.timeTriggers.remove(triggerWrapper);
                    operableTrigger.updateWithNewCalendar(calendar, this.getMisfireThreshold());
                    if (!bl3) continue;
                    this.timeTriggers.add(triggerWrapper);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeCalendar(String string) throws JobPersistenceException {
        int n = 0;
        Object object = this.lock;
        synchronized (object) {
            for (TriggerWrapper triggerWrapper : this.triggers) {
                OperableTrigger operableTrigger = triggerWrapper.trigger;
                if (operableTrigger.getCalendarName() == null || !operableTrigger.getCalendarName().equals(string)) continue;
                ++n;
            }
        }
        if (n > 0) {
            throw new JobPersistenceException("Calender cannot be removed if it referenced by a Trigger!");
        }
        return this.calendarsByName.remove(string) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Calendar retrieveCalendar(String string) {
        Object object = this.lock;
        synchronized (object) {
            Calendar calendar = this.calendarsByName.get(string);
            if (calendar != null) {
                return (Calendar)calendar.clone();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfJobs() {
        Object object = this.lock;
        synchronized (object) {
            return this.jobsByKey.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfTriggers() {
        Object object = this.lock;
        synchronized (object) {
            return this.triggers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfCalendars() {
        Object object = this.lock;
        synchronized (object) {
            return this.calendarsByName.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<JobKey> getJobKeys(GroupMatcher<JobKey> groupMatcher) {
        HashSet<Object> hashSet = null;
        Object object = this.lock;
        synchronized (object) {
            StringMatcher.StringOperatorName stringOperatorName = groupMatcher.getCompareWithOperator();
            String string = groupMatcher.getCompareToValue();
            switch (stringOperatorName) {
                case EQUALS: {
                    HashMap<JobKey, JobWrapper> hashMap = this.jobsByGroup.get(string);
                    if (hashMap == null) break;
                    hashSet = new HashSet();
                    for (JobWrapper jobWrapper : hashMap.values()) {
                        if (jobWrapper == null) continue;
                        hashSet.add(jobWrapper.jobDetail.getKey());
                    }
                    break;
                }
                default: {
                    for (Map.Entry<String, HashMap<JobKey, JobWrapper>> entry : this.jobsByGroup.entrySet()) {
                        if (!stringOperatorName.evaluate(entry.getKey(), string) || entry.getValue() == null) continue;
                        if (hashSet == null) {
                            hashSet = new HashSet();
                        }
                        for (JobWrapper jobWrapper : entry.getValue().values()) {
                            if (jobWrapper == null) continue;
                            hashSet.add(jobWrapper.jobDetail.getKey());
                        }
                    }
                }
            }
        }
        return hashSet == null ? Collections.emptySet() : hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getCalendarNames() {
        Object object = this.lock;
        synchronized (object) {
            return new LinkedList<String>(this.calendarsByName.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<TriggerKey> getTriggerKeys(GroupMatcher<TriggerKey> groupMatcher) {
        HashSet<Object> hashSet = null;
        Object object = this.lock;
        synchronized (object) {
            StringMatcher.StringOperatorName stringOperatorName = groupMatcher.getCompareWithOperator();
            String string = groupMatcher.getCompareToValue();
            switch (stringOperatorName) {
                case EQUALS: {
                    HashMap<TriggerKey, TriggerWrapper> hashMap = this.triggersByGroup.get(string);
                    if (hashMap == null) break;
                    hashSet = new HashSet();
                    for (TriggerWrapper triggerWrapper : hashMap.values()) {
                        if (triggerWrapper == null) continue;
                        hashSet.add(triggerWrapper.trigger.getKey());
                    }
                    break;
                }
                default: {
                    for (Map.Entry<String, HashMap<TriggerKey, TriggerWrapper>> entry : this.triggersByGroup.entrySet()) {
                        if (!stringOperatorName.evaluate(entry.getKey(), string) || entry.getValue() == null) continue;
                        if (hashSet == null) {
                            hashSet = new HashSet();
                        }
                        for (TriggerWrapper triggerWrapper : entry.getValue().values()) {
                            if (triggerWrapper == null) continue;
                            hashSet.add(triggerWrapper.trigger.getKey());
                        }
                    }
                }
            }
        }
        return hashSet == null ? Collections.emptySet() : hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getJobGroupNames() {
        LinkedList<String> linkedList;
        Object object = this.lock;
        synchronized (object) {
            linkedList = new LinkedList<String>(this.jobsByGroup.keySet());
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getTriggerGroupNames() {
        LinkedList<String> linkedList;
        Object object = this.lock;
        synchronized (object) {
            linkedList = new LinkedList<String>(this.triggersByGroup.keySet());
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OperableTrigger> getTriggersForJob(JobKey jobKey) {
        ArrayList<OperableTrigger> arrayList = new ArrayList<OperableTrigger>();
        Object object = this.lock;
        synchronized (object) {
            for (TriggerWrapper triggerWrapper : this.triggers) {
                if (!triggerWrapper.jobKey.equals(jobKey)) continue;
                arrayList.add((OperableTrigger)triggerWrapper.trigger.clone());
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList<TriggerWrapper> getTriggerWrappersForJob(JobKey jobKey) {
        ArrayList<TriggerWrapper> arrayList = new ArrayList<TriggerWrapper>();
        Object object = this.lock;
        synchronized (object) {
            for (TriggerWrapper triggerWrapper : this.triggers) {
                if (!triggerWrapper.jobKey.equals(jobKey)) continue;
                arrayList.add(triggerWrapper);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList<TriggerWrapper> getTriggerWrappersForCalendar(String string) {
        ArrayList<TriggerWrapper> arrayList = new ArrayList<TriggerWrapper>();
        Object object = this.lock;
        synchronized (object) {
            for (TriggerWrapper triggerWrapper : this.triggers) {
                String string2 = triggerWrapper.getTrigger().getCalendarName();
                if (string2 == null || !string2.equals(string)) continue;
                arrayList.add(triggerWrapper);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pauseTrigger(TriggerKey triggerKey) {
        Object object = this.lock;
        synchronized (object) {
            TriggerWrapper triggerWrapper = this.triggersByKey.get(triggerKey);
            if (triggerWrapper == null || triggerWrapper.trigger == null) {
                return;
            }
            if (triggerWrapper.state == 3) {
                return;
            }
            triggerWrapper.state = triggerWrapper.state == 5 ? 6 : 4;
            this.timeTriggers.remove(triggerWrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> pauseTriggers(GroupMatcher<TriggerKey> groupMatcher) {
        LinkedList<String> linkedList;
        Object object = this.lock;
        synchronized (object) {
            linkedList = new LinkedList<String>();
            StringMatcher.StringOperatorName stringOperatorName = groupMatcher.getCompareWithOperator();
            switch (stringOperatorName) {
                case EQUALS: {
                    if (!this.pausedTriggerGroups.add(groupMatcher.getCompareToValue())) break;
                    linkedList.add(groupMatcher.getCompareToValue());
                    break;
                }
                default: {
                    for (String string : this.triggersByGroup.keySet()) {
                        if (!stringOperatorName.evaluate(string, groupMatcher.getCompareToValue()) || !this.pausedTriggerGroups.add(groupMatcher.getCompareToValue())) continue;
                        linkedList.add(string);
                    }
                }
            }
            for (String string : linkedList) {
                Set<TriggerKey> set = this.getTriggerKeys(GroupMatcher.triggerGroupEquals(string));
                for (TriggerKey triggerKey : set) {
                    this.pauseTrigger(triggerKey);
                }
            }
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pauseJob(JobKey jobKey) {
        Object object = this.lock;
        synchronized (object) {
            List<OperableTrigger> list = this.getTriggersForJob(jobKey);
            for (OperableTrigger operableTrigger : list) {
                this.pauseTrigger(operableTrigger.getKey());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> pauseJobs(GroupMatcher<JobKey> groupMatcher) {
        LinkedList<String> linkedList = new LinkedList<String>();
        Object object = this.lock;
        synchronized (object) {
            StringMatcher.StringOperatorName stringOperatorName = groupMatcher.getCompareWithOperator();
            switch (stringOperatorName) {
                case EQUALS: {
                    if (!this.pausedJobGroups.add(groupMatcher.getCompareToValue())) break;
                    linkedList.add(groupMatcher.getCompareToValue());
                    break;
                }
                default: {
                    for (String string : this.jobsByGroup.keySet()) {
                        if (!stringOperatorName.evaluate(string, groupMatcher.getCompareToValue()) || !this.pausedJobGroups.add(string)) continue;
                        linkedList.add(string);
                    }
                }
            }
            for (String string : linkedList) {
                for (JobKey jobKey : this.getJobKeys(GroupMatcher.jobGroupEquals(string))) {
                    List<OperableTrigger> list = this.getTriggersForJob(jobKey);
                    for (OperableTrigger operableTrigger : list) {
                        this.pauseTrigger(operableTrigger.getKey());
                    }
                }
            }
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeTrigger(TriggerKey triggerKey) {
        Object object = this.lock;
        synchronized (object) {
            TriggerWrapper triggerWrapper = this.triggersByKey.get(triggerKey);
            if (triggerWrapper == null || triggerWrapper.trigger == null) {
                return;
            }
            OperableTrigger operableTrigger = triggerWrapper.getTrigger();
            if (triggerWrapper.state != 4 && triggerWrapper.state != 6) {
                return;
            }
            triggerWrapper.state = this.blockedJobs.contains(operableTrigger.getJobKey()) ? 5 : 0;
            this.applyMisfire(triggerWrapper);
            if (triggerWrapper.state == 0) {
                this.timeTriggers.add(triggerWrapper);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> resumeTriggers(GroupMatcher<TriggerKey> groupMatcher) {
        HashSet<String> hashSet = new HashSet<String>();
        Object object = this.lock;
        synchronized (object) {
            Set<TriggerKey> set = this.getTriggerKeys(groupMatcher);
            for (TriggerKey object2 : set) {
                String string;
                hashSet.add(object2.getGroup());
                if (this.triggersByKey.get(object2) != null && this.pausedJobGroups.contains(string = this.triggersByKey.get((Object)object2).jobKey.getGroup())) continue;
                this.resumeTrigger(object2);
            }
            for (String string : hashSet) {
                this.pausedTriggerGroups.remove(string);
            }
        }
        return new ArrayList<String>(hashSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeJob(JobKey jobKey) {
        Object object = this.lock;
        synchronized (object) {
            List<OperableTrigger> list = this.getTriggersForJob(jobKey);
            for (OperableTrigger operableTrigger : list) {
                this.resumeTrigger(operableTrigger.getKey());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> resumeJobs(GroupMatcher<JobKey> groupMatcher) {
        HashSet<String> hashSet = new HashSet<String>();
        Object object = this.lock;
        synchronized (object) {
            Set<JobKey> set = this.getJobKeys(groupMatcher);
            for (String object2 : this.pausedJobGroups) {
                if (!groupMatcher.getCompareWithOperator().evaluate(object2, groupMatcher.getCompareToValue())) continue;
                hashSet.add(object2);
            }
            for (String string : hashSet) {
                this.pausedJobGroups.remove(string);
            }
            for (JobKey jobKey : set) {
                List<OperableTrigger> list = this.getTriggersForJob(jobKey);
                for (OperableTrigger operableTrigger : list) {
                    this.resumeTrigger(operableTrigger.getKey());
                }
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pauseAll() {
        Object object = this.lock;
        synchronized (object) {
            List<String> list = this.getTriggerGroupNames();
            for (String string : list) {
                this.pauseTriggers((GroupMatcher)GroupMatcher.triggerGroupEquals(string));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeAll() {
        Object object = this.lock;
        synchronized (object) {
            this.pausedJobGroups.clear();
            this.resumeTriggers((GroupMatcher)GroupMatcher.anyTriggerGroup());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean applyMisfire(TriggerWrapper triggerWrapper) {
        Date date;
        long l = System.currentTimeMillis();
        if (this.getMisfireThreshold() > 0L) {
            l -= this.getMisfireThreshold();
        }
        if ((date = triggerWrapper.trigger.getNextFireTime()) == null || date.getTime() > l || triggerWrapper.trigger.getMisfireInstruction() == -1) {
            return false;
        }
        Calendar calendar = null;
        if (triggerWrapper.trigger.getCalendarName() != null) {
            calendar = this.retrieveCalendar(triggerWrapper.trigger.getCalendarName());
        }
        this.signaler.notifyTriggerListenersMisfired((OperableTrigger)triggerWrapper.trigger.clone());
        triggerWrapper.trigger.updateAfterMisfire(calendar);
        if (triggerWrapper.trigger.getNextFireTime() == null) {
            triggerWrapper.state = 3;
            this.signaler.notifySchedulerListenersFinalized(triggerWrapper.trigger);
            Object object = this.lock;
            synchronized (object) {
                this.timeTriggers.remove(triggerWrapper);
            }
        } else if (date.equals(triggerWrapper.trigger.getNextFireTime())) {
            return false;
        }
        return true;
    }

    protected String getFiredTriggerRecordId() {
        return String.valueOf(ftrCtr.incrementAndGet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OperableTrigger> acquireNextTriggers(long l, int n, long l2) {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<OperableTrigger> arrayList = new ArrayList<OperableTrigger>();
            HashSet<JobKey> hashSet = new HashSet<JobKey>();
            HashSet<TriggerWrapper> hashSet2 = new HashSet<TriggerWrapper>();
            long l3 = l;
            if (this.timeTriggers.size() == 0) {
                return arrayList;
            }
            while (true) {
                TriggerWrapper triggerWrapper;
                try {
                    triggerWrapper = this.timeTriggers.first();
                    if (triggerWrapper == null) break;
                    this.timeTriggers.remove(triggerWrapper);
                }
                catch (NoSuchElementException noSuchElementException) {
                    break;
                }
                if (triggerWrapper.trigger.getNextFireTime() == null) continue;
                if (this.applyMisfire(triggerWrapper)) {
                    if (triggerWrapper.trigger.getNextFireTime() == null) continue;
                    this.timeTriggers.add(triggerWrapper);
                    continue;
                }
                if (triggerWrapper.getTrigger().getNextFireTime().getTime() > l3) {
                    this.timeTriggers.add(triggerWrapper);
                    break;
                }
                JobKey jobKey = triggerWrapper.trigger.getJobKey();
                JobDetail jobDetail = this.jobsByKey.get((Object)triggerWrapper.trigger.getJobKey()).jobDetail;
                if (jobDetail.isConcurrentExectionDisallowed()) {
                    if (hashSet.contains(jobKey)) {
                        hashSet2.add(triggerWrapper);
                        continue;
                    }
                    hashSet.add(jobKey);
                }
                triggerWrapper.state = 1;
                triggerWrapper.trigger.setFireInstanceId(this.getFiredTriggerRecordId());
                OperableTrigger operableTrigger = (OperableTrigger)triggerWrapper.trigger.clone();
                if (arrayList.isEmpty()) {
                    l3 = Math.max(triggerWrapper.trigger.getNextFireTime().getTime(), System.currentTimeMillis()) + l2;
                }
                arrayList.add(operableTrigger);
                if (arrayList.size() == n) break;
            }
            if (hashSet2.size() > 0) {
                this.timeTriggers.addAll(hashSet2);
            }
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseAcquiredTrigger(OperableTrigger operableTrigger) {
        Object object = this.lock;
        synchronized (object) {
            TriggerWrapper triggerWrapper = this.triggersByKey.get(operableTrigger.getKey());
            if (triggerWrapper != null && triggerWrapper.state == 1) {
                triggerWrapper.state = 0;
                this.timeTriggers.add(triggerWrapper);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TriggerFiredResult> triggersFired(List<OperableTrigger> list) {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<TriggerFiredResult> arrayList = new ArrayList<TriggerFiredResult>();
            for (OperableTrigger operableTrigger : list) {
                Object object2;
                TriggerWrapper triggerWrapper = this.triggersByKey.get(operableTrigger.getKey());
                if (triggerWrapper == null || triggerWrapper.trigger == null || triggerWrapper.state != 1) continue;
                Calendar calendar = null;
                if (triggerWrapper.trigger.getCalendarName() != null && (calendar = this.retrieveCalendar(triggerWrapper.trigger.getCalendarName())) == null) continue;
                Date date = operableTrigger.getPreviousFireTime();
                this.timeTriggers.remove(triggerWrapper);
                triggerWrapper.trigger.triggered(calendar);
                operableTrigger.triggered(calendar);
                triggerWrapper.state = 0;
                TriggerFiredBundle triggerFiredBundle = new TriggerFiredBundle(this.retrieveJob(triggerWrapper.jobKey), operableTrigger, calendar, false, new Date(), operableTrigger.getPreviousFireTime(), date, operableTrigger.getNextFireTime());
                JobDetail jobDetail = triggerFiredBundle.getJobDetail();
                if (jobDetail.isConcurrentExectionDisallowed()) {
                    object2 = this.getTriggerWrappersForJob(jobDetail.getKey());
                    Iterator<TriggerWrapper> iterator = ((ArrayList)object2).iterator();
                    while (iterator.hasNext()) {
                        TriggerWrapper triggerWrapper2 = iterator.next();
                        if (triggerWrapper2.state == 0) {
                            triggerWrapper2.state = 5;
                        }
                        if (triggerWrapper2.state == 4) {
                            triggerWrapper2.state = 6;
                        }
                        this.timeTriggers.remove(triggerWrapper2);
                    }
                    this.blockedJobs.add(jobDetail.getKey());
                } else if (triggerWrapper.trigger.getNextFireTime() != null) {
                    object2 = this.lock;
                    synchronized (object2) {
                        this.timeTriggers.add(triggerWrapper);
                    }
                }
                arrayList.add(new TriggerFiredResult(triggerFiredBundle));
            }
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void triggeredJobComplete(OperableTrigger operableTrigger, JobDetail jobDetail, Trigger.CompletedExecutionInstruction completedExecutionInstruction) {
        Object object = this.lock;
        synchronized (object) {
            JobWrapper jobWrapper = this.jobsByKey.get(jobDetail.getKey());
            TriggerWrapper triggerWrapper = this.triggersByKey.get(operableTrigger.getKey());
            if (jobWrapper != null) {
                Cloneable cloneable;
                JobDetail jobDetail2 = jobWrapper.jobDetail;
                if (jobDetail2.isPersistJobDataAfterExecution()) {
                    cloneable = jobDetail.getJobDataMap();
                    if (cloneable != null) {
                        cloneable = (JobDataMap)((DirtyFlagMap)cloneable).clone();
                        ((DirtyFlagMap)cloneable).clearDirtyFlag();
                    }
                    jobWrapper.jobDetail = jobDetail2 = jobDetail2.getJobBuilder().setJobData((JobDataMap)cloneable).build();
                }
                if (jobDetail2.isConcurrentExectionDisallowed()) {
                    this.blockedJobs.remove(jobDetail2.getKey());
                    cloneable = this.getTriggerWrappersForJob(jobDetail2.getKey());
                    Iterator iterator = ((ArrayList)cloneable).iterator();
                    while (iterator.hasNext()) {
                        TriggerWrapper triggerWrapper2 = (TriggerWrapper)iterator.next();
                        if (triggerWrapper2.state == 5) {
                            triggerWrapper2.state = 0;
                            this.timeTriggers.add(triggerWrapper2);
                        }
                        if (triggerWrapper2.state != 6) continue;
                        triggerWrapper2.state = 4;
                    }
                    this.signaler.signalSchedulingChange(0L);
                }
            } else {
                this.blockedJobs.remove(jobDetail.getKey());
            }
            if (triggerWrapper != null) {
                if (completedExecutionInstruction == Trigger.CompletedExecutionInstruction.DELETE_TRIGGER) {
                    if (operableTrigger.getNextFireTime() == null) {
                        if (triggerWrapper.getTrigger().getNextFireTime() == null) {
                            this.removeTrigger(operableTrigger.getKey());
                        }
                    } else {
                        this.removeTrigger(operableTrigger.getKey());
                        this.signaler.signalSchedulingChange(0L);
                    }
                } else if (completedExecutionInstruction == Trigger.CompletedExecutionInstruction.SET_TRIGGER_COMPLETE) {
                    triggerWrapper.state = 3;
                    this.timeTriggers.remove(triggerWrapper);
                    this.signaler.signalSchedulingChange(0L);
                } else if (completedExecutionInstruction == Trigger.CompletedExecutionInstruction.SET_TRIGGER_ERROR) {
                    this.getLog().info("Trigger " + operableTrigger.getKey() + " set to ERROR state.");
                    triggerWrapper.state = 7;
                    this.signaler.signalSchedulingChange(0L);
                } else if (completedExecutionInstruction == Trigger.CompletedExecutionInstruction.SET_ALL_JOB_TRIGGERS_ERROR) {
                    this.getLog().info("All triggers of Job " + operableTrigger.getJobKey() + " set to ERROR state.");
                    this.setAllTriggersOfJobToState(operableTrigger.getJobKey(), 7);
                    this.signaler.signalSchedulingChange(0L);
                } else if (completedExecutionInstruction == Trigger.CompletedExecutionInstruction.SET_ALL_JOB_TRIGGERS_COMPLETE) {
                    this.setAllTriggersOfJobToState(operableTrigger.getJobKey(), 3);
                    this.signaler.signalSchedulingChange(0L);
                }
            }
        }
    }

    protected void setAllTriggersOfJobToState(JobKey jobKey, int n) {
        ArrayList<TriggerWrapper> arrayList = this.getTriggerWrappersForJob(jobKey);
        for (TriggerWrapper triggerWrapper : arrayList) {
            triggerWrapper.state = n;
            if (n == 0) continue;
            this.timeTriggers.remove(triggerWrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String peekTriggers() {
        StringBuilder stringBuilder = new StringBuilder();
        Object object = this.lock;
        synchronized (object) {
            for (TriggerWrapper triggerWrapper : this.triggersByKey.values()) {
                stringBuilder.append(triggerWrapper.trigger.getKey().getName());
                stringBuilder.append("/");
            }
        }
        stringBuilder.append(" | ");
        object = this.lock;
        synchronized (object) {
            for (TriggerWrapper triggerWrapper : this.timeTriggers) {
                stringBuilder.append(triggerWrapper.trigger.getKey().getName());
                stringBuilder.append("->");
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public Set<String> getPausedTriggerGroups() throws JobPersistenceException {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.pausedTriggerGroups);
        return hashSet;
    }

    @Override
    public void setInstanceId(String string) {
    }

    @Override
    public void setInstanceName(String string) {
    }

    @Override
    public void setThreadPoolSize(int n) {
    }

    @Override
    public long getEstimatedTimeToReleaseAndAcquireTrigger() {
        return 5L;
    }

    @Override
    public boolean isClustered() {
        return false;
    }
}

