/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.plugins.history;

import java.text.MessageFormat;
import java.util.Date;
import org.quartz.JobExecutionContext;
import org.quartz.Matcher;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.TriggerListener;
import org.quartz.impl.matchers.EverythingMatcher;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.SchedulerPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingTriggerHistoryPlugin
implements SchedulerPlugin,
TriggerListener {
    private String name;
    private String triggerFiredMessage = "Trigger {1}.{0} fired job {6}.{5} at: {4, date, HH:mm:ss MM/dd/yyyy}";
    private String triggerMisfiredMessage = "Trigger {1}.{0} misfired job {6}.{5}  at: {4, date, HH:mm:ss MM/dd/yyyy}.  Should have fired at: {3, date, HH:mm:ss MM/dd/yyyy}";
    private String triggerCompleteMessage = "Trigger {1}.{0} completed firing job {6}.{5} at {4, date, HH:mm:ss MM/dd/yyyy} with resulting trigger instruction code: {9}";
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    protected Logger getLog() {
        return this.log;
    }

    public String getTriggerCompleteMessage() {
        return this.triggerCompleteMessage;
    }

    public String getTriggerFiredMessage() {
        return this.triggerFiredMessage;
    }

    public String getTriggerMisfiredMessage() {
        return this.triggerMisfiredMessage;
    }

    public void setTriggerCompleteMessage(String string) {
        this.triggerCompleteMessage = string;
    }

    public void setTriggerFiredMessage(String string) {
        this.triggerFiredMessage = string;
    }

    public void setTriggerMisfiredMessage(String string) {
        this.triggerMisfiredMessage = string;
    }

    @Override
    public void initialize(String string, Scheduler scheduler, ClassLoadHelper classLoadHelper) throws SchedulerException {
        this.name = string;
        scheduler.getListenerManager().addTriggerListener((TriggerListener)this, (Matcher<TriggerKey>)EverythingMatcher.allTriggers());
    }

    @Override
    public void start() {
    }

    @Override
    public void shutdown() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void triggerFired(Trigger trigger, JobExecutionContext jobExecutionContext) {
        if (!this.getLog().isInfoEnabled()) {
            return;
        }
        Object[] objectArray = new Object[]{trigger.getKey().getName(), trigger.getKey().getGroup(), trigger.getPreviousFireTime(), trigger.getNextFireTime(), new Date(), jobExecutionContext.getJobDetail().getKey().getName(), jobExecutionContext.getJobDetail().getKey().getGroup(), jobExecutionContext.getRefireCount()};
        this.getLog().info(MessageFormat.format(this.getTriggerFiredMessage(), objectArray));
    }

    @Override
    public void triggerMisfired(Trigger trigger) {
        if (!this.getLog().isInfoEnabled()) {
            return;
        }
        Object[] objectArray = new Object[]{trigger.getKey().getName(), trigger.getKey().getGroup(), trigger.getPreviousFireTime(), trigger.getNextFireTime(), new Date(), trigger.getJobKey().getName(), trigger.getJobKey().getGroup()};
        this.getLog().info(MessageFormat.format(this.getTriggerMisfiredMessage(), objectArray));
    }

    @Override
    public void triggerComplete(Trigger trigger, JobExecutionContext jobExecutionContext, Trigger.CompletedExecutionInstruction completedExecutionInstruction) {
        if (!this.getLog().isInfoEnabled()) {
            return;
        }
        String string = "UNKNOWN";
        if (completedExecutionInstruction == Trigger.CompletedExecutionInstruction.DELETE_TRIGGER) {
            string = "DELETE TRIGGER";
        } else if (completedExecutionInstruction == Trigger.CompletedExecutionInstruction.NOOP) {
            string = "DO NOTHING";
        } else if (completedExecutionInstruction == Trigger.CompletedExecutionInstruction.RE_EXECUTE_JOB) {
            string = "RE-EXECUTE JOB";
        } else if (completedExecutionInstruction == Trigger.CompletedExecutionInstruction.SET_ALL_JOB_TRIGGERS_COMPLETE) {
            string = "SET ALL OF JOB'S TRIGGERS COMPLETE";
        } else if (completedExecutionInstruction == Trigger.CompletedExecutionInstruction.SET_TRIGGER_COMPLETE) {
            string = "SET THIS TRIGGER COMPLETE";
        }
        Object[] objectArray = new Object[]{trigger.getKey().getName(), trigger.getKey().getGroup(), trigger.getPreviousFireTime(), trigger.getNextFireTime(), new Date(), jobExecutionContext.getJobDetail().getKey().getName(), jobExecutionContext.getJobDetail().getKey().getGroup(), jobExecutionContext.getRefireCount(), completedExecutionInstruction.toString(), string};
        this.getLog().info(MessageFormat.format(this.getTriggerCompleteMessage(), objectArray));
    }

    @Override
    public boolean vetoJobExecution(Trigger trigger, JobExecutionContext jobExecutionContext) {
        return false;
    }
}

