/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.jobs;

import java.io.File;
import java.io.FileFilter;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;
import org.quartz.jobs.DirectoryScanListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DisallowConcurrentExecution
@PersistJobDataAfterExecution
public class DirectoryScanJob
implements Job {
    public static final String DIRECTORY_NAME = "DIRECTORY_NAME";
    public static final String DIRECTORY_SCAN_LISTENER_NAME = "DIRECTORY_SCAN_LISTENER_NAME";
    public static final String MINIMUM_UPDATE_AGE = "MINIMUM_UPDATE_AGE";
    private static final String LAST_MODIFIED_TIME = "LAST_MODIFIED_TIME";
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        long l;
        File[] fileArray;
        JobDataMap jobDataMap = jobExecutionContext.getMergedJobDataMap();
        SchedulerContext schedulerContext = null;
        try {
            schedulerContext = jobExecutionContext.getScheduler().getContext();
        }
        catch (SchedulerException schedulerException) {
            throw new JobExecutionException("Error obtaining scheduler context.", schedulerException, false);
        }
        String string = jobDataMap.getString(DIRECTORY_NAME);
        String string2 = jobDataMap.getString(DIRECTORY_SCAN_LISTENER_NAME);
        if (string == null) {
            throw new JobExecutionException("Required parameter 'DIRECTORY_NAME' not found in merged JobDataMap");
        }
        if (string2 == null) {
            throw new JobExecutionException("Required parameter 'DIRECTORY_SCAN_LISTENER_NAME' not found in merged JobDataMap");
        }
        DirectoryScanListener directoryScanListener = (DirectoryScanListener)schedulerContext.get(string2);
        if (directoryScanListener == null) {
            throw new JobExecutionException("DirectoryScanListener named '" + string2 + "' not found in SchedulerContext");
        }
        long l2 = -1L;
        if (jobDataMap.containsKey(LAST_MODIFIED_TIME)) {
            l2 = jobDataMap.getLong(LAST_MODIFIED_TIME);
        }
        long l3 = 5000L;
        if (jobDataMap.containsKey(MINIMUM_UPDATE_AGE)) {
            l3 = jobDataMap.getLong(MINIMUM_UPDATE_AGE);
        }
        if ((fileArray = this.getUpdatedOrNewFiles(string, l2, l = System.currentTimeMillis() - l3)) == null) {
            this.log.warn("Directory '" + string + "' does not exist.");
            return;
        }
        long l4 = l2;
        for (File file : fileArray) {
            long l5 = file.lastModified();
            l4 = l5 > l4 ? l5 : l4;
        }
        if (fileArray.length > 0) {
            this.log.info("Directory '" + string + "' contents updated, notifying listener.");
            directoryScanListener.filesUpdatedOrAdded(fileArray);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Directory '" + string + "' contents unchanged.");
        }
        jobExecutionContext.getJobDetail().getJobDataMap().put(LAST_MODIFIED_TIME, l4);
    }

    protected File[] getUpdatedOrNewFiles(String string, final long l, final long l2) {
        File file = new File(string);
        if (!file.exists() || !file.isDirectory()) {
            return null;
        }
        File[] fileArray = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.lastModified() > l && file.lastModified() < l2;
            }
        });
        if (fileArray == null) {
            fileArray = new File[]{};
        }
        return fileArray;
    }
}

