/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.triggers;

import java.util.Date;
import java.util.Set;
import org.quartz.Calendar;
import org.quartz.DailyTimeIntervalScheduleBuilder;
import org.quartz.DailyTimeIntervalTrigger;
import org.quartz.DateBuilder;
import org.quartz.ScheduleBuilder;
import org.quartz.SchedulerException;
import org.quartz.TimeOfDay;
import org.quartz.impl.triggers.AbstractTrigger;
import org.quartz.impl.triggers.CoreTrigger;

public class DailyTimeIntervalTriggerImpl
extends AbstractTrigger<DailyTimeIntervalTrigger>
implements DailyTimeIntervalTrigger,
CoreTrigger {
    private static final long serialVersionUID = -632667786771388749L;
    private static final int YEAR_TO_GIVEUP_SCHEDULING_AT = java.util.Calendar.getInstance().get(1) + 100;
    private Date startTime = null;
    private Date endTime = null;
    private Date nextFireTime = null;
    private Date previousFireTime = null;
    private int repeatCount = -1;
    private int repeatInterval = 1;
    private DateBuilder.IntervalUnit repeatIntervalUnit = DateBuilder.IntervalUnit.MINUTE;
    private Set<Integer> daysOfWeek;
    private TimeOfDay startTimeOfDay;
    private TimeOfDay endTimeOfDay;
    private int timesTriggered = 0;
    private boolean complete = false;

    public DailyTimeIntervalTriggerImpl() {
    }

    public DailyTimeIntervalTriggerImpl(String string, TimeOfDay timeOfDay, TimeOfDay timeOfDay2, DateBuilder.IntervalUnit intervalUnit, int n) {
        this(string, null, timeOfDay, timeOfDay2, intervalUnit, n);
    }

    public DailyTimeIntervalTriggerImpl(String string, String string2, TimeOfDay timeOfDay, TimeOfDay timeOfDay2, DateBuilder.IntervalUnit intervalUnit, int n) {
        this(string, string2, new Date(), null, timeOfDay, timeOfDay2, intervalUnit, n);
    }

    public DailyTimeIntervalTriggerImpl(String string, Date date, Date date2, TimeOfDay timeOfDay, TimeOfDay timeOfDay2, DateBuilder.IntervalUnit intervalUnit, int n) {
        this(string, null, date, date2, timeOfDay, timeOfDay2, intervalUnit, n);
    }

    public DailyTimeIntervalTriggerImpl(String string, String string2, Date date, Date date2, TimeOfDay timeOfDay, TimeOfDay timeOfDay2, DateBuilder.IntervalUnit intervalUnit, int n) {
        super(string, string2);
        this.setStartTime(date);
        this.setEndTime(date2);
        this.setRepeatIntervalUnit(intervalUnit);
        this.setRepeatInterval(n);
        this.setStartTimeOfDay(timeOfDay);
        this.setEndTimeOfDay(timeOfDay2);
    }

    public DailyTimeIntervalTriggerImpl(String string, String string2, String string3, String string4, Date date, Date date2, TimeOfDay timeOfDay, TimeOfDay timeOfDay2, DateBuilder.IntervalUnit intervalUnit, int n) {
        super(string, string2, string3, string4);
        this.setStartTime(date);
        this.setEndTime(date2);
        this.setRepeatIntervalUnit(intervalUnit);
        this.setRepeatInterval(n);
        this.setStartTimeOfDay(timeOfDay);
        this.setEndTimeOfDay(timeOfDay2);
    }

    @Override
    public Date getStartTime() {
        if (this.startTime == null) {
            this.startTime = new Date();
        }
        return this.startTime;
    }

    @Override
    public void setStartTime(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("Start time cannot be null");
        }
        Date date2 = this.getEndTime();
        if (date2 != null && date2.before(date)) {
            throw new IllegalArgumentException("End time cannot be before start time");
        }
        this.startTime = date;
    }

    @Override
    public Date getEndTime() {
        return this.endTime;
    }

    @Override
    public void setEndTime(Date date) {
        Date date2 = this.getStartTime();
        if (date2 != null && date != null && date2.after(date)) {
            throw new IllegalArgumentException("End time cannot be before start time");
        }
        this.endTime = date;
    }

    @Override
    public DateBuilder.IntervalUnit getRepeatIntervalUnit() {
        return this.repeatIntervalUnit;
    }

    public void setRepeatIntervalUnit(DateBuilder.IntervalUnit intervalUnit) {
        if (this.repeatIntervalUnit == null || !this.repeatIntervalUnit.equals((Object)DateBuilder.IntervalUnit.SECOND) && !this.repeatIntervalUnit.equals((Object)DateBuilder.IntervalUnit.MINUTE) && !this.repeatIntervalUnit.equals((Object)DateBuilder.IntervalUnit.HOUR)) {
            throw new IllegalArgumentException("Invalid repeat IntervalUnit (must be SECOND, MINUTE or HOUR).");
        }
        this.repeatIntervalUnit = intervalUnit;
    }

    @Override
    public int getRepeatInterval() {
        return this.repeatInterval;
    }

    public void setRepeatInterval(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Repeat interval must be >= 1");
        }
        this.repeatInterval = n;
    }

    @Override
    public int getTimesTriggered() {
        return this.timesTriggered;
    }

    public void setTimesTriggered(int n) {
        this.timesTriggered = n;
    }

    @Override
    protected boolean validateMisfireInstruction(int n) {
        return n >= -1 && n <= 2;
    }

    @Override
    public void updateAfterMisfire(Calendar calendar) {
        int n = this.getMisfireInstruction();
        if (n == -1) {
            return;
        }
        if (n == 0) {
            n = 1;
        }
        if (n == 2) {
            Date date = this.getFireTimeAfter(new Date());
            while (date != null && calendar != null && !calendar.isTimeIncluded(date.getTime())) {
                date = this.getFireTimeAfter(date);
            }
            this.setNextFireTime(date);
        } else if (n == 1) {
            this.setNextFireTime(new Date());
        }
    }

    @Override
    public void triggered(Calendar calendar) {
        ++this.timesTriggered;
        this.previousFireTime = this.nextFireTime;
        this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
        while (this.nextFireTime != null && calendar != null && !calendar.isTimeIncluded(this.nextFireTime.getTime())) {
            this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
            if (this.nextFireTime == null) break;
            java.util.Calendar calendar2 = java.util.Calendar.getInstance();
            calendar2.setTime(this.nextFireTime);
            if (calendar2.get(1) <= YEAR_TO_GIVEUP_SCHEDULING_AT) continue;
            this.nextFireTime = null;
        }
        if (this.nextFireTime == null) {
            this.complete = true;
        }
    }

    @Override
    public void updateWithNewCalendar(Calendar calendar, long l) {
        this.nextFireTime = this.getFireTimeAfter(this.previousFireTime);
        if (this.nextFireTime == null || calendar == null) {
            return;
        }
        Date date = new Date();
        while (this.nextFireTime != null && !calendar.isTimeIncluded(this.nextFireTime.getTime())) {
            long l2;
            this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
            if (this.nextFireTime == null) break;
            java.util.Calendar calendar2 = java.util.Calendar.getInstance();
            calendar2.setTime(this.nextFireTime);
            if (calendar2.get(1) > YEAR_TO_GIVEUP_SCHEDULING_AT) {
                this.nextFireTime = null;
            }
            if (this.nextFireTime == null || !this.nextFireTime.before(date) || (l2 = date.getTime() - this.nextFireTime.getTime()) < l) continue;
            this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
        }
    }

    @Override
    public Date computeFirstFireTime(Calendar calendar) {
        this.nextFireTime = this.getFireTimeAfter(new Date(this.getStartTime().getTime() - 1000L));
        while (this.nextFireTime != null && calendar != null && !calendar.isTimeIncluded(this.nextFireTime.getTime())) {
            this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
            if (this.nextFireTime == null) break;
            java.util.Calendar calendar2 = java.util.Calendar.getInstance();
            calendar2.setTime(this.nextFireTime);
            if (calendar2.get(1) <= YEAR_TO_GIVEUP_SCHEDULING_AT) continue;
            return null;
        }
        return this.nextFireTime;
    }

    private java.util.Calendar createCalendarTime(Date date) {
        java.util.Calendar calendar = java.util.Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    @Override
    public Date getNextFireTime() {
        return this.nextFireTime;
    }

    @Override
    public Date getPreviousFireTime() {
        return this.previousFireTime;
    }

    @Override
    public void setNextFireTime(Date date) {
        this.nextFireTime = date;
    }

    @Override
    public void setPreviousFireTime(Date date) {
        this.previousFireTime = date;
    }

    @Override
    public Date getFireTimeAfter(Date date) {
        Date date2;
        if (this.complete) {
            return null;
        }
        if (this.repeatCount != -1 && this.timesTriggered > this.repeatCount) {
            return null;
        }
        if ((date = date == null ? new Date(System.currentTimeMillis() + 1000L) : new Date(date.getTime() + 1000L)).before(this.startTime)) {
            date = this.startTime;
        }
        boolean bl = false;
        if (this.endTimeOfDay != null) {
            boolean bl2 = bl = date.getTime() > this.endTimeOfDay.getTimeOfDayForDate(date).getTime();
        }
        if ((date2 = this.advanceToNextDayOfWeekIfNecessary(date, bl)) == null) {
            return null;
        }
        Date date3 = null;
        date3 = this.endTimeOfDay == null ? new TimeOfDay(23, 59, 59).getTimeOfDayForDate(date2) : this.endTimeOfDay.getTimeOfDayForDate(date2);
        Date date4 = this.startTimeOfDay.getTimeOfDayForDate(date2);
        if (date2.before(date4)) {
            return date4;
        }
        long l = date2.getTime();
        long l2 = date4.getTime();
        long l3 = (l - l2) / 1000L;
        long l4 = this.getRepeatInterval();
        java.util.Calendar calendar = this.createCalendarTime(date4);
        DateBuilder.IntervalUnit intervalUnit = this.getRepeatIntervalUnit();
        if (intervalUnit.equals((Object)DateBuilder.IntervalUnit.SECOND)) {
            long l5 = l3 / l4;
            if (l3 % l4 != 0L) {
                ++l5;
            }
            calendar.add(13, this.getRepeatInterval() * (int)l5);
            date2 = calendar.getTime();
        } else if (intervalUnit.equals((Object)DateBuilder.IntervalUnit.MINUTE)) {
            long l6 = l3 / (l4 * 60L);
            if (l3 % (l4 * 60L) != 0L) {
                ++l6;
            }
            calendar.add(12, this.getRepeatInterval() * (int)l6);
            date2 = calendar.getTime();
        } else if (intervalUnit.equals((Object)DateBuilder.IntervalUnit.HOUR)) {
            long l7 = l3 / (l4 * 60L * 60L);
            if (l3 % (l4 * 60L * 60L) != 0L) {
                ++l7;
            }
            calendar.add(11, this.getRepeatInterval() * (int)l7);
            date2 = calendar.getTime();
        }
        if (date2.after(date3)) {
            date2 = this.advanceToNextDayOfWeekIfNecessary(date2, this.isSameDay(date2, date3));
            date2 = this.startTimeOfDay.getTimeOfDayForDate(date2);
        }
        return date2;
    }

    private boolean isSameDay(Date date, Date date2) {
        java.util.Calendar calendar = this.createCalendarTime(date);
        java.util.Calendar calendar2 = this.createCalendarTime(date2);
        return calendar.get(1) == calendar2.get(1) && calendar.get(6) == calendar2.get(6);
    }

    private Date advanceToNextDayOfWeekIfNecessary(Date date, boolean bl) {
        Date date2;
        TimeOfDay timeOfDay = this.getStartTimeOfDay();
        Date date3 = timeOfDay.getTimeOfDayForDate(date);
        java.util.Calendar calendar = this.createCalendarTime(date3);
        int n = calendar.get(7);
        Set<Integer> set = this.getDaysOfWeek();
        if (bl || !set.contains(n)) {
            for (int i = 1; i <= 7; ++i) {
                calendar.add(5, 1);
                n = calendar.get(7);
                if (!set.contains(n)) continue;
                date = calendar.getTime();
                break;
            }
        }
        if ((date2 = this.getEndTime()) != null && date.getTime() > date2.getTime()) {
            return null;
        }
        return date;
    }

    @Override
    public Date getFinalFireTime() {
        if (this.complete || this.getEndTime() == null) {
            return null;
        }
        Date date = this.getEndTime();
        if (this.endTimeOfDay != null) {
            Date date2 = this.endTimeOfDay.getTimeOfDayForDate(date);
            if (date.getTime() < date2.getTime()) {
                date = date2;
            }
        }
        return date;
    }

    @Override
    public boolean mayFireAgain() {
        return this.getNextFireTime() != null;
    }

    @Override
    public void validate() throws SchedulerException {
        super.validate();
        if (this.repeatIntervalUnit == null || !this.repeatIntervalUnit.equals((Object)DateBuilder.IntervalUnit.SECOND) && !this.repeatIntervalUnit.equals((Object)DateBuilder.IntervalUnit.MINUTE) && !this.repeatIntervalUnit.equals((Object)DateBuilder.IntervalUnit.HOUR)) {
            throw new SchedulerException("Invalid repeat IntervalUnit (must be SECOND, MINUTE or HOUR).");
        }
        if (this.repeatInterval < 1) {
            throw new SchedulerException("Repeat Interval cannot be zero.");
        }
        long l = 86400L;
        if (this.repeatIntervalUnit == DateBuilder.IntervalUnit.SECOND && (long)this.repeatInterval > l) {
            throw new SchedulerException("repeatInterval can not exceed 24 hours (" + l + " seconds). Given " + this.repeatInterval);
        }
        if (this.repeatIntervalUnit == DateBuilder.IntervalUnit.MINUTE && (long)this.repeatInterval > l / 60L) {
            throw new SchedulerException("repeatInterval can not exceed 24 hours (" + l / 60L + " minutes). Given " + this.repeatInterval);
        }
        if (this.repeatIntervalUnit == DateBuilder.IntervalUnit.HOUR && this.repeatInterval > 24) {
            throw new SchedulerException("repeatInterval can not exceed 24 hours. Given " + this.repeatInterval + " hours.");
        }
        if (this.getEndTimeOfDay() != null && !this.getStartTimeOfDay().before(this.getEndTimeOfDay())) {
            throw new SchedulerException("StartTimeOfDay " + this.startTimeOfDay + " should not come after endTimeOfDay " + this.endTimeOfDay);
        }
    }

    @Override
    public Set<Integer> getDaysOfWeek() {
        if (this.daysOfWeek == null) {
            this.daysOfWeek = DailyTimeIntervalScheduleBuilder.ALL_DAYS_OF_THE_WEEK;
        }
        return this.daysOfWeek;
    }

    public void setDaysOfWeek(Set<Integer> set) {
        if (set == null || set.size() == 0) {
            throw new IllegalArgumentException("DaysOfWeek set must be a set that contains at least one day.");
        }
        if (set.size() == 0) {
            throw new IllegalArgumentException("DaysOfWeek set must contain at least one day.");
        }
        this.daysOfWeek = set;
    }

    @Override
    public TimeOfDay getStartTimeOfDay() {
        if (this.startTimeOfDay == null) {
            this.startTimeOfDay = new TimeOfDay(0, 0, 0);
        }
        return this.startTimeOfDay;
    }

    public void setStartTimeOfDay(TimeOfDay timeOfDay) {
        if (timeOfDay == null) {
            throw new IllegalArgumentException("Start time of day cannot be null");
        }
        TimeOfDay timeOfDay2 = this.getEndTimeOfDay();
        if (timeOfDay2 != null && timeOfDay2.before(timeOfDay)) {
            throw new IllegalArgumentException("End time of day cannot be before start time of day");
        }
        this.startTimeOfDay = timeOfDay;
    }

    @Override
    public TimeOfDay getEndTimeOfDay() {
        return this.endTimeOfDay;
    }

    public void setEndTimeOfDay(TimeOfDay timeOfDay) {
        if (timeOfDay == null) {
            throw new IllegalArgumentException("End time of day cannot be null");
        }
        TimeOfDay timeOfDay2 = this.getStartTimeOfDay();
        if (timeOfDay2 != null && timeOfDay.before(timeOfDay)) {
            throw new IllegalArgumentException("End time of day cannot be before start time of day");
        }
        this.endTimeOfDay = timeOfDay;
    }

    @Override
    public ScheduleBuilder<DailyTimeIntervalTrigger> getScheduleBuilder() {
        DailyTimeIntervalScheduleBuilder dailyTimeIntervalScheduleBuilder = DailyTimeIntervalScheduleBuilder.dailyTimeIntervalSchedule().withInterval(this.getRepeatInterval(), this.getRepeatIntervalUnit()).onDaysOfTheWeek(this.getDaysOfWeek()).startingDailyAt(this.getStartTimeOfDay()).endingDailyAt(this.getEndTimeOfDay());
        switch (this.getMisfireInstruction()) {
            case 2: {
                dailyTimeIntervalScheduleBuilder.withMisfireHandlingInstructionDoNothing();
                break;
            }
            case 1: {
                dailyTimeIntervalScheduleBuilder.withMisfireHandlingInstructionFireAndProceed();
            }
        }
        return dailyTimeIntervalScheduleBuilder;
    }

    @Override
    public boolean hasAdditionalProperties() {
        return false;
    }

    @Override
    public int getRepeatCount() {
        return this.repeatCount;
    }

    public void setRepeatCount(int n) {
        if (n < 0 && n != -1) {
            throw new IllegalArgumentException("Repeat count must be >= 0, use the constant REPEAT_INDEFINITELY for infinite.");
        }
        this.repeatCount = n;
    }
}

