/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.quartz.Calendar;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobPersistenceException;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.SchedulerConfigException;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.DefaultThreadExecutor;
import org.quartz.impl.jdbcjobstore.AttributeRestoringConnectionInvocationHandler;
import org.quartz.impl.jdbcjobstore.Constants;
import org.quartz.impl.jdbcjobstore.DriverDelegate;
import org.quartz.impl.jdbcjobstore.FiredTriggerRecord;
import org.quartz.impl.jdbcjobstore.InvalidConfigurationException;
import org.quartz.impl.jdbcjobstore.LockException;
import org.quartz.impl.jdbcjobstore.MSSQLDelegate;
import org.quartz.impl.jdbcjobstore.NoSuchDelegateException;
import org.quartz.impl.jdbcjobstore.SchedulerStateRecord;
import org.quartz.impl.jdbcjobstore.Semaphore;
import org.quartz.impl.jdbcjobstore.SimpleSemaphore;
import org.quartz.impl.jdbcjobstore.StdJDBCDelegate;
import org.quartz.impl.jdbcjobstore.StdRowLockSemaphore;
import org.quartz.impl.jdbcjobstore.TriggerStatus;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.impl.matchers.StringMatcher;
import org.quartz.impl.triggers.SimpleTriggerImpl;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.JobStore;
import org.quartz.spi.OperableTrigger;
import org.quartz.spi.SchedulerSignaler;
import org.quartz.spi.ThreadExecutor;
import org.quartz.spi.TriggerFiredBundle;
import org.quartz.spi.TriggerFiredResult;
import org.quartz.utils.DBConnectionManager;
import org.quartz.utils.Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JobStoreSupport
implements JobStore,
Constants {
    protected static final String LOCK_TRIGGER_ACCESS = "TRIGGER_ACCESS";
    protected static final String LOCK_STATE_ACCESS = "STATE_ACCESS";
    protected String dsName;
    protected String tablePrefix = "QRTZ_";
    protected boolean useProperties = false;
    protected String instanceId;
    protected String instanceName;
    protected String delegateClassName;
    protected String delegateInitString;
    protected Class<? extends DriverDelegate> delegateClass = StdJDBCDelegate.class;
    protected HashMap<String, Calendar> calendarCache = new HashMap();
    private DriverDelegate delegate;
    private long misfireThreshold = 60000L;
    private boolean dontSetAutoCommitFalse = false;
    private boolean isClustered = false;
    private boolean useDBLocks = false;
    private boolean lockOnInsert = true;
    private Semaphore lockHandler = null;
    private String selectWithLockSQL = null;
    private long clusterCheckinInterval = 7500L;
    private ClusterManager clusterManagementThread = null;
    private MisfireHandler misfireHandler = null;
    private ClassLoadHelper classLoadHelper;
    private SchedulerSignaler schedSignaler;
    protected int maxToRecoverAtATime = 20;
    private boolean setTxIsolationLevelSequential = false;
    private boolean acquireTriggersWithinLock = false;
    private long dbRetryInterval = 15000L;
    private boolean makeThreadsDaemons = false;
    private boolean threadsInheritInitializersClassLoadContext = false;
    private ClassLoader initializersLoader = null;
    private boolean doubleCheckLockMisfireHandler = true;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ThreadExecutor threadExecutor = new DefaultThreadExecutor();
    private volatile boolean schedulerRunning = false;
    private volatile boolean shutdown = false;
    private static long ftrCtr = System.currentTimeMillis();
    protected ThreadLocal<Long> sigChangeForTxCompletion = new ThreadLocal();
    protected boolean firstCheckIn = true;
    protected long lastCheckin = System.currentTimeMillis();

    public void setDataSource(String string) {
        this.dsName = string;
    }

    public String getDataSource() {
        return this.dsName;
    }

    public void setTablePrefix(String string) {
        if (string == null) {
            string = "";
        }
        this.tablePrefix = string;
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    public void setUseProperties(String string) {
        if (string == null) {
            string = "false";
        }
        this.useProperties = Boolean.valueOf(string);
    }

    public boolean canUseProperties() {
        return this.useProperties;
    }

    @Override
    public void setInstanceId(String string) {
        this.instanceId = string;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    @Override
    public void setInstanceName(String string) {
        this.instanceName = string;
    }

    @Override
    public void setThreadPoolSize(int n) {
    }

    public void setThreadExecutor(ThreadExecutor threadExecutor) {
        this.threadExecutor = threadExecutor;
    }

    public ThreadExecutor getThreadExecutor() {
        return this.threadExecutor;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    @Override
    public long getEstimatedTimeToReleaseAndAcquireTrigger() {
        return 70L;
    }

    public void setIsClustered(boolean bl) {
        this.isClustered = bl;
    }

    @Override
    public boolean isClustered() {
        return this.isClustered;
    }

    public long getClusterCheckinInterval() {
        return this.clusterCheckinInterval;
    }

    public void setClusterCheckinInterval(long l) {
        this.clusterCheckinInterval = l;
    }

    public int getMaxMisfiresToHandleAtATime() {
        return this.maxToRecoverAtATime;
    }

    public void setMaxMisfiresToHandleAtATime(int n) {
        this.maxToRecoverAtATime = n;
    }

    public long getDbRetryInterval() {
        return this.dbRetryInterval;
    }

    public void setDbRetryInterval(long l) {
        this.dbRetryInterval = l;
    }

    public void setUseDBLocks(boolean bl) {
        this.useDBLocks = bl;
    }

    public boolean getUseDBLocks() {
        return this.useDBLocks;
    }

    public boolean isLockOnInsert() {
        return this.lockOnInsert;
    }

    public void setLockOnInsert(boolean bl) {
        this.lockOnInsert = bl;
    }

    public long getMisfireThreshold() {
        return this.misfireThreshold;
    }

    public void setMisfireThreshold(long l) {
        if (l < 1L) {
            throw new IllegalArgumentException("Misfirethreshold must be larger than 0");
        }
        this.misfireThreshold = l;
    }

    public boolean isDontSetAutoCommitFalse() {
        return this.dontSetAutoCommitFalse;
    }

    public void setDontSetAutoCommitFalse(boolean bl) {
        this.dontSetAutoCommitFalse = bl;
    }

    public boolean isTxIsolationLevelSerializable() {
        return this.setTxIsolationLevelSequential;
    }

    public void setTxIsolationLevelSerializable(boolean bl) {
        this.setTxIsolationLevelSequential = bl;
    }

    public boolean isAcquireTriggersWithinLock() {
        return this.acquireTriggersWithinLock;
    }

    public void setAcquireTriggersWithinLock(boolean bl) {
        this.acquireTriggersWithinLock = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDriverDelegateClass(String string) throws InvalidConfigurationException {
        JobStoreSupport jobStoreSupport = this;
        synchronized (jobStoreSupport) {
            this.delegateClassName = string;
        }
    }

    public String getDriverDelegateClass() {
        return this.delegateClassName;
    }

    public void setDriverDelegateInitString(String string) throws InvalidConfigurationException {
        this.delegateInitString = string;
    }

    public String getDriverDelegateInitString() {
        return this.delegateInitString;
    }

    public String getSelectWithLockSQL() {
        return this.selectWithLockSQL;
    }

    public void setSelectWithLockSQL(String string) {
        this.selectWithLockSQL = string;
    }

    protected ClassLoadHelper getClassLoadHelper() {
        return this.classLoadHelper;
    }

    public boolean getMakeThreadsDaemons() {
        return this.makeThreadsDaemons;
    }

    public void setMakeThreadsDaemons(boolean bl) {
        this.makeThreadsDaemons = bl;
    }

    public boolean isThreadsInheritInitializersClassLoadContext() {
        return this.threadsInheritInitializersClassLoadContext;
    }

    public void setThreadsInheritInitializersClassLoadContext(boolean bl) {
        this.threadsInheritInitializersClassLoadContext = bl;
    }

    public boolean getDoubleCheckLockMisfireHandler() {
        return this.doubleCheckLockMisfireHandler;
    }

    public void setDoubleCheckLockMisfireHandler(boolean bl) {
        this.doubleCheckLockMisfireHandler = bl;
    }

    protected Logger getLog() {
        return this.log;
    }

    @Override
    public void initialize(ClassLoadHelper classLoadHelper, SchedulerSignaler schedulerSignaler) throws SchedulerConfigException {
        if (this.dsName == null) {
            throw new SchedulerConfigException("DataSource name not set.");
        }
        this.classLoadHelper = classLoadHelper;
        if (this.isThreadsInheritInitializersClassLoadContext()) {
            this.log.info("JDBCJobStore threads will inherit ContextClassLoader of thread: " + Thread.currentThread().getName());
            this.initializersLoader = Thread.currentThread().getContextClassLoader();
        }
        this.schedSignaler = schedulerSignaler;
        if (this.getLockHandler() == null) {
            if (this.isClustered()) {
                this.setUseDBLocks(true);
            }
            if (this.getUseDBLocks()) {
                if (this.getDriverDelegateClass() != null && this.getDriverDelegateClass().equals(MSSQLDelegate.class.getName()) && this.getSelectWithLockSQL() == null) {
                    String string = "SELECT * FROM {0}LOCKS WITH (UPDLOCK,ROWLOCK) WHERE SCHED_NAME = {1} AND LOCK_NAME = ?";
                    this.getLog().info("Detected usage of MSSQLDelegate class - defaulting 'selectWithLockSQL' to '" + string + "'.");
                    this.setSelectWithLockSQL(string);
                }
                this.getLog().info("Using db table-based data access locking (synchronization).");
                this.setLockHandler(new StdRowLockSemaphore(this.getTablePrefix(), this.getInstanceName(), this.getSelectWithLockSQL()));
            } else {
                this.getLog().info("Using thread monitor-based data access locking (synchronization).");
                this.setLockHandler(new SimpleSemaphore());
            }
        }
    }

    @Override
    public void schedulerStarted() throws SchedulerException {
        if (this.isClustered()) {
            this.clusterManagementThread = new ClusterManager();
            if (this.initializersLoader != null) {
                this.clusterManagementThread.setContextClassLoader(this.initializersLoader);
            }
            this.clusterManagementThread.initialize();
        } else {
            try {
                this.recoverJobs();
            }
            catch (SchedulerException schedulerException) {
                throw new SchedulerConfigException("Failure occured during job recovery.", schedulerException);
            }
        }
        this.misfireHandler = new MisfireHandler();
        if (this.initializersLoader != null) {
            this.misfireHandler.setContextClassLoader(this.initializersLoader);
        }
        this.misfireHandler.initialize();
        this.schedulerRunning = true;
        this.getLog().debug("JobStore background threads started (as scheduler was started).");
    }

    @Override
    public void schedulerPaused() {
        this.schedulerRunning = false;
    }

    @Override
    public void schedulerResumed() {
        this.schedulerRunning = true;
    }

    @Override
    public void shutdown() {
        this.shutdown = true;
        if (this.misfireHandler != null) {
            this.misfireHandler.shutdown();
            try {
                this.misfireHandler.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.clusterManagementThread != null) {
            this.clusterManagementThread.shutdown();
            try {
                this.clusterManagementThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        try {
            DBConnectionManager.getInstance().shutdown(this.getDataSource());
        }
        catch (SQLException sQLException) {
            this.getLog().warn("Database connection shutdown unsuccessful.", sQLException);
        }
        this.getLog().debug("JobStore background threads shutdown.");
    }

    @Override
    public boolean supportsPersistence() {
        return true;
    }

    protected abstract Connection getNonManagedTXConnection() throws JobPersistenceException;

    protected Connection getAttributeRestoringConnection(Connection connection) {
        return (Connection)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{Connection.class}, (InvocationHandler)new AttributeRestoringConnectionInvocationHandler(connection));
    }

    protected Connection getConnection() throws JobPersistenceException {
        Connection connection;
        try {
            connection = DBConnectionManager.getInstance().getConnection(this.getDataSource());
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Failed to obtain DB connection from data source '" + this.getDataSource() + "': " + sQLException.toString(), sQLException);
        }
        catch (Throwable throwable) {
            throw new JobPersistenceException("Failed to obtain DB connection from data source '" + this.getDataSource() + "': " + throwable.toString(), throwable);
        }
        if (connection == null) {
            throw new JobPersistenceException("Could not get connection from DataSource '" + this.getDataSource() + "'");
        }
        connection = this.getAttributeRestoringConnection(connection);
        try {
            if (!this.isDontSetAutoCommitFalse()) {
                connection.setAutoCommit(false);
            }
            if (this.isTxIsolationLevelSerializable()) {
                connection.setTransactionIsolation(8);
            }
        }
        catch (SQLException sQLException) {
            this.getLog().warn("Failed to override connection auto commit/transaction isolation.", sQLException);
        }
        catch (Throwable throwable) {
            try {
                connection.close();
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw new JobPersistenceException("Failure setting up connection.", throwable);
        }
        return connection;
    }

    protected void releaseLock(String string, boolean bl) {
        if (bl) {
            try {
                this.getLockHandler().releaseLock(string);
            }
            catch (LockException lockException) {
                this.getLog().error("Error returning lock: " + lockException.getMessage(), lockException);
            }
        }
    }

    protected void recoverJobs() throws JobPersistenceException {
        this.executeInNonManagedTXLock(LOCK_TRIGGER_ACCESS, new VoidTransactionCallback(){

            @Override
            public void executeVoid(Connection connection) throws JobPersistenceException {
                JobStoreSupport.this.recoverJobs(connection);
            }
        }, null);
    }

    protected void recoverJobs(Connection connection) throws JobPersistenceException {
        try {
            int n = this.getDelegate().updateTriggerStatesFromOtherStates(connection, "WAITING", "ACQUIRED", "BLOCKED");
            this.getLog().info("Freed " + (n += this.getDelegate().updateTriggerStatesFromOtherStates(connection, "PAUSED", "PAUSED_BLOCKED", "PAUSED_BLOCKED")) + " triggers from 'acquired' / 'blocked' state.");
            this.recoverMisfiredJobs(connection, true);
            List<OperableTrigger> list = this.getDelegate().selectTriggersForRecoveringJobs(connection);
            this.getLog().info("Recovering " + list.size() + " jobs that were in-progress at the time of the last shut-down.");
            for (OperableTrigger object2 : list) {
                if (!this.jobExists(connection, object2.getJobKey())) continue;
                object2.computeFirstFireTime(null);
                this.storeTrigger(connection, object2, null, false, "WAITING", false, true);
            }
            this.getLog().info("Recovery complete.");
            List<TriggerKey> list2 = this.getDelegate().selectTriggersInState(connection, "COMPLETE");
            Iterator n2 = list2.iterator();
            while (n2.hasNext()) {
                TriggerKey triggerKey = (TriggerKey)n2.next();
                this.removeTrigger(connection, triggerKey);
            }
            this.getLog().info("Removed " + list2.size() + " 'complete' triggers.");
            int n3 = this.getDelegate().deleteFiredTriggers(connection);
            this.getLog().info("Removed " + n3 + " stale fired job entries.");
        }
        catch (JobPersistenceException jobPersistenceException) {
            throw jobPersistenceException;
        }
        catch (Exception exception) {
            throw new JobPersistenceException("Couldn't recover jobs: " + exception.getMessage(), exception);
        }
    }

    protected long getMisfireTime() {
        long l = System.currentTimeMillis();
        if (this.getMisfireThreshold() > 0L) {
            l -= this.getMisfireThreshold();
        }
        return l > 0L ? l : 0L;
    }

    protected RecoverMisfiredJobsResult recoverMisfiredJobs(Connection connection, boolean bl) throws JobPersistenceException, SQLException {
        int n = bl ? -1 : this.getMaxMisfiresToHandleAtATime();
        LinkedList<TriggerKey> linkedList = new LinkedList<TriggerKey>();
        long l = Long.MAX_VALUE;
        boolean bl2 = this.getDelegate().hasMisfiredTriggersInState(connection, "WAITING", this.getMisfireTime(), n, linkedList);
        if (bl2) {
            this.getLog().info("Handling the first " + linkedList.size() + " triggers that missed their scheduled fire-time.  " + "More misfired triggers remain to be processed.");
        } else if (linkedList.size() > 0) {
            this.getLog().info("Handling " + linkedList.size() + " trigger(s) that missed their scheduled fire-time.");
        } else {
            this.getLog().debug("Found 0 triggers that missed their scheduled fire-time.");
            return RecoverMisfiredJobsResult.NO_OP;
        }
        for (TriggerKey triggerKey : linkedList) {
            OperableTrigger operableTrigger = this.retrieveTrigger(connection, triggerKey);
            if (operableTrigger == null) continue;
            this.doUpdateOfMisfiredTrigger(connection, operableTrigger, false, "WAITING", bl);
            if (operableTrigger.getNextFireTime() == null || operableTrigger.getNextFireTime().getTime() >= l) continue;
            l = operableTrigger.getNextFireTime().getTime();
        }
        return new RecoverMisfiredJobsResult(bl2, linkedList.size(), l);
    }

    protected boolean updateMisfiredTrigger(Connection connection, TriggerKey triggerKey, String string, boolean bl) throws JobPersistenceException {
        try {
            OperableTrigger operableTrigger = this.retrieveTrigger(connection, triggerKey);
            long l = System.currentTimeMillis();
            if (this.getMisfireThreshold() > 0L) {
                l -= this.getMisfireThreshold();
            }
            if (operableTrigger.getNextFireTime().getTime() > l) {
                return false;
            }
            this.doUpdateOfMisfiredTrigger(connection, operableTrigger, bl, string, false);
            return true;
        }
        catch (Exception exception) {
            throw new JobPersistenceException("Couldn't update misfired trigger '" + triggerKey + "': " + exception.getMessage(), exception);
        }
    }

    private void doUpdateOfMisfiredTrigger(Connection connection, OperableTrigger operableTrigger, boolean bl, String string, boolean bl2) throws JobPersistenceException {
        Calendar calendar = null;
        if (operableTrigger.getCalendarName() != null) {
            calendar = this.retrieveCalendar(connection, operableTrigger.getCalendarName());
        }
        this.schedSignaler.notifyTriggerListenersMisfired(operableTrigger);
        operableTrigger.updateAfterMisfire(calendar);
        if (operableTrigger.getNextFireTime() == null) {
            this.storeTrigger(connection, operableTrigger, null, true, "COMPLETE", bl, bl2);
            this.schedSignaler.notifySchedulerListenersFinalized(operableTrigger);
        } else {
            this.storeTrigger(connection, operableTrigger, null, true, string, bl, false);
        }
    }

    @Override
    public void storeJobAndTrigger(final JobDetail jobDetail, final OperableTrigger operableTrigger) throws JobPersistenceException {
        this.executeInLock(this.isLockOnInsert() ? LOCK_TRIGGER_ACCESS : null, new VoidTransactionCallback(){

            @Override
            public void executeVoid(Connection connection) throws JobPersistenceException {
                JobStoreSupport.this.storeJob(connection, jobDetail, false);
                JobStoreSupport.this.storeTrigger(connection, operableTrigger, jobDetail, false, "WAITING", false, false);
            }
        });
    }

    @Override
    public void storeJob(final JobDetail jobDetail, final boolean bl) throws JobPersistenceException {
        this.executeInLock(this.isLockOnInsert() || bl ? LOCK_TRIGGER_ACCESS : null, new VoidTransactionCallback(){

            @Override
            public void executeVoid(Connection connection) throws JobPersistenceException {
                JobStoreSupport.this.storeJob(connection, jobDetail, bl);
            }
        });
    }

    protected void storeJob(Connection connection, JobDetail jobDetail, boolean bl) throws JobPersistenceException {
        boolean bl2 = this.jobExists(connection, jobDetail.getKey());
        try {
            if (bl2) {
                if (!bl) {
                    throw new ObjectAlreadyExistsException(jobDetail);
                }
                this.getDelegate().updateJobDetail(connection, jobDetail);
            } else {
                this.getDelegate().insertJobDetail(connection, jobDetail);
            }
        }
        catch (IOException iOException) {
            throw new JobPersistenceException("Couldn't store job: " + iOException.getMessage(), iOException);
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't store job: " + sQLException.getMessage(), sQLException);
        }
    }

    protected boolean jobExists(Connection connection, JobKey jobKey) throws JobPersistenceException {
        try {
            return this.getDelegate().jobExists(connection, jobKey);
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't determine job existence (" + jobKey + "): " + sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public void storeTrigger(final OperableTrigger operableTrigger, final boolean bl) throws JobPersistenceException {
        this.executeInLock(this.isLockOnInsert() || bl ? LOCK_TRIGGER_ACCESS : null, new VoidTransactionCallback(){

            @Override
            public void executeVoid(Connection connection) throws JobPersistenceException {
                JobStoreSupport.this.storeTrigger(connection, operableTrigger, null, bl, "WAITING", false, false);
            }
        });
    }

    protected void storeTrigger(Connection connection, OperableTrigger operableTrigger, JobDetail jobDetail, boolean bl, String string, boolean bl2, boolean bl3) throws JobPersistenceException {
        boolean bl4 = this.triggerExists(connection, operableTrigger.getKey());
        if (bl4 && !bl) {
            throw new ObjectAlreadyExistsException(operableTrigger);
        }
        try {
            if (!bl2) {
                boolean bl5 = this.getDelegate().isTriggerGroupPaused(connection, operableTrigger.getKey().getGroup());
                if (!bl5 && (bl5 = this.getDelegate().isTriggerGroupPaused(connection, "_$_ALL_GROUPS_PAUSED_$_"))) {
                    this.getDelegate().insertPausedTriggerGroup(connection, operableTrigger.getKey().getGroup());
                }
                if (bl5 && (string.equals("WAITING") || string.equals("ACQUIRED"))) {
                    string = "PAUSED";
                }
            }
            if (jobDetail == null) {
                jobDetail = this.retrieveJob(connection, operableTrigger.getJobKey());
            }
            if (jobDetail == null) {
                throw new JobPersistenceException("The job (" + operableTrigger.getJobKey() + ") referenced by the trigger does not exist.");
            }
            if (jobDetail.isConcurrentExectionDisallowed() && !bl3) {
                string = this.checkBlockedState(connection, jobDetail.getKey(), string);
            }
            if (bl4) {
                this.getDelegate().updateTrigger(connection, operableTrigger, string, jobDetail);
            } else {
                this.getDelegate().insertTrigger(connection, operableTrigger, string, jobDetail);
            }
        }
        catch (Exception exception) {
            throw new JobPersistenceException("Couldn't store trigger '" + operableTrigger.getKey() + "' for '" + operableTrigger.getJobKey() + "' job:" + exception.getMessage(), exception);
        }
    }

    protected boolean triggerExists(Connection connection, TriggerKey triggerKey) throws JobPersistenceException {
        try {
            return this.getDelegate().triggerExists(connection, triggerKey);
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't determine trigger existence (" + triggerKey + "): " + sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public boolean removeJob(final JobKey jobKey) throws JobPersistenceException {
        return (Boolean)this.executeInLock(LOCK_TRIGGER_ACCESS, new TransactionCallback(){

            public Object execute(Connection connection) throws JobPersistenceException {
                return JobStoreSupport.this.removeJob(connection, jobKey) ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    protected boolean removeJob(Connection connection, JobKey jobKey) throws JobPersistenceException {
        try {
            List<TriggerKey> list = this.getDelegate().selectTriggerKeysForJob(connection, jobKey);
            for (TriggerKey triggerKey : list) {
                this.deleteTriggerAndChildren(connection, triggerKey);
            }
            return this.deleteJobAndChildren(connection, jobKey);
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't remove job: " + sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public boolean removeJobs(final List<JobKey> list) throws JobPersistenceException {
        return (Boolean)this.executeInLock(LOCK_TRIGGER_ACCESS, new TransactionCallback(){

            public Object execute(Connection connection) throws JobPersistenceException {
                boolean bl = true;
                for (JobKey jobKey : list) {
                    bl = JobStoreSupport.this.removeJob(connection, jobKey) && bl;
                }
                return bl ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    @Override
    public boolean removeTriggers(final List<TriggerKey> list) throws JobPersistenceException {
        return (Boolean)this.executeInLock(LOCK_TRIGGER_ACCESS, new TransactionCallback(){

            public Object execute(Connection connection) throws JobPersistenceException {
                boolean bl = true;
                for (TriggerKey triggerKey : list) {
                    bl = JobStoreSupport.this.removeTrigger(connection, triggerKey) && bl;
                }
                return bl ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    @Override
    public void storeJobsAndTriggers(final Map<JobDetail, Set<? extends Trigger>> map, final boolean bl) throws JobPersistenceException {
        this.executeInLock(this.isLockOnInsert() || bl ? LOCK_TRIGGER_ACCESS : null, new VoidTransactionCallback(){

            @Override
            public void executeVoid(Connection connection) throws JobPersistenceException {
                for (JobDetail jobDetail : map.keySet()) {
                    JobStoreSupport.this.storeJob(connection, jobDetail, bl);
                    for (Trigger trigger : (Set)map.get(jobDetail)) {
                        JobStoreSupport.this.storeTrigger(connection, (OperableTrigger)trigger, jobDetail, bl, "WAITING", false, false);
                    }
                }
            }
        });
    }

    private boolean deleteJobAndChildren(Connection connection, JobKey jobKey) throws NoSuchDelegateException, SQLException {
        return this.getDelegate().deleteJobDetail(connection, jobKey) > 0;
    }

    private boolean deleteTriggerAndChildren(Connection connection, TriggerKey triggerKey) throws SQLException, NoSuchDelegateException {
        return this.getDelegate().deleteTrigger(connection, triggerKey) > 0;
    }

    @Override
    public JobDetail retrieveJob(final JobKey jobKey) throws JobPersistenceException {
        return (JobDetail)this.executeWithoutLock(new TransactionCallback(){

            public Object execute(Connection connection) throws JobPersistenceException {
                return JobStoreSupport.this.retrieveJob(connection, jobKey);
            }
        });
    }

    protected JobDetail retrieveJob(Connection connection, JobKey jobKey) throws JobPersistenceException {
        try {
            return this.getDelegate().selectJobDetail(connection, jobKey, this.getClassLoadHelper());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JobPersistenceException("Couldn't retrieve job because a required class was not found: " + classNotFoundException.getMessage(), classNotFoundException);
        }
        catch (IOException iOException) {
            throw new JobPersistenceException("Couldn't retrieve job because the BLOB couldn't be deserialized: " + iOException.getMessage(), iOException);
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't retrieve job: " + sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public boolean removeTrigger(final TriggerKey triggerKey) throws JobPersistenceException {
        return (Boolean)this.executeInLock(LOCK_TRIGGER_ACCESS, new TransactionCallback(){

            public Object execute(Connection connection) throws JobPersistenceException {
                return JobStoreSupport.this.removeTrigger(connection, triggerKey) ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    protected boolean removeTrigger(Connection connection, TriggerKey triggerKey) throws JobPersistenceException {
        boolean bl;
        try {
            int n;
            JobDetail jobDetail = this.getDelegate().selectJobForTrigger(connection, this.getClassLoadHelper(), triggerKey, false);
            bl = this.deleteTriggerAndChildren(connection, triggerKey);
            if (null != jobDetail && !jobDetail.isDurable() && (n = this.getDelegate().selectNumTriggersForJob(connection, jobDetail.getKey())) == 0) {
                this.deleteJobAndChildren(connection, jobDetail.getKey());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JobPersistenceException("Couldn't remove trigger: " + classNotFoundException.getMessage(), classNotFoundException);
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't remove trigger: " + sQLException.getMessage(), sQLException);
        }
        return bl;
    }

    @Override
    public boolean replaceTrigger(final TriggerKey triggerKey, final OperableTrigger operableTrigger) throws JobPersistenceException {
        return (Boolean)this.executeInLock(LOCK_TRIGGER_ACCESS, new TransactionCallback(){

            public Object execute(Connection connection) throws JobPersistenceException {
                return JobStoreSupport.this.replaceTrigger(connection, triggerKey, operableTrigger) ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    protected boolean replaceTrigger(Connection connection, TriggerKey triggerKey, OperableTrigger operableTrigger) throws JobPersistenceException {
        try {
            JobDetail jobDetail = this.getDelegate().selectJobForTrigger(connection, this.getClassLoadHelper(), triggerKey);
            if (jobDetail == null) {
                return false;
            }
            if (!operableTrigger.getJobKey().equals(jobDetail.getKey())) {
                throw new JobPersistenceException("New trigger is not related to the same job as the old trigger.");
            }
            boolean bl = this.deleteTriggerAndChildren(connection, triggerKey);
            this.storeTrigger(connection, operableTrigger, jobDetail, false, "WAITING", false, false);
            return bl;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JobPersistenceException("Couldn't remove trigger: " + classNotFoundException.getMessage(), classNotFoundException);
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't remove trigger: " + sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public OperableTrigger retrieveTrigger(final TriggerKey triggerKey) throws JobPersistenceException {
        return (OperableTrigger)this.executeWithoutLock(new TransactionCallback(){

            public Object execute(Connection connection) throws JobPersistenceException {
                return JobStoreSupport.this.retrieveTrigger(connection, triggerKey);
            }
        });
    }

    protected OperableTrigger retrieveTrigger(Connection connection, TriggerKey triggerKey) throws JobPersistenceException {
        try {
            return this.getDelegate().selectTrigger(connection, triggerKey);
        }
        catch (Exception exception) {
            throw new JobPersistenceException("Couldn't retrieve trigger: " + exception.getMessage(), exception);
        }
    }

    @Override
    public Trigger.TriggerState getTriggerState(final TriggerKey triggerKey) throws JobPersistenceException {
        return (Trigger.TriggerState)((Object)this.executeWithoutLock(new TransactionCallback(){

            public Object execute(Connection connection) throws JobPersistenceException {
                return JobStoreSupport.this.getTriggerState(connection, triggerKey);
            }
        }));
    }

    public Trigger.TriggerState getTriggerState(Connection connection, TriggerKey triggerKey) throws JobPersistenceException {
        try {
            String string = this.getDelegate().selectTriggerState(connection, triggerKey);
            if (string == null) {
                return Trigger.TriggerState.NONE;
            }
            if (string.equals("DELETED")) {
                return Trigger.TriggerState.NONE;
            }
            if (string.equals("COMPLETE")) {
                return Trigger.TriggerState.COMPLETE;
            }
            if (string.equals("PAUSED")) {
                return Trigger.TriggerState.PAUSED;
            }
            if (string.equals("PAUSED_BLOCKED")) {
                return Trigger.TriggerState.PAUSED;
            }
            if (string.equals("ERROR")) {
                return Trigger.TriggerState.ERROR;
            }
            if (string.equals("BLOCKED")) {
                return Trigger.TriggerState.BLOCKED;
            }
            return Trigger.TriggerState.NORMAL;
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't determine state of trigger (" + triggerKey + "): " + sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public void storeCalendar(final String string, final Calendar calendar, final boolean bl, final boolean bl2) throws JobPersistenceException {
        this.executeInLock(this.isLockOnInsert() || bl2 ? LOCK_TRIGGER_ACCESS : null, new VoidTransactionCallback(){

            @Override
            public void executeVoid(Connection connection) throws JobPersistenceException {
                JobStoreSupport.this.storeCalendar(connection, string, calendar, bl, bl2);
            }
        });
    }

    protected void storeCalendar(Connection connection, String string, Calendar calendar, boolean bl, boolean bl2) throws JobPersistenceException {
        try {
            boolean bl3 = this.calendarExists(connection, string);
            if (bl3 && !bl) {
                throw new ObjectAlreadyExistsException("Calendar with name '" + string + "' already exists.");
            }
            if (bl3) {
                if (this.getDelegate().updateCalendar(connection, string, calendar) < 1) {
                    throw new JobPersistenceException("Couldn't store calendar.  Update failed.");
                }
                if (bl2) {
                    List<OperableTrigger> list = this.getDelegate().selectTriggersForCalendar(connection, string);
                    for (OperableTrigger operableTrigger : list) {
                        operableTrigger.updateWithNewCalendar(calendar, this.getMisfireThreshold());
                        this.storeTrigger(connection, operableTrigger, null, true, "WAITING", false, false);
                    }
                }
            } else if (this.getDelegate().insertCalendar(connection, string, calendar) < 1) {
                throw new JobPersistenceException("Couldn't store calendar.  Insert failed.");
            }
            if (!this.isClustered) {
                this.calendarCache.put(string, calendar);
            }
        }
        catch (IOException iOException) {
            throw new JobPersistenceException("Couldn't store calendar because the BLOB couldn't be serialized: " + iOException.getMessage(), iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JobPersistenceException("Couldn't store calendar: " + classNotFoundException.getMessage(), classNotFoundException);
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't store calendar: " + sQLException.getMessage(), sQLException);
        }
    }

    protected boolean calendarExists(Connection connection, String string) throws JobPersistenceException {
        try {
            return this.getDelegate().calendarExists(connection, string);
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't determine calendar existence (" + string + "): " + sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public boolean removeCalendar(final String string) throws JobPersistenceException {
        return (Boolean)this.executeInLock(LOCK_TRIGGER_ACCESS, new TransactionCallback(){

            public Object execute(Connection connection) throws JobPersistenceException {
                return JobStoreSupport.this.removeCalendar(connection, string) ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    protected boolean removeCalendar(Connection connection, String string) throws JobPersistenceException {
        try {
            if (this.getDelegate().calendarIsReferenced(connection, string)) {
                throw new JobPersistenceException("Calender cannot be removed if it referenced by a trigger!");
            }
            if (!this.isClustered) {
                this.calendarCache.remove(string);
            }
            return this.getDelegate().deleteCalendar(connection, string) > 0;
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't remove calendar: " + sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public Calendar retrieveCalendar(final String string) throws JobPersistenceException {
        return (Calendar)this.executeWithoutLock(new TransactionCallback(){

            public Object execute(Connection connection) throws JobPersistenceException {
                return JobStoreSupport.this.retrieveCalendar(connection, string);
            }
        });
    }

    protected Calendar retrieveCalendar(Connection connection, String string) throws JobPersistenceException {
        Calendar calendar;
        Calendar calendar2 = calendar = this.isClustered ? null : this.calendarCache.get(string);
        if (calendar != null) {
            return calendar;
        }
        try {
            calendar = this.getDelegate().selectCalendar(connection, string);
            if (!this.isClustered) {
                this.calendarCache.put(string, calendar);
            }
            return calendar;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JobPersistenceException("Couldn't retrieve calendar because a required class was not found: " + classNotFoundException.getMessage(), classNotFoundException);
        }
        catch (IOException iOException) {
            throw new JobPersistenceException("Couldn't retrieve calendar because the BLOB couldn't be deserialized: " + iOException.getMessage(), iOException);
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't retrieve calendar: " + sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public int getNumberOfJobs() throws JobPersistenceException {
        return (Integer)this.executeWithoutLock(new TransactionCallback(){

            public Object execute(Connection connection) throws JobPersistenceException {
                return JobStoreSupport.this.getNumberOfJobs(connection);
            }
        });
    }

    protected int getNumberOfJobs(Connection connection) throws JobPersistenceException {
        try {
            return this.getDelegate().selectNumJobs(connection);
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't obtain number of jobs: " + sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public int getNumberOfTriggers() throws JobPersistenceException {
        return (Integer)this.executeWithoutLock(new TransactionCallback(){

            public Object execute(Connection connection) throws JobPersistenceException {
                return JobStoreSupport.this.getNumberOfTriggers(connection);
            }
        });
    }

    protected int getNumberOfTriggers(Connection connection) throws JobPersistenceException {
        try {
            return this.getDelegate().selectNumTriggers(connection);
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't obtain number of triggers: " + sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public int getNumberOfCalendars() throws JobPersistenceException {
        return (Integer)this.executeWithoutLock(new TransactionCallback(){

            public Object execute(Connection connection) throws JobPersistenceException {
                return JobStoreSupport.this.getNumberOfCalendars(connection);
            }
        });
    }

    protected int getNumberOfCalendars(Connection connection) throws JobPersistenceException {
        try {
            return this.getDelegate().selectNumCalendars(connection);
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't obtain number of calendars: " + sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public Set<JobKey> getJobKeys(final GroupMatcher<JobKey> groupMatcher) throws JobPersistenceException {
        return (Set)this.executeWithoutLock(new TransactionCallback(){

            public Object execute(Connection connection) throws JobPersistenceException {
                return JobStoreSupport.this.getJobNames(connection, groupMatcher);
            }
        });
    }

    protected Set<JobKey> getJobNames(Connection connection, GroupMatcher<JobKey> groupMatcher) throws JobPersistenceException {
        Set<JobKey> set;
        try {
            set = this.getDelegate().selectJobsInGroup(connection, groupMatcher);
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't obtain job names: " + sQLException.getMessage(), sQLException);
        }
        return set;
    }

    @Override
    public boolean checkExists(final JobKey jobKey) throws JobPersistenceException {
        return (Boolean)this.executeWithoutLock(new TransactionCallback(){

            public Object execute(Connection connection) throws JobPersistenceException {
                return JobStoreSupport.this.checkExists(connection, jobKey);
            }
        });
    }

    protected boolean checkExists(Connection connection, JobKey jobKey) throws JobPersistenceException {
        try {
            return this.getDelegate().jobExists(connection, jobKey);
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't check for existence of job: " + sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public boolean checkExists(final TriggerKey triggerKey) throws JobPersistenceException {
        return (Boolean)this.executeWithoutLock(new TransactionCallback(){

            public Object execute(Connection connection) throws JobPersistenceException {
                return JobStoreSupport.this.checkExists(connection, triggerKey);
            }
        });
    }

    protected boolean checkExists(Connection connection, TriggerKey triggerKey) throws JobPersistenceException {
        try {
            return this.getDelegate().triggerExists(connection, triggerKey);
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't check for existence of job: " + sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public void clearAllSchedulingData() throws JobPersistenceException {
        this.executeInLock(LOCK_TRIGGER_ACCESS, new VoidTransactionCallback(){

            @Override
            public void executeVoid(Connection connection) throws JobPersistenceException {
                JobStoreSupport.this.clearAllSchedulingData(connection);
            }
        });
    }

    protected void clearAllSchedulingData(Connection connection) throws JobPersistenceException {
        try {
            this.getDelegate().clearData(connection);
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Error clearing scheduling data: " + sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public Set<TriggerKey> getTriggerKeys(final GroupMatcher<TriggerKey> groupMatcher) throws JobPersistenceException {
        return (Set)this.executeWithoutLock(new TransactionCallback(){

            public Object execute(Connection connection) throws JobPersistenceException {
                return JobStoreSupport.this.getTriggerNames(connection, groupMatcher);
            }
        });
    }

    protected Set<TriggerKey> getTriggerNames(Connection connection, GroupMatcher<TriggerKey> groupMatcher) throws JobPersistenceException {
        Set<TriggerKey> set;
        try {
            set = this.getDelegate().selectTriggersInGroup(connection, groupMatcher);
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't obtain trigger names: " + sQLException.getMessage(), sQLException);
        }
        return set;
    }

    @Override
    public List<String> getJobGroupNames() throws JobPersistenceException {
        return (List)this.executeWithoutLock(new TransactionCallback(){

            public Object execute(Connection connection) throws JobPersistenceException {
                return JobStoreSupport.this.getJobGroupNames(connection);
            }
        });
    }

    protected List<String> getJobGroupNames(Connection connection) throws JobPersistenceException {
        List<String> list;
        try {
            list = this.getDelegate().selectJobGroups(connection);
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't obtain job groups: " + sQLException.getMessage(), sQLException);
        }
        return list;
    }

    @Override
    public List<String> getTriggerGroupNames() throws JobPersistenceException {
        return (List)this.executeWithoutLock(new TransactionCallback(){

            public Object execute(Connection connection) throws JobPersistenceException {
                return JobStoreSupport.this.getTriggerGroupNames(connection);
            }
        });
    }

    protected List<String> getTriggerGroupNames(Connection connection) throws JobPersistenceException {
        List<String> list;
        try {
            list = this.getDelegate().selectTriggerGroups(connection);
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't obtain trigger groups: " + sQLException.getMessage(), sQLException);
        }
        return list;
    }

    @Override
    public List<String> getCalendarNames() throws JobPersistenceException {
        return (List)this.executeWithoutLock(new TransactionCallback(){

            public Object execute(Connection connection) throws JobPersistenceException {
                return JobStoreSupport.this.getCalendarNames(connection);
            }
        });
    }

    protected List<String> getCalendarNames(Connection connection) throws JobPersistenceException {
        try {
            return this.getDelegate().selectCalendars(connection);
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't obtain trigger groups: " + sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public List<OperableTrigger> getTriggersForJob(final JobKey jobKey) throws JobPersistenceException {
        return (List)this.executeWithoutLock(new TransactionCallback(){

            public Object execute(Connection connection) throws JobPersistenceException {
                return JobStoreSupport.this.getTriggersForJob(connection, jobKey);
            }
        });
    }

    protected List<OperableTrigger> getTriggersForJob(Connection connection, JobKey jobKey) throws JobPersistenceException {
        List<OperableTrigger> list;
        try {
            list = this.getDelegate().selectTriggersForJob(connection, jobKey);
        }
        catch (Exception exception) {
            throw new JobPersistenceException("Couldn't obtain triggers for job: " + exception.getMessage(), exception);
        }
        return list;
    }

    @Override
    public void pauseTrigger(final TriggerKey triggerKey) throws JobPersistenceException {
        this.executeInLock(LOCK_TRIGGER_ACCESS, new VoidTransactionCallback(){

            @Override
            public void executeVoid(Connection connection) throws JobPersistenceException {
                JobStoreSupport.this.pauseTrigger(connection, triggerKey);
            }
        });
    }

    public void pauseTrigger(Connection connection, TriggerKey triggerKey) throws JobPersistenceException {
        try {
            String string = this.getDelegate().selectTriggerState(connection, triggerKey);
            if (string.equals("WAITING") || string.equals("ACQUIRED")) {
                this.getDelegate().updateTriggerState(connection, triggerKey, "PAUSED");
            } else if (string.equals("BLOCKED")) {
                this.getDelegate().updateTriggerState(connection, triggerKey, "PAUSED_BLOCKED");
            }
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't pause trigger '" + triggerKey + "': " + sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public void pauseJob(final JobKey jobKey) throws JobPersistenceException {
        this.executeInLock(LOCK_TRIGGER_ACCESS, new VoidTransactionCallback(){

            @Override
            public void executeVoid(Connection connection) throws JobPersistenceException {
                List<OperableTrigger> list = JobStoreSupport.this.getTriggersForJob(connection, jobKey);
                for (OperableTrigger operableTrigger : list) {
                    JobStoreSupport.this.pauseTrigger(connection, operableTrigger.getKey());
                }
            }
        });
    }

    public Set<String> pauseJobs(final GroupMatcher<JobKey> groupMatcher) throws JobPersistenceException {
        return (Set)this.executeInLock(LOCK_TRIGGER_ACCESS, new TransactionCallback(){

            public Set<String> execute(Connection connection) throws JobPersistenceException {
                HashSet<String> hashSet = new HashSet<String>();
                Set<JobKey> set = JobStoreSupport.this.getJobNames(connection, groupMatcher);
                for (JobKey jobKey : set) {
                    List<OperableTrigger> list = JobStoreSupport.this.getTriggersForJob(connection, jobKey);
                    for (OperableTrigger operableTrigger : list) {
                        JobStoreSupport.this.pauseTrigger(connection, operableTrigger.getKey());
                    }
                    hashSet.add(jobKey.getGroup());
                }
                return hashSet;
            }
        });
    }

    protected String checkBlockedState(Connection connection, JobKey jobKey, String string) throws JobPersistenceException {
        if (!string.equals("WAITING") && !string.equals("PAUSED")) {
            return string;
        }
        try {
            FiredTriggerRecord firedTriggerRecord;
            List<FiredTriggerRecord> list = this.getDelegate().selectFiredTriggerRecordsByJob(connection, jobKey.getName(), jobKey.getGroup());
            if (list.size() > 0 && (firedTriggerRecord = list.get(0)).isJobDisallowsConcurrentExecution()) {
                return "PAUSED".equals(string) ? "PAUSED_BLOCKED" : "BLOCKED";
            }
            return string;
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't determine if trigger should be in a blocked state '" + jobKey + "': " + sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public void resumeTrigger(final TriggerKey triggerKey) throws JobPersistenceException {
        this.executeInLock(LOCK_TRIGGER_ACCESS, new VoidTransactionCallback(){

            @Override
            public void executeVoid(Connection connection) throws JobPersistenceException {
                JobStoreSupport.this.resumeTrigger(connection, triggerKey);
            }
        });
    }

    public void resumeTrigger(Connection connection, TriggerKey triggerKey) throws JobPersistenceException {
        try {
            TriggerStatus triggerStatus = this.getDelegate().selectTriggerStatus(connection, triggerKey);
            if (triggerStatus == null || triggerStatus.getNextFireTime() == null) {
                return;
            }
            boolean bl = false;
            if ("PAUSED_BLOCKED".equals(triggerStatus.getStatus())) {
                bl = true;
            }
            String string = this.checkBlockedState(connection, triggerStatus.getJobKey(), "WAITING");
            boolean bl2 = false;
            if (this.schedulerRunning && triggerStatus.getNextFireTime().before(new Date())) {
                bl2 = this.updateMisfiredTrigger(connection, triggerKey, string, true);
            }
            if (!bl2) {
                if (bl) {
                    this.getDelegate().updateTriggerStateFromOtherState(connection, triggerKey, string, "PAUSED_BLOCKED");
                } else {
                    this.getDelegate().updateTriggerStateFromOtherState(connection, triggerKey, string, "PAUSED");
                }
            }
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't resume trigger '" + triggerKey + "': " + sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public void resumeJob(final JobKey jobKey) throws JobPersistenceException {
        this.executeInLock(LOCK_TRIGGER_ACCESS, new VoidTransactionCallback(){

            @Override
            public void executeVoid(Connection connection) throws JobPersistenceException {
                List<OperableTrigger> list = JobStoreSupport.this.getTriggersForJob(connection, jobKey);
                for (OperableTrigger operableTrigger : list) {
                    JobStoreSupport.this.resumeTrigger(connection, operableTrigger.getKey());
                }
            }
        });
    }

    public Set<String> resumeJobs(final GroupMatcher<JobKey> groupMatcher) throws JobPersistenceException {
        return (Set)this.executeInLock(LOCK_TRIGGER_ACCESS, new TransactionCallback(){

            public Set<String> execute(Connection connection) throws JobPersistenceException {
                Set<JobKey> set = JobStoreSupport.this.getJobNames(connection, groupMatcher);
                HashSet<String> hashSet = new HashSet<String>();
                for (JobKey jobKey : set) {
                    List<OperableTrigger> list = JobStoreSupport.this.getTriggersForJob(connection, jobKey);
                    for (OperableTrigger operableTrigger : list) {
                        JobStoreSupport.this.resumeTrigger(connection, operableTrigger.getKey());
                    }
                    hashSet.add(jobKey.getGroup());
                }
                return hashSet;
            }
        });
    }

    public Set<String> pauseTriggers(final GroupMatcher<TriggerKey> groupMatcher) throws JobPersistenceException {
        return (Set)this.executeInLock(LOCK_TRIGGER_ACCESS, new TransactionCallback(){

            public Set<String> execute(Connection connection) throws JobPersistenceException {
                return JobStoreSupport.this.pauseTriggerGroup(connection, groupMatcher);
            }
        });
    }

    public Set<String> pauseTriggerGroup(Connection connection, GroupMatcher<TriggerKey> groupMatcher) throws JobPersistenceException {
        try {
            this.getDelegate().updateTriggerGroupStateFromOtherStates(connection, groupMatcher, "PAUSED", "ACQUIRED", "WAITING", "WAITING");
            this.getDelegate().updateTriggerGroupStateFromOtherState(connection, groupMatcher, "PAUSED_BLOCKED", "BLOCKED");
            List<String> list = this.getDelegate().selectTriggerGroups(connection, groupMatcher);
            StringMatcher.StringOperatorName stringOperatorName = groupMatcher.getCompareWithOperator();
            if (stringOperatorName.equals((Object)StringMatcher.StringOperatorName.EQUALS) && !list.contains(groupMatcher.getCompareToValue())) {
                list.add(groupMatcher.getCompareToValue());
            }
            for (String string : list) {
                if (this.getDelegate().isTriggerGroupPaused(connection, string)) continue;
                this.getDelegate().insertPausedTriggerGroup(connection, string);
            }
            return new HashSet<String>(list);
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't pause trigger group '" + groupMatcher + "': " + sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public Set<String> getPausedTriggerGroups() throws JobPersistenceException {
        return (Set)this.executeWithoutLock(new TransactionCallback(){

            public Object execute(Connection connection) throws JobPersistenceException {
                return JobStoreSupport.this.getPausedTriggerGroups(connection);
            }
        });
    }

    public Set<String> getPausedTriggerGroups(Connection connection) throws JobPersistenceException {
        try {
            return this.getDelegate().selectPausedTriggerGroups(connection);
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't determine paused trigger groups: " + sQLException.getMessage(), sQLException);
        }
    }

    public Set<String> resumeTriggers(final GroupMatcher<TriggerKey> groupMatcher) throws JobPersistenceException {
        return (Set)this.executeInLock(LOCK_TRIGGER_ACCESS, new TransactionCallback(){

            public Set<String> execute(Connection connection) throws JobPersistenceException {
                return JobStoreSupport.this.resumeTriggerGroup(connection, groupMatcher);
            }
        });
    }

    public Set<String> resumeTriggerGroup(Connection connection, GroupMatcher<TriggerKey> groupMatcher) throws JobPersistenceException {
        try {
            this.getDelegate().deletePausedTriggerGroup(connection, groupMatcher);
            HashSet<String> hashSet = new HashSet<String>();
            Set<TriggerKey> set = this.getDelegate().selectTriggersInGroup(connection, groupMatcher);
            for (TriggerKey triggerKey : set) {
                this.resumeTrigger(connection, triggerKey);
                hashSet.add(triggerKey.getGroup());
            }
            return hashSet;
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't pause trigger group '" + groupMatcher + "': " + sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public void pauseAll() throws JobPersistenceException {
        this.executeInLock(LOCK_TRIGGER_ACCESS, new VoidTransactionCallback(){

            @Override
            public void executeVoid(Connection connection) throws JobPersistenceException {
                JobStoreSupport.this.pauseAll(connection);
            }
        });
    }

    public void pauseAll(Connection connection) throws JobPersistenceException {
        List<String> list = this.getTriggerGroupNames(connection);
        for (String string : list) {
            this.pauseTriggerGroup(connection, GroupMatcher.triggerGroupEquals(string));
        }
        try {
            if (!this.getDelegate().isTriggerGroupPaused(connection, "_$_ALL_GROUPS_PAUSED_$_")) {
                this.getDelegate().insertPausedTriggerGroup(connection, "_$_ALL_GROUPS_PAUSED_$_");
            }
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't pause all trigger groups: " + sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public void resumeAll() throws JobPersistenceException {
        this.executeInLock(LOCK_TRIGGER_ACCESS, new VoidTransactionCallback(){

            @Override
            public void executeVoid(Connection connection) throws JobPersistenceException {
                JobStoreSupport.this.resumeAll(connection);
            }
        });
    }

    public void resumeAll(Connection connection) throws JobPersistenceException {
        List<String> list = this.getTriggerGroupNames(connection);
        for (String string : list) {
            this.resumeTriggerGroup(connection, GroupMatcher.triggerGroupEquals(string));
        }
        try {
            this.getDelegate().deletePausedTriggerGroup(connection, "_$_ALL_GROUPS_PAUSED_$_");
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't resume all trigger groups: " + sQLException.getMessage(), sQLException);
        }
    }

    protected synchronized String getFiredTriggerRecordId() {
        return this.getInstanceId() + ftrCtr++;
    }

    @Override
    public List<OperableTrigger> acquireNextTriggers(final long l, final int n, final long l2) throws JobPersistenceException {
        String string = this.isAcquireTriggersWithinLock() || n > 1 ? LOCK_TRIGGER_ACCESS : null;
        return this.executeInNonManagedTXLock(string, new TransactionCallback<List<OperableTrigger>>(){

            @Override
            public List<OperableTrigger> execute(Connection connection) throws JobPersistenceException {
                return JobStoreSupport.this.acquireNextTrigger(connection, l, n, l2);
            }
        }, new TransactionValidator<List<OperableTrigger>>(){

            @Override
            public Boolean validate(Connection connection, List<OperableTrigger> list) throws JobPersistenceException {
                try {
                    List<FiredTriggerRecord> list2 = JobStoreSupport.this.getDelegate().selectInstancesFiredTriggerRecords(connection, JobStoreSupport.this.getInstanceId());
                    HashSet<String> hashSet = new HashSet<String>();
                    for (FiredTriggerRecord serializable : list2) {
                        hashSet.add(serializable.getFireInstanceId());
                    }
                    for (OperableTrigger operableTrigger : list) {
                        if (!hashSet.contains(operableTrigger.getFireInstanceId())) continue;
                        return true;
                    }
                    return false;
                }
                catch (SQLException sQLException) {
                    throw new JobPersistenceException("error validating trigger acquisition", sQLException);
                }
            }
        });
    }

    protected List<OperableTrigger> acquireNextTrigger(Connection connection, long l, int n, long l2) throws JobPersistenceException {
        if (l2 < 0L) {
            throw new IllegalArgumentException();
        }
        ArrayList<OperableTrigger> arrayList = new ArrayList<OperableTrigger>();
        HashSet<JobKey> hashSet = new HashSet<JobKey>();
        int n2 = 3;
        int n3 = 0;
        while (true) {
            ++n3;
            try {
                List<TriggerKey> list = this.getDelegate().selectTriggerToAcquire(connection, l + l2, this.getMisfireTime(), n);
                if (list == null || list.size() == 0) {
                    return arrayList;
                }
                long l3 = l;
                for (TriggerKey triggerKey : list) {
                    JobDetail jobDetail;
                    OperableTrigger operableTrigger = this.retrieveTrigger(connection, triggerKey);
                    if (operableTrigger == null) continue;
                    JobKey jobKey = operableTrigger.getJobKey();
                    try {
                        jobDetail = this.retrieveJob(connection, jobKey);
                    }
                    catch (JobPersistenceException jobPersistenceException) {
                        try {
                            this.getLog().error("Error retrieving job, setting trigger state to ERROR.", jobPersistenceException);
                            this.getDelegate().updateTriggerState(connection, triggerKey, "ERROR");
                        }
                        catch (SQLException sQLException) {
                            this.getLog().error("Unable to set trigger state to ERROR.", sQLException);
                        }
                        continue;
                    }
                    if (jobDetail.isConcurrentExectionDisallowed()) {
                        if (hashSet.contains(jobKey)) continue;
                        hashSet.add(jobKey);
                    }
                    if (operableTrigger.getNextFireTime().getTime() > l3) break;
                    int n4 = this.getDelegate().updateTriggerStateFromOtherState(connection, triggerKey, "ACQUIRED", "WAITING");
                    if (n4 <= 0) continue;
                    operableTrigger.setFireInstanceId(this.getFiredTriggerRecordId());
                    this.getDelegate().insertFiredTrigger(connection, operableTrigger, "ACQUIRED", null);
                    if (arrayList.isEmpty()) {
                        l3 = Math.max(operableTrigger.getNextFireTime().getTime(), System.currentTimeMillis()) + l2;
                    }
                    arrayList.add(operableTrigger);
                }
                if (arrayList.size() != 0 || n3 >= 3) break;
            }
            catch (Exception exception) {
                throw new JobPersistenceException("Couldn't acquire next trigger: " + exception.getMessage(), exception);
            }
        }
        return arrayList;
    }

    @Override
    public void releaseAcquiredTrigger(final OperableTrigger operableTrigger) {
        this.retryExecuteInNonManagedTXLock(LOCK_TRIGGER_ACCESS, new VoidTransactionCallback(){

            @Override
            public void executeVoid(Connection connection) throws JobPersistenceException {
                JobStoreSupport.this.releaseAcquiredTrigger(connection, operableTrigger);
            }
        });
    }

    protected void releaseAcquiredTrigger(Connection connection, OperableTrigger operableTrigger) throws JobPersistenceException {
        try {
            this.getDelegate().updateTriggerStateFromOtherState(connection, operableTrigger.getKey(), "WAITING", "ACQUIRED");
            this.getDelegate().deleteFiredTrigger(connection, operableTrigger.getFireInstanceId());
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't release acquired trigger: " + sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public List<TriggerFiredResult> triggersFired(final List<OperableTrigger> list) throws JobPersistenceException {
        return this.executeInNonManagedTXLock(LOCK_TRIGGER_ACCESS, new TransactionCallback<List<TriggerFiredResult>>(){

            @Override
            public List<TriggerFiredResult> execute(Connection connection) throws JobPersistenceException {
                ArrayList<TriggerFiredResult> arrayList = new ArrayList<TriggerFiredResult>();
                for (OperableTrigger operableTrigger : list) {
                    TriggerFiredResult triggerFiredResult;
                    try {
                        TriggerFiredBundle triggerFiredBundle = JobStoreSupport.this.triggerFired(connection, operableTrigger);
                        triggerFiredResult = new TriggerFiredResult(triggerFiredBundle);
                    }
                    catch (JobPersistenceException jobPersistenceException) {
                        triggerFiredResult = new TriggerFiredResult(jobPersistenceException);
                    }
                    catch (RuntimeException runtimeException) {
                        triggerFiredResult = new TriggerFiredResult(runtimeException);
                    }
                    arrayList.add(triggerFiredResult);
                }
                return arrayList;
            }
        }, new TransactionValidator<List<TriggerFiredResult>>(){

            @Override
            public Boolean validate(Connection connection, List<TriggerFiredResult> list) throws JobPersistenceException {
                try {
                    List<FiredTriggerRecord> list2 = JobStoreSupport.this.getDelegate().selectInstancesFiredTriggerRecords(connection, JobStoreSupport.this.getInstanceId());
                    HashSet<String> hashSet = new HashSet<String>();
                    for (FiredTriggerRecord object : list2) {
                        if (!"EXECUTING".equals(object.getFireInstanceState())) continue;
                        hashSet.add(object.getFireInstanceId());
                    }
                    for (TriggerFiredResult triggerFiredResult : list) {
                        if (triggerFiredResult.getTriggerFiredBundle() == null || !hashSet.contains(triggerFiredResult.getTriggerFiredBundle().getTrigger().getFireInstanceId())) continue;
                        return true;
                    }
                    return false;
                }
                catch (SQLException sQLException) {
                    throw new JobPersistenceException("error validating trigger acquisition", sQLException);
                }
            }
        });
    }

    protected TriggerFiredBundle triggerFired(Connection connection, OperableTrigger operableTrigger) throws JobPersistenceException {
        JobDetail jobDetail;
        Object object;
        Calendar calendar = null;
        try {
            object = this.getDelegate().selectTriggerState(connection, operableTrigger.getKey());
            if (!((String)object).equals("ACQUIRED")) {
                return null;
            }
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't select trigger state: " + sQLException.getMessage(), sQLException);
        }
        try {
            jobDetail = this.retrieveJob(connection, operableTrigger.getJobKey());
            if (jobDetail == null) {
                return null;
            }
        }
        catch (JobPersistenceException jobPersistenceException) {
            try {
                this.getLog().error("Error retrieving job, setting trigger state to ERROR.", jobPersistenceException);
                this.getDelegate().updateTriggerState(connection, operableTrigger.getKey(), "ERROR");
            }
            catch (SQLException sQLException) {
                this.getLog().error("Unable to set trigger state to ERROR.", sQLException);
            }
            throw jobPersistenceException;
        }
        if (operableTrigger.getCalendarName() != null && (calendar = this.retrieveCalendar(connection, operableTrigger.getCalendarName())) == null) {
            return null;
        }
        try {
            this.getDelegate().updateFiredTrigger(connection, operableTrigger, "EXECUTING", jobDetail);
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't insert fired trigger: " + sQLException.getMessage(), sQLException);
        }
        object = operableTrigger.getPreviousFireTime();
        operableTrigger.triggered(calendar);
        String string = "WAITING";
        boolean bl = true;
        if (jobDetail.isConcurrentExectionDisallowed()) {
            string = "BLOCKED";
            bl = false;
            try {
                this.getDelegate().updateTriggerStatesForJobFromOtherState(connection, jobDetail.getKey(), "BLOCKED", "WAITING");
                this.getDelegate().updateTriggerStatesForJobFromOtherState(connection, jobDetail.getKey(), "BLOCKED", "ACQUIRED");
                this.getDelegate().updateTriggerStatesForJobFromOtherState(connection, jobDetail.getKey(), "PAUSED_BLOCKED", "PAUSED");
            }
            catch (SQLException sQLException) {
                throw new JobPersistenceException("Couldn't update states of blocked triggers: " + sQLException.getMessage(), sQLException);
            }
        }
        if (operableTrigger.getNextFireTime() == null) {
            string = "COMPLETE";
            bl = true;
        }
        this.storeTrigger(connection, operableTrigger, jobDetail, true, string, bl, false);
        jobDetail.getJobDataMap().clearDirtyFlag();
        return new TriggerFiredBundle(jobDetail, operableTrigger, calendar, operableTrigger.getKey().getGroup().equals("RECOVERING_JOBS"), new Date(), operableTrigger.getPreviousFireTime(), (Date)object, operableTrigger.getNextFireTime());
    }

    @Override
    public void triggeredJobComplete(final OperableTrigger operableTrigger, final JobDetail jobDetail, final Trigger.CompletedExecutionInstruction completedExecutionInstruction) {
        this.retryExecuteInNonManagedTXLock(LOCK_TRIGGER_ACCESS, new VoidTransactionCallback(){

            @Override
            public void executeVoid(Connection connection) throws JobPersistenceException {
                JobStoreSupport.this.triggeredJobComplete(connection, operableTrigger, jobDetail, completedExecutionInstruction);
            }
        });
    }

    protected void triggeredJobComplete(Connection connection, OperableTrigger operableTrigger, JobDetail jobDetail, Trigger.CompletedExecutionInstruction completedExecutionInstruction) throws JobPersistenceException {
        block21: {
            try {
                if (completedExecutionInstruction == Trigger.CompletedExecutionInstruction.DELETE_TRIGGER) {
                    if (operableTrigger.getNextFireTime() == null) {
                        TriggerStatus triggerStatus = this.getDelegate().selectTriggerStatus(connection, operableTrigger.getKey());
                        if (triggerStatus != null && triggerStatus.getNextFireTime() == null) {
                            this.removeTrigger(connection, operableTrigger.getKey());
                        }
                    } else {
                        this.removeTrigger(connection, operableTrigger.getKey());
                        this.signalSchedulingChangeOnTxCompletion(0L);
                    }
                } else if (completedExecutionInstruction == Trigger.CompletedExecutionInstruction.SET_TRIGGER_COMPLETE) {
                    this.getDelegate().updateTriggerState(connection, operableTrigger.getKey(), "COMPLETE");
                    this.signalSchedulingChangeOnTxCompletion(0L);
                } else if (completedExecutionInstruction == Trigger.CompletedExecutionInstruction.SET_TRIGGER_ERROR) {
                    this.getLog().info("Trigger " + operableTrigger.getKey() + " set to ERROR state.");
                    this.getDelegate().updateTriggerState(connection, operableTrigger.getKey(), "ERROR");
                    this.signalSchedulingChangeOnTxCompletion(0L);
                } else if (completedExecutionInstruction == Trigger.CompletedExecutionInstruction.SET_ALL_JOB_TRIGGERS_COMPLETE) {
                    this.getDelegate().updateTriggerStatesForJob(connection, operableTrigger.getJobKey(), "COMPLETE");
                    this.signalSchedulingChangeOnTxCompletion(0L);
                } else if (completedExecutionInstruction == Trigger.CompletedExecutionInstruction.SET_ALL_JOB_TRIGGERS_ERROR) {
                    this.getLog().info("All triggers of Job " + operableTrigger.getKey() + " set to ERROR state.");
                    this.getDelegate().updateTriggerStatesForJob(connection, operableTrigger.getJobKey(), "ERROR");
                    this.signalSchedulingChangeOnTxCompletion(0L);
                }
                if (jobDetail.isConcurrentExectionDisallowed()) {
                    this.getDelegate().updateTriggerStatesForJobFromOtherState(connection, jobDetail.getKey(), "WAITING", "BLOCKED");
                    this.getDelegate().updateTriggerStatesForJobFromOtherState(connection, jobDetail.getKey(), "PAUSED", "PAUSED_BLOCKED");
                    this.signalSchedulingChangeOnTxCompletion(0L);
                }
                if (!jobDetail.isPersistJobDataAfterExecution()) break block21;
                try {
                    if (jobDetail.getJobDataMap().isDirty()) {
                        this.getDelegate().updateJobData(connection, jobDetail);
                    }
                }
                catch (IOException iOException) {
                    throw new JobPersistenceException("Couldn't serialize job data: " + iOException.getMessage(), iOException);
                }
                catch (SQLException sQLException) {
                    throw new JobPersistenceException("Couldn't update job data: " + sQLException.getMessage(), sQLException);
                }
            }
            catch (SQLException sQLException) {
                throw new JobPersistenceException("Couldn't update trigger state(s): " + sQLException.getMessage(), sQLException);
            }
        }
        try {
            this.getDelegate().deleteFiredTrigger(connection, operableTrigger.getFireInstanceId());
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't delete fired trigger: " + sQLException.getMessage(), sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DriverDelegate getDelegate() throws NoSuchDelegateException {
        JobStoreSupport jobStoreSupport = this;
        synchronized (jobStoreSupport) {
            if (null == this.delegate) {
                try {
                    if (this.delegateClassName != null) {
                        this.delegateClass = this.getClassLoadHelper().loadClass(this.delegateClassName, DriverDelegate.class);
                    }
                    this.delegate = this.delegateClass.newInstance();
                    this.delegate.initialize(this.getLog(), this.tablePrefix, this.instanceName, this.instanceId, this.getClassLoadHelper(), this.canUseProperties(), this.getDriverDelegateInitString());
                }
                catch (InstantiationException instantiationException) {
                    throw new NoSuchDelegateException("Couldn't create delegate: " + instantiationException.getMessage(), instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new NoSuchDelegateException("Couldn't create delegate: " + illegalAccessException.getMessage(), illegalAccessException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoSuchDelegateException("Couldn't load delegate class: " + classNotFoundException.getMessage(), classNotFoundException);
                }
            }
            return this.delegate;
        }
    }

    protected Semaphore getLockHandler() {
        return this.lockHandler;
    }

    public void setLockHandler(Semaphore semaphore) {
        this.lockHandler = semaphore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RecoverMisfiredJobsResult doRecoverMisfires() throws JobPersistenceException {
        boolean bl = false;
        Connection connection = this.getNonManagedTXConnection();
        try {
            int n;
            RecoverMisfiredJobsResult recoverMisfiredJobsResult = RecoverMisfiredJobsResult.NO_OP;
            int n2 = n = this.getDoubleCheckLockMisfireHandler() ? this.getDelegate().countMisfiredTriggersInState(connection, "WAITING", this.getMisfireTime()) : Integer.MAX_VALUE;
            if (n == 0) {
                this.getLog().debug("Found 0 triggers that missed their scheduled fire-time.");
            } else {
                bl = this.getLockHandler().obtainLock(connection, LOCK_TRIGGER_ACCESS);
                recoverMisfiredJobsResult = this.recoverMisfiredJobs(connection, false);
            }
            this.commitConnection(connection);
            RecoverMisfiredJobsResult recoverMisfiredJobsResult2 = recoverMisfiredJobsResult;
            return recoverMisfiredJobsResult2;
        }
        catch (JobPersistenceException jobPersistenceException) {
            this.rollbackConnection(connection);
            throw jobPersistenceException;
        }
        catch (SQLException sQLException) {
            this.rollbackConnection(connection);
            throw new JobPersistenceException("Database error recovering from misfires.", sQLException);
        }
        catch (RuntimeException runtimeException) {
            this.rollbackConnection(connection);
            throw new JobPersistenceException("Unexpected runtime exception: " + runtimeException.getMessage(), runtimeException);
        }
        finally {
            try {
                this.releaseLock(LOCK_TRIGGER_ACCESS, bl);
            }
            finally {
                this.cleanupConnection(connection);
            }
        }
    }

    protected void signalSchedulingChangeOnTxCompletion(long l) {
        Long l2 = this.sigChangeForTxCompletion.get();
        if (l2 == null && l >= 0L) {
            this.sigChangeForTxCompletion.set(l);
        } else if (l2 == null || l < l2) {
            this.sigChangeForTxCompletion.set(l);
        }
    }

    protected Long clearAndGetSignalSchedulingChangeOnTxCompletion() {
        Long l = this.sigChangeForTxCompletion.get();
        this.sigChangeForTxCompletion.set(null);
        return l;
    }

    protected void signalSchedulingChangeImmediately(long l) {
        this.schedSignaler.signalSchedulingChange(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doCheckin() throws JobPersistenceException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Connection connection = this.getNonManagedTXConnection();
        try {
            List<SchedulerStateRecord> list = null;
            if (!this.firstCheckIn) {
                list = this.clusterCheckIn(connection);
                this.commitConnection(connection);
            }
            if (this.firstCheckIn || list.size() > 0) {
                this.getLockHandler().obtainLock(connection, LOCK_STATE_ACCESS);
                bl2 = true;
                List<SchedulerStateRecord> list2 = list = this.firstCheckIn ? this.clusterCheckIn(connection) : this.findFailedInstances(connection);
                if (list.size() > 0) {
                    this.getLockHandler().obtainLock(connection, LOCK_TRIGGER_ACCESS);
                    bl = true;
                    this.clusterRecover(connection, list);
                    bl3 = true;
                }
            }
            this.commitConnection(connection);
        }
        catch (JobPersistenceException jobPersistenceException) {
            this.rollbackConnection(connection);
            throw jobPersistenceException;
        }
        finally {
            try {
                this.releaseLock(LOCK_TRIGGER_ACCESS, bl);
            }
            finally {
                try {
                    this.releaseLock(LOCK_STATE_ACCESS, bl2);
                }
                finally {
                    this.cleanupConnection(connection);
                }
            }
        }
        this.firstCheckIn = false;
        return bl3;
    }

    protected List<SchedulerStateRecord> findFailedInstances(Connection connection) throws JobPersistenceException {
        try {
            LinkedList<SchedulerStateRecord> linkedList = new LinkedList<SchedulerStateRecord>();
            boolean bl = false;
            long l = System.currentTimeMillis();
            List<SchedulerStateRecord> list = this.getDelegate().selectSchedulerStateRecords(connection, null);
            for (SchedulerStateRecord schedulerStateRecord : list) {
                if (schedulerStateRecord.getSchedulerInstanceId().equals(this.getInstanceId())) {
                    bl = true;
                    if (!this.firstCheckIn) continue;
                    linkedList.add(schedulerStateRecord);
                    continue;
                }
                if (this.calcFailedIfAfter(schedulerStateRecord) >= l) continue;
                linkedList.add(schedulerStateRecord);
            }
            if (this.firstCheckIn) {
                linkedList.addAll(this.findOrphanedFailedInstances(connection, list));
            }
            if (!bl && !this.firstCheckIn) {
                this.getLog().warn("This scheduler instance (" + this.getInstanceId() + ") is still " + "active but was recovered by another instance in the cluster.  " + "This may cause inconsistent behavior.");
            }
            return linkedList;
        }
        catch (Exception exception) {
            this.lastCheckin = System.currentTimeMillis();
            throw new JobPersistenceException("Failure identifying failed instances when checking-in: " + exception.getMessage(), exception);
        }
    }

    private List<SchedulerStateRecord> findOrphanedFailedInstances(Connection connection, List<SchedulerStateRecord> list) throws SQLException, NoSuchDelegateException {
        ArrayList<SchedulerStateRecord> arrayList = new ArrayList<SchedulerStateRecord>();
        Set<String> set = this.getDelegate().selectFiredTriggerInstanceNames(connection);
        if (!set.isEmpty()) {
            for (SchedulerStateRecord object : list) {
                set.remove(object.getSchedulerInstanceId());
            }
            for (String string : set) {
                SchedulerStateRecord schedulerStateRecord = new SchedulerStateRecord();
                schedulerStateRecord.setSchedulerInstanceId(string);
                arrayList.add(schedulerStateRecord);
                this.getLog().warn("Found orphaned fired triggers for instance: " + schedulerStateRecord.getSchedulerInstanceId());
            }
        }
        return arrayList;
    }

    protected long calcFailedIfAfter(SchedulerStateRecord schedulerStateRecord) {
        return schedulerStateRecord.getCheckinTimestamp() + Math.max(schedulerStateRecord.getCheckinInterval(), System.currentTimeMillis() - this.lastCheckin) + 7500L;
    }

    protected List<SchedulerStateRecord> clusterCheckIn(Connection connection) throws JobPersistenceException {
        List<SchedulerStateRecord> list = this.findFailedInstances(connection);
        try {
            this.lastCheckin = System.currentTimeMillis();
            if (this.getDelegate().updateSchedulerState(connection, this.getInstanceId(), this.lastCheckin) == 0) {
                this.getDelegate().insertSchedulerState(connection, this.getInstanceId(), this.lastCheckin, this.getClusterCheckinInterval());
            }
        }
        catch (Exception exception) {
            throw new JobPersistenceException("Failure updating scheduler state when checking-in: " + exception.getMessage(), exception);
        }
        return list;
    }

    protected void clusterRecover(Connection connection, List<SchedulerStateRecord> list) throws JobPersistenceException {
        if (list.size() > 0) {
            long l = System.currentTimeMillis();
            this.logWarnIfNonZero(list.size(), "ClusterManager: detected " + list.size() + " failed or restarted instances.");
            try {
                for (SchedulerStateRecord schedulerStateRecord : list) {
                    Object object;
                    this.getLog().info("ClusterManager: Scanning for instance \"" + schedulerStateRecord.getSchedulerInstanceId() + "\"'s failed in-progress jobs.");
                    List<FiredTriggerRecord> list2 = this.getDelegate().selectInstancesFiredTriggerRecords(connection, schedulerStateRecord.getSchedulerInstanceId());
                    int n = 0;
                    int n2 = 0;
                    int n3 = 0;
                    HashSet<TriggerKey> hashSet = new HashSet<TriggerKey>();
                    for (FiredTriggerRecord firedTriggerRecord : list2) {
                        TriggerKey triggerKey = firedTriggerRecord.getTriggerKey();
                        object = firedTriggerRecord.getJobKey();
                        hashSet.add(triggerKey);
                        if (firedTriggerRecord.getFireInstanceState().equals("BLOCKED")) {
                            this.getDelegate().updateTriggerStatesForJobFromOtherState(connection, (JobKey)object, "WAITING", "BLOCKED");
                        } else if (firedTriggerRecord.getFireInstanceState().equals("PAUSED_BLOCKED")) {
                            this.getDelegate().updateTriggerStatesForJobFromOtherState(connection, (JobKey)object, "PAUSED", "PAUSED_BLOCKED");
                        }
                        if (firedTriggerRecord.getFireInstanceState().equals("ACQUIRED")) {
                            this.getDelegate().updateTriggerStateFromOtherState(connection, triggerKey, "WAITING", "ACQUIRED");
                            ++n;
                        } else if (firedTriggerRecord.isJobRequestsRecovery()) {
                            if (this.jobExists(connection, (JobKey)object)) {
                                SimpleTriggerImpl simpleTriggerImpl = new SimpleTriggerImpl("recover_" + schedulerStateRecord.getSchedulerInstanceId() + "_" + String.valueOf(l++), "RECOVERING_JOBS", new Date(firedTriggerRecord.getScheduleTimestamp()));
                                simpleTriggerImpl.setJobName(((Key)object).getName());
                                simpleTriggerImpl.setJobGroup(((Key)object).getGroup());
                                simpleTriggerImpl.setMisfireInstruction(-1);
                                simpleTriggerImpl.setPriority(firedTriggerRecord.getPriority());
                                JobDataMap jobDataMap = this.getDelegate().selectTriggerJobDataMap(connection, triggerKey.getName(), triggerKey.getGroup());
                                jobDataMap.put("QRTZ_FAILED_JOB_ORIG_TRIGGER_NAME", triggerKey.getName());
                                jobDataMap.put("QRTZ_FAILED_JOB_ORIG_TRIGGER_GROUP", triggerKey.getGroup());
                                jobDataMap.put("QRTZ_FAILED_JOB_ORIG_TRIGGER_FIRETIME_IN_MILLISECONDS_AS_STRING", String.valueOf(firedTriggerRecord.getFireTimestamp()));
                                jobDataMap.put("QRTZ_FAILED_JOB_ORIG_TRIGGER_SCHEDULED_FIRETIME_IN_MILLISECONDS_AS_STRING", String.valueOf(firedTriggerRecord.getScheduleTimestamp()));
                                simpleTriggerImpl.setJobDataMap(jobDataMap);
                                simpleTriggerImpl.computeFirstFireTime(null);
                                this.storeTrigger(connection, simpleTriggerImpl, null, false, "WAITING", false, true);
                                ++n2;
                            } else {
                                this.getLog().warn("ClusterManager: failed job '" + object + "' no longer exists, cannot schedule recovery.");
                                ++n3;
                            }
                        } else {
                            ++n3;
                        }
                        if (!firedTriggerRecord.isJobDisallowsConcurrentExecution()) continue;
                        this.getDelegate().updateTriggerStatesForJobFromOtherState(connection, (JobKey)object, "WAITING", "BLOCKED");
                        this.getDelegate().updateTriggerStatesForJobFromOtherState(connection, (JobKey)object, "PAUSED", "PAUSED_BLOCKED");
                    }
                    this.getDelegate().deleteFiredTriggers(connection, schedulerStateRecord.getSchedulerInstanceId());
                    int n4 = 0;
                    for (TriggerKey triggerKey : hashSet) {
                        if (!this.getDelegate().selectTriggerState(connection, triggerKey).equals("COMPLETE") || !(object = this.getDelegate().selectFiredTriggerRecords(connection, triggerKey.getName(), triggerKey.getGroup())).isEmpty() || !this.removeTrigger(connection, triggerKey)) continue;
                        ++n4;
                    }
                    this.logWarnIfNonZero(n, "ClusterManager: ......Freed " + n + " acquired trigger(s).");
                    this.logWarnIfNonZero(n4, "ClusterManager: ......Deleted " + n4 + " complete triggers(s).");
                    this.logWarnIfNonZero(n2, "ClusterManager: ......Scheduled " + n2 + " recoverable job(s) for recovery.");
                    this.logWarnIfNonZero(n3, "ClusterManager: ......Cleaned-up " + n3 + " other failed job(s).");
                    if (schedulerStateRecord.getSchedulerInstanceId().equals(this.getInstanceId())) continue;
                    this.getDelegate().deleteSchedulerState(connection, schedulerStateRecord.getSchedulerInstanceId());
                }
            }
            catch (Throwable throwable) {
                throw new JobPersistenceException("Failure recovering jobs: " + throwable.getMessage(), throwable);
            }
        }
    }

    protected void logWarnIfNonZero(int n, String string) {
        if (n > 0) {
            this.getLog().info(string);
        } else {
            this.getLog().debug(string);
        }
    }

    protected void cleanupConnection(Connection connection) {
        if (connection != null) {
            Proxy proxy;
            InvocationHandler invocationHandler;
            if (connection instanceof Proxy && (invocationHandler = Proxy.getInvocationHandler(proxy = (Proxy)((Object)connection))) instanceof AttributeRestoringConnectionInvocationHandler) {
                AttributeRestoringConnectionInvocationHandler attributeRestoringConnectionInvocationHandler = (AttributeRestoringConnectionInvocationHandler)invocationHandler;
                attributeRestoringConnectionInvocationHandler.restoreOriginalAtributes();
                this.closeConnection(attributeRestoringConnectionInvocationHandler.getWrappedConnection());
                return;
            }
            this.closeConnection(connection);
        }
    }

    protected void closeConnection(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                this.getLog().error("Failed to close Connection", sQLException);
            }
            catch (Throwable throwable) {
                this.getLog().error("Unexpected exception closing Connection.  This is often due to a Connection being returned after or during shutdown.", throwable);
            }
        }
    }

    protected void rollbackConnection(Connection connection) {
        if (connection != null) {
            try {
                connection.rollback();
            }
            catch (SQLException sQLException) {
                this.getLog().error("Couldn't rollback jdbc connection. " + sQLException.getMessage(), sQLException);
            }
        }
    }

    protected void commitConnection(Connection connection) throws JobPersistenceException {
        if (connection != null) {
            try {
                connection.commit();
            }
            catch (SQLException sQLException) {
                throw new JobPersistenceException("Couldn't commit jdbc connection. " + sQLException.getMessage(), sQLException);
            }
        }
    }

    public <T> T executeWithoutLock(TransactionCallback<T> transactionCallback) throws JobPersistenceException {
        return this.executeInLock(null, transactionCallback);
    }

    protected abstract <T> T executeInLock(String var1, TransactionCallback<T> var2) throws JobPersistenceException;

    protected <T> T retryExecuteInNonManagedTXLock(String string, TransactionCallback<T> transactionCallback) {
        int n = 1;
        while (!this.shutdown) {
            try {
                return this.executeInNonManagedTXLock(string, transactionCallback, null);
            }
            catch (JobPersistenceException jobPersistenceException) {
                if (n % 4 == 0) {
                    this.schedSignaler.notifySchedulerListenersError("An error occurred while " + transactionCallback, jobPersistenceException);
                }
            }
            catch (RuntimeException runtimeException) {
                this.getLog().error("retryExecuteInNonManagedTXLock: RuntimeException " + runtimeException.getMessage(), runtimeException);
            }
            try {
                Thread.sleep(this.getDbRetryInterval());
            }
            catch (InterruptedException interruptedException) {
                throw new IllegalStateException("Received interrupted exception", interruptedException);
            }
            ++n;
        }
        throw new IllegalStateException("JobStore is shutdown - aborting retry");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T executeInNonManagedTXLock(String string, TransactionCallback<T> transactionCallback, final TransactionValidator<T> transactionValidator) throws JobPersistenceException {
        boolean bl = false;
        Connection connection = null;
        try {
            T t;
            block17: {
                if (string != null) {
                    if (this.getLockHandler().requiresConnection()) {
                        connection = this.getNonManagedTXConnection();
                    }
                    bl = this.getLockHandler().obtainLock(connection, string);
                }
                if (connection == null) {
                    connection = this.getNonManagedTXConnection();
                }
                t = transactionCallback.execute(connection);
                try {
                    this.commitConnection(connection);
                }
                catch (JobPersistenceException jobPersistenceException) {
                    this.rollbackConnection(connection);
                    if (transactionValidator != null && this.retryExecuteInNonManagedTXLock(string, new TransactionCallback<Boolean>(){

                        @Override
                        public Boolean execute(Connection connection) throws JobPersistenceException {
                            return transactionValidator.validate(connection, t);
                        }
                    }).booleanValue()) break block17;
                    throw jobPersistenceException;
                }
            }
            Long l = this.clearAndGetSignalSchedulingChangeOnTxCompletion();
            if (l != null && l >= 0L) {
                this.signalSchedulingChangeImmediately(l);
            }
            T t2 = t;
            return t2;
        }
        catch (JobPersistenceException jobPersistenceException) {
            this.rollbackConnection(connection);
            throw jobPersistenceException;
        }
        catch (RuntimeException runtimeException) {
            this.rollbackConnection(connection);
            throw new JobPersistenceException("Unexpected runtime exception: " + runtimeException.getMessage(), runtimeException);
        }
        finally {
            try {
                this.releaseLock(string, bl);
            }
            finally {
                this.cleanupConnection(connection);
            }
        }
    }

    class MisfireHandler
    extends Thread {
        private volatile boolean shutdown = false;
        private int numFails = 0;

        MisfireHandler() {
            this.setName("QuartzScheduler_" + JobStoreSupport.this.instanceName + "-" + JobStoreSupport.this.instanceId + "_MisfireHandler");
            this.setDaemon(JobStoreSupport.this.getMakeThreadsDaemons());
        }

        public void initialize() {
            ThreadExecutor threadExecutor = JobStoreSupport.this.getThreadExecutor();
            threadExecutor.execute(this);
        }

        public void shutdown() {
            this.shutdown = true;
            this.interrupt();
        }

        private RecoverMisfiredJobsResult manage() {
            try {
                JobStoreSupport.this.getLog().debug("MisfireHandler: scanning for misfires...");
                RecoverMisfiredJobsResult recoverMisfiredJobsResult = JobStoreSupport.this.doRecoverMisfires();
                this.numFails = 0;
                return recoverMisfiredJobsResult;
            }
            catch (Exception exception) {
                if (this.numFails % 4 == 0) {
                    JobStoreSupport.this.getLog().error("MisfireHandler: Error handling misfires: " + exception.getMessage(), exception);
                }
                ++this.numFails;
                return RecoverMisfiredJobsResult.NO_OP;
            }
        }

        @Override
        public void run() {
            while (!this.shutdown) {
                long l = System.currentTimeMillis();
                RecoverMisfiredJobsResult recoverMisfiredJobsResult = this.manage();
                if (recoverMisfiredJobsResult.getProcessedMisfiredTriggerCount() > 0) {
                    JobStoreSupport.this.signalSchedulingChangeImmediately(recoverMisfiredJobsResult.getEarliestNewTime());
                }
                if (this.shutdown) continue;
                long l2 = 50L;
                if (!recoverMisfiredJobsResult.hasMoreMisfiredTriggers()) {
                    l2 = JobStoreSupport.this.getMisfireThreshold() - (System.currentTimeMillis() - l);
                    if (l2 <= 0L) {
                        l2 = 50L;
                    }
                    if (this.numFails > 0) {
                        l2 = Math.max(JobStoreSupport.this.getDbRetryInterval(), l2);
                    }
                }
                try {
                    Thread.sleep(l2);
                }
                catch (Exception exception) {}
            }
        }
    }

    class ClusterManager
    extends Thread {
        private volatile boolean shutdown = false;
        private int numFails = 0;

        ClusterManager() {
            this.setPriority(7);
            this.setName("QuartzScheduler_" + JobStoreSupport.this.instanceName + "-" + JobStoreSupport.this.instanceId + "_ClusterManager");
            this.setDaemon(JobStoreSupport.this.getMakeThreadsDaemons());
        }

        public void initialize() {
            this.manage();
            ThreadExecutor threadExecutor = JobStoreSupport.this.getThreadExecutor();
            threadExecutor.execute(this);
        }

        public void shutdown() {
            this.shutdown = true;
            this.interrupt();
        }

        private boolean manage() {
            boolean bl = false;
            try {
                bl = JobStoreSupport.this.doCheckin();
                this.numFails = 0;
                JobStoreSupport.this.getLog().debug("ClusterManager: Check-in complete.");
            }
            catch (Exception exception) {
                if (this.numFails % 4 == 0) {
                    JobStoreSupport.this.getLog().error("ClusterManager: Error managing cluster: " + exception.getMessage(), exception);
                }
                ++this.numFails;
            }
            return bl;
        }

        @Override
        public void run() {
            while (!this.shutdown) {
                if (!this.shutdown) {
                    long l = JobStoreSupport.this.getClusterCheckinInterval();
                    long l2 = System.currentTimeMillis() - JobStoreSupport.this.lastCheckin;
                    if ((l -= l2) <= 0L) {
                        l = 100L;
                    }
                    if (this.numFails > 0) {
                        l = Math.max(JobStoreSupport.this.getDbRetryInterval(), l);
                    }
                    try {
                        Thread.sleep(l);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.shutdown || !this.manage()) continue;
                JobStoreSupport.this.signalSchedulingChangeImmediately(0L);
            }
        }
    }

    protected abstract class VoidTransactionCallback
    implements TransactionCallback<Void> {
        protected VoidTransactionCallback() {
        }

        @Override
        public final Void execute(Connection connection) throws JobPersistenceException {
            this.executeVoid(connection);
            return null;
        }

        abstract void executeVoid(Connection var1) throws JobPersistenceException;
    }

    protected static interface TransactionValidator<T> {
        public Boolean validate(Connection var1, T var2) throws JobPersistenceException;
    }

    protected static interface TransactionCallback<T> {
        public T execute(Connection var1) throws JobPersistenceException;
    }

    protected static class RecoverMisfiredJobsResult {
        public static final RecoverMisfiredJobsResult NO_OP = new RecoverMisfiredJobsResult(false, 0, Long.MAX_VALUE);
        private boolean _hasMoreMisfiredTriggers;
        private int _processedMisfiredTriggerCount;
        private long _earliestNewTime;

        public RecoverMisfiredJobsResult(boolean bl, int n, long l) {
            this._hasMoreMisfiredTriggers = bl;
            this._processedMisfiredTriggerCount = n;
            this._earliestNewTime = l;
        }

        public boolean hasMoreMisfiredTriggers() {
            return this._hasMoreMisfiredTriggers;
        }

        public int getProcessedMisfiredTriggerCount() {
            return this._processedMisfiredTriggerCount;
        }

        public long getEarliestNewTime() {
            return this._earliestNewTime;
        }
    }
}

