/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.quartz.DailyTimeIntervalScheduleBuilder;
import org.quartz.DailyTimeIntervalTrigger;
import org.quartz.DateBuilder;
import org.quartz.TimeOfDay;
import org.quartz.impl.jdbcjobstore.SimplePropertiesTriggerPersistenceDelegateSupport;
import org.quartz.impl.jdbcjobstore.SimplePropertiesTriggerProperties;
import org.quartz.impl.jdbcjobstore.TriggerPersistenceDelegate;
import org.quartz.impl.triggers.DailyTimeIntervalTriggerImpl;
import org.quartz.spi.OperableTrigger;

public class DailyTimeIntervalTriggerPersistenceDelegate
extends SimplePropertiesTriggerPersistenceDelegateSupport {
    @Override
    public boolean canHandleTriggerType(OperableTrigger operableTrigger) {
        return operableTrigger instanceof DailyTimeIntervalTrigger && !((DailyTimeIntervalTriggerImpl)operableTrigger).hasAdditionalProperties();
    }

    @Override
    public String getHandledTriggerTypeDiscriminator() {
        return "DAILY_I";
    }

    @Override
    protected SimplePropertiesTriggerProperties getTriggerProperties(OperableTrigger operableTrigger) {
        DailyTimeIntervalTriggerImpl dailyTimeIntervalTriggerImpl = (DailyTimeIntervalTriggerImpl)operableTrigger;
        SimplePropertiesTriggerProperties simplePropertiesTriggerProperties = new SimplePropertiesTriggerProperties();
        simplePropertiesTriggerProperties.setInt1(dailyTimeIntervalTriggerImpl.getRepeatInterval());
        simplePropertiesTriggerProperties.setString1(dailyTimeIntervalTriggerImpl.getRepeatIntervalUnit().name());
        simplePropertiesTriggerProperties.setInt2(dailyTimeIntervalTriggerImpl.getTimesTriggered());
        Set<Integer> set = dailyTimeIntervalTriggerImpl.getDaysOfWeek();
        String string = this.join(set, ",");
        simplePropertiesTriggerProperties.setString2(string);
        StringBuilder stringBuilder = new StringBuilder();
        TimeOfDay timeOfDay = dailyTimeIntervalTriggerImpl.getStartTimeOfDay();
        if (timeOfDay != null) {
            stringBuilder.append(timeOfDay.getHour()).append(",");
            stringBuilder.append(timeOfDay.getMinute()).append(",");
            stringBuilder.append(timeOfDay.getSecond()).append(",");
        } else {
            stringBuilder.append(",,,");
        }
        TimeOfDay timeOfDay2 = dailyTimeIntervalTriggerImpl.getEndTimeOfDay();
        if (timeOfDay2 != null) {
            stringBuilder.append(timeOfDay2.getHour()).append(",");
            stringBuilder.append(timeOfDay2.getMinute()).append(",");
            stringBuilder.append(timeOfDay2.getSecond());
        } else {
            stringBuilder.append(",,,");
        }
        simplePropertiesTriggerProperties.setString3(stringBuilder.toString());
        simplePropertiesTriggerProperties.setLong1(dailyTimeIntervalTriggerImpl.getRepeatCount());
        return simplePropertiesTriggerProperties;
    }

    private String join(Set<Integer> set, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (set == null || set.size() <= 0) {
            return "";
        }
        Iterator<Integer> iterator = set.iterator();
        stringBuilder.append(iterator.next());
        while (iterator.hasNext()) {
            stringBuilder.append(string).append(iterator.next());
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected TriggerPersistenceDelegate.TriggerPropertyBundle getTriggerPropertyBundle(SimplePropertiesTriggerProperties simplePropertiesTriggerProperties) {
        String[] stringArray;
        String[] stringArray2;
        int n = (int)simplePropertiesTriggerProperties.getLong1();
        int n2 = simplePropertiesTriggerProperties.getInt1();
        String string = simplePropertiesTriggerProperties.getString1();
        String string2 = simplePropertiesTriggerProperties.getString2();
        String string3 = simplePropertiesTriggerProperties.getString3();
        DateBuilder.IntervalUnit intervalUnit = DateBuilder.IntervalUnit.valueOf(string);
        DailyTimeIntervalScheduleBuilder dailyTimeIntervalScheduleBuilder = DailyTimeIntervalScheduleBuilder.dailyTimeIntervalSchedule().withInterval(n2, intervalUnit).withRepeatCount(n);
        if (string2 != null) {
            stringArray2 = new HashSet();
            stringArray = string2.split(",");
            if (stringArray.length > 0) {
                for (String string4 : stringArray) {
                    stringArray2.add(Integer.parseInt(string4));
                }
                dailyTimeIntervalScheduleBuilder.onDaysOfTheWeek((Set<Integer>)stringArray2);
            }
        } else {
            dailyTimeIntervalScheduleBuilder.onDaysOfTheWeek(DailyTimeIntervalScheduleBuilder.ALL_DAYS_OF_THE_WEEK);
        }
        if (string3 != null) {
            void var11_16;
            int n3;
            int n4;
            stringArray2 = string3.split(",");
            if (stringArray2.length >= 3) {
                int n5 = Integer.parseInt(stringArray2[0]);
                n4 = Integer.parseInt(stringArray2[1]);
                n3 = Integer.parseInt(stringArray2[2]);
                stringArray = new TimeOfDay(n5, n4, n3);
            } else {
                stringArray = TimeOfDay.hourMinuteAndSecondOfDay(0, 0, 0);
            }
            dailyTimeIntervalScheduleBuilder.startingDailyAt((TimeOfDay)stringArray);
            if (stringArray2.length >= 6) {
                n4 = Integer.parseInt(stringArray2[3]);
                n3 = Integer.parseInt(stringArray2[4]);
                int n5 = Integer.parseInt(stringArray2[5]);
                TimeOfDay timeOfDay = new TimeOfDay(n4, n3, n5);
            } else {
                TimeOfDay timeOfDay = TimeOfDay.hourMinuteAndSecondOfDay(23, 59, 59);
            }
            dailyTimeIntervalScheduleBuilder.endingDailyAt((TimeOfDay)var11_16);
        } else {
            dailyTimeIntervalScheduleBuilder.startingDailyAt(TimeOfDay.hourMinuteAndSecondOfDay(0, 0, 0));
            dailyTimeIntervalScheduleBuilder.endingDailyAt(TimeOfDay.hourMinuteAndSecondOfDay(23, 59, 59));
        }
        int n7 = simplePropertiesTriggerProperties.getInt2();
        stringArray = new String[]{"timesTriggered"};
        Object[] objectArray = new Object[]{n7};
        return new TriggerPersistenceDelegate.TriggerPropertyBundle(dailyTimeIntervalScheduleBuilder, stringArray, objectArray);
    }
}

