/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.quartz.impl.jdbcjobstore.StdJDBCDelegate;

public class CacheDelegate
extends StdJDBCDelegate {
    @Override
    protected void setBytes(PreparedStatement preparedStatement, int n, ByteArrayOutputStream byteArrayOutputStream) throws SQLException {
        preparedStatement.setObject(n, (Object)(byteArrayOutputStream == null ? null : byteArrayOutputStream.toByteArray()), 2004);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object getObjectFromBlob(ResultSet resultSet, String string) throws ClassNotFoundException, IOException, SQLException {
        Blob blob = resultSet.getBlob(string);
        if (blob == null) {
            return null;
        }
        try {
            Object object;
            if (blob.length() == 0L) {
                Object var4_4 = null;
                return var4_4;
            }
            InputStream inputStream = blob.getBinaryStream();
            if (inputStream == null) {
                Object var5_6 = null;
                return var5_6;
            }
            if (inputStream instanceof ByteArrayInputStream && ((ByteArrayInputStream)inputStream).available() == 0) {
                Object var5_7 = null;
                return var5_7;
            }
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            try {
                object = objectInputStream.readObject();
            }
            catch (Throwable throwable) {
                objectInputStream.close();
                throw throwable;
            }
            objectInputStream.close();
            return object;
        }
        finally {
            blob.free();
        }
    }

    @Override
    protected Object getJobDataFromBlob(ResultSet resultSet, String string) throws ClassNotFoundException, IOException, SQLException {
        if (this.canUseProperties()) {
            Blob blob = resultSet.getBlob(string);
            if (blob == null) {
                return null;
            }
            return new BlobFreeingStream(blob, blob.getBinaryStream());
        }
        return this.getObjectFromBlob(resultSet, string);
    }

    private static class BlobFreeingStream
    extends InputStream {
        private final Blob source;
        private final InputStream delegate;

        private BlobFreeingStream(Blob blob, InputStream inputStream) {
            this.source = blob;
            this.delegate = inputStream;
        }

        @Override
        public int read() throws IOException {
            return this.delegate.read();
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return this.delegate.read(byArray);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this.delegate.read(byArray, n, n2);
        }

        @Override
        public long skip(long l) throws IOException {
            return this.delegate.skip(l);
        }

        @Override
        public int available() throws IOException {
            return this.delegate.available();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                this.delegate.close();
            }
            finally {
                try {
                    this.source.free();
                }
                catch (SQLException sQLException) {
                    throw new IOException(sQLException);
                }
            }
        }

        @Override
        public synchronized void mark(int n) {
            this.delegate.mark(n);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.delegate.reset();
        }

        @Override
        public boolean markSupported() {
            return this.delegate.markSupported();
        }
    }
}

