/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.calendar;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.quartz.Calendar;
import org.quartz.impl.calendar.BaseCalendar;

public class DailyCalendar
extends BaseCalendar {
    static final long serialVersionUID = -7561220099904944039L;
    private static final String invalidHourOfDay = "Invalid hour of day: ";
    private static final String invalidMinute = "Invalid minute: ";
    private static final String invalidSecond = "Invalid second: ";
    private static final String invalidMillis = "Invalid millis: ";
    private static final String invalidTimeRange = "Invalid time range: ";
    private static final String separator = " - ";
    private static final long oneMillis = 1L;
    private static final String colon = ":";
    private int rangeStartingHourOfDay;
    private int rangeStartingMinute;
    private int rangeStartingSecond;
    private int rangeStartingMillis;
    private int rangeEndingHourOfDay;
    private int rangeEndingMinute;
    private int rangeEndingSecond;
    private int rangeEndingMillis;
    private boolean invertTimeRange = false;

    public DailyCalendar(String string, String string2) {
        this.setTimeRange(string, string2);
    }

    public DailyCalendar(Calendar calendar, String string, String string2) {
        super(calendar);
        this.setTimeRange(string, string2);
    }

    public DailyCalendar(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.setTimeRange(n, n2, n3, n4, n5, n6, n7, n8);
    }

    public DailyCalendar(Calendar calendar, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        super(calendar);
        this.setTimeRange(n, n2, n3, n4, n5, n6, n7, n8);
    }

    public DailyCalendar(java.util.Calendar calendar, java.util.Calendar calendar2) {
        this.setTimeRange(calendar, calendar2);
    }

    public DailyCalendar(Calendar calendar, java.util.Calendar calendar2, java.util.Calendar calendar3) {
        super(calendar);
        this.setTimeRange(calendar2, calendar3);
    }

    public DailyCalendar(long l, long l2) {
        this.setTimeRange(l, l2);
    }

    public DailyCalendar(Calendar calendar, long l, long l2) {
        super(calendar);
        this.setTimeRange(l, l2);
    }

    public DailyCalendar(TimeZone timeZone, long l, long l2) {
        super(timeZone);
        this.setTimeRange(l, l2);
    }

    public DailyCalendar(Calendar calendar, TimeZone timeZone, long l, long l2) {
        super(calendar, timeZone);
        this.setTimeRange(l, l2);
    }

    @Override
    public Object clone() {
        DailyCalendar dailyCalendar = (DailyCalendar)super.clone();
        return dailyCalendar;
    }

    @Override
    public boolean isTimeIncluded(long l) {
        if (this.getBaseCalendar() != null && !this.getBaseCalendar().isTimeIncluded(l)) {
            return false;
        }
        long l2 = this.getStartOfDayJavaCalendar(l).getTime().getTime();
        long l3 = this.getEndOfDayJavaCalendar(l).getTime().getTime();
        long l4 = this.getTimeRangeStartingTimeInMillis(l);
        long l5 = this.getTimeRangeEndingTimeInMillis(l);
        if (!this.invertTimeRange) {
            return l > l2 && l < l4 || l > l5 && l < l3;
        }
        return l >= l4 && l <= l5;
    }

    @Override
    public long getNextIncludedTime(long l) {
        long l2 = l + 1L;
        while (!this.isTimeIncluded(l2)) {
            if (!this.invertTimeRange) {
                if (l2 >= this.getTimeRangeStartingTimeInMillis(l2) && l2 <= this.getTimeRangeEndingTimeInMillis(l2)) {
                    l2 = this.getTimeRangeEndingTimeInMillis(l2) + 1L;
                    continue;
                }
                if (this.getBaseCalendar() != null && !this.getBaseCalendar().isTimeIncluded(l2)) {
                    l2 = this.getBaseCalendar().getNextIncludedTime(l2);
                    continue;
                }
                ++l2;
                continue;
            }
            if (l2 < this.getTimeRangeStartingTimeInMillis(l2)) {
                l2 = this.getTimeRangeStartingTimeInMillis(l2);
                continue;
            }
            if (l2 > this.getTimeRangeEndingTimeInMillis(l2)) {
                l2 = this.getEndOfDayJavaCalendar(l2).getTime().getTime();
                ++l2;
                continue;
            }
            if (this.getBaseCalendar() != null && !this.getBaseCalendar().isTimeIncluded(l2)) {
                l2 = this.getBaseCalendar().getNextIncludedTime(l2);
                continue;
            }
            ++l2;
        }
        return l2;
    }

    public long getTimeRangeStartingTimeInMillis(long l) {
        java.util.Calendar calendar = this.createJavaCalendar(l);
        calendar.set(11, this.rangeStartingHourOfDay);
        calendar.set(12, this.rangeStartingMinute);
        calendar.set(13, this.rangeStartingSecond);
        calendar.set(14, this.rangeStartingMillis);
        return calendar.getTime().getTime();
    }

    public long getTimeRangeEndingTimeInMillis(long l) {
        java.util.Calendar calendar = this.createJavaCalendar(l);
        calendar.set(11, this.rangeEndingHourOfDay);
        calendar.set(12, this.rangeEndingMinute);
        calendar.set(13, this.rangeEndingSecond);
        calendar.set(14, this.rangeEndingMillis);
        return calendar.getTime().getTime();
    }

    public boolean getInvertTimeRange() {
        return this.invertTimeRange;
    }

    public void setInvertTimeRange(boolean bl) {
        this.invertTimeRange = bl;
    }

    public String toString() {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMaximumFractionDigits(0);
        numberFormat.setMinimumIntegerDigits(2);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("base calendar: [");
        if (this.getBaseCalendar() != null) {
            stringBuffer.append(this.getBaseCalendar().toString());
        } else {
            stringBuffer.append("null");
        }
        stringBuffer.append("], time range: '");
        stringBuffer.append(numberFormat.format(this.rangeStartingHourOfDay));
        stringBuffer.append(colon);
        stringBuffer.append(numberFormat.format(this.rangeStartingMinute));
        stringBuffer.append(colon);
        stringBuffer.append(numberFormat.format(this.rangeStartingSecond));
        stringBuffer.append(colon);
        numberFormat.setMinimumIntegerDigits(3);
        stringBuffer.append(numberFormat.format(this.rangeStartingMillis));
        numberFormat.setMinimumIntegerDigits(2);
        stringBuffer.append(separator);
        stringBuffer.append(numberFormat.format(this.rangeEndingHourOfDay));
        stringBuffer.append(colon);
        stringBuffer.append(numberFormat.format(this.rangeEndingMinute));
        stringBuffer.append(colon);
        stringBuffer.append(numberFormat.format(this.rangeEndingSecond));
        stringBuffer.append(colon);
        numberFormat.setMinimumIntegerDigits(3);
        stringBuffer.append(numberFormat.format(this.rangeEndingMillis));
        stringBuffer.append("', inverted: " + this.invertTimeRange + "]");
        return stringBuffer.toString();
    }

    private String[] split(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void setTimeRange(String string, String string2) {
        String[] stringArray = this.split(string, colon);
        if (stringArray.length < 2 || stringArray.length > 4) {
            throw new IllegalArgumentException("Invalid time string '" + string + "'");
        }
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        int n3 = stringArray.length > 2 ? Integer.parseInt(stringArray[2]) : 0;
        int n4 = stringArray.length == 4 ? Integer.parseInt(stringArray[3]) : 0;
        String[] stringArray2 = this.split(string2, colon);
        if (stringArray2.length < 2 || stringArray2.length > 4) {
            throw new IllegalArgumentException("Invalid time string '" + string2 + "'");
        }
        int n5 = Integer.parseInt(stringArray2[0]);
        int n6 = Integer.parseInt(stringArray2[1]);
        int n7 = stringArray2.length > 2 ? Integer.parseInt(stringArray2[2]) : 0;
        int n8 = stringArray2.length == 4 ? Integer.parseInt(stringArray2[3]) : 0;
        this.setTimeRange(n, n2, n3, n4, n5, n6, n7, n8);
    }

    public void setTimeRange(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.validate(n, n2, n3, n4);
        this.validate(n5, n6, n7, n8);
        java.util.Calendar calendar = this.createJavaCalendar();
        calendar.set(11, n);
        calendar.set(12, n2);
        calendar.set(13, n3);
        calendar.set(14, n4);
        java.util.Calendar calendar2 = this.createJavaCalendar();
        calendar2.set(11, n5);
        calendar2.set(12, n6);
        calendar2.set(13, n7);
        calendar2.set(14, n8);
        if (!calendar.before(calendar2)) {
            throw new IllegalArgumentException(invalidTimeRange + n + colon + n2 + colon + n3 + colon + n4 + separator + n5 + colon + n6 + colon + n7 + colon + n8);
        }
        this.rangeStartingHourOfDay = n;
        this.rangeStartingMinute = n2;
        this.rangeStartingSecond = n3;
        this.rangeStartingMillis = n4;
        this.rangeEndingHourOfDay = n5;
        this.rangeEndingMinute = n6;
        this.rangeEndingSecond = n7;
        this.rangeEndingMillis = n8;
    }

    public void setTimeRange(java.util.Calendar calendar, java.util.Calendar calendar2) {
        this.setTimeRange(calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14), calendar2.get(11), calendar2.get(12), calendar2.get(13), calendar2.get(14));
    }

    public void setTimeRange(long l, long l2) {
        this.setTimeRange(this.createJavaCalendar(l), this.createJavaCalendar(l2));
    }

    private void validate(int n, int n2, int n3, int n4) {
        if (n < 0 || n > 23) {
            throw new IllegalArgumentException(invalidHourOfDay + n);
        }
        if (n2 < 0 || n2 > 59) {
            throw new IllegalArgumentException(invalidMinute + n2);
        }
        if (n3 < 0 || n3 > 59) {
            throw new IllegalArgumentException(invalidSecond + n3);
        }
        if (n4 < 0 || n4 > 999) {
            throw new IllegalArgumentException(invalidMillis + n4);
        }
    }
}

