/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.ee.jta;

import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.core.JobRunShell;
import org.quartz.ee.jta.UserTransactionHelper;
import org.quartz.spi.TriggerFiredBundle;

public class JTAJobRunShell
extends JobRunShell {
    private final Integer transactionTimeout;
    private UserTransaction ut;

    public JTAJobRunShell(Scheduler scheduler, TriggerFiredBundle triggerFiredBundle) {
        super(scheduler, triggerFiredBundle);
        this.transactionTimeout = null;
    }

    public JTAJobRunShell(Scheduler scheduler, TriggerFiredBundle triggerFiredBundle, int n) {
        super(scheduler, triggerFiredBundle);
        this.transactionTimeout = n;
    }

    @Override
    protected void begin() throws SchedulerException {
        this.cleanupUserTransaction();
        boolean bl = false;
        try {
            this.getLog().debug("Looking up UserTransaction.");
            this.ut = UserTransactionHelper.lookupUserTransaction();
            if (this.transactionTimeout != null) {
                this.ut.setTransactionTimeout(this.transactionTimeout.intValue());
            }
            this.getLog().debug("Beginning UserTransaction.");
            this.ut.begin();
            bl = true;
        }
        catch (SchedulerException schedulerException) {
            throw schedulerException;
        }
        catch (Exception exception) {
            throw new SchedulerException("JTAJobRunShell could not start UserTransaction.", exception);
        }
        finally {
            if (!bl) {
                this.cleanupUserTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void complete(boolean bl) throws SchedulerException {
        block12: {
            if (this.ut == null) {
                return;
            }
            try {
                try {
                    if (this.ut.getStatus() == 1) {
                        this.getLog().debug("UserTransaction marked for rollback only.");
                        bl = false;
                    }
                }
                catch (SystemException systemException) {
                    throw new SchedulerException("JTAJobRunShell could not read UserTransaction status.", systemException);
                }
                if (bl) {
                    try {
                        this.getLog().debug("Committing UserTransaction.");
                        this.ut.commit();
                        break block12;
                    }
                    catch (Exception exception) {
                        throw new SchedulerException("JTAJobRunShell could not commit UserTransaction.", exception);
                    }
                }
                try {
                    this.getLog().debug("Rolling-back UserTransaction.");
                    this.ut.rollback();
                }
                catch (Exception exception) {
                    throw new SchedulerException("JTAJobRunShell could not rollback UserTransaction.", exception);
                }
            }
            finally {
                this.cleanupUserTransaction();
            }
        }
    }

    @Override
    public void passivate() {
        this.cleanupUserTransaction();
        super.passivate();
    }

    private void cleanupUserTransaction() {
        if (this.ut != null) {
            UserTransactionHelper.returnUserTransaction(this.ut);
            this.ut = null;
        }
    }
}

